/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.dockingmanagement.layout;

import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.dockingmanagement.PerspectiveManager;
import com.swimap.iview.framework.dockingmanagement.PerspectiveStore;
import com.swimap.iview.framework.dockingmanagement.ViewInfo;
import com.swimap.iview.framework.dockingmanagement.ViewInitException;
import com.swimap.iview.framework.dockingmanagement.ViewPart;
import com.swimap.iview.framework.dockingmanagement.layout.IPageLayout;
import com.swimap.iview.framework.dockingmanagement.layout.ViewLayoutInfo;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import java.util.List;

public class PageLayout
implements IPageLayout {
    private static final int SIZE = 5;
    private List<ViewLayoutInfo> layoutInfoList = new ArrayList<ViewLayoutInfo>(5);
    private static IviewLogger logger = IviewLogger.getLogger(PageLayout.class, "IVIEW");

    @Override
    public void addView(double d, double d2, double d3, double d4, String string) throws ViewInitException {
        Object object;
        PerspectiveManager perspectiveManager = PerspectiveManager.getInstance();
        ViewInfo viewInfo = perspectiveManager.getViewInfo(string);
        if (viewInfo == null) {
            logger.trace("View not exsists " + string);
            return;
        }
        PerspectiveStore perspectiveStore = perspectiveManager.getStore();
        ViewPart viewPart = null;
        try {
            object = perspectiveStore.getPluginName(string, true);
            viewPart = (ViewPart)perspectiveManager.createObject(viewInfo.getViewClass(), (String)object);
            viewPart.setViewInfo(viewInfo);
            viewPart.loadView(viewInfo.getViewId());
        }
        catch (Exception exception) {
            throw new ViewInitException("Failed to add the view " + string + exception);
        }
        object = new ViewLayoutInfo(d, d2, d3, d4, viewPart);
        this.layoutInfoList.add((ViewLayoutInfo)object);
    }

    public List<ViewLayoutInfo> getViewLayoutInfoList() {
        return this.layoutInfoList;
    }

    public ViewLayoutInfo getLayoutInfo(String string) {
        for (ViewLayoutInfo viewLayoutInfo : this.layoutInfoList) {
            String string2;
            if (null == viewLayoutInfo || (string2 = viewLayoutInfo.getViewPart().getViewId()) == null || !ResourceUtil.areEquals(string2, string)) continue;
            return viewLayoutInfo;
        }
        return null;
    }
}

