/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.dockingmanagement.communication;

import com.swimap.iview.framework.dockingmanagement.PerspectiveManager;
import com.swimap.iview.framework.dockingmanagement.ViewPart;
import com.swimap.iview.framework.dockingmanagement.communication.IViewPropertyChangedListener;
import com.swimap.iview.framework.dockingmanagement.communication.IViewPropertyChangedProvider;
import com.swimap.iview.framework.dockingmanagement.communication.ViewPropertyChangedEvent;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class ViewPropertyChangedService
implements IViewPropertyChangedProvider {
    private static IviewLogger logger = IviewLogger.getLogger(ViewPropertyChangedService.class, "IVIEW");
    private static ViewPropertyChangedService instance;
    private HashMap<String, ArrayList<IViewPropertyChangedListener>> propertyListenerMap = null;
    private static final int SIZE = 10;
    private static final String GLOBAL_EVENT = "global";

    private ViewPropertyChangedService() {
    }

    public static ViewPropertyChangedService getInstance() {
        if (null == instance) {
            instance = new ViewPropertyChangedService();
        }
        return instance;
    }

    @Override
    public void addViewPropertyChangedListener(IViewPropertyChangedListener iViewPropertyChangedListener) {
        this.addViewPropertyChangedListener(GLOBAL_EVENT, iViewPropertyChangedListener);
    }

    @Override
    public void addViewPropertyChangedListener(String string, IViewPropertyChangedListener iViewPropertyChangedListener) {
        ArrayList<IViewPropertyChangedListener> arrayList;
        if (null == string || string.length() == 0 || null == iViewPropertyChangedListener) {
            logger.trace("propertyName or listener is null or invalid");
            return;
        }
        if (null == this.propertyListenerMap) {
            this.propertyListenerMap = new HashMap(10);
        }
        if (null == (arrayList = this.propertyListenerMap.get(string))) {
            arrayList = new ArrayList(10);
            this.propertyListenerMap.put(string, arrayList);
        }
        arrayList.add(iViewPropertyChangedListener);
    }

    @Override
    public void removeViewPropertyChangeListener(IViewPropertyChangedListener iViewPropertyChangedListener) {
        this.removeViewPropertyChangeListener(GLOBAL_EVENT, iViewPropertyChangedListener);
    }

    @Override
    public void removeViewPropertyChangeListener(String string, IViewPropertyChangedListener iViewPropertyChangedListener) {
        List list;
        if (null == string || string.length() == 0 || null == iViewPropertyChangedListener) {
            logger.trace("property or listener is null or invalid");
            return;
        }
        if (null != this.propertyListenerMap && null != (list = (List)this.propertyListenerMap.get(string))) {
            list.remove(iViewPropertyChangedListener);
        }
    }

    public void firePropertyChange(String string, Object object, ViewPart viewPart) {
        Object object2;
        Object object3;
        if (null == string || string.length() == 0 || null == object || null == viewPart) {
            logger.trace("Invalid input property,source or instance is null");
            return;
        }
        if (null == this.propertyListenerMap) {
            return;
        }
        ViewPropertyChangedEvent viewPropertyChangedEvent = new ViewPropertyChangedEvent(object);
        viewPropertyChangedEvent.setPropertyName(string);
        String string2 = PerspectiveManager.getInstance().getPerspective(viewPart);
        viewPropertyChangedEvent.setPerspectivId(string2);
        viewPropertyChangedEvent.setViewId(viewPart.getViewId());
        ArrayList<IViewPropertyChangedListener> arrayList = this.propertyListenerMap.get(string);
        if (null != arrayList) {
            object3 = arrayList.iterator();
            while (object3.hasNext()) {
                object2 = (IViewPropertyChangedListener)object3.next();
                if (null == object2) continue;
                object2.viewPropertyChanged(viewPropertyChangedEvent);
            }
        }
        if (null != (object3 = this.propertyListenerMap.get(GLOBAL_EVENT))) {
            object2 = ((ArrayList)object3).iterator();
            while (object2.hasNext()) {
                IViewPropertyChangedListener iViewPropertyChangedListener = (IViewPropertyChangedListener)object2.next();
                if (null == iViewPropertyChangedListener) continue;
                iViewPropertyChangedListener.viewPropertyChanged(viewPropertyChangedEvent);
            }
        }
    }
}

