/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.dockingmanagement;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.accept.DockAcceptance;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.ButtonDockAction;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewGenerator;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.split.SplitDockGrid;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockProperty;
import bibliothek.gui.dock.themes.basic.action.BasicButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XIO;
import com.swimap.iview.commstyle.commini.Menu;
import com.swimap.iview.framework.dockingmanagement.View;
import com.swimap.iview.framework.dockingmanagement.ViewInitException;
import com.swimap.iview.framework.dockingmanagement.ViewPart;
import com.swimap.iview.framework.dockingmanagement.images.PerspectiveViewImages;
import com.swimap.iview.framework.dockingmanagement.layout.PageLayout;
import com.swimap.iview.framework.dockingmanagement.layout.ViewLayoutInfo;
import com.swimap.iview.framework.dockingmanagement.theme.PerspectiveViewButton;
import com.swimap.iview.framework.dockingmanagement.theme.SwimapIntegrateStyle;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ViewHandler {
    private static IviewLogger logger = IviewLogger.getLogger(ViewHandler.class, "IVIEW");
    private CControl control = null;
    private Container container = null;
    private SplitDockStation station = null;
    private SplitDockPathProperty editorLocation = null;
    private static final int SIZE = 10;
    private static final double RELATIVE_SIZE_1 = 0.5;
    private HashMap<String, View> viewMap = new HashMap(10);
    private HashMap<String, Integer> indexMap = new HashMap(10);
    private HashMap<String, Boolean> maxMap = new HashMap(10);
    private HashMap<String, Boolean> closeMap = new HashMap(10);
    private HashMap<String, JPanel> panelMap = new HashMap(10);
    private boolean isDragable = true;
    private static final String STYLE = "Style";

    public ViewHandler(Container container) {
        this.container = container;
        this.init();
    }

    private void init() {
        this.control = new CControl(FrameworkUtilities.getMainFrame());
        this.container.add((Component)this.control.getContentArea());
        SwimapIntegrateStyle swimapIntegrateStyle = new SwimapIntegrateStyle();
        DockFrontend dockFrontend = this.control.intern();
        dockFrontend.getController().setTheme((DockTheme)swimapIntegrateStyle);
        this.station = this.control.getContentArea().getCenter();
        this.editorLocation = new SplitDockPathProperty();
        this.editorLocation.add(SplitDockPathProperty.Location.TOP, 0.5);
        DockAcceptance dockAcceptance = new DockAcceptance(){

            public boolean accept(DockStation dockStation, Dockable dockable) {
                return ViewHandler.this.isDragable;
            }

            public boolean accept(DockStation dockStation, Dockable dockable, Dockable dockable2) {
                return ViewHandler.this.isDragable;
            }
        };
        this.station.getController().addAcceptance(dockAcceptance);
        this.setPerspectiveViewButton();
        this.setPerspectiveViewImages();
    }

    private void setPerspectiveViewButton() {
        ViewGenerator<ButtonDockAction, BasicTitleViewItem<JComponent>> viewGenerator = new ViewGenerator<ButtonDockAction, BasicTitleViewItem<JComponent>>(){

            public BasicTitleViewItem<JComponent> create(ActionViewConverter actionViewConverter, ButtonDockAction buttonDockAction, Dockable dockable) {
                BasicButtonHandler basicButtonHandler = new BasicButtonHandler(buttonDockAction, dockable);
                PerspectiveViewButton perspectiveViewButton = new PerspectiveViewButton((BasicTrigger)basicButtonHandler);
                basicButtonHandler.setModel(perspectiveViewButton.getModel());
                return basicButtonHandler;
            }
        };
        ActionViewConverter actionViewConverter = this.station.getController().getActionViewConverter();
        if (actionViewConverter != null) {
            actionViewConverter.putTheme(ActionType.BUTTON, ViewTarget.TITLE, (ViewGenerator)viewGenerator);
        }
    }

    private void setPerspectiveViewImages() {
        PerspectiveViewImages perspectiveViewImages = PerspectiveViewImages.getInstance();
        this.control.intern().getController().getIcons().setIconClient("close", perspectiveViewImages.getImages("close_normal"));
        this.control.intern().getController().getIcons().setIconClient("statemanager.maximize", perspectiveViewImages.getImages("max_normal"));
        this.control.intern().getController().getIcons().setIconClient("statemanager.minimize", perspectiveViewImages.getImages("min_normal"));
        this.control.intern().getController().getIcons().setIconClient("statemanager.normalize", perspectiveViewImages.getImages("restore_normal"));
    }

    protected void addView(ViewPart viewPart, int n) throws ViewInitException {
        if (null == viewPart) {
            return;
        }
        View view = this.getView(viewPart.getViewId());
        if (null != view) {
            view.setVisible(true);
            view.toFront();
            this.setViewFeatures(view);
            logger.trace("View with the id " + viewPart.getViewId() + " is already present.");
            return;
        }
        view = new View(viewPart);
        DockableProperty dockableProperty = this.getLocation(n);
        this.control.add((SingleCDockable)view);
        this.setViewFeatures(view);
        if (null != dockableProperty) {
            this.station.drop((Dockable)view.intern(), dockableProperty);
        } else {
            this.station.drop((Dockable)view.intern(), this.editorLocation);
        }
        view.setViewArea(n);
        this.viewMap.put(view.getUniqueId(), view);
    }

    private DockableProperty getLocation(int n) {
        DockableProperty dockableProperty = null;
        Collection<View> collection = this.viewMap.values();
        View view2 = null;
        for (View view2 : collection) {
            if (!view2.isVisible() || view2.getViewArea() != n) continue;
            DockStation dockStation = DockUtilities.getRoot((DockElement)view2.intern());
            dockableProperty = DockUtilities.getPropertyChain((DockStation)dockStation, (Dockable)view2.intern());
            dockableProperty.setSuccessor(dockableProperty);
            break;
        }
        return dockableProperty;
    }

    protected void removeView(String string) {
        View view = this.getView(string);
        if (null == view) {
            logger.trace("View " + string + " not exsist in the perspective ");
            return;
        }
        try {
            DockStation dockStation = view.intern().getDockParent();
            if (null != dockStation) {
                dockStation.drag((Dockable)view.intern());
            }
        }
        catch (Exception exception) {
            logger.trace("Unable to remove the view " + exception);
        }
        this.control.remove((SingleCDockable)view);
        view.getViewPart().dispose();
        view.clearView();
        this.viewMap.remove(view.getUniqueId());
    }

    protected ViewPart findView(String string) {
        if (this.viewMap.containsKey(string)) {
            View view = this.viewMap.get(string);
            return view.getViewPart();
        }
        return null;
    }

    protected View getView(String string) {
        return this.viewMap.get(string);
    }

    private void showView(String string, boolean bl) {
        if (this.viewMap.containsKey(string)) {
            View view = this.viewMap.get(string);
            view.setVisible(bl);
            if (bl) {
                view.toFront();
            }
            this.setViewFeatures(view);
        } else {
            logger.trace("View id is invalid");
        }
    }

    protected List<ViewPart> getAllViewParts() {
        ArrayList<ViewPart> arrayList = new ArrayList<ViewPart>(10);
        Collection<View> collection = this.viewMap.values();
        for (View view : collection) {
            arrayList.add(view.getViewPart());
        }
        return arrayList;
    }

    protected void hideView(String string) {
        this.showView(string, false);
    }

    protected void loadWorkPage(File file) throws IOException {
        XElement xElement = this.getRootElement(file);
        this.control.getResources().readXML(xElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XElement getRootElement(File file) throws IOException {
        XElement xElement = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            xElement = XIO.readUTF((InputStream)fileInputStream);
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {
                logger.trace("Exception while closing stream ");
            }
        }
        return xElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveWorkPage(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        XElement xElement = new XElement("stations");
        String string = null;
        string = this.isDragable ? "V3R1" : "V2R9";
        XAttribute xAttribute = new XAttribute(STYLE);
        xAttribute.setValue(string);
        xElement.addAttribute(xAttribute);
        try {
            this.control.getResources().writeXML(xElement);
            XIO.writeUTF((XElement)xElement, (OutputStream)fileOutputStream);
        }
        finally {
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                logger.trace("Exception while closing stream ");
            }
        }
    }

    protected void showView(String string) {
        this.showView(string, true);
    }

    protected void addViewsWithPageLayout(PageLayout pageLayout) {
        SplitDockGrid splitDockGrid = new SplitDockGrid();
        View view = null;
        if (null != pageLayout) {
            try {
                StackDockStation stackDockStation = null;
                ViewLayoutInfo viewLayoutInfo = null;
                List<ViewLayoutInfo> list = pageLayout.getViewLayoutInfoList();
                String string = "";
                boolean bl = false;
                boolean bl2 = false;
                int n = 0;
                ArrayList<ViewLayoutInfo> arrayList = null;
                ViewLayoutInfo viewLayoutInfo2 = null;
                int n2 = list.size();
                for (int i = 0; i < n2; ++i) {
                    viewLayoutInfo = list.get(i);
                    if (null == viewLayoutInfo) continue;
                    view = new View(viewLayoutInfo.getViewPart());
                    string = view.getUniqueId();
                    this.setViewFeatures(view);
                    try {
                        this.control.add((SingleCDockable)view);
                        this.viewMap.put(string, view);
                    }
                    catch (Exception exception) {
                        logger.trace("View already there in the control " + string);
                    }
                    stackDockStation = new StackDockStation();
                    bl = false;
                    bl2 = false;
                    n = 0;
                    arrayList = new ArrayList<ViewLayoutInfo>(list);
                    int n3 = list.size();
                    for (int j = i + 1; j < n3; ++j) {
                        viewLayoutInfo2 = list.get(j);
                        if (!viewLayoutInfo.isEqualLocation(viewLayoutInfo2)) continue;
                        bl = true;
                        if (!bl2) {
                            stackDockStation.add((Dockable)view.intern(), n++);
                            bl2 = true;
                        }
                        View view2 = new View(viewLayoutInfo2.getViewPart());
                        try {
                            this.control.add((SingleCDockable)view2);
                            this.viewMap.put(view2.getUniqueId(), view2);
                        }
                        catch (Exception exception) {
                            logger.trace("View already there in the control " + view2.getUniqueId());
                        }
                        stackDockStation.add((Dockable)view2.intern(), n++);
                        arrayList.remove(viewLayoutInfo2);
                    }
                    if (bl) {
                        splitDockGrid.addDockable(viewLayoutInfo.getX(), viewLayoutInfo.getY(), viewLayoutInfo.getWidth(), viewLayoutInfo.getHeight(), new Dockable[]{stackDockStation.asDockable()});
                    } else {
                        splitDockGrid.addDockable(viewLayoutInfo.getX(), viewLayoutInfo.getY(), viewLayoutInfo.getWidth(), viewLayoutInfo.getHeight(), new Dockable[]{view.intern()});
                    }
                    list = arrayList;
                }
                this.station.dropTree(splitDockGrid.toTree());
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
    }

    protected void addViews(PageLayout pageLayout) {
        if (null == pageLayout) {
            return;
        }
        StackDockStation stackDockStation = null;
        List<ViewLayoutInfo> list = pageLayout.getViewLayoutInfoList();
        ViewLayoutInfo viewLayoutInfo = null;
        View view = null;
        String string = "";
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        ArrayList<ViewLayoutInfo> arrayList = null;
        SplitDockProperty splitDockProperty = null;
        ViewLayoutInfo viewLayoutInfo2 = null;
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            viewLayoutInfo = list.get(i);
            if (null == viewLayoutInfo || this.viewMap.containsKey(string = viewLayoutInfo.getViewPart().getViewId())) continue;
            view = new View(viewLayoutInfo.getViewPart());
            this.setViewFeatures(view);
            try {
                this.control.add((SingleCDockable)view);
                this.viewMap.put(string, view);
            }
            catch (Exception exception) {
                logger.trace("View already there in the control " + string);
                continue;
            }
            stackDockStation = new StackDockStation();
            bl = false;
            bl2 = false;
            n = 0;
            arrayList = new ArrayList<ViewLayoutInfo>(list);
            int n3 = list.size();
            for (int j = i + 1; j < n3; ++j) {
                viewLayoutInfo2 = list.get(j);
                if (!viewLayoutInfo.isEqualLocation(viewLayoutInfo2)) continue;
                bl = true;
                if (!bl2) {
                    stackDockStation.add((Dockable)view.intern(), n++);
                    bl2 = true;
                }
                View view2 = new View(viewLayoutInfo2.getViewPart());
                try {
                    this.control.add((SingleCDockable)view2);
                    this.viewMap.put(view2.getUniqueId(), view2);
                }
                catch (Exception exception) {
                    logger.trace("View already there in the control " + view2.getUniqueId());
                    continue;
                }
                stackDockStation.add((Dockable)view2.intern(), n++);
                arrayList.remove(viewLayoutInfo2);
            }
            splitDockProperty = new SplitDockProperty(viewLayoutInfo.getX(), viewLayoutInfo.getY(), viewLayoutInfo.getWidth(), viewLayoutInfo.getHeight());
            if (bl) {
                this.station.drop(stackDockStation.asDockable(), splitDockProperty);
            } else {
                this.station.drop((Dockable)view.intern(), splitDockProperty);
            }
            list = arrayList;
        }
    }

    protected Set<String> getViews() {
        return this.viewMap.keySet();
    }

    public void setDraggable(boolean bl) {
        Component component;
        MenuManager menuManager = FrameworkUtilities.getMenuManager();
        Menu menu = menuManager.getBaseMenuSet().getMenu("WindowMenu");
        if (null != menu && (component = menu.getMenuItem("DefaultStyle")) instanceof AbstractButton) {
            ((AbstractButton)component).setSelected(!bl);
        }
        this.isDragable = bl;
        this.changeViewToolbar();
    }

    private void setStyleFlag(boolean bl) {
        MenuManager menuManager = FrameworkUtilities.getMenuManager();
        Menu menu = menuManager.getBaseMenuSet().getMenu("WindowMenu");
        if (menu != null) {
            Component component;
            Component component2 = menu.getMenuItem("DefaultStyle");
            if (component2 instanceof AbstractButton) {
                ((AbstractButton)component2).setSelected(!bl);
            }
            if ((component = menu.getMenuItem("ResetPerspective")) instanceof AbstractButton) {
                ((AbstractButton)component).setEnabled(bl);
            }
        }
        this.isDragable = bl;
    }

    private boolean getStyle() {
        Component component;
        boolean bl = false;
        MenuManager menuManager = FrameworkUtilities.getMenuManager();
        Menu menu = menuManager.getBaseMenuSet().getMenu("WindowMenu");
        if (menu != null && (component = menu.getMenuItem("DefaultStyle")) instanceof AbstractButton) {
            bl = ((AbstractButton)component).isSelected();
        }
        return bl;
    }

    private void changeViewToolbar() {
        Collection<View> collection = this.viewMap.values();
        for (View view : collection) {
            this.setViewFeatures(view);
        }
    }

    private void setViewFeatures(View view) {
        boolean bl = this.isDragable = !this.getStyle();
        if (view.isVisible()) {
            if (!this.isDragable) {
                this.maxMap.put(view.getUniqueId(), view.isMaximizable());
                this.closeMap.put(view.getUniqueId(), view.isCloseable());
                int n = view.intern().getActions().getDockActionCount();
                if (n > 0) {
                    this.indexMap.put(view.getUniqueId(), n);
                }
                for (int i = n - 1; i >= 0; --i) {
                    view.removeAction(i);
                }
                JPanel jPanel = view.getToolPanel();
                if (null != jPanel) {
                    view.getContentPane().add((Component)jPanel, "North");
                }
                this.panelMap.put(view.getUniqueId(), jPanel);
                view.setMaximizable(this.isDragable);
                view.setCloseable(this.isDragable);
            } else {
                if (this.indexMap.containsKey(view.getUniqueId())) {
                    List<Object> list = view.getActionsList();
                    for (Object object : list) {
                        view.addAction((CAction)object);
                    }
                    if (this.panelMap.containsKey(view.getUniqueId())) {
                        view.getContentPane().remove(this.panelMap.get(view.getUniqueId()));
                    }
                }
                if (this.maxMap.containsKey(view.getUniqueId())) {
                    view.setMaximizable(this.maxMap.get(view.getUniqueId()));
                }
                if (this.closeMap.containsKey(view.getUniqueId())) {
                    view.setCloseable(this.closeMap.get(view.getUniqueId()));
                }
            }
        }
    }

    protected boolean setStyleFromPerspectiveFile(File file) throws IOException {
        XElement xElement = this.getRootElement(file);
        XAttribute xAttribute = xElement.getAttribute(STYLE);
        String string = null;
        if (null != xAttribute) {
            string = xAttribute.getValue();
        }
        if ("V2R9".equals(string)) {
            this.setStyleFlag(false);
        }
        return true;
    }

    protected ViewLayoutInfo getLayout(String string) {
        SplitDockPathProperty splitDockPathProperty;
        View view = this.viewMap.get(string);
        if (null == view) {
            logger.trace("View not exists " + string);
            return null;
        }
        DockableProperty dockableProperty = DockUtilities.getPropertyChain((Dockable)view.intern());
        ViewLayoutInfo viewLayoutInfo = null;
        if (null == dockableProperty) {
            viewLayoutInfo = new ViewLayoutInfo(0.0, 0.0, 0.0, 0.0, view.getViewPart());
        } else if (dockableProperty instanceof SplitDockPathProperty) {
            splitDockPathProperty = (SplitDockPathProperty)dockableProperty;
            dockableProperty = splitDockPathProperty.toLocation();
        }
        if (dockableProperty instanceof SplitDockProperty) {
            splitDockPathProperty = (SplitDockProperty)dockableProperty;
            viewLayoutInfo = new ViewLayoutInfo(splitDockPathProperty.getX(), splitDockPathProperty.getY(), splitDockPathProperty.getWidth(), splitDockPathProperty.getHeight(), view.getViewPart());
        }
        return viewLayoutInfo;
    }
}

