/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.dockingmanagement;

import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.intern.AbstractCDockable;
import bibliothek.gui.dock.common.intern.DefaultCDockable;
import bibliothek.gui.dock.common.intern.DefaultCommonDockable;
import com.swimap.iview.commstyle.commini.BorderlessButton;
import com.swimap.iview.commstyle.commini.BorderlessToggleButton;
import com.swimap.iview.commstyle.commini.PopupButton;
import com.swimap.iview.framework.dockingmanagement.ViewPart;
import com.swimap.iview.framework.dockingmanagement.action.IViewAction;
import com.swimap.iview.framework.dockingmanagement.action.IViewButton;
import com.swimap.iview.framework.dockingmanagement.action.IViewToggleButton;
import com.swimap.iview.framework.dockingmanagement.action.ViewButton;
import com.swimap.iview.framework.dockingmanagement.action.ViewDropDownMenu;
import com.swimap.iview.framework.dockingmanagement.action.ViewToggleButton;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class View
extends DefaultSingleCDockable {
    private static IviewLogger logger = IviewLogger.getLogger(View.class, "IVIEW");
    private int mode = 1;
    private ViewPart viewPart = null;
    private List<IViewAction> viewActions = null;
    private static final int SIZE = 5;
    private static final int MIN_WIDTH = 90;
    private static final int MIN_HEIGHT = 20;
    private static final int HEIGHT = 26;
    private static final int WIDTH_1 = 1;
    private static final int WIDTH_2 = 2048;
    private List<Object> actionsList = new ArrayList<Object>(5);

    public View(ViewPart viewPart) {
        super(viewPart.getViewId(), new CAction[0]);
        this.viewPart = viewPart;
        this.setTitleIcon(viewPart.getTitleIcon());
        String string = viewPart.getTitleToolTip();
        String string2 = viewPart.getTitle();
        if (null == string) {
            string = string2;
        }
        this.setTitleText(string2);
        this.setTitleToolTip(string);
        this.setMaximizable(viewPart.isMaximizable());
        this.setCloseable(viewPart.isClosable());
        this.getContentPane().setMinimumSize(new Dimension(90, 20));
        Container container = viewPart.createPartControl();
        this.getContentPane().setLayout(new BorderLayout());
        if (container != null) {
            try {
                this.getContentPane().add((Component)container, "Center");
            }
            catch (Exception exception) {
                logger.trace("Container Returned by CreatePartControl is invalid" + exception);
            }
        }
        if (null != viewPart.getContext() && null != viewPart.getContext().getActions()) {
            if (null == this.viewActions) {
                this.viewActions = new ArrayList<IViewAction>(5);
            }
            IViewAction[] iViewActionArray = viewPart.getContext().getActions();
            IViewAction iViewAction = null;
            for (int i = 0; i < iViewActionArray.length; ++i) {
                Object object;
                iViewAction = iViewActionArray[i];
                if (iViewAction instanceof IViewButton) {
                    object = new ViewButton((IViewButton)iViewAction);
                    this.addAction((CAction)object);
                    this.actionsList.add(object);
                    this.viewActions.add(iViewAction);
                    continue;
                }
                if (iViewAction instanceof IViewToggleButton) {
                    object = new ViewToggleButton((IViewToggleButton)iViewAction);
                    this.addAction((CAction)object);
                    this.actionsList.add(object);
                    this.viewActions.add(iViewAction);
                    continue;
                }
                if (!(iViewAction instanceof ViewDropDownMenu)) continue;
                object = (ViewDropDownMenu)iViewAction;
                ((ViewDropDownMenu)object).initialize();
                this.addAction(((ViewDropDownMenu)object).internalRef());
                this.actionsList.add(((ViewDropDownMenu)object).internalRef());
                this.viewActions.add(iViewAction);
            }
        }
        this.setExternalizable(false);
        this.setMinimizable(false);
    }

    public ViewPart getViewPart() {
        return this.viewPart;
    }

    public void setViewArea(int n) {
        this.mode = n;
    }

    public int getViewArea() {
        return this.mode;
    }

    protected List<Object> getActionsList() {
        return this.actionsList;
    }

    protected JPanel getToolPanel() {
        if (this.viewActions == null) {
            return null;
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        for (final IViewAction iViewAction : this.viewActions) {
            Serializable serializable;
            Object object;
            if (null == iViewAction) continue;
            if (iViewAction instanceof ViewDropDownMenu) {
                object = (ViewDropDownMenu)iViewAction;
                serializable = new JPopupMenu();
                AbstractAction abstractAction = null;
                for (final ViewButton viewButton : ((ViewDropDownMenu)object).getActions().values()) {
                    abstractAction = new AbstractAction(viewButton.getText(), viewButton.getIcon()){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            viewButton.action();
                        }
                    };
                    ((JPopupMenu)serializable).add(abstractAction);
                }
                MenuButton menuButton = new MenuButton(iViewAction.getIcon(), "", iViewAction.getTooltip(), (JPopupMenu)serializable);
                jPanel.add(menuButton);
                continue;
            }
            if (iViewAction instanceof IViewToggleButton) {
                object = new BorderlessToggleButton(){

                    @Override
                    public Icon getIcon() {
                        return iViewAction.getIcon();
                    }
                };
                serializable = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ((IViewToggleButton)iViewAction).actionChanged();
                    }
                };
                ((AbstractButton)object).setAction((Action)((Object)serializable));
                jPanel.add((Component)object);
                continue;
            }
            if (!(iViewAction instanceof IViewButton)) continue;
            object = new BorderlessButton();
            ((AbstractButton)object).setIcon(iViewAction.getIcon());
            serializable = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((IViewButton)iViewAction).actionPerformed();
                }
            };
            ((AbstractButton)object).setAction((Action)((Object)serializable));
        }
        jPanel.setMinimumSize(new Dimension(1, 26));
        jPanel.setMaximumSize(new Dimension(2048, 26));
        return jPanel;
    }

    public void clearView() {
        Class<AbstractCDockable> clazz = AbstractCDockable.class;
        Class<DefaultCDockable> clazz2 = DefaultCDockable.class;
        DefaultCommonDockable defaultCommonDockable = this.intern();
        Class<DefaultCommonDockable> clazz3 = DefaultCommonDockable.class;
        try {
            Field field = clazz.getDeclaredField("colors");
            field.setAccessible(true);
            field.set((Object)this, null);
            Field field2 = clazz.getDeclaredField("fonts");
            field2.setAccessible(true);
            field2.set((Object)this, null);
            Field field3 = clazz.getDeclaredField("actions");
            field3.setAccessible(true);
            field3.set((Object)this, null);
            Field field4 = clazz.getDeclaredField("close");
            field4.setAccessible(true);
            field4.set((Object)this, null);
            Field field5 = clazz3.getDeclaredField("dockable");
            field5.setAccessible(true);
            field5.set(defaultCommonDockable, null);
            Field field6 = clazz3.getDeclaredField("actions");
            field6.setAccessible(true);
            field6.set(defaultCommonDockable, null);
            Field field7 = clazz3.getDeclaredField("sources");
            field7.setAccessible(true);
            field7.set(defaultCommonDockable, null);
            Field field8 = clazz2.getDeclaredField("dockable");
            field8.setAccessible(true);
            field8.set((Object)this, null);
        }
        catch (SecurityException securityException) {
            logger.trace(securityException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            logger.trace(noSuchFieldException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.trace(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.trace(illegalAccessException);
        }
    }

    private class MenuButton
    extends PopupButton {
        MenuButton(Icon icon, String string, String string2, JPopupMenu jPopupMenu) {
            super(string, icon, jPopupMenu);
        }
    }
}

