/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.dockingmanagement;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.dockingmanagement.CategoryInfo;
import com.swimap.iview.framework.dockingmanagement.IPerspective;
import com.swimap.iview.framework.dockingmanagement.PerspectiveFrame;
import com.swimap.iview.framework.dockingmanagement.PerspectiveInfo;
import com.swimap.iview.framework.dockingmanagement.ViewInfo;
import com.swimap.iview.framework.dockingmanagement.ViewManager;
import com.swimap.iview.framework.dockingmanagement.ViewPart;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public final class PerspectiveStore {
    private static IviewLogger logger = IviewLogger.getLogger(PerspectiveStore.class, "IVIEW");
    private static PerspectiveStore instance = null;
    private static final int SIZE = 5;
    private HashMap<String, PerspectiveInfo> perspectiveInfoMap = new HashMap(5);
    private HashMap<String, CategoryInfo> categoryInfoMap = new HashMap(5);
    private HashMap<String, ViewInfo> viewInfoMap = new HashMap(5);
    private HashMap<String, CommStyleInfo> perspStyleMap = new HashMap(5);
    private HashMap<String, CommStyleInfo> viewStyleMap = new HashMap(5);
    private HashMap<String, PerspectiveFrame> framePerspMap = new HashMap(5);
    private HashMap<String, IPerspective> perspectiveMap = new HashMap(5);
    private HashMap<InternalFrame, ViewManager> dockMgrMaP = new HashMap(5);
    private Map<String, Set<String>> idMap = null;
    private Map<String, ViewPart> viewPartMap = new HashMap<String, ViewPart>(5);
    private static final String LAYOUT_DIR = "conf/views/layout";
    private static final String PERSPECTIVE = "perspective";
    private static final String RESOURCE = "ResourceBundle";
    private static final String PARA_NAME = "name";
    private static final String PARA_CLASS = "class";
    private static final String PARA_ID = "id";
    private static final String PARA_ICON = "icon";
    private static final String PARA_CATEGORY = "category";
    private static final String PARA_PARENTID = "parentid";
    private static final String PARA_DESCRIPTION = "description";
    private static final String PARA_MULTIPLEINSTANCE = "isMultipleInstance";
    private static final String PARA_UNMANAGED = "unmanaged";
    private static final String PERSPECTIVES = "perspectives";
    private static final String VIEWS = "views";

    private PerspectiveStore() {
        this.initializePerspectives();
    }

    public static PerspectiveStore getInstance() {
        if (null == instance) {
            instance = new PerspectiveStore();
        }
        return instance;
    }

    private void initializePerspectives() {
        List<Plugin> list = PluginManager.getInstance().getStartupPluginList();
        if (null != list) {
            CommStyleInfo commStyleInfo = null;
            for (Plugin plugin : list) {
                try {
                    if (null != plugin) {
                        commStyleInfo = plugin.getCommStyleParser().getUserCommStyleInfo(PERSPECTIVE);
                    }
                    if (null == commStyleInfo) continue;
                    this.initializePerspectiveFromStyle(commStyleInfo);
                }
                catch (Exception exception) {
                    if (null != plugin) {
                        logger.trace("Failed to initalize perspective from plugin " + plugin.getPluginName());
                    }
                    logger.trace(exception);
                }
            }
        }
    }

    private void initializePerspectiveFromStyle(CommStyleInfo commStyleInfo) {
        int n = commStyleInfo.getAreaDescCount();
        AreaDescContainer areaDescContainer = null;
        DescContainer descContainer = null;
        DescContainer descContainer2 = null;
        DescContainer descContainer3 = null;
        DescContainer descContainer4 = null;
        ResourceBundle resourceBundle = null;
        for (int i = 0; i < n; ++i) {
            String string;
            areaDescContainer = commStyleInfo.getAreaDescContainer()[i];
            descContainer = areaDescContainer.getDescContainer(RESOURCE);
            if (null != descContainer && RESOURCE.equals(string = descContainer.getParasItemValue("type"))) {
                String string2 = descContainer.getParasItemValue("resourceBundleName");
                try {
                    if (null != commStyleInfo.getPluginName()) {
                        resourceBundle = commStyleInfo.getResource().getResourceBundleFromPropertyFile(string2);
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    logger.trace(missingResourceException);
                }
                if (null != resourceBundle) {
                    commStyleInfo.setResourceBundle(resourceBundle);
                }
            }
            descContainer2 = areaDescContainer.getDescContainer(PERSPECTIVES);
            descContainer3 = areaDescContainer.getDescContainer("categories");
            descContainer4 = areaDescContainer.getDescContainer(VIEWS);
            this.initCategories(descContainer3, commStyleInfo);
            this.initViews(descContainer4, commStyleInfo);
            this.initPerspective(descContainer2, commStyleInfo);
        }
    }

    private void initCategories(DescContainer descContainer, CommStyleInfo commStyleInfo) {
        if (null == descContainer) {
            return;
        }
        DescContainer[] descContainerArray = descContainer.getDescContainer();
        String string = null;
        String string2 = null;
        String string3 = null;
        CategoryInfo categoryInfo = null;
        String string4 = null;
        Icon icon = null;
        for (DescContainer descContainer2 : descContainerArray) {
            if (null == descContainer2) continue;
            string = commStyleInfo.getResString(descContainer2.getParasItemValue(PARA_NAME));
            if (null == string) {
                string = descContainer2.getParasItemValue(PARA_NAME);
            }
            string2 = descContainer2.getDescName();
            string3 = descContainer2.getParasItemValue(PARA_PARENTID);
            string4 = commStyleInfo.getResString(descContainer2.getParasItemValue(PARA_ICON));
            if (string4 == null) {
                string4 = descContainer2.getParasItemValue(PARA_ICON);
            }
            if (string4 != null) {
                icon = commStyleInfo.getResource().getIcon(string4);
            }
            categoryInfo = new CategoryInfo(string, string2, string3, icon);
            if (this.categoryInfoMap.get(string2) != null) continue;
            this.categoryInfoMap.put(string2, categoryInfo);
        }
    }

    private void initPerspective(DescContainer descContainer, CommStyleInfo commStyleInfo) {
        if (null == descContainer) {
            return;
        }
        DescContainer[] descContainerArray = descContainer.getDescContainer();
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        ArrayList<String> arrayList = null;
        PerspectiveInfo perspectiveInfo = null;
        String string4 = null;
        Icon icon = null;
        DescContainer descContainer2 = null;
        String string5 = null;
        boolean bl = false;
        ArrayList<String> arrayList2 = null;
        String string6 = null;
        for (DescContainer descContainer3 : descContainerArray) {
            if (null == descContainer3) continue;
            string6 = descContainer3.getParasItemValue(PARA_NAME);
            string = commStyleInfo.getResString(string6);
            if (null == string) {
                string = string6;
            }
            string2 = descContainer3.getDescName();
            string3 = descContainer3.getParasItemValue(PARA_CLASS);
            n = descContainer3.getDescContainerCount();
            arrayList = new ArrayList<String>(5);
            arrayList2 = new ArrayList<String>(5);
            for (int i = 0; i < n; ++i) {
                descContainer2 = descContainer3.getDescContainer(i);
                string5 = descContainer2.getParasItemValue(PARA_ID);
                if (null == string5) continue;
                bl = Boolean.valueOf(descContainer2.getParasItemValue(PARA_UNMANAGED));
                if (bl) {
                    arrayList2.add(string5);
                }
                arrayList.add(string5);
            }
            string4 = commStyleInfo.getResString(descContainer3.getParasItemValue(PARA_ICON));
            if (null == string4) {
                string4 = descContainer3.getParasItemValue(PARA_ICON);
            }
            if (null != string4) {
                icon = commStyleInfo.getResource().getIcon(string4);
            }
            perspectiveInfo = new PerspectiveInfo(string, string2, icon, arrayList, string3);
            perspectiveInfo.setUnManagedViews(arrayList2);
            if (this.perspectiveInfoMap.get(string2) == null) {
                this.perspectiveInfoMap.put(string2, perspectiveInfo);
            } else {
                logger.trace("Duplicate perspective id not able to add to perspectiveInfoMap" + string2);
            }
            if (this.perspStyleMap.get(string2) != null) continue;
            this.perspStyleMap.put(string2, commStyleInfo);
        }
    }

    private void initViews(DescContainer descContainer, CommStyleInfo commStyleInfo) {
        if (null == descContainer) {
            return;
        }
        DescContainer[] descContainerArray = descContainer.getDescContainer();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Icon icon = null;
        ViewInfo viewInfo = null;
        CategoryInfo categoryInfo = null;
        String string6 = null;
        for (DescContainer descContainer2 : descContainerArray) {
            if (descContainer2 == null) continue;
            string = commStyleInfo.getResString(descContainer2.getParasItemValue(PARA_NAME));
            if (null == string) {
                string = descContainer2.getParasItemValue(PARA_NAME);
            }
            string2 = descContainer2.getDescName();
            string3 = descContainer2.getParasItemValue(PARA_CLASS);
            string4 = descContainer2.getParasItemValue(PARA_CATEGORY);
            string5 = commStyleInfo.getResString(descContainer2.getParasItemValue(PARA_ICON));
            if (null == string5) {
                string5 = descContainer2.getParasItemValue(PARA_ICON);
            }
            if (null != string5) {
                icon = commStyleInfo.getResource().getIcon(string5);
            }
            categoryInfo = this.categoryInfoMap.get(string4);
            string6 = commStyleInfo.getResString(descContainer2.getParasItemValue(PARA_DESCRIPTION));
            if (null == string6) {
                string6 = descContainer2.getParasItemValue(PARA_DESCRIPTION);
            }
            viewInfo = new ViewInfo(string, string2, string3, icon, categoryInfo);
            if (null != string6) {
                viewInfo.setDescription(string6);
            }
            boolean bl = Boolean.valueOf(descContainer2.getParasItemValue(PARA_MULTIPLEINSTANCE));
            viewInfo.setMultipleInstance(bl);
            if (this.viewInfoMap.get(string2) == null) {
                this.viewInfoMap.put(string2, viewInfo);
            }
            if (this.viewStyleMap.get(string2) == null) {
                this.viewStyleMap.put(string2, commStyleInfo);
            }
            this.initMultipleViews(descContainer2, string2);
        }
    }

    private void initMultipleViews(DescContainer descContainer, String string) {
        DescContainer descContainer2 = descContainer.getDescContainer("MultipleViews");
        if (null != descContainer2) {
            DescContainer[] descContainerArray = null;
            Set<String> set = null;
            for (DescContainer descContainer3 : descContainerArray = descContainer2.getDescContainer()) {
                if (null == descContainer3) continue;
                if (this.idMap == null) {
                    this.idMap = new HashMap<String, Set<String>>(5);
                }
                if ((set = this.idMap.get(string)) == null) {
                    set = new HashSet<String>(5);
                    this.idMap.put(string, set);
                }
                set.add(descContainer3.getDescName());
                this.createView(string, descContainer3.getDescName());
            }
        }
    }

    public PerspectiveInfo getPerspectiveInfo(String string) {
        return this.perspectiveInfoMap.get(string);
    }

    public ViewInfo getViewInfo(String string) {
        return this.viewInfoMap.get(string);
    }

    public void setPerspectiveObj(String string, IPerspective iPerspective) {
        this.perspectiveMap.put(string, iPerspective);
    }

    public IPerspective getPerspectiveObj(String string) {
        return this.perspectiveMap.get(string);
    }

    public PerspectiveFrame getWorkPage(String string) {
        Set<Map.Entry<String, PerspectiveFrame>> set = this.framePerspMap.entrySet();
        if (set != null) {
            Iterator<Map.Entry<String, PerspectiveFrame>> iterator = set.iterator();
            Map.Entry<String, PerspectiveFrame> entry = null;
            boolean bl = iterator.hasNext();
            while (bl) {
                entry = iterator.next();
                if (ResourceUtil.areEquals(entry.getKey(), string)) {
                    return entry.getValue();
                }
                bl = iterator.hasNext();
            }
        }
        return null;
    }

    public void setWorkPage(String string, PerspectiveFrame perspectiveFrame) {
        this.framePerspMap.put(string, perspectiveFrame);
    }

    public ViewManager getViewManager(PerspectiveFrame perspectiveFrame, boolean bl) {
        ViewManager viewManager = this.dockMgrMaP.get(perspectiveFrame);
        if (null == viewManager && bl) {
            viewManager = this.createViewManager(perspectiveFrame);
        }
        return viewManager;
    }

    public void setViewPart(String string, ViewPart viewPart) {
        this.viewPartMap.put(string, viewPart);
    }

    public ViewPart getViewPart(String string) {
        return this.viewPartMap.get(string);
    }

    private ViewManager createViewManager(final PerspectiveFrame perspectiveFrame) {
        ViewManager viewManager = new ViewManager(perspectiveFrame);
        this.dockMgrMaP.put(perspectiveFrame, viewManager);
        perspectiveFrame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                PerspectiveStore.this.savePerspective(perspectiveFrame);
            }
        });
        return viewManager;
    }

    private void savePerspective(PerspectiveFrame perspectiveFrame) {
        try {
            String string = perspectiveFrame.getPerspectiveId();
            CommStyleInfo commStyleInfo = this.perspStyleMap.get(string);
            ViewManager viewManager = this.getViewManager(perspectiveFrame, true);
            String string2 = this.getPerspectiveFilePath(string);
            File file = CommonUtil.getAbsoluteFile(string2);
            if (!file.exists()) {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
            this.savePerspective(string, file);
            DescContainer descContainer = commStyleInfo.getAreaDescContainer()[0].getDescContainer(PERSPECTIVES);
            DescContainer[] descContainerArray = descContainer.getDescContainer();
            DescContainer descContainer2 = null;
            for (int i = 0; i < descContainerArray.length; ++i) {
                if (!ResourceUtil.areEquals(descContainerArray[i].getDescName(), string)) continue;
                descContainer2 = descContainerArray[i];
                break;
            }
            if (null != descContainer2) {
                descContainer2.clearDescContainerList();
            }
            List<ViewPart> list = viewManager.getAllViews();
            int n = list.size();
            ViewPart viewPart = null;
            DescContainer descContainer3 = null;
            PARA pARA = null;
            ArrayList<String> arrayList = new ArrayList<String>(5);
            for (int i = 0; i < n; ++i) {
                viewPart = list.get(i);
                descContainer3 = new DescContainer(viewPart.getViewId());
                pARA = new PARA();
                pARA.setName(PARA_ID);
                pARA.setValue(viewPart.getViewId());
                descContainer3.addParasItem(pARA);
                if (null != descContainer2) {
                    descContainer2.addDescContainer(descContainer3);
                }
                arrayList.add(viewPart.getViewId());
            }
            this.writeStyleInfo(commStyleInfo);
            this.perspStyleMap.put(string, commStyleInfo);
            this.perspectiveInfoMap.get(string).setViewIds(arrayList);
        }
        catch (IOException iOException) {
            logger.trace(iOException);
        }
    }

    void savePerspective(String string, File file) throws IOException {
        PerspectiveFrame perspectiveFrame = this.getWorkPage(string);
        if (null == perspectiveFrame) {
            logger.trace("Perspective with the given id is not there " + string);
            return;
        }
        ViewManager viewManager = this.getViewManager(perspectiveFrame, true);
        if (null == viewManager) {
            logger.trace("View Manager not exists");
            return;
        }
        viewManager.saveWorkPage(file);
    }

    public String getPerspectiveFilePath(String string) {
        if (string == null) {
            return null;
        }
        String string2 = CommStyleManager.getInstance().getUserDir() + LAYOUT_DIR + System.getProperty("file.separator") + string + ".xml";
        return string2;
    }

    public boolean userLayoutExists(String string) {
        String string2 = this.getPerspectiveFilePath(string);
        return new File(string2).exists();
    }

    public HashMap<String, PerspectiveInfo> getAllPerspectiveInfo() {
        if (!this.perspectiveInfoMap.isEmpty()) {
            return this.perspectiveInfoMap;
        }
        return null;
    }

    public void setGUIStyle(boolean bl) {
        Collection<ViewManager> collection = this.dockMgrMaP.values();
        ViewManager viewManager2 = null;
        for (ViewManager viewManager2 : collection) {
            viewManager2.setDraggable(bl);
        }
    }

    public String getPluginName(String string, boolean bl) {
        String string2 = null;
        CommStyleInfo commStyleInfo = null;
        commStyleInfo = bl ? this.viewStyleMap.get(string) : this.perspStyleMap.get(string);
        if (null != commStyleInfo) {
            string2 = commStyleInfo.getPluginName();
        }
        return string2;
    }

    String createUniqueId(String string) {
        boolean bl;
        int n = 0;
        if (this.idMap == null) {
            this.idMap = new HashMap<String, Set<String>>(5);
        }
        String string2 = string + '#' + n;
        Set<String> set = this.idMap.get(string);
        if (set != null) {
            bl = set.contains(string2);
            while (bl) {
                string2 = string + '#' + ++n;
                bl = set.contains(string2);
            }
        } else {
            set = new HashSet<String>(5);
            this.idMap.put(string, set);
        }
        boolean bl2 = bl = this.viewInfoMap.get(string2) != null;
        while (bl) {
            string2 = string + '#' + ++n;
            bl = this.viewInfoMap.get(string2) != null;
        }
        set.add(string2);
        return string2;
    }

    boolean createView(String string, String string2) {
        ViewInfo viewInfo = this.viewInfoMap.get(string);
        ViewInfo viewInfo2 = new ViewInfo(viewInfo.getName(), string2, viewInfo.getViewClass(), viewInfo.getIcon(), viewInfo.getCategory());
        viewInfo2.setDescription(viewInfo.getDescription());
        if (this.viewInfoMap.get(string2) != null) {
            logger.trace("Unable to create the multiple instance of view " + string + " with id " + string2);
            return false;
        }
        this.viewInfoMap.put(string2, viewInfo2);
        if (this.viewStyleMap.get(string2) != null) {
            logger.trace("Unable to create the multiple instance of view " + string);
            return false;
        }
        CommStyleInfo commStyleInfo = this.viewStyleMap.get(string);
        this.updateViewStyleInfo(commStyleInfo, string, string2);
        this.viewStyleMap.put(string2, commStyleInfo);
        return true;
    }

    private void updateViewStyleInfo(CommStyleInfo commStyleInfo, String string, String string2) {
        int n = commStyleInfo.getAreaDescCount();
        AreaDescContainer areaDescContainer = null;
        DescContainer descContainer = null;
        DescContainer descContainer2 = null;
        DescContainer descContainer3 = null;
        DescContainer descContainer4 = null;
        for (int i = 0; i < n; ++i) {
            areaDescContainer = commStyleInfo.getAreaDescContainer()[i];
            descContainer = areaDescContainer.getDescContainer(VIEWS);
            descContainer2 = descContainer.getDescContainer(string);
            descContainer3 = descContainer2.getDescContainer("MultipleViews");
            if (null == descContainer3) {
                descContainer3 = new DescContainer("MultipleViews");
                descContainer2.addDescContainer(descContainer3);
            }
            if (null != (descContainer4 = descContainer3.getDescContainer(string2))) continue;
            descContainer4 = new DescContainer(string2);
            descContainer3.addDescContainer(descContainer4);
        }
    }

    void addView(String string, String string2) {
        ArrayList<String> arrayList;
        PerspectiveInfo perspectiveInfo = this.perspectiveInfoMap.get(string);
        List<String> list = perspectiveInfo.getViewIds();
        if (list != null) {
            if (list.contains(string2)) {
                logger.trace("View id is already present in the perspective " + string2);
                return;
            }
            list.add(string2);
            arrayList = perspectiveInfo.getUnManagedViews();
            if (arrayList == null) {
                arrayList = new ArrayList<String>(5);
                perspectiveInfo.setUnManagedViews(arrayList);
            }
            arrayList.add(string2);
        }
        arrayList = this.perspStyleMap.get(string);
        int n = ((CommStyleInfo)((Object)arrayList)).getAreaDescContainerCount();
        AreaDescContainer areaDescContainer = null;
        DescContainer descContainer = null;
        DescContainer descContainer2 = null;
        DescContainer descContainer3 = null;
        for (int i = 0; i < n; ++i) {
            areaDescContainer = ((CommStyleInfo)((Object)arrayList)).getAreaDescContainer(i);
            descContainer = areaDescContainer.getDescContainer(PERSPECTIVES);
            if (descContainer == null || (descContainer2 = descContainer.getDescContainer(string)) == null) continue;
            descContainer3 = new DescContainer(string2);
            descContainer3.setParasItem(PARA_ID, string2, true);
            descContainer3.setParasItem(PARA_UNMANAGED, "true", true);
            descContainer2.addDescContainer(descContainer3);
        }
        this.writeStyleInfo((CommStyleInfo)((Object)arrayList));
    }

    private void writeStyleInfo(CommStyleInfo commStyleInfo) {
        String string = commStyleInfo.getPluginName();
        Plugin plugin = PluginManager.getInstance().getPlugin(string);
        if (null != plugin) {
            try {
                plugin.getCommStyleParser().writeToUser(commStyleInfo);
            }
            catch (IOException iOException) {
                logger.trace("Unable to write the style information to user folder " + iOException);
            }
        }
    }

    void removeView(String string, String string2) {
        PerspectiveInfo perspectiveInfo = this.perspectiveInfoMap.get(string);
        List<String> list = perspectiveInfo.getViewIds();
        if (list == null) {
            logger.trace("No views exist in the perspective");
            return;
        }
        if (!list.contains(string2)) {
            logger.trace("View " + string2 + " not exsist in the perspective " + string);
            return;
        }
        list.remove(string2);
        CommStyleInfo commStyleInfo = this.perspStyleMap.get(string);
        int n = commStyleInfo.getAreaDescContainerCount();
        AreaDescContainer areaDescContainer = null;
        DescContainer descContainer = null;
        DescContainer descContainer2 = null;
        for (int i = 0; i < n; ++i) {
            areaDescContainer = commStyleInfo.getAreaDescContainer(i);
            if (areaDescContainer == null || (descContainer = areaDescContainer.getDescContainer(PERSPECTIVES)) == null || (descContainer2 = descContainer.getDescContainer(string)) == null) continue;
            descContainer2.removeDescContainer(string2);
        }
        this.writeStyleInfo(commStyleInfo);
    }

    void clearUnManagedView(String string, String string2) {
        CommStyleInfo commStyleInfo = this.perspStyleMap.get(string);
        int n = commStyleInfo.getAreaDescContainerCount();
        AreaDescContainer areaDescContainer = null;
        DescContainer descContainer = null;
        DescContainer descContainer2 = null;
        DescContainer descContainer3 = null;
        for (int i = 0; i < n; ++i) {
            areaDescContainer = commStyleInfo.getAreaDescContainer(i);
            if (areaDescContainer == null || (descContainer = areaDescContainer.getDescContainer(PERSPECTIVES)) == null || (descContainer2 = descContainer.getDescContainer(string)) == null || (descContainer3 = descContainer2.getDescContainer(string2)) == null) continue;
            descContainer3.setParasItem(PARA_UNMANAGED, "false", false);
        }
    }

    void clean() {
        this.categoryInfoMap.clear();
        this.perspectiveInfoMap.clear();
        this.perspStyleMap.clear();
        this.viewInfoMap.clear();
        this.framePerspMap.clear();
        this.perspectiveMap.clear();
        this.dockMgrMaP.clear();
        this.viewStyleMap.clear();
        this.viewPartMap.clear();
        this.viewPartMap = null;
        if (this.idMap != null) {
            this.idMap.clear();
        }
        instance = null;
    }
}

