/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.dockingmanagement;

import com.swimap.iview.framework.dockingmanagement.IPerspective;
import com.swimap.iview.framework.dockingmanagement.PerspectiveFrame;
import com.swimap.iview.framework.dockingmanagement.PerspectiveInfo;
import com.swimap.iview.framework.dockingmanagement.PerspectiveStore;
import com.swimap.iview.framework.dockingmanagement.ViewInfo;
import com.swimap.iview.framework.dockingmanagement.ViewInitException;
import com.swimap.iview.framework.dockingmanagement.ViewManager;
import com.swimap.iview.framework.dockingmanagement.ViewPart;
import com.swimap.iview.framework.dockingmanagement.layout.PageLayout;
import com.swimap.iview.framework.dockingmanagement.layout.ViewLayoutInfo;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.WindowManager;
import com.swimap.iview.util.ReflectionUtilities;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;

public final class PerspectiveManager {
    private PerspectiveStore store = null;
    private boolean setStyleFlag = false;
    private static final int SIZE = 5;
    private static PerspectiveManager instance;
    private static IviewLogger logger;

    private PerspectiveManager() {
        this.init();
    }

    private void init() {
        if (this.store == null) {
            this.store = PerspectiveStore.getInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PerspectiveManager getInstance() {
        if (null != instance) return instance;
        Class<PerspectiveManager> clazz = PerspectiveManager.class;
        synchronized (PerspectiveManager.class) {
            if (null != instance) return instance;
            instance = new PerspectiveManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void loadPerspective(String string) {
        Object object;
        if (null == string || string.length() == 0) {
            logger.trace("Invalid perspectiveId");
            return;
        }
        PerspectiveFrame perspectiveFrame = this.store.getWorkPage(string);
        WindowManager windowManager = FrameworkUtilities.getWindowManager();
        if (null != perspectiveFrame) {
            windowManager.registerWindow(perspectiveFrame);
            windowManager.activateWindow(perspectiveFrame.getWindowId());
            return;
        }
        PerspectiveInfo perspectiveInfo = this.store.getPerspectiveInfo(string);
        if (null == perspectiveInfo) {
            logger.trace("Perspective not exists" + string);
            return;
        }
        perspectiveFrame = new PerspectiveFrame(perspectiveInfo.getName(), string);
        Icon icon = perspectiveInfo.getIcon();
        if (null != icon) {
            perspectiveFrame.setFrameIcon(icon);
        }
        windowManager.registerWindow(perspectiveFrame);
        windowManager.activateWindow(perspectiveFrame.getWindowId());
        IPerspective iPerspective = null;
        try {
            object = this.store.getPluginName(string, false);
            iPerspective = (IPerspective)this.createObject(perspectiveInfo.getPerspClass(), (String)object);
            this.store.setPerspectiveObj(string, iPerspective);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return;
        }
        object = new ArrayList(5);
        List<String> list = perspectiveInfo.getViewIds();
        ViewInfo viewInfo = null;
        for (String string2 : list) {
            viewInfo = this.getViewInfo(string2);
            ((ArrayList)object).add(viewInfo);
        }
        if (!this.store.userLayoutExists(string)) {
            this.addViewsWithLayout(iPerspective, (ArrayList<ViewInfo>)object, perspectiveInfo, perspectiveFrame);
        }
        this.store.setWorkPage(string, perspectiveFrame);
        this.loadPerspective(perspectiveFrame, perspectiveInfo);
    }

    private void addViewsWithLayout(IPerspective iPerspective, ArrayList<ViewInfo> arrayList, PerspectiveInfo perspectiveInfo, PerspectiveFrame perspectiveFrame) {
        if (null != iPerspective) {
            PageLayout pageLayout = new PageLayout();
            List<String> list = perspectiveInfo.getViewIds();
            iPerspective.createPerspective(pageLayout, perspectiveInfo, arrayList.toArray(new ViewInfo[arrayList.size()]));
            ViewLayoutInfo viewLayoutInfo = null;
            ViewInfo viewInfo = null;
            for (String string : list) {
                viewLayoutInfo = pageLayout.getLayoutInfo(string);
                if (null == viewLayoutInfo || iPerspective.acceptView(viewInfo = this.getViewInfo(viewLayoutInfo.getViewPart().getViewId()))) continue;
                pageLayout.getViewLayoutInfoList().remove(viewLayoutInfo);
            }
            ViewManager viewManager = this.store.getViewManager(perspectiveFrame, true);
            try {
                viewManager.addViewsWithPageLayout(pageLayout);
            }
            catch (ViewInitException viewInitException) {
                logger.trace(viewInitException.getMessage(), viewInitException);
            }
        }
    }

    private void loadPerspective(PerspectiveFrame perspectiveFrame, PerspectiveInfo perspectiveInfo) {
        ViewManager viewManager = this.store.getViewManager(perspectiveFrame, true);
        List<String> list = perspectiveInfo.getViewIds();
        ArrayList<ViewPart> arrayList = new ArrayList<ViewPart>(5);
        ArrayList<ViewPart> arrayList2 = new ArrayList<ViewPart>(5);
        List<ViewPart> list2 = viewManager.getAllViews();
        String string = null;
        List<String> list3 = perspectiveInfo.getUnManagedViews();
        for (ViewPart object2 : list2) {
            string = object2.getViewId();
            if (list.contains(string)) {
                arrayList2.add(object2);
                continue;
            }
            arrayList.add(object2);
        }
        for (ViewPart viewPart : arrayList) {
            viewManager.removeView(viewPart.getViewId());
        }
        String string2 = this.store.getPerspectiveFilePath(perspectiveInfo.getPerspectiveId());
        File file = new File(string2);
        boolean bl = file.exists();
        if (bl) {
            try {
                if (!this.setStyleFlag) {
                    this.setStyleFlag = this.setStyleFromPerspectiveFile(perspectiveInfo.getPerspectiveId(), file);
                }
            }
            catch (IOException iOException) {
                logger.trace("Not able to load perspective " + perspectiveInfo.getPerspectiveId() + iOException);
            }
        }
        for (String string3 : list) {
            if (list3 == null || list3.contains(string3)) continue;
            this.addView(perspectiveFrame, this.store.getViewInfo(string3));
        }
        if (bl) {
            try {
                this.loadPerspective(perspectiveInfo.getPerspectiveId(), file);
            }
            catch (IOException iOException) {
                logger.trace("Not able to load perspective " + perspectiveInfo.getPerspectiveId() + iOException);
            }
        }
        if (list3 != null) {
            for (String string3 : list3) {
                this.addView(perspectiveFrame, this.store.getViewInfo(string3));
                this.store.clearUnManagedView(perspectiveInfo.getPerspectiveId(), string3);
            }
            list3.clear();
        }
    }

    private boolean setStyleFromPerspectiveFile(String string, File file) throws IOException {
        if (null == string || string.length() == 0 || null == file) {
            logger.trace("Invalid Perspective or file");
            return false;
        }
        PerspectiveFrame perspectiveFrame = this.store.getWorkPage(string);
        if (null == perspectiveFrame) {
            logger.trace("Perspective not open");
            return false;
        }
        ViewManager viewManager = this.store.getViewManager(perspectiveFrame, true);
        return viewManager.setStyleFromPerspectiveFile(file);
    }

    public void loadPerspective(String string, File file) throws IOException {
        if (null == string || string.length() == 0 || null == file) {
            logger.trace("Invalid Perspective or file");
            return;
        }
        PerspectiveFrame perspectiveFrame = this.store.getWorkPage(string);
        if (null == perspectiveFrame) {
            logger.trace("Perspective not open");
            return;
        }
        ViewManager viewManager = this.store.getViewManager(perspectiveFrame, true);
        viewManager.loadWorkPage(file);
    }

    public void addView(String string, String string2) {
        Object object;
        if (!this.ensureValidity(string, string2)) {
            return;
        }
        ViewInfo viewInfo = this.store.getViewInfo(string2);
        if (null == this.store.getViewPart(string2)) {
            object = this.createViewPart(viewInfo);
            this.store.setViewPart(string2, (ViewPart)object);
        }
        if (null == (object = this.store.getWorkPage(string))) {
            this.store.addView(string, string2);
        } else {
            this.addView((PerspectiveFrame)object, viewInfo);
        }
    }

    private void addView(PerspectiveFrame perspectiveFrame, ViewInfo viewInfo) {
        boolean bl = false;
        IPerspective iPerspective = this.store.getPerspectiveObj(perspectiveFrame.getPerspectiveId());
        if (null != iPerspective && !iPerspective.acceptView(viewInfo)) {
            logger.trace("The perspective " + perspectiveFrame.getPerspectiveId() + " does not accept the view " + viewInfo.getName());
            return;
        }
        perspectiveFrame.requestFocus();
        ViewManager viewManager = this.store.getViewManager(perspectiveFrame, true);
        String string = viewInfo.getViewId();
        bl = this.isViewInFrame(perspectiveFrame, string);
        if (!bl) {
            try {
                ViewPart viewPart = this.createViewPart(viewInfo);
                viewManager.addView(viewPart);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
                return;
            }
        }
        viewManager.showView(viewInfo.getViewId());
    }

    private ViewPart createViewPart(ViewInfo viewInfo) {
        String string = viewInfo.getViewId();
        String string2 = viewInfo.getViewClass();
        ViewPart viewPart = this.store.getViewPart(string);
        try {
            if (null == viewPart) {
                String string3 = this.store.getPluginName(string, true);
                Object object = this.createObject(string2, string3);
                viewPart = (ViewPart)object;
                viewPart.loadView(string);
                viewPart.setViewInfo(viewInfo);
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return viewPart;
    }

    public void addViews(String string, PageLayout pageLayout) {
        if (null == string || string.length() == 0 || null == pageLayout) {
            return;
        }
        PerspectiveInfo perspectiveInfo = this.store.getPerspectiveInfo(string);
        if (perspectiveInfo == null) {
            logger.trace("Perspective not exists " + string);
            return;
        }
        PerspectiveFrame perspectiveFrame = this.store.getWorkPage(string);
        if (null == perspectiveFrame) {
            this.addViewsToPerspective(string, pageLayout);
            return;
        }
        perspectiveFrame.requestFocus();
        ViewManager viewManager = this.store.getViewManager(perspectiveFrame, true);
        if (null == viewManager) {
            logger.trace("Manager is not created");
            return;
        }
        viewManager.addViews(pageLayout);
        IPerspective iPerspective = this.store.getPerspectiveObj(string);
        if (iPerspective == null) {
            logger.trace("perspObj is null");
            return;
        }
        ViewLayoutInfo viewLayoutInfo = null;
        ViewInfo viewInfo = null;
        Set<String> set = viewManager.getViews();
        ArrayList<String> arrayList = new ArrayList<String>(5);
        if (null != set) {
            for (String string2 : set) {
                viewLayoutInfo = pageLayout.getLayoutInfo(string2);
                if (null == viewLayoutInfo || (viewInfo = this.getViewInfo(viewLayoutInfo.getViewPart().getViewId())) == null || iPerspective.acceptView(viewInfo)) continue;
                arrayList.add(viewInfo.getViewId());
            }
            for (String string2 : arrayList) {
                this.removeView(perspectiveInfo.getPerspectiveId(), string2);
            }
        }
    }

    private void addViewsToPerspective(String string, PageLayout pageLayout) {
        ViewPart viewPart = null;
        for (ViewLayoutInfo viewLayoutInfo : pageLayout.getViewLayoutInfoList()) {
            viewPart = viewLayoutInfo.getViewPart();
            if (null == viewPart) continue;
            this.store.addView(string, viewPart.getViewId());
        }
    }

    public void removeView(String string, String string2) {
        if (!this.ensureValidity(string, string2)) {
            return;
        }
        PerspectiveFrame perspectiveFrame = this.store.getWorkPage(string);
        if (null == perspectiveFrame) {
            this.removeViewFromPerspective(string, string2);
            logger.trace("The perspectiveId is invalid.");
            return;
        }
        ViewManager viewManager = this.store.getViewManager(perspectiveFrame, true);
        if (null != viewManager) {
            viewManager.removeView(string2);
        } else {
            logger.trace("The frame does not have a viewmanager");
        }
    }

    private void removeViewFromPerspective(String string, String string2) {
        this.store.removeView(string, string2);
    }

    private ViewPart findView(String string, String string2) {
        PerspectiveFrame perspectiveFrame = this.store.getWorkPage(string);
        if (null == perspectiveFrame) {
            logger.trace("The perspective " + string + " does notmatch with any frame");
            return null;
        }
        ViewManager viewManager = this.store.getViewManager(perspectiveFrame, true);
        if (null != viewManager) {
            return viewManager.findView(string2);
        }
        logger.trace("The frame does not have a viewmanager");
        return null;
    }

    public void showView(String string, String string2) {
        if (!this.ensureValidity(string, string2)) {
            return;
        }
        PerspectiveFrame perspectiveFrame = this.store.getWorkPage(string);
        if (null == perspectiveFrame) {
            logger.trace("The perspective not loaded");
            return;
        }
        ViewManager viewManager = this.store.getViewManager(perspectiveFrame, false);
        if (null != viewManager) {
            viewManager.showView(string2);
        } else {
            logger.trace("The frame does not have a viewmanager");
        }
    }

    public void hideView(String string, String string2) {
        if (!this.ensureValidity(string, string2)) {
            return;
        }
        PerspectiveFrame perspectiveFrame = this.store.getWorkPage(string);
        if (null == perspectiveFrame) {
            logger.trace("Perspective not loaded");
            return;
        }
        ViewManager viewManager = this.store.getViewManager(perspectiveFrame, false);
        if (null != viewManager) {
            viewManager.hideView(string2);
        } else {
            logger.trace("The frame does not have a viewmanager");
        }
    }

    private boolean isViewInFrame(PerspectiveFrame perspectiveFrame, String string) {
        ViewManager viewManager = this.store.getViewManager(perspectiveFrame, true);
        ViewPart viewPart = viewManager.findView(string);
        return null != viewPart;
    }

    public void savePerspective(String string, File file) throws IOException {
        if (null == string || string.length() == 0 || null == file) {
            return;
        }
        this.store.savePerspective(string, file);
    }

    public ViewInfo getViewInfo(String string) {
        return this.store.getViewInfo(string);
    }

    public String getPerspective(ViewPart viewPart) {
        HashMap<String, PerspectiveInfo> hashMap = this.store.getAllPerspectiveInfo();
        if (null != hashMap) {
            Set<Map.Entry<String, PerspectiveInfo>> set = hashMap.entrySet();
            Iterator<Map.Entry<String, PerspectiveInfo>> iterator = set.iterator();
            Map.Entry<String, PerspectiveInfo> entry = null;
            ViewPart viewPart2 = null;
            String string = null;
            boolean bl = iterator.hasNext();
            while (bl) {
                entry = iterator.next();
                if (null != entry && null != viewPart) {
                    string = viewPart.getViewId();
                    viewPart2 = this.findView(entry.getKey(), string);
                    if (viewPart.equals(viewPart2)) {
                        return entry.getKey();
                    }
                }
                bl = iterator.hasNext();
            }
        }
        return null;
    }

    public void resetPerspective(String string) {
        if (null == string || string.length() == 0) {
            return;
        }
        PerspectiveFrame perspectiveFrame = this.store.getWorkPage(string);
        PerspectiveInfo perspectiveInfo = this.store.getPerspectiveInfo(string);
        IPerspective iPerspective = this.store.getPerspectiveObj(string);
        ArrayList<ViewInfo> arrayList = new ArrayList<ViewInfo>(5);
        List<String> list = perspectiveInfo.getViewIds();
        ViewInfo viewInfo = null;
        for (String string2 : list) {
            viewInfo = this.store.getViewInfo(string2);
            arrayList.add(viewInfo);
        }
        if (!this.store.userLayoutExists(string)) {
            for (String string2 : list) {
                this.removeView(string, string2);
            }
            this.addViewsWithLayout(iPerspective, arrayList, perspectiveInfo, perspectiveFrame);
        }
        this.loadPerspective(perspectiveFrame, perspectiveInfo);
    }

    public void setGUIStyle(boolean bl) {
        this.store.setGUIStyle(bl);
    }

    public String createMultipleInstance(String string, String string2) {
        if (!this.ensureValidity(string, string2)) {
            return null;
        }
        ViewInfo viewInfo = this.store.getViewInfo(string2);
        boolean bl = this.isMultipleInstance(viewInfo);
        String string3 = null;
        boolean bl2 = false;
        PerspectiveFrame perspectiveFrame = this.store.getWorkPage(string);
        if (null == perspectiveFrame) {
            logger.trace("The Pespective not open." + string);
            PerspectiveInfo perspectiveInfo = this.store.getPerspectiveInfo(string);
            List<String> list = perspectiveInfo.getViewIds();
            if (list != null && !list.contains(string2)) {
                this.store.addView(string, string2);
                return string2;
            }
            if (bl && (bl2 = this.store.createView(string2, string3 = this.createUniqueId(string2)))) {
                this.store.addView(string, string2);
                return string3;
            }
            return null;
        }
        if (!this.isViewInFrame(perspectiveFrame, string2)) {
            this.addView(perspectiveFrame, viewInfo);
            return string2;
        }
        if (bl) {
            string3 = this.createUniqueId(string2);
            bl2 = this.store.createView(string2, string3);
        }
        if (bl2) {
            ViewInfo viewInfo2 = this.store.getViewInfo(string3);
            this.addView(perspectiveFrame, viewInfo2);
            return string3;
        }
        return null;
    }

    private boolean isMultipleInstance(ViewInfo viewInfo) {
        String string = viewInfo.getViewId();
        ViewPart viewPart = this.store.getViewPart(string);
        if (null == viewPart) {
            viewPart = this.createViewPart(viewInfo);
            this.store.setViewPart(string, viewPart);
        }
        if (null == viewPart) {
            return viewInfo.isMultipleInstance();
        }
        return viewPart.isMultipleInstance();
    }

    private String createUniqueId(String string) {
        return this.store.createUniqueId(string);
    }

    public Object createObject(String string, String string2) throws Exception {
        Plugin plugin = PluginManager.getInstance().getPlugin(string2);
        if (null == plugin) {
            return null;
        }
        Class clazz = plugin.loadClass(string);
        Object object = ReflectionUtilities.instantiateTheClass(clazz);
        return object;
    }

    public PerspectiveStore getStore() {
        return this.store;
    }

    public ViewLayoutInfo getLayout(String string, String string2) {
        if (!this.ensureValidity(string, string2)) {
            return null;
        }
        PerspectiveFrame perspectiveFrame = this.store.getWorkPage(string);
        if (null == perspectiveFrame) {
            logger.trace("The perspective not open");
            return null;
        }
        ViewManager viewManager = this.store.getViewManager(perspectiveFrame, false);
        if (null != viewManager) {
            return viewManager.getLayout(string2);
        }
        logger.trace("The frame does not have a viewmanager");
        return null;
    }

    private boolean ensureValidity(String string, String string2) {
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            logger.trace("Invalid perspective or view id");
            return false;
        }
        if (this.store.getPerspectiveInfo(string) == null) {
            logger.trace("Perspective not exists " + string);
            return false;
        }
        ViewInfo viewInfo = this.store.getViewInfo(string2);
        if (null == viewInfo) {
            logger.trace("The view not exist " + string2);
            return false;
        }
        return true;
    }

    public void cleanUp() {
        if (null != this.store) {
            this.store.clean();
        }
        this.store = null;
        instance = null;
    }

    public boolean isPerspectiveFrame(Object object) {
        return object instanceof PerspectiveFrame;
    }

    public void cleanupWhileOSGIExit() {
        this.cleanUp();
        logger = null;
    }

    static {
        logger = IviewLogger.getLogger(PerspectiveManager.class, "IVIEW");
    }
}

