/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.datasharemanagement;

import com.swimap.iview.corbahelpers.DataChangeNotification;
import com.swimap.iview.corbahelpers.DataShareInterface;
import com.swimap.iview.framework.datasharemanagement.BaseDataShare;
import com.swimap.iview.framework.datasharemanagement.DataShareManagementException;
import com.swimap.iview.framework.datasharemanagement.IUniversalDataShareStoreInterface;
import java.util.Hashtable;

public class UniversalDataShareStore
implements IUniversalDataShareStoreInterface {
    private Hashtable dataShareInterfaces = new Hashtable(11);

    @Override
    public synchronized void addDataShare(String string, BaseDataShare baseDataShare) throws DataShareManagementException {
        if (this.dataShareInterfaces.get(string) != null) {
            throw new DataShareManagementException("Failed to add the data share interface with Id = " + string + " since the interface Id is already used");
        }
        this.dataShareInterfaces.put(string, baseDataShare);
    }

    @Override
    public synchronized BaseDataShare getLocalDataShare(String string) throws DataShareManagementException {
        BaseDataShare baseDataShare = (BaseDataShare)this.dataShareInterfaces.get(string);
        if (baseDataShare == null) {
            throw new DataShareManagementException("Failed to get the local data share interface with Id = " + string);
        }
        return baseDataShare;
    }

    @Override
    public synchronized DataShareInterface getRemoteDataShare(String string) throws DataShareManagementException {
        DataShareInterface dataShareInterface = null;
        BaseDataShare baseDataShare = (BaseDataShare)this.dataShareInterfaces.get(string);
        if (baseDataShare == null) {
            throw new DataShareManagementException("Failed to get the remote data share interface with Id = " + string);
        }
        dataShareInterface = baseDataShare.getRemoteDataShareInterface();
        if (dataShareInterface == null) {
            throw new DataShareManagementException("The data share interface with Id = " + string + " does not support a remote interface." + " It only supports a local java interface");
        }
        return dataShareInterface;
    }

    @Override
    public synchronized void removeDataShare(String string) throws DataShareManagementException {
        this.dataShareInterfaces.remove(string);
    }

    @Override
    public synchronized int notifyChangeListeners(String string, DataChangeNotification[] dataChangeNotificationArray) throws DataShareManagementException {
        BaseDataShare baseDataShare = this.getLocalDataShare(string);
        return baseDataShare.fireDataChangeNotification(dataChangeNotificationArray);
    }
}

