/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.datasharemanagement;

import com.swimap.iview.corbahelpers.DataChangeNotification;
import com.swimap.iview.corbahelpers.DataShareInterface;
import com.swimap.iview.framework.datasharemanagement.BaseDataShare;
import com.swimap.iview.framework.datasharemanagement.DataShareManagementException;
import com.swimap.iview.framework.datasharemanagement.IDataShareManagerInterface;
import com.swimap.iview.framework.datasharemanagement.IUniversalDataShareStoreInterface;
import com.swimap.iview.framework.datasharemanagement.UniversalDataShareStore;
import com.swimap.iview.util.log.IviewLogger;

public class DataShareManager
implements IDataShareManagerInterface {
    private static IviewLogger logger = IviewLogger.getLogger(DataShareManager.class, "IVIEW");
    protected IUniversalDataShareStoreInterface dataShareStore = new UniversalDataShareStore();

    @Override
    public void addDataShareInterface(String string, BaseDataShare baseDataShare) throws DataShareManagementException {
        this.dataShareStore.addDataShare(string, baseDataShare);
    }

    @Override
    public BaseDataShare getLocalDataShareInterface(String string) throws DataShareManagementException {
        return this.dataShareStore.getLocalDataShare(string);
    }

    @Override
    public DataShareInterface getRemoteDataShareInterface(String string) {
        DataShareInterface dataShareInterface = null;
        try {
            dataShareInterface = this.dataShareStore.getRemoteDataShare(string);
        }
        catch (DataShareManagementException dataShareManagementException) {
            logger.trace(dataShareManagementException.getMessage(), dataShareManagementException);
        }
        return dataShareInterface;
    }

    @Override
    public void removeDataShareInterface(String string) throws DataShareManagementException {
        this.dataShareStore.removeDataShare(string);
    }

    public void setLocalStore(IUniversalDataShareStoreInterface iUniversalDataShareStoreInterface) {
        this.dataShareStore = iUniversalDataShareStoreInterface;
    }

    @Override
    public int notifyChangeListeners(String string, DataChangeNotification[] dataChangeNotificationArray) throws DataShareManagementException {
        return this.dataShareStore.notifyChangeListeners(string, dataChangeNotificationArray);
    }
}

