/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.datasharemanagement;

import com.swimap.iview.corbahelpers.DataChangeListenerInterface;
import com.swimap.iview.corbahelpers.DataChangeListenerInterfaceOperations;
import com.swimap.iview.corbahelpers.DataChangeNotification;
import com.swimap.iview.corbahelpers.DataShareInterface;
import com.swimap.iview.framework.datasharemanagement.IUniversalDataShareInterfaceOperations;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.log.IviewLogger;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.Servant;

public abstract class BaseDataShare
implements IUniversalDataShareInterfaceOperations {
    private static IviewLogger logger = IviewLogger.getLogger(BaseDataShare.class, "IVIEW");
    protected Hashtable listenerStore = new Hashtable(11);
    protected int key = 0;
    protected DataShareInterface remoteDataShareInterface = null;

    @Override
    public int addDataChangeListener(DataChangeListenerInterfaceOperations dataChangeListenerInterfaceOperations) {
        ++this.key;
        this.listenerStore.put(this.key, dataChangeListenerInterfaceOperations);
        return this.key;
    }

    public int addDataChangeListener(DataChangeListenerInterface dataChangeListenerInterface) {
        ++this.key;
        this.listenerStore.put(this.key, dataChangeListenerInterface);
        return this.key;
    }

    public boolean removeDataChangeListener(int n) {
        boolean bl = false;
        if (this.listenerStore.remove(n) != null) {
            bl = true;
        }
        return bl;
    }

    public int fireDataChangeNotification(DataChangeNotification[] dataChangeNotificationArray) {
        int n = 0;
        Enumeration enumeration = this.listenerStore.elements();
        DataChangeListenerInterfaceOperations dataChangeListenerInterfaceOperations = null;
        while (enumeration.hasMoreElements()) {
            dataChangeListenerInterfaceOperations = (DataChangeListenerInterfaceOperations)enumeration.nextElement();
            dataChangeListenerInterfaceOperations.dataChanged(dataChangeNotificationArray);
            ++n;
        }
        return n;
    }

    public DataShareInterface getRemoteDataShareInterface() {
        return this.remoteDataShareInterface;
    }

    protected void createRemoteDataShare(ORB oRB) {
        try {
            Servant servant = FrameworkUtilities.createObject(this.getDataSharePOATieClassName(), this.getDataShareInterfaceClassName(), this);
            this.remoteDataShareInterface = (DataShareInterface)FrameworkUtilities.invokeNarrow(this.getDataShareHelperClassName(), servant._this_object(oRB));
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    protected abstract String getDataSharePOATieClassName();

    protected abstract String getDataShareInterfaceClassName();

    protected abstract String getDataShareHelperClassName();
}

