/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.customizedialog;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.customizedialog.SelectObject;
import com.swimap.iview.framework.customizedialog.SelectObjectVector;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.dialog.DetailMessageDlg;
import com.swimap.iview.templates.toolbar.Toolbar;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.helpmanagement.HelpManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class CustomizeDialog
extends JDialog {
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/customizedialog/Res");
    private static final int BUTTON_HEIGHT = 21;
    private static final int DIALOG_WIDTH = 512;
    private static final int DIALOG_NORMAL_HEIGHT = 196;
    private static final int DIALOG_EXPAND_HEIGHT = 350;
    private static final EtchedBorder ETCHED_BORDER = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
    private JSplitPane splitPane = new JSplitPane();
    private JButton applyBtn = new JButton();
    private JButton cancelBtn = new JButton();
    private JButton okBtn = new JButton();
    private JPanel memberPane = new JPanel();
    private JScrollPane groupScrollPane = new JScrollPane();
    private JPanel rightPane = new JPanel();
    private JButton advancedBtn = new JButton();
    private JButton resetGroupBtn = new JButton();
    private DefaultTableModel groupModel = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }
    };
    private JTable groupTable = new JTable(this.groupModel);
    private JCheckBox editor = new JCheckBox(null, null, false);
    private JButton addBtn = new JButton();
    private JButton deleteBtn = new JButton();
    private JButton resetMemberBtn = new JButton();
    private JList memberList = new JList();
    private JList selectionList = new JList();
    private boolean bShowDetail = false;
    private Toolbar toolbar = null;
    private SelectObjectVector theSelectObjectVector = null;
    private Icon selectIcon = null;
    private Icon noneSelectIcon = null;
    private String[] columnNames = new String[]{"", ""};
    private DefaultTableCellRenderer checkboxRenderer = new DefaultTableCellRenderer(){
        private JCheckBox renderer = new JCheckBox(null, null, false);

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof SelectObject) {
                boolean bl3 = ((SelectObject)object).isTempSelected();
                this.renderer.setSelected(bl3);
                if (bl3) {
                    this.renderer.setIcon(CustomizeDialog.this.selectIcon);
                } else {
                    this.renderer.setIcon(CustomizeDialog.this.noneSelectIcon);
                }
            }
            if (bl) {
                this.renderer.setBackground(jTable.getSelectionBackground());
                this.renderer.setForeground(jTable.getSelectionForeground());
            } else {
                this.renderer.setBackground(jTable.getBackground());
                this.renderer.setForeground(jTable.getForeground());
            }
            return this.renderer;
        }
    };
    private DefaultCellEditor chkboxEditor = new DefaultCellEditor(this.editor){
        private SelectObject editorValue;
        {
            this.editorValue = null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof SelectObject) {
                this.editorValue = (SelectObject)object;
                CustomizeDialog.this.editor.setSelected(((SelectObject)object).isTempSelected());
            }
            return CustomizeDialog.this.editor;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.editorValue != null) {
                this.editorValue.setTempSelected(CustomizeDialog.this.editor.isSelected());
            }
            return this.editorValue;
        }
    };
    private transient ListSelectionListener selectionListSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (CustomizeDialog.this.selectionList.getSelectedIndex() >= 0) {
                CustomizeDialog.this.deleteBtn.setEnabled(true);
                CustomizeDialog.this.resetMemberBtn.setEnabled(true);
            } else {
                CustomizeDialog.this.deleteBtn.setEnabled(false);
            }
        }
    };
    transient ListSelectionListener memberListSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (CustomizeDialog.this.memberList.getSelectedIndex() >= 0) {
                CustomizeDialog.this.addBtn.setEnabled(true);
                CustomizeDialog.this.resetMemberBtn.setEnabled(true);
            } else {
                CustomizeDialog.this.addBtn.setEnabled(false);
            }
        }
    };
    private transient MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                if (mouseEvent.getSource() == CustomizeDialog.this.selectionList) {
                    CustomizeDialog.this.deleteBtnActionPerformed();
                } else if (mouseEvent.getSource() == CustomizeDialog.this.memberList) {
                    CustomizeDialog.this.addBtnActionPerformed();
                }
            }
        }
    };
    private boolean applied = false;

    public CustomizeDialog(Frame frame, String string, String string2, String string3, SelectObjectVector selectObjectVector, Toolbar toolbar) {
        super(frame, true);
        this.selectIcon = new ImageIcon(this.getClass().getResource("select.gif"));
        this.noneSelectIcon = new ImageIcon(this.getClass().getResource("none.gif"));
        this.jbInit();
        ScreenToolKit.centerLocateToScreen(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CustomizeDialog.this.exit();
            }
        });
        if (string != null) {
            this.setTitle(string);
        }
        this.toolbar = toolbar;
        this.setSelectObjects(selectObjectVector);
        if (string2 != null) {
            ((TitledBorder)this.groupScrollPane.getBorder()).setTitle(string2);
        }
        if (string3 != null) {
            ((TitledBorder)this.memberPane.getBorder()).setTitle(string3);
        }
    }

    public void setSelectObjects(SelectObjectVector selectObjectVector) {
        this.theSelectObjectVector = selectObjectVector;
        this.updateGroupTable();
    }

    private void jbInit() {
        this.setModal(true);
        this.setResizable(false);
        this.setName("CustomizeDialog");
        this.setSize(512, 196);
        this.splitPane.setOrientation(0);
        this.splitPane.setDividerSize(0);
        this.splitPane.setName("CustomizeDialog_splitPane");
        this.cancelBtn.setText(res.getString("CustomizeDialog_cancelBtn_Text"));
        this.cancelBtn.setName("CustomizeDialog_cancelBtn");
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizeDialog.this.exit();
            }
        });
        this.applyBtn.setText(res.getString("CustomizeDialog_applyBtn_Text"));
        this.applyBtn.setName("CustomizeDialog_applyBtn");
        this.applyBtn.setMnemonic('A');
        this.applyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizeDialog.this.apply();
            }
        });
        this.okBtn.setText(res.getString("CustomizeDialog_okBtn_Text"));
        this.okBtn.setName("CustomizeDialog_okBtn");
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizeDialog.this.okBtn_actionPerformed(actionEvent);
            }
        });
        ScreenToolKit.setDefaultButtons(this.okBtn, this.cancelBtn);
        JPanel jPanel = new JPanel(new FlowLayout(2, 4, 5));
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 5));
        this.advancedBtn.setText(res.getString("CustomizeDialog_advancedBtn_Text"));
        this.advancedBtn.setName("CustomizeDialog_advancedBtn");
        this.advancedBtn.setMnemonic('V');
        this.advancedBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizeDialog.this.advancedBtn_actionPerformed(actionEvent);
            }
        });
        this.resetGroupBtn.setText(res.getString("CustomizeDialog_resetGroupBtn_Text"));
        this.resetGroupBtn.setName("CustomizeDialog_resetGroupBtn");
        this.resetGroupBtn.setMnemonic('R');
        this.resetGroupBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizeDialog.this.resetGroupBtn_actionPerformed(actionEvent);
            }
        });
        this.rightPane.setLayout(new GridBagLayout());
        this.rightPane.setBorder(BorderFactory.createEmptyBorder(25, 0, 25, 0));
        this.groupScrollPane.setBorder(new TitledBorder(ETCHED_BORDER, res.getString("CustomizeDialog_KEY")));
        this.memberPane.setBorder(new TitledBorder(ETCHED_BORDER, res.getString("CustomizeDialog_KEY1")));
        this.memberPane.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(new TitledBorder(ETCHED_BORDER, res.getString("CustomizeDialog_KEY2")));
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setBorder(new TitledBorder(ETCHED_BORDER, res.getString("CustomizeDialog_KEY3")));
        this.addBtn.setText(res.getString("CustomizeDialog_addBtn_Text"));
        this.addBtn.setName("CustomizeDialog_addBtn");
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizeDialog.this.addBtnActionPerformed();
            }
        });
        this.deleteBtn.setText(res.getString("CustomizeDialog_deleteBtn_Text"));
        this.deleteBtn.setName("CustomizeDialog_deleteBtn");
        this.deleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizeDialog.this.deleteBtnActionPerformed();
            }
        });
        this.deleteBtn.setEnabled(false);
        this.addBtn.setEnabled(false);
        this.resetMemberBtn.setEnabled(false);
        this.resetGroupBtn.setEnabled(false);
        this.selectionList.addListSelectionListener(this.selectionListSelectionListener);
        this.memberList.addListSelectionListener(this.memberListSelectionListener);
        this.selectionList.addMouseListener(this.mouseListener);
        this.memberList.addMouseListener(this.mouseListener);
        this.resetMemberBtn.setText(res.getString("CustomizeDialog_resetMemberBtn_Text"));
        this.resetMemberBtn.setName("CustomizeDialog_resetMemberBtn");
        this.resetMemberBtn.setMnemonic('S');
        this.resetMemberBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizeDialog.this.resetMemberBtn_actionPerformed(actionEvent);
            }
        });
        jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        String string = "ENTER";
        String string2 = "ESCAPE";
        this.groupTable.setName("CustomizeDialog_groupTable");
        this.groupTable.getInputMap().put(KeyStroke.getKeyStroke(string), string);
        this.groupTable.getActionMap().put(string, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizeDialog.this.okBtn_actionPerformed(actionEvent);
            }
        });
        this.groupTable.getInputMap().put(KeyStroke.getKeyStroke(string2), string2);
        this.groupTable.getActionMap().put(string2, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomizeDialog.this.exit();
            }
        });
        this.groupTable.getSelectionModel().setSelectionMode(0);
        this.groupTable.setShowHorizontalLines(false);
        this.groupTable.setShowVerticalLines(false);
        this.groupTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CustomizeDialog.this.groupChanged(CustomizeDialog.this.groupTable.getSelectedRow());
            }
        });
        this.editor.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (CustomizeDialog.this.isChange()) {
                    CustomizeDialog.this.applyBtn.setEnabled(true);
                    CustomizeDialog.this.resetGroupBtn.setEnabled(true);
                } else {
                    CustomizeDialog.this.applyBtn.setEnabled(false);
                }
            }
        });
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        jPanel.add((Component)this.okBtn, null);
        jPanel.add((Component)this.cancelBtn, null);
        jPanel.add((Component)this.applyBtn, null);
        this.splitPane.add((Component)jPanel2, "left");
        this.splitPane.setBottomComponent(null);
        JButton[] jButtonArray = new JButton[]{this.advancedBtn, this.resetGroupBtn};
        ScreenToolKit.setPreferredSizeofButtons(jButtonArray, 21);
        JButton[] jButtonArray2 = new JButton[]{this.okBtn, this.cancelBtn, this.applyBtn};
        ScreenToolKit.setPreferredSizeofButtons(jButtonArray2, 21);
        JButton[] jButtonArray3 = new JButton[]{this.resetMemberBtn, this.addBtn, this.deleteBtn};
        ScreenToolKit.setPreferredSizeofButtons(jButtonArray3, 21);
        Dimension dimension = this.resetMemberBtn.getPreferredSize();
        this.resetMemberBtn.setMaximumSize(dimension);
        this.resetMemberBtn.setMinimumSize(dimension);
        this.addBtn.setMaximumSize(dimension);
        this.addBtn.setMinimumSize(dimension);
        this.deleteBtn.setMaximumSize(dimension);
        this.deleteBtn.setMinimumSize(dimension);
        jPanel2.add((Component)this.groupScrollPane, "Center");
        jPanel2.add((Component)this.rightPane, "East");
        this.rightPane.add((Component)this.resetGroupBtn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 2, new Insets(0, 3, 10, 3), 0, 0));
        this.rightPane.add((Component)this.advancedBtn, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 12, 2, new Insets(10, 3, 1, 3), 0, 0));
        this.groupScrollPane.getViewport().add((Component)this.groupTable, null);
        this.memberPane.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 3, 100.0, 100.0, 10, 1, new Insets(0, 3, 1, 8), 0, 0));
        this.memberPane.add((Component)this.addBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 15, 2, new Insets(10, 0, 13, 0), 0, 0));
        this.memberPane.add((Component)this.deleteBtn, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 13, 0), 0, 0));
        this.memberPane.add((Component)this.resetMemberBtn, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 11, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.memberPane.add((Component)jScrollPane2, new GridBagConstraints(2, 0, 1, 3, 100.0, 100.0, 10, 1, new Insets(0, 8, 1, 3), 0, 0));
        jScrollPane.getViewport().add((Component)this.memberList, null);
        this.memberList.setModel(new DefaultListModel());
        this.memberList.setName("CustomizeDialog_memberList");
        jScrollPane2.getViewport().add((Component)this.selectionList, null);
        this.selectionList.setModel(new DefaultListModel());
        this.selectionList.setName("CustomizeDialog_selectionList");
        this.splitPane.setDividerLocation(134);
        DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                this.setComponentOrientation(jList.getComponentOrientation());
                if (bl) {
                    this.setBackground(jList.getSelectionBackground());
                    this.setForeground(jList.getSelectionForeground());
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
                SelectObject selectObject = (SelectObject)object;
                this.setText(selectObject.getText());
                this.setIcon(selectObject.getIcon());
                this.setEnabled(jList.isEnabled());
                this.setFont(jList.getFont());
                this.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
                return this;
            }
        };
        this.memberList.setCellRenderer(defaultListCellRenderer);
        this.selectionList.setCellRenderer(defaultListCellRenderer);
        HelpManager.getInstance().enableHelpKey(this.getRootPane(), "iVIEW.toolbarcustomize");
    }

    private void updateGroupTable() {
        if (this.theSelectObjectVector == null || this.theSelectObjectVector.size() == 0) {
            return;
        }
        int n = this.theSelectObjectVector.size();
        Object[][] objectArray = new Object[n][2];
        SelectObject selectObject = null;
        for (int i = n - 1; i >= 0; --i) {
            selectObject = this.theSelectObjectVector.getElement(i);
            objectArray[i][0] = selectObject;
            objectArray[i][1] = selectObject.getText();
        }
        this.groupModel.setDataVector(objectArray, this.columnNames);
        this.groupTable.setTableHeader(null);
        this.groupTable.setShowGrid(false);
        TableColumn tableColumn = this.groupTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(this.checkboxRenderer);
        tableColumn.setCellEditor(this.chkboxEditor);
        int n2 = this.groupTable.getRowHeight();
        tableColumn.setMinWidth(n2);
        tableColumn.setMaxWidth(n2);
        this.groupTable.sizeColumnsToFit(0);
        if (this.groupTable.getRowCount() > 0) {
            this.groupTable.setRowSelectionInterval(0, 0);
        }
        this.groupChanged(this.groupTable.getSelectedRow());
    }

    private void groupChanged(int n) {
        DefaultListModel defaultListModel = (DefaultListModel)this.memberList.getModel();
        DefaultListModel defaultListModel2 = (DefaultListModel)this.selectionList.getModel();
        defaultListModel.clear();
        defaultListModel2.clear();
        if (n == -1) {
            return;
        }
        SelectObjectVector selectObjectVector = this.theSelectObjectVector.getElement(n).getDetailSelectObject();
        if (selectObjectVector == null || selectObjectVector.size() == 0) {
            return;
        }
        SelectObject selectObject = null;
        int n2 = selectObjectVector.size();
        for (int i = 0; i < n2; ++i) {
            selectObject = selectObjectVector.getElement(i);
            if (selectObject.isTempSelected()) {
                defaultListModel2.addElement(selectObject);
                continue;
            }
            defaultListModel.addElement(selectObject);
        }
        if (this.isChange()) {
            this.applyBtn.setEnabled(true);
            this.resetGroupBtn.setEnabled(true);
        } else {
            this.applyBtn.setEnabled(false);
        }
    }

    private void resetGroupBtn_actionPerformed(ActionEvent actionEvent) {
        this.reset();
        this.updateGroupTable();
        this.resetMemberBtn.setEnabled(false);
        this.resetGroupBtn.setEnabled(false);
    }

    private void advancedBtn_actionPerformed(ActionEvent actionEvent) {
        if (this.bShowDetail) {
            this.splitPane.remove(this.memberPane);
            this.advancedBtn.setText(res.getString("CustomizeDialog_advancedBtn_Text"));
            this.bShowDetail = false;
            this.setSize(512, 196);
        } else {
            this.splitPane.add((Component)this.memberPane, "bottom");
            this.advancedBtn.setText(res.getString("CustomizeDialog_advancedBtn_Text_2"));
            this.bShowDetail = true;
            this.setSize(512, 350);
        }
    }

    private void addBtnActionPerformed() {
        this.selectionList.removeListSelectionListener(this.selectionListSelectionListener);
        this.memberList.removeListSelectionListener(this.memberListSelectionListener);
        int n = this.memberList.getSelectedIndex();
        if (n == -1) {
            this.selectionList.addListSelectionListener(this.selectionListSelectionListener);
            this.memberList.addListSelectionListener(this.memberListSelectionListener);
            return;
        }
        Object[] objectArray = this.memberList.getSelectedValues();
        if (objectArray != null) {
            int n2;
            for (n2 = objectArray.length - 1; n2 >= 0; --n2) {
                SelectObject selectObject = (SelectObject)objectArray[n2];
                selectObject.setTempSelected(true);
            }
            this.groupChanged(this.groupTable.getSelectedRow());
            n2 = this.memberList.getModel().getSize();
            if (n < n2) {
                this.memberList.setSelectedIndex(n);
            } else if (n >= n2 && n2 > 0) {
                this.memberList.setSelectedIndex(n2 - 1);
            } else {
                this.memberList.clearSelection();
            }
            this.theSelectObjectVector.getElement(this.groupTable.getSelectedRow()).setTempSelected(true);
            this.repaint();
        }
        this.setAddDeleteBtnStatus();
        this.selectionList.addListSelectionListener(this.selectionListSelectionListener);
        this.memberList.addListSelectionListener(this.memberListSelectionListener);
    }

    private void deleteBtnActionPerformed() {
        this.selectionList.removeListSelectionListener(this.selectionListSelectionListener);
        this.memberList.removeListSelectionListener(this.memberListSelectionListener);
        int n = this.selectionList.getSelectedIndex();
        if (n == -1) {
            this.selectionList.addListSelectionListener(this.selectionListSelectionListener);
            this.memberList.addListSelectionListener(this.memberListSelectionListener);
            return;
        }
        Object[] objectArray = this.selectionList.getSelectedValues();
        if (objectArray != null) {
            int n2;
            SelectObject selectObject = null;
            for (n2 = objectArray.length - 1; n2 >= 0; --n2) {
                selectObject = (SelectObject)objectArray[n2];
                selectObject.setTempSelected(false);
            }
            this.groupChanged(this.groupTable.getSelectedRow());
            n2 = this.selectionList.getModel().getSize();
            if (n < n2) {
                this.selectionList.setSelectedIndex(n);
            } else if (n >= n2 && n2 > 0) {
                this.selectionList.setSelectedIndex(n2 - 1);
            } else {
                this.selectionList.clearSelection();
                this.theSelectObjectVector.getElement(this.groupTable.getSelectedRow()).setTempSelected(false);
                this.groupChanged(this.groupTable.getSelectedRow());
                this.repaint();
            }
        }
        this.setAddDeleteBtnStatus();
        this.selectionList.addListSelectionListener(this.selectionListSelectionListener);
        this.memberList.addListSelectionListener(this.memberListSelectionListener);
    }

    private void setAddDeleteBtnStatus() {
        if (this.selectionList.getSelectedIndex() >= 0 && this.selectionList.getModel().getSize() > 0) {
            this.deleteBtn.setEnabled(true);
        } else {
            this.deleteBtn.setEnabled(false);
        }
        if (this.memberList.getSelectedIndex() >= 0 && this.memberList.getModel().getSize() > 0) {
            this.addBtn.setEnabled(true);
        } else {
            this.addBtn.setEnabled(false);
        }
    }

    private void resetMemberBtn_actionPerformed(ActionEvent actionEvent) {
        SelectObject selectObject = this.theSelectObjectVector.getElement(this.groupTable.getSelectedRow());
        selectObject.reset();
        SelectObjectVector selectObjectVector = selectObject.getDetailSelectObject();
        int n = selectObjectVector.size();
        for (int i = 0; i < n; ++i) {
            selectObjectVector.getElement(i).reset();
        }
        this.groupChanged(this.groupTable.getSelectedRow());
        this.resetMemberBtn.setEnabled(false);
        this.repaint();
    }

    private void okBtn_actionPerformed(ActionEvent actionEvent) {
        this.apply();
        this.dispose();
    }

    private void apply() {
        int n;
        boolean bl = this.isChange();
        SelectObjectVector selectObjectVector = new SelectObjectVector();
        SelectObjectVector selectObjectVector2 = new SelectObjectVector();
        SelectObjectVector selectObjectVector3 = null;
        SelectObject selectObject = null;
        int n2 = this.theSelectObjectVector.size();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            selectObject = this.theSelectObjectVector.getElement(i);
            if (selectObject.isChanged()) {
                selectObjectVector.add(selectObject);
            }
            selectObject.apply();
            selectObjectVector3 = selectObject.getDetailSelectObject();
            n3 = selectObjectVector3.size();
            for (n = 0; n < n3; ++n) {
                if (selectObjectVector3.getElement(n).isChanged()) {
                    selectObjectVector2.add(selectObjectVector3.getElement(n));
                }
                selectObjectVector3.getElement(n).apply();
            }
        }
        this.applied = true;
        this.applyBtn.setEnabled(false);
        this.memberList.clearSelection();
        this.selectionList.clearSelection();
        this.resetMemberBtn.setEnabled(false);
        this.toolbar.setCurrentComponentsPositions();
        this.toolbar.updateToolbars();
        if (bl) {
            try {
                this.toolbar.storeToolbarSettingToServer();
            }
            catch (Exception exception) {
                n = this.theSelectObjectVector.size();
                int n4 = 0;
                for (int i = 0; i < n; ++i) {
                    selectObject = this.theSelectObjectVector.getElement(i);
                    if (selectObjectVector.contains(selectObject)) {
                        selectObject.setSelected(!selectObject.isSelected());
                        selectObject.setTempSelected(!selectObject.isSelected());
                        selectObject.reset();
                    }
                    selectObjectVector3 = selectObject.getDetailSelectObject();
                    n4 = selectObjectVector3.size();
                    for (int j = 0; j < n4; ++j) {
                        if (!selectObjectVector2.contains(selectObjectVector3.getElement(j))) continue;
                        selectObjectVector3.getElement(j).setSelected(!selectObjectVector3.getElement(j).isSelected());
                        selectObjectVector3.getElement(j).setTempSelected(!selectObjectVector3.getElement(j).isSelected());
                        selectObjectVector3.getElement(j).reset();
                    }
                    this.groupChanged(this.groupTable.getSelectedRow());
                    this.repaint();
                }
                this.applied = false;
                this.applyBtn.setEnabled(false);
                this.toolbar.setCurrentComponentsPositions();
                this.toolbar.updateToolbars();
                DetailMessageDlg detailMessageDlg = new DetailMessageDlg(FrameworkUtilities.getMainFrame(), res.getString("CustomizeDialog_title"), (Object)res.getString("CustomizeDialog_Failed"), 1, 0, (Object)res.getString("CustomizeDialog_Fail"), false);
                detailMessageDlg.pack();
                detailMessageDlg.show();
            }
        }
        this.toolbar.rearrangeCurrentOrder();
        this.toolbar.resetPositions();
        this.toolbar.storeOldPositions();
    }

    private void reset() {
        SelectObjectVector selectObjectVector = null;
        SelectObject selectObject = null;
        int n = this.theSelectObjectVector.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            selectObject = this.theSelectObjectVector.getElement(i);
            selectObject.reset();
            selectObjectVector = selectObject.getDetailSelectObject();
            n2 = selectObjectVector.size();
            for (int j = 0; j < n2; ++j) {
                selectObjectVector.getElement(j).reset();
            }
        }
    }

    private void exit() {
        if (!this.isChange()) {
            if (null != this.mouseListener) {
                this.selectionList.addMouseListener(this.mouseListener);
                this.memberList.addMouseListener(this.mouseListener);
            }
            this.dispose();
        } else if (this.sureIgnoreChange()) {
            if (null != this.mouseListener) {
                this.selectionList.addMouseListener(this.mouseListener);
                this.memberList.addMouseListener(this.mouseListener);
            }
            this.reset();
            this.dispose();
        }
    }

    public boolean isApplied() {
        return this.applied;
    }

    private boolean isChange() {
        int n = this.theSelectObjectVector.size();
        int n2 = 0;
        SelectObject selectObject = null;
        SelectObjectVector selectObjectVector = null;
        for (int i = 0; i < n; ++i) {
            selectObject = this.theSelectObjectVector.getElement(i);
            if (selectObject.isChanged()) {
                return true;
            }
            selectObjectVector = selectObject.getDetailSelectObject();
            n2 = selectObjectVector.size();
            for (int j = 0; j < n2; ++j) {
                if (!selectObjectVector.getElement(j).isChanged()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean sureIgnoreChange() {
        int n = OptionPane.showConfirmDialog((Component)this, (Object)res.getString("CustomizeDialog_KEY4"), res.getString("CustomizeDialog_tint"), 0, 3);
        return n == 0;
    }
}

