/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.classmanangement;

import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sun.security.action.GetPropertyAction;

public final class DynClassLoader
extends ClassLoader {
    private static IviewLogger logger = IviewLogger.getLogger(DynClassLoader.class, "IVIEW");
    private String strClassPath = "";
    private boolean isJarFile = false;
    private static final String STR_SEPARATOR = "/";
    private static final char CH_SEPARATOR = '/';
    private static final Map<String, Class> LOADCLASSMAP = Collections.synchronizedMap(new HashMap(16));
    private static final Map INSTANCEMAP = new HashMap(16);

    private DynClassLoader(String string) {
        if (string.endsWith(".jar")) {
            this.isJarFile = true;
        } else if (!string.endsWith(STR_SEPARATOR)) {
            string = string + STR_SEPARATOR;
        }
        this.strClassPath = string;
    }

    public static synchronized ClassLoader getDynClassLoader(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        String string2 = string.replace('\\', '/');
        if (INSTANCEMAP.containsKey(string2)) {
            return (ClassLoader)INSTANCEMAP.get(string2);
        }
        DynClassLoader dynClassLoader = new DynClassLoader(string2);
        DynClassLoader.recordInstance(string2, dynClassLoader);
        return dynClassLoader;
    }

    public String toString() {
        return new StringBuffer("[").append("IsJar=").append(this.isJarFile).append(", Path=").append(this.strClassPath).append(", LoadedClass=").append(LOADCLASSMAP.size()).append("]").toString();
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        logger.trace(this.getInformation("Begin load class : ", string));
        Class clazz = this.findAllClass(string);
        if (clazz != null) {
            logger.trace(this.getInformation("End load class : ", string));
            return clazz;
        }
        if (this.isJarFile) {
            String string2 = new StringBuffer(string.replace('.', '/')).append(".class").toString();
            clazz = this.loadJarFile(string2, string);
        } else {
            String string3 = new StringBuffer(this.strClassPath).append(string.replace('.', '/')).append(".class").toString();
            clazz = this.loadClassFile(string3, string);
        }
        DynClassLoader.recordClass(clazz);
        logger.trace(this.getInformation("End load class : ", string));
        return clazz;
    }

    @Override
    protected URL findResource(String string) {
        Serializable serializable;
        String string2 = null;
        if (this.isJarFile) {
            serializable = new StringBuffer("jar:file:");
            serializable.append(this.getRightPath(this.strClassPath));
            serializable.append("!/");
            serializable.append(string);
            string2 = serializable.toString();
        } else {
            serializable = new StringBuffer("file://");
            serializable.append(this.getRightPath(this.strClassPath));
            int n = serializable.indexOf(":", 6);
            serializable.insert(n + 1, "@");
            string2 = serializable.toString() + string;
        }
        try {
            serializable = super.findResource(string2);
            if (serializable != null) {
                return serializable;
            }
            serializable = new URL(string2);
            return serializable;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private String getRightPath(String string) {
        String string2 = "";
        if (string.indexOf("..") == -1) {
            string2 = string;
        } else {
            String string3 = AccessController.doPrivileged(new GetPropertyAction("user.dir"));
            string2 = string3 + STR_SEPARATOR + string;
        }
        return string2.replace(File.separatorChar, '/');
    }

    private static Class findDynLoadedClass(String string) {
        if (LOADCLASSMAP.containsKey(string)) {
            return LOADCLASSMAP.get(string);
        }
        return null;
    }

    private static synchronized void recordClass(Class clazz) {
        if (clazz == null) {
            return;
        }
        LOADCLASSMAP.put(clazz.getName(), clazz);
    }

    private static void recordInstance(String string, DynClassLoader dynClassLoader) {
        if (string == null || dynClassLoader == null) {
            return;
        }
        INSTANCEMAP.put(string, dynClassLoader);
    }

    private Class findAllClass(String string) {
        Class<?> clazz = DynClassLoader.findDynLoadedClass(string);
        if (clazz != null) {
            logger.trace("Class has been loaded at findDynLoadedClass: " + string);
            return clazz;
        }
        clazz = super.findLoadedClass(string);
        if (clazz != null) {
            logger.trace("Class has been loaded at findLoadedClass: " + string);
            return clazz;
        }
        try {
            clazz = super.findSystemClass(string);
            if (clazz != null) {
                logger.trace(this.getInformation("Class has been loaded at findSystemClass: ", string));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.trace(this.getInformation("Not found class at super.findSystemClass(String): ", string));
        }
        catch (Exception exception) {
            logger.trace(this.getInformation("Exception when invoke super.findSystemClass(String):", string));
        }
        return clazz;
    }

    private Class loadJarFile(String string, String string2) throws ClassNotFoundException {
        Class clazz = null;
        ZipFile zipFile = null;
        InputStream inputStream = null;
        try {
            zipFile = new JarFile(CommonUtil.getAbsoluteFile(this.strClassPath), true, 1);
            Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
            ZipEntry zipEntry = null;
            while (enumeration.hasMoreElements()) {
                zipEntry = enumeration.nextElement();
                if (!ResourceUtil.areEquals(zipEntry.getName(), string)) continue;
                inputStream = ((JarFile)zipFile).getInputStream(zipEntry);
                clazz = this.loadClass(inputStream, string2);
                break;
            }
        }
        catch (Exception exception) {
            logger.trace(this.getInformation("Exception when load jar file. class name: ", string2));
            logger.trace(exception.getMessage(), exception);
            throw new ClassNotFoundException(this.getExceptionMessage(string2));
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {
                logger.trace("Exception when close file. ");
                logger.trace(iOException.getMessage(), iOException);
            }
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                logger.trace("IOException while closing file. ");
                logger.trace(iOException.getMessage(), iOException);
            }
        }
        if (clazz == null) {
            logger.trace(this.getInformation("After Load jar file, the class still is null. class name: ", string2));
            throw new ClassNotFoundException(this.getExceptionMessage(string2));
        }
        return clazz;
    }

    private Class loadClassFile(String string, String string2) throws ClassNotFoundException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(CommonUtil.getAbsoluteFile(string));
            Class clazz = this.loadClass(fileInputStream, string2);
            return clazz;
        }
        catch (Exception exception) {
            throw new ClassNotFoundException(this.getExceptionMessage(string2));
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    logger.trace("IOException Occured while closing the stream");
                }
            }
        }
    }

    private Class loadClass(InputStream inputStream, String string) throws ClassNotFoundException {
        if (inputStream == null || string == null) {
            throw new ClassNotFoundException(this.getExceptionMessage(string));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = null;
        try {
            int n = inputStream.read();
            while (n != -1) {
                byteArrayOutputStream.write(n);
                n = inputStream.read();
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            logger.trace(this.getInformation("IOException when load class: ", string));
            logger.trace(iOException.getMessage(), iOException);
            throw new ClassNotFoundException(this.getExceptionMessage(string));
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException iOException) {
                logger.trace("Exception when close file.");
                logger.trace(iOException.getMessage(), iOException);
            }
        }
        return super.defineClass(string, byArray, 0, byArray.length);
    }

    private String getInformation(String string, String string2) {
        return new StringBuffer(string).append(string2).append(" ").append(this.toString()).toString();
    }

    private String getExceptionMessage(String string) {
        return new StringBuffer("Class: ").append(string).append(" not found. ").append(this.toString()).toString();
    }
}

