/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationsearch;

import com.swimap.iview.commstyle.commini.IComminiProperties;
import com.swimap.iview.commstyle.commini.Menu;
import com.swimap.iview.commstyle.commini.MenuSet;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.applicationfavourites.FavouriteStateMgr;
import com.swimap.iview.framework.applicationmanagement.AppMenu;
import com.swimap.iview.framework.applicationmanagement.AppMenuItemProperties;
import com.swimap.iview.framework.applicationmanagement.AppPopupMenu;
import com.swimap.iview.framework.applicationmanagement.AppPopupMenuManager;
import com.swimap.iview.framework.applicationmanagement.Application;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.applicationmanagement.ApplicationUtilities;
import com.swimap.iview.framework.applicationsearch.SearchAppMenuItemInformation;
import com.swimap.iview.framework.applicationsearch.SearchTextFieldLimit;
import com.swimap.iview.templates.extendedtable.EditableRenderer;
import com.swimap.iview.templates.extendedtable.ExtendedTable;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;

public class SearchPanel
extends JPanel {
    static final long serialVersionUID = 1L;
    private JTextField searchField = null;
    private JPanel bottom = null;
    private ImageIcon searchIcon = (ImageIcon)ResourceMng.getInstance().getIconDirect("portal/searchpane.png");
    private JPanel messagePanel = null;
    private ArrayList<String> menuItemNames = null;
    private ArrayList<String> menuPathNames = null;
    private String searchText = "";
    private SortableTableModel dataModel = null;
    private ExtendedTable table = null;
    private Locale locale = null;
    private static final int ARRAY_INIT_CAPACITY = 10;
    private static final int COLUMN_INIT_CAPACITY = 5;
    private static final int ROWHEIGHT = 30;
    private static final int TABLE_WIDTH = 960;
    private static final int TABLE_HEIGHT = 480;
    private static final int TABLE_MAXROW = 16;
    private static final int MAX_TEXTFIELD_LIMIT = 255;
    private static final int MAX_TEXTFIELD_SIZE = 430;
    private static final int MAX_TEXTFIELD_HEIGHT = 30;
    private static final int MAX_SEARCHBUTTON_HEIGHT = 30;
    private static final int ERROR_MESSAGE_FONTSIZE = 16;
    private static final int CELLWIDTH_IMAGE_CAL = 10;
    private static final int BOARDLAYOUT_VGAP = 10;
    private static final int BOARDLAYOUT_TOP = 40;
    private static final int BOARDLAYOUT_LEFT_RIGHT = 10;
    private static final int HASHTABLE_CPACITY = 10;
    private static final int FUNCTIONCOL_WIDTH = 220;
    private static final int APPNAMECOL_WIDTH = 200;
    private static final int MENUPATHCOL_WIDTH = 440;
    private static final int IMAGEICONCOL_WIDTH = 100;
    private static final String TABLE_HIDE_COLUMNNAME = "DummyColumn";
    private static final int FUNTIONNAME_COL = 0;
    private static final int MENUPATH_COL = 1;
    private static final int APPNAME_COL = 2;
    private static final int IMAGEICON_COL = 3;
    private static final int LAST_COLUMN_INDEX = 4;
    private Map<SearchAppMenuItemInformation, String> appInfoAndMenuName = new LinkedHashMap<SearchAppMenuItemInformation, String>(10);
    private Map<SearchAppMenuItemInformation, String> appInfoAndMenuPath = new LinkedHashMap<SearchAppMenuItemInformation, String>(10);
    static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/applicationmanagement/Res");
    private static SearchPanel searchPanel = null;
    private static final int BUFFER_SIZE = 3;
    private static final int PANEL_VALUE = 8;
    private static final int BOARDER_VALUE = 28;
    private static ArrayList<String> tokensList = new ArrayList(10);
    private static IviewLogger logger = IviewLogger.getLogger(SearchPanel.class, "IVIEW");

    private SearchPanel() {
        this.setLayout(new BorderLayout(0, 10));
        this.searchField = new JTextField();
        this.searchField.setBorder(BorderFactory.createEmptyBorder());
        this.searchField.setName("Searchpanel.searchfield");
        this.searchField.setBackground(Color.white);
        this.searchField.setOpaque(false);
        Dimension dimension = new Dimension(430, 30);
        this.searchField.setPreferredSize(dimension);
        this.searchField.setMaximumSize(dimension);
        this.searchField.setMinimumSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setName("Searchpanel.topPanel");
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(32, 10, 0, 10));
        jPanel.setOpaque(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setName("SearchPanel.BtnPanel");
        jPanel2.add((Component)this.searchField, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 30, 0, 0), 0, 0));
        JLabel jLabel = new JLabel(this.searchIcon);
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.setOpaque(false);
        this.messagePanel = new JPanel();
        this.messagePanel.setName("Searchpanel.messagepanel");
        JLabel jLabel2 = new JLabel(res.getString("AppMenuItems_notmatched"));
        jLabel2.setHorizontalTextPosition(2);
        jLabel2.setFont(new Font("Monospaced", 0, 16));
        jLabel2.setForeground(Color.BLACK);
        this.messagePanel.add(jLabel2);
        this.messagePanel.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 10));
        this.bottom = new TableInfo(null);
        this.bottom.setName("Searchpanel.tablepanel");
        this.bottom.setOpaque(false);
        this.bottom.setVisible(false);
        JPanel jPanel3 = new JPanel();
        jPanel3.setName("Searchpanel_mainPanel");
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setOpaque(false);
        JPanel jPanel4 = new JPanel();
        jPanel4.setName("Searchpanel.bottomPanel");
        jPanel4.setOpaque(false);
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createEmptyBorder(28, 2, 2, 2));
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)this.messagePanel, "South");
        jPanel4.add((Component)this.bottom, "Center");
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jPanel4, "Center");
        this.add((Component)jPanel3, "Center");
        this.bottom.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.messagePanel.setVisible(false);
        this.messagePanel.setOpaque(false);
        this.menuItemNames = new ArrayList(10);
        this.menuPathNames = new ArrayList(10);
        this.locale = ResourceMng.getInstance().getLocale();
        this.searchField.setDocument(new SearchTextFieldLimit(255));
        this.searchText = res.getString("Searchkey");
        this.searchField.setText("");
        this.searchField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                try {
                    if (SearchPanel.this.searchField.getDocument().getText(0, SearchPanel.this.searchField.getDocument().getLength()).equals("")) {
                        SearchPanel.this.searchField.setForeground(SystemColor.textInactiveText);
                        SearchPanel.this.searchField.setText(SearchPanel.this.searchText);
                        SearchPanel.this.setFocusOnText();
                    }
                }
                catch (BadLocationException badLocationException) {
                    logger.trace("bad location Error");
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (SearchPanel.this.isDefaulttext()) {
                    SearchPanel.this.searchField.setForeground(SystemColor.textText);
                    SearchPanel.this.searchField.setText("");
                }
            }
        });
        this.setOpaque(false);
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                SearchPanel.this.eventCall();
            }
        });
        this.searchField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (null != SearchPanel.this.table) {
                    SearchPanel.this.table.clearSelection();
                }
            }
        });
        HelpManager.getInstance().enableHelpKey(this, "topics_portal_t_search");
    }

    public static SearchPanel getInstance() {
        if (null == searchPanel) {
            searchPanel = new SearchPanel();
        }
        return searchPanel;
    }

    public void makeCommandList() {
        this.appInfoAndMenuName.clear();
        this.appInfoAndMenuPath.clear();
        List<Application> list = ApplicationManager.getInstance().getApplications();
        AppPopupMenu appPopupMenu = null;
        JPopupMenu jPopupMenu = null;
        Component[] componentArray = null;
        for (Application application : list) {
            if (!application.isLicensed()) {
                logger.debug("application with appId:" + application.getId() + "is not licensed");
                continue;
            }
            jPopupMenu = application.getPopupMenuManager().getPopupMenu();
            if (null == jPopupMenu || null == (componentArray = (appPopupMenu = (AppPopupMenu)jPopupMenu.getComponent()).getComponents())) continue;
            this.getMenuItems(componentArray);
        }
        this.eventCall();
    }

    private void getMenuItems(Component[] componentArray) {
        int n = 40;
        int n2 = 41;
        char c = ' ';
        StringBuffer stringBuffer = null;
        String string = null;
        String string2 = null;
        SearchAppMenuItemInformation searchAppMenuItemInformation = null;
        for (int i = 0; i < componentArray.length; ++i) {
            if (!componentArray[i].isEnabled() || !componentArray[i].isVisible()) continue;
            if (!(componentArray[i] instanceof AppMenu) && componentArray[i] instanceof AppMenuItemProperties && ((AppMenuItemProperties)((Object)componentArray[i])).getMenuType() != AppMenuItemProperties.MenuItemType.NotAItem) {
                int n3;
                AppMenuItemProperties appMenuItemProperties = (AppMenuItemProperties)((Object)componentArray[i]);
                stringBuffer = new StringBuffer(0);
                boolean bl = FavouriteStateMgr.getInstance().isSupportClick(appMenuItemProperties);
                JMenuItem jMenuItem = (JMenuItem)componentArray[i];
                string = jMenuItem.getText().trim();
                if (null != this.locale && !this.locale.getLanguage().equalsIgnoreCase("en")) {
                    n3 = string.lastIndexOf(n);
                    int n4 = string.lastIndexOf(n2);
                    if (n3 != -1 && n4 != -1 && n4 - n3 == 2) {
                        int n5 = string.length();
                        for (int j = 0; j < n5; ++j) {
                            c = string.charAt(j);
                            if (n3 == j || n4 == j || j + 1 == n4) continue;
                            stringBuffer = stringBuffer.append(c);
                        }
                        string = stringBuffer.toString();
                    }
                }
                searchAppMenuItemInformation = new SearchAppMenuItemInformation();
                searchAppMenuItemInformation.setAppID(appMenuItemProperties.getAPPId());
                searchAppMenuItemInformation.setAppMenuItemName(string);
                searchAppMenuItemInformation.setFavourite(bl);
                searchAppMenuItemInformation.setAppMenuItemId(appMenuItemProperties.getID());
                n3 = this.hasSameAppName(this.getAppName(appMenuItemProperties.getAPPId()), appMenuItemProperties.getID()) ? 1 : 0;
                if (0 != n3) continue;
                this.appInfoAndMenuName.put(searchAppMenuItemInformation, string);
                string2 = this.getMenupath(appMenuItemProperties);
                this.appInfoAndMenuPath.put(searchAppMenuItemInformation, string2);
                continue;
            }
            if (!(componentArray[i] instanceof AppMenu)) continue;
            this.getMenuItems(((AppMenu)componentArray[i]).getMenuComponents());
        }
    }

    String getAppName(String string) {
        Application application = ApplicationManager.getInstance().getApplication(string);
        if (null != application) {
            return application.getName();
        }
        return null;
    }

    boolean hasSameAppName(String string, String string2) {
        if (null == string) {
            return true;
        }
        SearchAppMenuItemInformation searchAppMenuItemInformation = null;
        if (!this.appInfoAndMenuName.containsValue(string2)) {
            return false;
        }
        for (Map.Entry<SearchAppMenuItemInformation, String> entry : this.appInfoAndMenuName.entrySet()) {
            searchAppMenuItemInformation = entry.getKey();
            if (!string.equals(this.getAppName(searchAppMenuItemInformation.getAppId())) || !string2.equals(searchAppMenuItemInformation.getAppMenuItemId())) continue;
            return true;
        }
        return false;
    }

    private ArrayList<String> search(String string, List<String> list) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        List<String> list2 = list;
        HashSet<String> hashSet = new HashSet<String>(10);
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!tokensList.contains(string2)) {
                tokensList.add(string2);
            }
            hashSet.clear();
            for (String string3 : list2) {
                String string4 = string3;
                if (!string4.toLowerCase().contains(string2.toLowerCase())) continue;
                hashSet.add(string3);
            }
            list2 = new ArrayList<String>(hashSet);
        }
        return new ArrayList<String>(hashSet);
    }

    private void eventCall() {
        Object object;
        String string;
        boolean bl;
        SearchAppMenuItemInformation searchAppMenuItemInformation;
        this.messagePanel.setVisible(false);
        String string2 = this.searchField.getText();
        if (string2.length() <= 0) {
            this.bottom.setVisible(false);
            this.messagePanel.setVisible(false);
            return;
        }
        this.bottom.setVisible(true);
        ArrayList<Object> arrayList = new ArrayList(10);
        ArrayList<Object> arrayList2 = new ArrayList(10);
        this.menuItemNames.clear();
        this.menuPathNames.clear();
        this.dataModel.clear();
        arrayList.clear();
        arrayList2.clear();
        String string3 = "";
        if (null != this.searchField.getText()) {
            string3 = this.searchField.getText().replaceAll("\\s+", " ");
        }
        String string4 = string3;
        if (string3.equals(" ") || !this.searchField.isFocusOwner() && this.isDefaulttext()) {
            this.bottom.setVisible(false);
            this.messagePanel.setVisible(false);
            return;
        }
        for (Map.Entry<SearchAppMenuItemInformation, String> entry : this.appInfoAndMenuName.entrySet()) {
            this.menuItemNames.add(entry.getValue());
        }
        tokensList.clear();
        this.table.clearSelection();
        this.dataModel.getDataVector().clear();
        Object[] objectArray = new Object[5];
        arrayList = this.search(string4, this.menuItemNames);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            objectArray[0] = arrayList.get(i);
            for (Map.Entry<SearchAppMenuItemInformation, String> entry : this.appInfoAndMenuName.entrySet()) {
                if (!((String)arrayList.get(i)).equals(entry.getValue())) continue;
                searchAppMenuItemInformation = entry.getKey();
                bl = FavouriteStateMgr.getInstance().isAppMenuExist(searchAppMenuItemInformation.getAppId(), searchAppMenuItemInformation.getAppMenuItemId());
                searchAppMenuItemInformation.setFavouriteAdded(bl);
                string = this.getAppName(searchAppMenuItemInformation.getAppId());
                object = this.getAppMenuItemInformation(searchAppMenuItemInformation.getAppMenuItemId(), (String)arrayList.get(i), string);
                objectArray[1] = this.getMenupath((AppMenuItemProperties)object);
                objectArray[2] = string;
                objectArray[3] = searchAppMenuItemInformation.isFavourite() ? this.getIconStatus(searchAppMenuItemInformation.isFavouriteAdded() ? FavourteState.ALREADYFAVOURITE : FavourteState.FAVOURITE) : this.getIconStatus(FavourteState.NOFAVOURITE);
                objectArray[4] = searchAppMenuItemInformation.getAppMenuItemId();
                this.dataModel.insertRow(i, objectArray);
            }
        }
        for (Map.Entry<SearchAppMenuItemInformation, String> entry : this.appInfoAndMenuPath.entrySet()) {
            this.menuPathNames.add(entry.getValue());
        }
        string4 = string2.replaceAll("-", "");
        arrayList2 = this.search(string4, this.menuPathNames);
        n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            for (Map.Entry<SearchAppMenuItemInformation, String> entry : this.appInfoAndMenuPath.entrySet()) {
                objectArray[1] = arrayList2.get(i);
                if (!((String)arrayList2.get(i)).equals(entry.getValue())) continue;
                searchAppMenuItemInformation = entry.getKey();
                bl = FavouriteStateMgr.getInstance().isAppMenuExist(searchAppMenuItemInformation.getAppId(), searchAppMenuItemInformation.getAppMenuItemId());
                searchAppMenuItemInformation.setFavouriteAdded(bl);
                string = this.getAppName(searchAppMenuItemInformation.getAppId());
                object = searchAppMenuItemInformation.getAppMenuItemName();
                if (!arrayList.isEmpty() && arrayList.contains(object)) continue;
                objectArray[0] = object;
                objectArray[2] = string;
                objectArray[3] = searchAppMenuItemInformation.isFavourite() ? this.getIconStatus(searchAppMenuItemInformation.isFavouriteAdded() ? FavourteState.ALREADYFAVOURITE : FavourteState.FAVOURITE) : this.getIconStatus(FavourteState.NOFAVOURITE);
                objectArray[4] = searchAppMenuItemInformation.getAppMenuItemId();
                this.dataModel.insertRow(i, objectArray);
            }
        }
        if (this.dataModel.getRowCount() <= 0) {
            this.bottom.setVisible(false);
            this.messagePanel.setVisible(true);
            return;
        }
        if (this.dataModel.getRowCount() <= 16) {
            this.table.setPreferredScrollableViewportSize(new Dimension(960, this.dataModel.getRowCount() * 30));
        } else {
            this.table.setPreferredScrollableViewportSize(new Dimension(960, 480));
        }
        this.table.getSelectionModel().setSelectionInterval(0, 0);
        this.table.clearSelection();
        this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(0, 0, true)));
        this.table.revalidate();
        this.table.repaint();
        this.bottom.revalidate();
        this.bottom.repaint();
    }

    private ImageIcon getIconStatus(FavourteState favourteState) {
        ImageIcon imageIcon = null;
        switch (favourteState) {
            case FAVOURITE: {
                imageIcon = (ImageIcon)ResourceMng.getInstance().getIconDirect("portal/favourite.png");
                imageIcon.getAccessibleContext().setAccessibleDescription("true");
                break;
            }
            case NOFAVOURITE: {
                return null;
            }
            case ALREADYFAVOURITE: {
                imageIcon = (ImageIcon)ResourceMng.getInstance().getIconDirect("portal/noFavourite.png");
                imageIcon.getAccessibleContext().setAccessibleDescription("true");
                break;
            }
        }
        return imageIcon;
    }

    private static String replaceString(int n, String string, String string2) {
        String string3 = string.substring(0, n - 1) + string2 + string.substring(n, string.length());
        return string3;
    }

    private String getMenupath(AppMenuItemProperties appMenuItemProperties) {
        String string = null;
        String string2 = appMenuItemProperties.getAPPId();
        AppPopupMenuManager appPopupMenuManager = ApplicationManager.getInstance().getAppPopUpMenuManager(string2);
        MenuSet menuSet = appPopupMenuManager.getMenuset();
        int n = menuSet.getMenuCount();
        Menu menu = null;
        Menu menu2 = null;
        StringBuffer stringBuffer = null;
        for (int i = 0; i < n; ++i) {
            menu = menuSet.getMenu(i);
            menu2 = this.getParentMenu(menu, appMenuItemProperties.getID());
            if (menu2 == null) continue;
            stringBuffer = new StringBuffer(3);
            stringBuffer.append(ApplicationUtilities.replacePopupMenuMnemonic(menu.getText()));
            if (menu != menu2) {
                stringBuffer.append(" - ");
                stringBuffer.append(ApplicationUtilities.replacePopupMenuMnemonic(menu2.getText()));
            }
            string = stringBuffer.toString();
            return string;
        }
        return string;
    }

    private Menu getParentMenu(Menu menu, String string) {
        String string2 = null;
        int n = menu.getMenuComponentCount();
        Component component = null;
        Menu menu2 = null;
        for (int i = 0; i < n; ++i) {
            component = menu.getMenuComponent(i);
            if (component instanceof Menu && null != (menu2 = this.getParentMenu((Menu)component, string))) {
                return menu2;
            }
            String string3 = string2 = component instanceof IComminiProperties ? ((IComminiProperties)((Object)component)).getID() : null;
            if (string2 == null || !string2.equals(string)) continue;
            return menu;
        }
        return null;
    }

    private String getToolTipForFavorite(MouseEvent mouseEvent) {
        String string;
        String string2 = null;
        int n = this.table.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
        TableModel tableModel = this.table.getModel();
        String string3 = (String)tableModel.getValueAt(n, 0);
        String string4 = (String)tableModel.getValueAt(n, 2);
        ImageIcon imageIcon = (ImageIcon)tableModel.getValueAt(n, 3);
        boolean bl = false;
        if (null != imageIcon) {
            string = imageIcon.getAccessibleContext().getAccessibleDescription();
            bl = Boolean.parseBoolean(string);
        }
        if (bl) {
            string = (String)tableModel.getValueAt(n, 4);
            SearchAppMenuItemInformation searchAppMenuItemInformation = null;
            String string5 = null;
            for (Map.Entry<SearchAppMenuItemInformation, String> entry : this.appInfoAndMenuName.entrySet()) {
                if (!string3.equals(entry.getValue()) || !string4.equals(this.getAppName((searchAppMenuItemInformation = entry.getKey()).getAppId()))) continue;
                string5 = searchAppMenuItemInformation.getAppId();
            }
            boolean bl2 = FavouriteStateMgr.getInstance().isAppMenuExist(string5, string);
            string2 = bl2 ? res.getString("Alreadyfavourited") : res.getString("AddTofavourite");
        } else {
            string2 = res.getString("Notfavourite");
        }
        return string2;
    }

    private void addToFavouriteOnMouseClick(MouseEvent mouseEvent) {
        JMenuItem jMenuItem;
        String string;
        boolean bl;
        ExtendedTable extendedTable = (ExtendedTable)mouseEvent.getSource();
        Point point = mouseEvent.getPoint();
        int n = extendedTable.columnAtPoint(point);
        int n2 = extendedTable.rowAtPoint(point);
        boolean bl2 = bl = mouseEvent.getClickCount() > 1;
        if (bl && n == 3 && this.isFaviconClicked(mouseEvent)) {
            return;
        }
        if (!(bl || n == 3 && this.isFaviconClicked(mouseEvent))) {
            return;
        }
        TableModel tableModel = extendedTable.getModel();
        String string2 = (String)tableModel.getValueAt(n2, 0);
        String string3 = (String)tableModel.getValueAt(n2, 2);
        ImageIcon imageIcon = (ImageIcon)tableModel.getValueAt(n2, 3);
        boolean bl3 = false;
        if (null != imageIcon) {
            string = imageIcon.getAccessibleContext().getAccessibleDescription();
            bl3 = Boolean.parseBoolean(string);
        }
        if (!bl && n == 3 && !bl3) {
            return;
        }
        string = (String)tableModel.getValueAt(n2, 4);
        SearchAppMenuItemInformation searchAppMenuItemInformation = null;
        SearchAppMenuItemInformation searchAppMenuItemInformation2 = null;
        String string4 = null;
        for (Map.Entry<SearchAppMenuItemInformation, String> entry : this.appInfoAndMenuName.entrySet()) {
            if (!string2.equals(entry.getValue()) || !string3.equals(this.getAppName((searchAppMenuItemInformation = entry.getKey()).getAppId())) || !string.equals(searchAppMenuItemInformation.getAppMenuItemId())) continue;
            searchAppMenuItemInformation2 = searchAppMenuItemInformation;
            string4 = searchAppMenuItemInformation.getAppId();
            break;
        }
        searchAppMenuItemInformation = searchAppMenuItemInformation2;
        AppMenuItemProperties appMenuItemProperties = ApplicationManager.getInstance().getApplication(string4).getPopupMenuManager().getAppMenuItemProperties(string, true);
        boolean bl4 = FavouriteStateMgr.getInstance().isAppMenuExist(string4, string);
        if (!bl && bl4 && n == 3 && this.isFaviconClicked(mouseEvent)) {
            return;
        }
        if (mouseEvent.getButton() == 1 && bl && appMenuItemProperties instanceof JMenuItem) {
            jMenuItem = (JMenuItem)((Object)appMenuItemProperties);
            ActionListener[] actionListenerArray = jMenuItem.getActionListeners();
            if (null != actionListenerArray && actionListenerArray.length > 0) {
                for (ActionListener actionListener : actionListenerArray) {
                    actionListener.actionPerformed(new ActionEvent(appMenuItemProperties, 1001, null));
                }
            } else if (null != appMenuItemProperties.getAction()) {
                appMenuItemProperties.getAction().actionPerformed(new ActionEvent(appMenuItemProperties, 1001, null));
            } else {
                logger.trace("No action is defined for App menu" + appMenuItemProperties);
            }
        }
        if (mouseEvent.getButton() == 1 && !bl) {
            jMenuItem = null;
            if (n == 3 && this.isFaviconClicked(mouseEvent)) {
                boolean bl5;
                if (bl3 && string2.equals(searchAppMenuItemInformation.getAppMenuItemName()) && string3.equals(this.getAppName(searchAppMenuItemInformation.getAppId())) && string.equals(searchAppMenuItemInformation.getAppMenuItemId()) && appMenuItemProperties instanceof JMenuItem) {
                    jMenuItem = (JMenuItem)((Object)appMenuItemProperties);
                }
                if (!(mouseEvent.getClickCount() >= 2) && (bl5 = FavouriteStateMgr.getInstance().isSupportClick(jMenuItem))) {
                    FavouriteStateMgr.getInstance().click(jMenuItem);
                    boolean bl6 = FavouriteStateMgr.getInstance().isAppMenuExist(string4, string);
                    if (bl6) {
                        ImageIcon imageIcon2 = this.getIconStatus(FavourteState.ALREADYFAVOURITE);
                        extendedTable.setValueAt(imageIcon2, n2, n);
                        extendedTable.refurbishTable();
                    }
                }
            }
        }
    }

    private AppMenuItemProperties getAppMenuItemInformation(String string, String string2, String string3) {
        AppMenuItemProperties appMenuItemProperties = null;
        SearchAppMenuItemInformation searchAppMenuItemInformation = null;
        String string4 = null;
        for (Map.Entry<SearchAppMenuItemInformation, String> entry : this.appInfoAndMenuName.entrySet()) {
            if (!string2.equals(entry.getValue()) || !string3.equals(this.getAppName((searchAppMenuItemInformation = entry.getKey()).getAppId())) || !string.equals(searchAppMenuItemInformation.getAppMenuItemId())) continue;
            string4 = searchAppMenuItemInformation.getAppId();
            break;
        }
        appMenuItemProperties = ApplicationManager.getInstance().getApplication(string4).getPopupMenuManager().getAppMenuItemProperties(string, true);
        return appMenuItemProperties;
    }

    private boolean isFaviconClicked(MouseEvent mouseEvent) {
        int n;
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n2 = tableColumnModel.getColumn(0).getWidth() + tableColumnModel.getColumn(1).getWidth() + tableColumnModel.getColumn(2).getWidth();
        int n3 = n2 + (n = tableColumnModel.getColumn(3).getWidth()) / 2;
        return false == n3 - 10 > mouseEvent.getX() && false == mouseEvent.getX() > n3 + 10;
    }

    public void clearCacheInformation() {
        this.searchField.setText("");
        this.eventCall();
    }

    public void cleanWhileOSGIExit() {
        this.menuItemNames.clear();
        this.appInfoAndMenuName.clear();
        this.menuPathNames.clear();
        this.appInfoAndMenuPath.clear();
    }

    private boolean isDefaulttext() {
        try {
            return this.searchField.getDocument().getText(0, this.searchField.getDocument().getLength()).equals(res.getString("Searchkey"));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public void setFocusOnText() {
        if (!this.isDefaulttext()) {
            this.searchField.requestFocusInWindow();
        } else {
            this.searchField.transferFocus();
        }
    }

    public JTextField getSearchFiled() {
        return this.searchField;
    }

    private static final class IconRenderer
    extends EditableRenderer {
        public IconRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!bl) {
                this.setBackground(jTable.getBackground());
            }
            return component;
        }

        @Override
        public void setValue(Object object) {
            super.setIcon(object instanceof Icon ? (Icon)object : null);
        }
    }

    private static class CharProperties {
        private String charValue = "";
        private String color = "black";

        private CharProperties() {
        }

        public void setCharValue(String string) {
            this.charValue = string;
        }

        public void setColor(String string) {
            this.color = string;
        }

        public String getColor() {
            return this.color;
        }

        String getCharValue() {
            return this.charValue;
        }
    }

    private static final class FunctionRender
    extends EditableRenderer {
        private FunctionRender() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!bl) {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            if (n2 == 0 || n2 == 1) {
                int n3;
                int n4;
                String string = "";
                String string2 = "";
                string2 = string = String.valueOf(object);
                CharProperties charProperties = null;
                ArrayList<CharProperties> arrayList = new ArrayList<CharProperties>(10);
                char[] cArray = string2.toCharArray();
                for (n4 = 0; n4 < cArray.length; ++n4) {
                    charProperties = new CharProperties();
                    charProperties.setCharValue(Character.toString(cArray[n4]));
                    arrayList.add(charProperties);
                }
                n4 = tokensList.size();
                String string3 = "";
                int n5 = 0;
                int n6 = -1;
                String string4 = "";
                for (n3 = 0; n3 < n4; ++n3) {
                    string3 = (String)tokensList.get(n3);
                    n6 = string2.toLowerCase().indexOf(string3.toLowerCase());
                    n5 = string3.length();
                    string4 = string2;
                    int n7 = 0;
                    while (n6 >= 0) {
                        string4 = string4.substring(n6 + n5);
                        for (int i = n7 + n6; i < n7 + n6 + n5; ++i) {
                            if (((CharProperties)arrayList.get(i)).getCharValue().equals("-") && n2 == 1) continue;
                            ((CharProperties)arrayList.get(i)).setColor("red");
                        }
                        n7 = n7 + n6 + n5;
                        n6 = string4.toLowerCase().indexOf(string3.toLowerCase());
                        n5 = string3.length();
                    }
                }
                for (n3 = arrayList.size(); n3 > 0; --n3) {
                    if (!((CharProperties)arrayList.get(n3 - 1)).getColor().equals("red")) continue;
                    string2 = SearchPanel.replaceString(n3, string2, "<span color='FF0000'>" + string.charAt(n3 - 1) + "</span>");
                }
                string2 = "<html>" + string2 + "</html>";
                arrayList.clear();
                this.setText(string2);
            }
            return component;
        }
    }

    private class TableInfo
    extends JPanel {
        TableInfo(Object[] objectArray) {
            String string = ApplicationUtilities.getString("MenuPath");
            Object[] objectArray2 = new String[]{res.getString("MenuItem_Name"), string, res.getString("Application_Name"), res.getString("Favorite_Icon"), SearchPanel.TABLE_HIDE_COLUMNNAME};
            SearchPanel.this.dataModel = new SortableTableModel(objectArray2, 0){

                @Override
                public Class getColumnClass(int n) {
                    if (n == 3) {
                        return ImageIcon.class;
                    }
                    return String.class;
                }
            };
            SearchPanel.this.table = new ExtendedTable(SearchPanel.this.dataModel){

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    int n = this.columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                    if (n == 3) {
                        return SearchPanel.this.getToolTipForFavorite(mouseEvent);
                    }
                    int n2 = this.rowAtPoint(mouseEvent.getPoint());
                    return SearchPanel.this.table.getValueAt(n2, n).toString();
                }
            };
            SearchPanel.this.table.setPreferredScrollableViewportSize(new Dimension(960, 480));
            SearchPanel.this.table.setSelectionMode(0);
            SearchPanel.this.table.setColumnSortable(res.getString("MenuItem_Name"), true);
            SearchPanel.this.table.setColumnSortable(res.getString("Application_Name"), true);
            SearchPanel.this.table.setColumnSortable(string, true);
            SearchPanel.this.table.setSortableClickCount(1);
            SearchPanel.this.table.getTableHeader().setPreferredSize(new Dimension(SearchPanel.this.table.getWidth(), 30));
            SearchPanel.this.table.addComponentListener(new ComponentAdapter(){
                boolean firstTime = false;

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    if (this.firstTime) {
                        SearchPanel.this.table.getTableHeader().setPreferredSize(new Dimension(componentEvent.getComponent().getWidth(), 30));
                    } else {
                        this.firstTime = true;
                    }
                }
            });
            SearchPanel.this.table.setColumnVisible(SearchPanel.TABLE_HIDE_COLUMNNAME, 3);
            SearchPanel.this.table.setAutoResizeMode(0);
            SearchPanel.this.table.getColumnModel().getColumn(0).setPreferredWidth(220);
            SearchPanel.this.table.getColumnModel().getColumn(1).setPreferredWidth(440);
            SearchPanel.this.table.getColumnModel().getColumn(2).setPreferredWidth(200);
            SearchPanel.this.table.getColumnModel().getColumn(3).setPreferredWidth(100);
            SearchPanel.this.table.getTableHeader().setReorderingAllowed(false);
            SearchPanel.this.table.setFillsViewportHeight(true);
            SearchPanel.this.table.setBackground(Color.white);
            SearchPanel.this.table.setRowHeight(30);
            JScrollPane jScrollPane = new JScrollPane(SearchPanel.this.table);
            this.add(jScrollPane);
            SearchPanel.this.table.setDefaultRenderer(String.class, new FunctionRender());
            SearchPanel.this.table.setDefaultRenderer(ImageIcon.class, new IconRenderer());
            final JTableHeader jTableHeader = SearchPanel.this.table.getTableHeader();
            jTableHeader.setResizingAllowed(true);
            jTableHeader.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    TableColumn tableColumn;
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && (tableColumn = TableInfo.this.getResizingColumn(mouseEvent)) != null && jTableHeader.getResizingAllowed() && tableColumn.getResizable()) {
                        int n = TableInfo.this.getPreferredWidthForContent(tableColumn);
                        tableColumn.setPreferredWidth(n);
                    }
                }
            });
            SearchPanel.this.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    SearchPanel.this.addToFavouriteOnMouseClick(mouseEvent);
                }
            });
        }

        protected int getPreferredWidthForContent(TableColumn tableColumn) {
            int n;
            int n2 = 0;
            int n3 = SearchPanel.this.table.convertColumnIndexToView(tableColumn.getModelIndex());
            TableCellRenderer tableCellRenderer = null;
            Object object = null;
            Component component = null;
            JLabel jLabel = new JLabel();
            FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
            int n4 = SearchPanel.this.table.getRowCount();
            for (n = 0; n < n4; ++n) {
                tableCellRenderer = SearchPanel.this.table.getCellRenderer(n, n3);
                object = SearchPanel.this.table.getValueAt(n, n3);
                component = tableCellRenderer.getTableCellRendererComponent(SearchPanel.this.table, object, false, false, n, n3);
                n2 = Math.max(component.getPreferredSize().width, n2);
            }
            n = fontMetrics.stringWidth(SearchPanel.this.table.getColumnName(n3));
            n2 = Math.max(n, n2);
            return n2 + 15;
        }

        protected TableColumn getResizingColumn(MouseEvent mouseEvent) {
            if (mouseEvent == null) {
                throw new IllegalArgumentException("e is null.");
            }
            Point point = mouseEvent.getPoint();
            int n = SearchPanel.this.table.getTableHeader().columnAtPoint(point);
            if (n == -1) {
                return null;
            }
            JTableHeader jTableHeader = SearchPanel.this.table.getTableHeader();
            Rectangle rectangle = jTableHeader.getHeaderRect(n);
            rectangle.grow(-3, 0);
            if (rectangle.contains(point)) {
                return null;
            }
            int n2 = rectangle.x + rectangle.width / 2;
            int n3 = 0;
            if (jTableHeader.getComponentOrientation().isLeftToRight()) {
                n3 = point.x < n2 ? n - 1 : n;
            } else {
                int n4 = n3 = point.x < n2 ? n : n - 1;
            }
            if (n3 == -1) {
                return null;
            }
            return jTableHeader.getColumnModel().getColumn(n3);
        }
    }

    private static enum FavourteState {
        FAVOURITE,
        NOFAVOURITE,
        ALREADYFAVOURITE;

    }
}

