/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement.gui;

import com.swimap.iview.framework.applicationmanagement.gui.FloatingAppPanel;
import com.swimap.iview.framework.applicationmanagement.gui.TabItemBorder;
import com.swimap.iview.framework.applicationmanagement.gui.TabSelectionListener;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicPanelUI;

public class TabItem
extends JPanel {
    private boolean isSelected = false;
    private Color backgroundColor = null;
    int[] xPointsSelected = null;
    int[] yPointsSelected = null;
    int[] yPointsDeSelected = null;
    private JLabel label = new JLabel();
    private List<TabSelectionListener> selectionListeners = new ArrayList<TabSelectionListener>();
    private JComponent component = null;
    private static WeakReference<TabItem> selectedTabReference = null;

    public TabItem(String string, Icon icon, JComponent jComponent) {
        this.setLayout(new FlowLayout(1, 0, 1));
        this.component = jComponent;
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setOpaque(false);
        this.label.setText(string);
        this.label.setIcon(icon);
        this.label.setHorizontalTextPosition(4);
        this.add(this.label);
        this.label.setPreferredSize(new Dimension(70, 23));
        this.setPreferredSize(new Dimension(80, 23));
        this.setMinimumSize(new Dimension(80, 23));
        this.setMaximumSize(new Dimension(80, 23));
        this.setBorder(new TabItemBorder());
        this.backgroundColor = this.getBackground();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TabItem.this.setSelected(true);
            }
        });
    }

    @Override
    public void updateUI() {
        this.setUI(new BasicPanelUI(){

            @Override
            public void paint(Graphics graphics, JComponent jComponent) {
                if (null == TabItem.this.xPointsSelected) {
                    int n = TabItem.this.getSize().width;
                    int n2 = TabItem.this.getSize().height;
                    TabItem.this.xPointsSelected = new int[]{0, 0, 4, n - 5, n - 1, n - 1};
                    TabItem.this.yPointsSelected = new int[]{n2 - 1, 4, 0, 0, 4, n2 - 1};
                    TabItem.this.yPointsDeSelected = new int[]{n2 - 1, 6, 2, 2, 6, n2 - 1};
                }
                Color color = graphics.getColor();
                TabItem tabItem = (TabItem)jComponent;
                if (tabItem.isSelected()) {
                    graphics.setColor(Color.WHITE);
                    graphics.fillPolygon(TabItem.this.xPointsSelected, TabItem.this.yPointsSelected, 6);
                } else {
                    graphics.setColor(TabItem.this.backgroundColor);
                    graphics.fillPolygon(TabItem.this.xPointsSelected, TabItem.this.yPointsDeSelected, 6);
                }
                super.paint(graphics, jComponent);
            }
        });
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean bl) {
        if (this.isSelected == bl) {
            return;
        }
        this.isSelected = bl;
        if (this.isSelected) {
            TabItem tabItem;
            if (null != selectedTabReference && null != (tabItem = (TabItem)selectedTabReference.get())) {
                tabItem.setSelected(false);
            }
            selectedTabReference = new WeakReference<TabItem>(this);
            this.setBackground(Color.WHITE);
            this.label.setForeground(Color.BLUE);
        } else {
            this.setBackground(this.backgroundColor);
            this.label.setForeground(Color.BLACK);
        }
        FloatingAppPanel.getInstance().revalidate();
        this.repaint(0L);
        this.fireSelectionChanged();
    }

    public void addSelectionListener(TabSelectionListener tabSelectionListener) {
        this.selectionListeners.add(tabSelectionListener);
    }

    public void removeSelectionListener(TabSelectionListener tabSelectionListener) {
        this.selectionListeners.remove(tabSelectionListener);
    }

    private void fireSelectionChanged() {
        for (TabSelectionListener tabSelectionListener : this.selectionListeners) {
            tabSelectionListener.selectionChanged(this.isSelected);
        }
    }

    public JComponent getComponent() {
        return this.component;
    }
}

