/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement.gui;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.framework.applicationfavourites.FavouritePanel;
import com.swimap.iview.framework.applicationfavourites.FavouriteStateMgr;
import com.swimap.iview.framework.applicationmanagement.AppPopupMenuManager;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.applicationmanagement.gui.AppRoundButton;
import com.swimap.iview.framework.applicationsearch.SearchPanel;
import com.swimap.iview.framework.lookandfeel.skin.SkinManager;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.tabbedpane.PortalTabbedPane;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FloatingAppPanel
extends JPanel {
    private static IviewLogger logger = IviewLogger.getLogger(FloatingAppPanel.class, "IVIEW");
    private static FloatingAppPanel instance = null;
    private JTabbedPane jTabbedPane = new PortalTabbedPane();
    private AWTEventListener mouseEventCloseListener = null;
    private KeyEventPostProcessor keyEventCloseListener = null;
    private KeyEventDispatcher preKeyEventDispatcher = null;
    private WindowAdapter windowEventCloseListener = null;
    private boolean isFirst = true;
    private List<Component> excludedMouseCloseComponents = new ArrayList<Component>();
    private Component lastfocusOwner = null;
    public static int FLOAT_PANEL_WIDTH = 1040;
    public static int FLOAT_PANEL_HEIGHT = 680;

    public static FloatingAppPanel getInstance() {
        if (null == instance) {
            logger.trace("intiailizing app floating panel start");
            instance = new FloatingAppPanel();
            logger.trace("intiailizing app floating panel end " + instance.hashCode());
        }
        return instance;
    }

    private FloatingAppPanel() {
        Object object;
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFromDefaultAndProductStyle("conf/mainfrm/app/portalstyleConfig");
        if (null != commStyleInfo) {
            try {
                object = commStyleInfo.getAreaDescContainer()[0].getDescContainer("FloatingPanelSettings");
                FLOAT_PANEL_WIDTH = Integer.parseInt(((DescContainer)object).getParasItemValue("width"));
                FLOAT_PANEL_HEIGHT = Integer.parseInt(((DescContainer)object).getParasItemValue("height"));
                FLOAT_PANEL_HEIGHT += 30;
            }
            catch (Exception exception) {
                logger.trace("Exception while reading portal style settings" + exception);
            }
        }
        if ("gray".equals(object = SkinManager.getInstance().getSelectedSkin())) {
            this.setBackground(new Color(221, 221, 221));
        } else {
            this.setBackground(new Color(178, 195, 196));
        }
        FrameworkUtilities.getMainFrame().addComponentListener(this.getComponentListener());
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(FLOAT_PANEL_WIDTH, FLOAT_PANEL_HEIGHT));
        this.setBorder(new FloatingPanelBorder());
        this.addJTabbedPane();
        this.revalidate();
        this.setVisible(false);
        this.excludedMouseCloseComponents.add(this);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, FLOAT_PANEL_WIDTH, FLOAT_PANEL_HEIGHT);
    }

    private void addJTabbedPane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jTabbedPane.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = FloatingAppPanel.this.jTabbedPane.getSelectedIndex();
                if (n == 2) {
                    logger.trace("Query search panel command list");
                    SearchPanel searchPanel = SearchPanel.getInstance();
                    searchPanel.makeCommandList();
                }
                if (n == 0) {
                    try {
                        ScreenToolKit.setSystemBusy(true);
                        FavouriteStateMgr.getInstance().updateVisibilityOfFavouriteButtons();
                    }
                    finally {
                        ScreenToolKit.setSystemBusy(false);
                    }
                }
                FloatingAppPanel.this.updateUI();
                logger.trace("Floating panel tab switch happend and selected tab = " + n);
            }
        });
        this.add((Component)this.jTabbedPane, gridBagConstraints);
    }

    public void addCloseListeners() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this.getMouseEventCloseListener(), 48L);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.getKeyEventDispatcher());
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this.getKeyEventCloseListener());
    }

    public void removeCloseListeners() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.getMouseEventCloseListener());
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this.getKeyEventCloseListener());
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.getKeyEventDispatcher());
        FrameworkUtilities.getMainFrame().removeWindowListener(this.getWindowEventCloseListener());
    }

    private WindowListener getWindowEventCloseListener() {
        if (null == this.windowEventCloseListener) {
            this.windowEventCloseListener = new WindowAdapter(){

                @Override
                public void windowDeactivated(WindowEvent windowEvent) {
                    logger.trace("Deactivating floating panel");
                    instance.setVisible(false);
                }
            };
        }
        return this.windowEventCloseListener;
    }

    private KeyEventDispatcher getKeyEventDispatcher() {
        if (null == this.preKeyEventDispatcher) {
            this.preKeyEventDispatcher = new KeyEventDispatcher(){

                @Override
                public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                    if (!FloatingAppPanel.this.isVisible()) {
                        FloatingAppPanel.this.removeCloseListeners();
                    }
                    if (keyEvent.getID() == 401 && keyEvent.isControlDown() && keyEvent.getKeyCode() == 9 || keyEvent.getKeyCode() == 122) {
                        logger.trace("Dispatching key Event to the floating panel return true");
                        return true;
                    }
                    logger.trace("Dispatching Key Event to floating panel return false");
                    return false;
                }
            };
        }
        return this.preKeyEventDispatcher;
    }

    private AWTEventListener getMouseEventCloseListener() {
        if (null == this.mouseEventCloseListener) {
            this.mouseEventCloseListener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent aWTEvent) {
                    if (aWTEvent instanceof MouseEvent) {
                        if (!FloatingAppPanel.this.isShowing()) {
                            FloatingAppPanel.this.removeCloseListeners();
                            return;
                        }
                        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                        Component component = (Component)mouseEvent.getSource();
                        if (mouseEvent.getID() == 501) {
                            boolean bl;
                            Component component22;
                            for (Component component22 : FloatingAppPanel.this.excludedMouseCloseComponents) {
                                bl = true;
                                bl = SwingUtilities.isDescendingFrom(component, component22);
                                if (!bl) continue;
                                logger.info("Floating panel is clicked");
                                return;
                            }
                            Container container = FrameworkUtilities.getMainFrame().getContentPane();
                            component22 = FrameworkUtilities.getMainFrame().getJMenuBar();
                            bl = SwingUtilities.isDescendingFrom(component, container);
                            boolean bl2 = bl = bl || SwingUtilities.isDescendingFrom(component, component22);
                            if (bl || component instanceof MDIFrame) {
                                FloatingAppPanel.getInstance().setVisible(false);
                            }
                        }
                    } else if (aWTEvent instanceof KeyEvent) {
                        Component component = (Component)aWTEvent.getSource();
                        if (!FrameworkUtilities.getTerminalManager().isLockOrUnLockDialogshown()) {
                            if (component == FrameworkUtilities.getMainFrame().getJMenuBar().getRootPane()) {
                                FloatingAppPanel.this.lastfocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                            }
                            if (component instanceof FloatingAppPanel && ((KeyEvent)aWTEvent).getKeyCode() != 17) {
                                FloatingAppPanel.getInstance().setVisible(false);
                            }
                        }
                    }
                }
            };
        }
        return this.mouseEventCloseListener;
    }

    public void excludeMouseCloseEvent(Component component) {
        this.excludedMouseCloseComponents.add(component);
    }

    private KeyEventPostProcessor getKeyEventCloseListener() {
        if (null == this.keyEventCloseListener) {
            this.keyEventCloseListener = new KeyEventPostProcessor(){

                @Override
                public boolean postProcessKeyEvent(KeyEvent keyEvent) {
                    if (!keyEvent.isConsumed() && keyEvent.getID() == 401 && keyEvent.getKeyCode() == 27) {
                        logger.trace("ESC Key is pressed");
                        FloatingAppPanel.getInstance().setVisible(false);
                        CommonUtil.hideShowTooltip();
                    }
                    return false;
                }
            };
        }
        return this.keyEventCloseListener;
    }

    private ComponentListener getComponentListener() {
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Component component = (Component)componentEvent.getSource();
                int n = component.getWidth() - 70;
                int n2 = component.getHeight() - 160;
                FloatingAppPanel.this.setSize(new Dimension(n, n2));
            }
        };
        return componentAdapter;
    }

    public void addTab(String string, Icon icon, JComponent jComponent) {
        this.jTabbedPane.addTab(string, icon, jComponent);
    }

    public void removeTabs() {
        if (null != this.jTabbedPane) {
            this.jTabbedPane.removeAll();
        }
        this.isFirst = true;
    }

    public void selectTab(int n) {
        this.jTabbedPane.setSelectedIndex(n);
    }

    @Override
    public void setVisible(boolean bl) {
        final boolean bl2 = bl;
        if (SwingUtilities.isEventDispatchThread()) {
            this.setFloatingAppPanelVisible(bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FloatingAppPanel.this.setFloatingAppPanelVisible(bl2);
                }
            });
        }
    }

    private void setFloatingAppPanelVisible(boolean bl) {
        logger.trace("Setting Floating panel state : " + bl + "HashCode :" + this.hashCode());
        if (bl != this.isVisible()) {
            super.setVisible(bl);
            if (bl) {
                if (this.isFirst) {
                    FavouriteStateMgr favouriteStateMgr = FavouriteStateMgr.getInstance();
                    int n = favouriteStateMgr.getButtonCnt();
                    if (n == 0) {
                        this.jTabbedPane.setSelectedIndex(1);
                    }
                    FavouritePanel.setDividerLocation(0.23);
                    this.isFirst = false;
                }
                logger.info("floating panel will become visible");
                MenuSelectionManager.defaultManager().clearSelectedPath();
                this.addCloseListeners();
                if (null == this.lastfocusOwner) {
                    this.lastfocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    this.requestFocus();
                }
                AppRoundButton.getInstance().setState(AppRoundButton.State.PRESSED);
                if (2 == this.jTabbedPane.getSelectedIndex()) {
                    SearchPanel.getInstance().setFocusOnText();
                } else if (null != this.jTabbedPane.getSelectedComponent()) {
                    this.jTabbedPane.getSelectedComponent().requestFocusInWindow();
                }
                logger.info("floating panel will become visible end");
            } else {
                AppPopupMenuManager appPopupMenuManager;
                String string;
                logger.info("floating panel will become invisible");
                this.removeCloseListeners();
                AppRoundButton appRoundButton = AppRoundButton.getInstance();
                PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                Point point = pointerInfo.getLocation();
                SwingUtilities.convertPointFromScreen(point, appRoundButton);
                if (appRoundButton.contains(point)) {
                    appRoundButton.setState(AppRoundButton.State.HOVERED);
                } else {
                    appRoundButton.setState(AppRoundButton.State.NORMAL);
                }
                if (null != this.lastfocusOwner) {
                    this.lastfocusOwner.requestFocus();
                    this.lastfocusOwner = null;
                }
                if (null != (string = ApplicationManager.getInstance().getApplicationPanel().getSelectedApp()) && string.length() > 0 && null != (appPopupMenuManager = ApplicationManager.getInstance().getAppPopUpMenuManager(string))) {
                    appPopupMenuManager.hidePopupMenu();
                }
                logger.info("floating panel will become invisible end HashCode :" + this.hashCode());
            }
        } else {
            logger.trace("floating panel visibility remains unchanged HashCode :" + this.hashCode());
        }
    }

    public void showAt(int n, int n2) {
        logger.debug("Show floating panel at " + n + " " + n2 + "HashCode" + this.hashCode());
        Dimension dimension = FrameworkUtilities.getMainFrame().getSize();
        this.setSize(new Dimension(dimension.width - 70, dimension.height - 160));
        this.setLocation(n, n2);
        this.revalidate();
        FrameworkUtilities.getMainFrame().getLayeredPane().add(this, JLayeredPane.POPUP_LAYER - 1, 1);
        this.setVisible(true);
        logger.debug("Show floating panel complete HashCode" + this.hashCode());
    }

    public static void clearWhileOSGIExit() {
        logger.debug("clearing the instanceof floating panel");
        instance = null;
    }

    private class FloatingPanelBorder
    extends AbstractBorder {
        private Color highlight = new Color(102, 102, 102);
        private Color shadow = new Color(218, 226, 226);

        FloatingPanelBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            int n5 = n3;
            int n6 = n4;
            graphics.translate(n, n2);
            graphics.setColor(this.highlight);
            graphics.drawRect(0, 0, n5 - 1, n6 - 1);
            graphics.setColor(this.shadow);
            graphics.drawLine(1, 1, n5 - 2, 1);
            graphics.translate(-n, -n2);
            graphics.setColor(color);
        }
    }
}

