/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement.gui;

import com.swimap.iview.framework.applicationmanagement.gui.ApplicationButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;

public class ApplicationPanelLayout
extends DraggableLayout {
    private static int Y_GAP_BTWN_BTNS = 10;
    private static int X_GAP_BTWN_BTNS = 20;
    private int iconBufferGap = 60;
    private int APP_ICON_WIDTH = 90;
    private int APP_ICON_HEIGHT = 90;

    public ApplicationPanelLayout() {
    }

    public ApplicationPanelLayout(Dimension dimension, int n, int n2, int n3) {
        this.APP_ICON_WIDTH = dimension.width;
        this.APP_ICON_HEIGHT = dimension.height;
        X_GAP_BTWN_BTNS = n;
        Y_GAP_BTWN_BTNS = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Component[] componentArray = container.getComponents();
            Insets insets = container.getInsets();
            if (componentArray.length == 0) {
                return;
            }
            DraggableButton draggableButton = null;
            int n = 0;
            int n2 = 0;
            for (Component component : componentArray) {
                if (!component.isVisible() || !(component instanceof ApplicationButton)) continue;
                draggableButton = (DraggableButton)component;
                int n3 = draggableButton.getXIndex();
                int n4 = draggableButton.getYIndex();
                n = n3 == 0 ? X_GAP_BTWN_BTNS + insets.left : X_GAP_BTWN_BTNS + n3 * this.getFixedWidth();
                n2 = n4 == 0 ? Y_GAP_BTWN_BTNS + insets.top : Y_GAP_BTWN_BTNS + n4 * this.getFixedHeight();
                int n5 = draggableButton.getPreferredSize().width;
                int n6 = draggableButton.getPreferredSize().height;
                draggableButton.setBounds(n - 3, n2, n5, n6);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getCustomLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Component[] componentArray = container.getComponents();
            Insets insets = container.getInsets();
            if (componentArray.length == 0) {
                return new Dimension(0, 0);
            }
            int n = 0;
            int n2 = 0;
            DraggableButton draggableButton = null;
            for (Component component : componentArray) {
                if (!(component instanceof ApplicationButton)) continue;
                draggableButton = (DraggableButton)component;
                n = draggableButton.getXIndex() > n ? draggableButton.getXIndex() : n;
                n2 = draggableButton.getYIndex() > n2 ? draggableButton.getYIndex() : n2;
            }
            return new Dimension(insets.left + insets.right + (n + 1) * this.getFixedWidth(), insets.top + insets.bottom + (n2 + 1) * this.getFixedHeight());
        }
    }

    @Override
    public int getFixedHeight() {
        return this.APP_ICON_HEIGHT + this.iconBufferGap + Y_GAP_BTWN_BTNS;
    }

    @Override
    public int getFixedWidth() {
        return this.APP_ICON_WIDTH + this.iconBufferGap + X_GAP_BTWN_BTNS;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.getCustomLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.getCustomLayoutSize(container);
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Point getDestIndex(Point point) {
        int n = -1;
        int n2 = -1;
        if (null != point) {
            n = point.x <= X_GAP_BTWN_BTNS ? 0 : point.x / this.getFixedWidth();
            n2 = point.y <= Y_GAP_BTWN_BTNS ? 0 : point.y / this.getFixedHeight();
            if (n >= 6) {
                --n;
            }
            if (n2 >= 4) {
                --n2;
            }
        }
        return new Point(n, n2);
    }
}

