/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement.gui;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.applicationmanagement.Application;
import com.swimap.iview.framework.applicationmanagement.gui.ApplicationButton;
import com.swimap.iview.framework.applicationmanagement.gui.ApplicationPanelLayout;
import com.swimap.iview.framework.windowmanagement.welcomepage.IButtonStateListerer;
import com.swimap.iview.framework.windowmanagement.welcomepage.IClickListener;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeTextButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.PanelDropTargetListener;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JPanel;

public class ApplicationPanel
extends JPanel
implements IClickListener,
IButtonStateListerer {
    private static final long serialVersionUID = -6298163340712289639L;
    private static final IviewLogger logger = IviewLogger.getLogger(ApplicationPanel.class);
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/applicationmanagement/Res");
    private static final String APPLICATIONS_FILE = "applications";
    protected static final int MAX_BUTTONS_IN_ROW = 6;
    protected static final int MAX_BUTTONS_IN_COLUMN = 4;
    private static final String DEFAULT_APP_ICON = "default_application.png";
    private List<ApplicationButton> appButtons = new ArrayList<ApplicationButton>();
    private CommStyleInfo info = null;

    public ApplicationPanel() {
        super(new ApplicationPanelLayout());
        this.setOpaque(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (!mouseEvent.isPopupTrigger()) {
                    for (ApplicationButton applicationButton : ApplicationPanel.this.appButtons) {
                        applicationButton.setSingleSelected(false);
                        applicationButton.setState(0);
                    }
                }
            }
        });
        this.setDropTarget(new DropTarget(this, new PanelDropTargetListener(this, this, ApplicationButton.getDataFlavor())));
    }

    public void clear() {
        this.removeAll();
        this.appButtons.clear();
        this.info = null;
    }

    public void initialize(List<Application> list) {
        if (null == list || list.isEmpty()) {
            return;
        }
        this.removeAll();
        this.appButtons.clear();
        this.info = CommStyleManager.getInstance().getUserCommonStyleFile(APPLICATIONS_FILE);
        if (null == this.info) {
            this.info = new CommStyleInfo();
            this.info.setFileName(CommStyleManager.getInstance().getUserDir() + APPLICATIONS_FILE + ".xml");
            this.info.addAreaDescContainer(new AreaDescContainer());
            for (Application object : list) {
                if (!object.isLicensed()) {
                    logger.debug("Application is not license so that application button will not create");
                    continue;
                }
                ApplicationButton applicationButton = this.getApplicationButton(object, this.info);
                this.appButtons.add(applicationButton);
                if (this.appButtons.size() < 24) continue;
                break;
            }
            this.resetIndexes(this.appButtons);
            for (ApplicationButton applicationButton : this.appButtons) {
                this.add(applicationButton);
            }
        } else {
            Serializable serializable;
            DescContainer[] descContainerArray = this.info.getAreaDescContainer(0).getDescContainer();
            ArrayList<Application> arrayList = new ArrayList<Application>(list);
            boolean bl = false;
            for (DescContainer descContainer : descContainerArray) {
                bl = false;
                String string = descContainer.getDescName();
                for (Application application : list) {
                    if (!string.equals(application.getId())) continue;
                    bl = true;
                    descContainer.setParasItem("name", application.getName());
                    descContainer.setParasItem("description", application.getDescription());
                    descContainer.setParasItem("icon", application.getIconPath());
                    if (!application.isLicensed()) {
                        logger.debug("Application is not license so that application button will not create");
                        this.info.getAreaDescContainer(0).removeDescContainer(descContainer);
                        continue;
                    }
                    serializable = this.getApplicationButton(application, descContainer);
                    this.appButtons.add((ApplicationButton)serializable);
                    this.add((Component)serializable);
                    arrayList.remove(application);
                    break;
                }
                if (bl) continue;
                this.info.getAreaDescContainer(0).removeDescContainer(descContainer);
            }
            for (Application application : arrayList) {
                int n;
                int n2 = list.indexOf(application) + 1;
                int n3 = n2 % 6 == 0 ? 5 : n2 % 6 - 1;
                int n4 = n = n2 % 6 == 0 ? n2 / 6 - 1 : n2 / 6;
                if (!application.isLicensed()) {
                    logger.debug("Application is not license so that application button will not create");
                    continue;
                }
                ApplicationButton applicationButton = this.getApplicationButton(application, this.info);
                boolean bl2 = this.isButtonExist(n3, n);
                if (bl2) {
                    serializable = this.getNextAvailablePositionXY(this.appButtons, n3, n);
                    n3 = ((Point)serializable).x;
                    n = ((Point)serializable).y;
                }
                applicationButton.setXIndex(n3);
                applicationButton.setYIndex(n);
                applicationButton.storeXYInfo();
                this.appButtons.add(applicationButton);
                this.add(applicationButton);
                if (this.appButtons.size() < 24) continue;
                break;
            }
        }
    }

    private boolean isButtonExist(int n, int n2) {
        ArrayList<ApplicationButton> arrayList = new ArrayList<ApplicationButton>(this.appButtons);
        for (ApplicationButton applicationButton : arrayList) {
            if (applicationButton.getXIndex() != n || applicationButton.getYIndex() != n2) continue;
            return true;
        }
        return false;
    }

    private Point getNextAvailablePositionXY(List<ApplicationButton> list, int n, int n2) {
        int n3 = 0;
        Point point = new Point();
        for (int i = 0; i <= 6; ++i) {
            ApplicationButton applicationButton;
            if (i >= 6) {
                ++n3;
                i = 0;
            }
            if (n3 >= 4) {
                n3 = 0;
            }
            if (null != (applicationButton = this.getTargetBtn(new Point(i, n3), this))) continue;
            point.setLocation(i, n3);
            return point;
        }
        return null;
    }

    private ApplicationButton getTargetBtn(Point point, ApplicationPanel applicationPanel) {
        ApplicationButton applicationButton = null;
        for (Component component : applicationPanel.getComponents()) {
            ApplicationButton applicationButton2;
            if (!(component instanceof ApplicationButton) || (applicationButton2 = (ApplicationButton)component).getXIndex() != point.x || applicationButton2.getYIndex() != point.y) continue;
            applicationButton = applicationButton2;
            break;
        }
        return applicationButton;
    }

    private void resetIndexes(List<ApplicationButton> list) {
        int n = 0;
        int n2 = 0;
        for (ApplicationButton applicationButton : list) {
            applicationButton.setXIndex(n++);
            applicationButton.setYIndex(n2);
            applicationButton.storeXYInfo();
            if (n < 6) continue;
            n = 0;
            ++n2;
        }
    }

    private ApplicationButton getApplicationButton(Application application, CommStyleInfo commStyleInfo) {
        DescContainer descContainer = new DescContainer();
        descContainer.setDescName(application.getId());
        descContainer.setParasItem("name", application.getName(), true);
        descContainer.setParasItem("description", application.getDescription(), true);
        descContainer.setParasItem("icon", application.getIconPath(), true);
        descContainer.setParasItem("serialnumber", "" + application.getSerialNumber(), true);
        descContainer.setParasItem("xIndex", "0", true);
        descContainer.setParasItem("yIndex", "0", true);
        commStyleInfo.getAreaDescContainer(0).addDescContainer(descContainer);
        ApplicationButton applicationButton = this.getApplicationButton(application, descContainer);
        return applicationButton;
    }

    private ApplicationButton getApplicationButton(Application application, DescContainer descContainer) {
        ApplicationButton applicationButton = new ApplicationButton(descContainer, DEFAULT_APP_ICON, new Dimension(90, 90), 90, application.getId());
        applicationButton.initializeButton(this);
        String string = descContainer.getParasItemValue("xIndex");
        String string2 = descContainer.getParasItemValue("yIndex");
        applicationButton.setXIndex(Integer.parseInt(string));
        applicationButton.setYIndex(Integer.parseInt(string2));
        applicationButton.addListeners();
        return applicationButton;
    }

    @Override
    public void buttonClicked(Object object) {
        List<Component> list = Arrays.asList(this.getComponents());
        if (object instanceof DraggableButton && this.getComponentZOrder((WelcomeTextButton)object) > 0) {
            this.setComponentZOrder((WelcomeTextButton)object, 0);
        }
        if (null == list) {
            return;
        }
        int n = list.size();
        ApplicationButton applicationButton = null;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            applicationButton = (ApplicationButton)list.get(i);
            bl = applicationButton.isSingleSelected();
            if (!bl) continue;
            applicationButton.setSingleSelected(false);
            applicationButton.setState(0);
        }
        this.updateUI();
    }

    @Override
    public void buttonDragged(Object object, Object object2) {
        this.needRefresh(object);
        this.needRefresh(object2);
    }

    private void needRefresh(Object object) {
        if (object instanceof ApplicationButton) {
            ApplicationButton applicationButton = (ApplicationButton)object;
            applicationButton.setNeedCommit(true);
            if (applicationButton.isSingleSelected()) {
                applicationButton.setState(2);
            }
        }
    }

    public String getSelectedApp() {
        String string = "";
        if (null != this.appButtons) {
            for (ApplicationButton applicationButton : this.appButtons) {
                if (null == applicationButton || !applicationButton.isSingleSelected()) continue;
                string = applicationButton.getDescName();
            }
        }
        return string;
    }

    public void saveState() {
        for (ApplicationButton applicationButton : this.appButtons) {
            if (null == applicationButton || !applicationButton.isNeedCommit()) continue;
            applicationButton.setNeedCommit(false);
        }
        if (null != this.info) {
            CommStyleManager.getInstance().writeToUser(this.info);
        }
    }
}

