/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement.gui;

import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.applicationmanagement.AppPopupMenuManager;
import com.swimap.iview.framework.applicationmanagement.ApplicationLauncher;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.applicationmanagement.gui.ApplicationPanel;
import com.swimap.iview.framework.applicationmanagement.gui.PortalDraggableButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableButtonDropTargetListener;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class ApplicationButton
extends PortalDraggableButton {
    private static IviewLogger logger = IviewLogger.getLogger(ApplicationButton.class, "IVIEW");
    private static final long serialVersionUID = 2015976580264960599L;
    private ApplicationPanel appPanel = null;
    public static final int DEFAULT_APP_ICON_WIDTH = 90;
    public static final int DEFAULT_APP_ICON_HEIGHT = 90;
    private static DataFlavor flavour = null;
    private String appId = null;
    private static ImageIcon hoveredIcon = null;
    private static ImageIcon selectedIcon = null;
    private boolean isHovered = true;
    private AppPopupMenuManager popupMenuManager = null;

    public ApplicationButton(DescContainer descContainer, String string, Dimension dimension, int n, String string2) {
        super(descContainer, string, dimension, n);
        this.appId = string2;
    }

    @Override
    public void initializeButton() {
        super.initializeButton();
        this.addSelectionListener(this.appPanel);
        DraggableButtonDropTargetListener draggableButtonDropTargetListener = new DraggableButtonDropTargetListener(this, this.appPanel, this.appPanel, ApplicationButton.getDataFlavor());
        DropTarget dropTarget = new DropTarget(this, draggableButtonDropTargetListener);
        this.setDropTarget(dropTarget);
        for (Component component : this.getComponents()) {
            component.setDropTarget(dropTarget);
        }
        this.addMouseListener(new BtnCickListener());
        this.setToolTipText(this.getTooltip());
    }

    public void addListeners() {
        this.addMouseListener(this.createPopupMenuMouseAdapter());
        this.getTitleComponent().addMouseListener(this.createPopupMenuMouseAdapter());
    }

    private MouseAdapter createPopupMenuMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ApplicationButton.this.showPopupForButton(mouseEvent);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void showPopupForButton(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0) {
            try {
                ScreenToolKit.setSystemBusy(true);
                if (null == this.popupMenuManager) {
                    this.popupMenuManager = ApplicationManager.getInstance().getApplication(this.appId).getPopupMenuManager();
                }
                this.popupMenuManager.updatePopupMenu();
                this.popupMenuManager.updateAppPopUP();
                JPopupMenu jPopupMenu = this.popupMenuManager.getPopupMenu();
                if (null != jPopupMenu && jPopupMenu.getComponentCount() != 0) {
                    logger.debug("Showing PopupMenu: " + mouseEvent.getX() + mouseEvent.getY());
                    ScreenToolKit.showPopupMenu(jPopupMenu, mouseEvent);
                    return;
                }
            }
            finally {
                ScreenToolKit.setSystemBusy(false);
            }
            this.showMenuErrorMessage();
            return;
        }
    }

    private void showMenuErrorMessage() {
        ResourceBundle resourceBundle = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/applicationmanagement/Res");
        String string = resourceBundle.getString("infoDialog_title");
        String string2 = resourceBundle.getString("infoMessage");
        OptionPane.showMessageDialog(this, string2, string, 1);
    }

    @Override
    protected void processTextClick(Object object) {
        this.processClick(object);
    }

    @Override
    protected void processClick(Object object) {
        logger.debug("Process Click--- application button is clicked" + this.getFullName());
        logger.trace("Hash code for the Application Button :" + this.hashCode());
        try {
            JPopupMenu jPopupMenu = ApplicationManager.getInstance().getApplication(this.appId).getPopupMenuManager().getPopupMenu();
            if (null == jPopupMenu || jPopupMenu.getComponentCount() == 0) {
                this.showMenuErrorMessage();
                return;
            }
            ApplicationLauncher.getAppLauncher().launchApplication(this.appId, true, null, true);
        }
        catch (Exception exception) {
            logger.trace("Exception occured while launching the application:" + this.appId);
            logger.error(exception);
        }
        logger.debug("Process Click--- application button action is completed" + this.getFullName());
    }

    public String getAppId() {
        return this.appId;
    }

    public void initializeButton(ApplicationPanel applicationPanel) {
        this.appPanel = applicationPanel;
        this.initializeButton();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[]{ApplicationButton.getDataFlavor()};
        return dataFlavorArray;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return null != dataFlavor ? dataFlavor.equals(ApplicationButton.getDataFlavor()) : false;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor != null && dataFlavor.equals(ApplicationButton.getDataFlavor())) {
            return this;
        }
        return null;
    }

    public static final DataFlavor getDataFlavor() {
        if (null == flavour) {
            try {
                flavour = new DataFlavor("application/x-java-jvm-local-objectref;class=" + ApplicationButton.class.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                flavour = null;
            }
        }
        return flavour;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        Dimension dimension = this.getPreferredSize();
        if (null == hoveredIcon) {
            hoveredIcon = (ImageIcon)ResourceMng.getInstance().getIconDirect("portal/hovered.png");
            selectedIcon = (ImageIcon)ResourceMng.getInstance().getIconDirect("portal/selected.png");
        }
        if (this.isEnabled() && this.isSingleSelected()) {
            graphics2D.drawImage(selectedIcon.getImage(), 0, 0, dimension.width + 2, dimension.height + 2, null);
        } else if (this.isEnabled() && this.isHovered()) {
            graphics2D.drawImage(hoveredIcon.getImage(), 0, 0, dimension.width, dimension.height, null);
        }
        graphics2D.setComposite(composite);
        super.paintComponent(graphics);
    }

    @Override
    public boolean isHovered() {
        return this.isHovered;
    }

    private class BtnCickListener
    extends MouseAdapter {
        private BtnCickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (2 == mouseEvent.getClickCount() && 16 == mouseEvent.getModifiers()) {
                try {
                    ApplicationButton.this.processClick(mouseEvent.getSource());
                }
                catch (Throwable throwable) {
                    logger.error("IView Handled error in welcome text Button mouse clickAction" + throwable);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && (mouseEvent.getModifiers() & 2) == 2) {
                ApplicationButton.this.fireControlClick();
            } else {
                ApplicationButton.this.fireClickAction(SwingUtilities.isLeftMouseButton(mouseEvent));
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ToolTipManager.sharedInstance().setEnabled(false);
            ToolTipManager.sharedInstance().setEnabled(true);
        }
    }
}

