/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement.gui;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.applicationmanagement.gui.AppButtonStateListener;
import com.swimap.iview.framework.applicationmanagement.gui.FloatingAppPanel;
import com.swimap.iview.framework.lookandfeel.skin.SkinManager;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.util.FrameworkUtilities;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;

public class AppRoundButton
extends JComponent {
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/applicationmanagement/Res");
    private static final long serialVersionUID = 2684504253870749629L;
    private static final String normalImageName = "normal.png";
    private static final String portalImageType = "portal";
    private static final int APPBUTTON_HEIGHT = 55;
    private static final int APPBUTTON_WIDTH = 55;
    private static final String pressedImageName = "pressed.png";
    private static final String hoveredImageName = "hovered.png";
    private static Image normalImage = null;
    private static Image hoveredImage = null;
    private static Image pressedImage = null;
    private State state = State.NORMAL;
    private List<AppButtonStateListener> buttonStateListenerList = new ArrayList<AppButtonStateListener>(2);
    private static AppRoundButton instance = null;

    private AppRoundButton() {
        SkinManager skinManager = SkinManager.getInstance();
        ImageIcon imageIcon = skinManager.getSkinImage(portalImageType, normalImageName);
        ImageIcon imageIcon2 = skinManager.getSkinImage(portalImageType, pressedImageName);
        ImageIcon imageIcon3 = skinManager.getSkinImage(portalImageType, hoveredImageName);
        if (null != imageIcon) {
            normalImage = imageIcon.getImage();
        }
        if (null != imageIcon2) {
            hoveredImage = imageIcon2.getImage();
        }
        if (null != hoveredImageName) {
            pressedImage = imageIcon3.getImage();
        }
        this.setSize(new Dimension(55, 55));
        this.setPreferredSize(new Dimension(55, 55));
        this.setOpaque(false);
        this.setToolTipText(res.getString("ApplicationPaneltip"));
        this.setLocation(0, 0);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (AppRoundButton.this.state == State.NORMAL) {
                    AppRoundButton.this.setState(State.HOVERED);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 0x10) == 0) {
                    return;
                }
                if (AppRoundButton.this.state == State.PRESSED) {
                    AppRoundButton.this.state = State.HOVERED;
                } else {
                    AppRoundButton.this.state = State.PRESSED;
                }
                AppRoundButton.this.repaint(0L);
                AppRoundButton.this.fireButtonStateChange();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (AppRoundButton.this.state != State.PRESSED) {
                    AppRoundButton.this.state = State.HOVERED;
                    AppRoundButton.this.repaint(0L);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (AppRoundButton.this.state == State.HOVERED) {
                    AppRoundButton.this.state = State.NORMAL;
                    AppRoundButton.this.repaint(0L);
                }
                ToolTipManager.sharedInstance().setEnabled(false);
                ToolTipManager.sharedInstance().setEnabled(true);
            }
        });
        this.addButtonStateListener(new AppButtonStateListener(){

            @Override
            public void buttonPressed() {
                FloatingAppPanel.getInstance().showAt(0, 23);
            }

            @Override
            public void buttonReleased() {
                FloatingAppPanel.getInstance().setVisible(false);
            }
        });
    }

    private void fireButtonStateChange() {
        for (AppButtonStateListener appButtonStateListener : this.buttonStateListenerList) {
            if (this.state == State.PRESSED) {
                appButtonStateListener.buttonPressed();
                continue;
            }
            appButtonStateListener.buttonReleased();
        }
    }

    public static AppRoundButton getInstance() {
        if (null == instance) {
            instance = new AppRoundButton();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics graphics) {
        Graphics graphics2 = graphics.create();
        try {
            int n;
            int n2 = this.getSize().width;
            int n3 = this.getSize().height;
            MDIFrame mDIFrame = (MDIFrame)FrameworkUtilities.getMainFrame();
            if (null != mDIFrame.getJMenuBar() && null != mDIFrame.getToolBarPanel() && (n = mDIFrame.getJMenuBar().getHeight() + mDIFrame.getToolBarPanel().getHeight()) != n3) {
                this.setSize(n2, n);
            }
            n = this.getLocation().x;
            int n4 = this.getLocation().y;
            Graphics2D graphics2D = null;
            graphics2D = (Graphics2D)graphics2;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            graphics2D.drawImage(this.getStateImage(), n, n4, 55, 55, null);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            graphics2D.setColor(this.getBackground().darker());
            int n5 = 23;
            if (null != mDIFrame.getJMenuBar()) {
                n5 = mDIFrame.getJMenuBar().getHeight();
            }
            graphics2D.drawLine(n2 - 2, n4, n2 - 2, n5);
            graphics2D.setColor(this.getBackground().brighter());
            graphics2D.drawLine(n2 - 1, n4, n2 - 1, n5);
            if (this.state != State.PRESSED) {
                graphics2D.setColor(this.getBackground().darker());
                graphics2D.drawLine(n, n3 - 2, n2, n3 - 2);
                graphics2D.setColor(this.getBackground().brighter());
                graphics2D.drawLine(n, n3 - 1, n2, n3 - 1);
            }
            graphics2D.setComposite(composite);
        }
        finally {
            graphics2.dispose();
        }
    }

    private Image getStateImage() {
        if (State.NORMAL == this.state) {
            return normalImage;
        }
        if (State.HOVERED == this.state) {
            return hoveredImage;
        }
        if (State.PRESSED == this.state) {
            return pressedImage;
        }
        return null;
    }

    public void setState(State state) {
        this.state = state;
        this.repaint(0L);
    }

    @Override
    public boolean contains(int n, int n2) {
        int n3 = this.getSize().width;
        int n4 = n3 / 2;
        int n5 = n3 / 2;
        int n6 = (int)Math.sqrt(Math.pow(n5 - n, 2.0) + Math.pow(n5 - n2, 2.0));
        return n6 <= n4;
    }

    public void addButtonStateListener(AppButtonStateListener appButtonStateListener) {
        this.buttonStateListenerList.add(appButtonStateListener);
    }

    public static enum State {
        NORMAL,
        HOVERED,
        PRESSED;

    }
}

