/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement;

import com.swimap.iview.commstyle.commandmng.CommandSource;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityAction;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JComponent;

class StartupCommand {
    private StartupCommandType type = null;
    private String value = null;
    private boolean isBlankFrame = true;
    private static IviewLogger logger = IviewLogger.getLogger(StartupCommand.class, "IVIEW");

    StartupCommand(StartupCommandType startupCommandType, String string, boolean bl) {
        this.type = startupCommandType;
        this.value = string;
        this.isBlankFrame = bl;
    }

    public StartupCommandType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isBlankFrame() {
        return this.isBlankFrame;
    }

    public void invokeStartupCommand() {
        JButton jButton = new JButton();
        jButton.setActionCommand(this.getValue());
        CommandSource commandSource = new CommandSource(jButton);
        ActionEvent actionEvent = new ActionEvent(commandSource, 1001, null);
        AuthorityAction authorityAction = this.initActionClass(jButton);
        if (null != authorityAction) {
            if (!authorityAction.isActionEnabled() || !authorityAction.isActionVisible()) {
                return;
            }
            authorityAction.actionPerformed(actionEvent);
        } else {
            logger.trace("Action class is null");
        }
    }

    private AuthorityAction initActionClass(JComponent jComponent) {
        if (null != this.value) {
            try {
                Class<?> clazz = null;
                clazz = Class.forName(this.value);
                AuthorityAction authorityAction = (AuthorityAction)clazz.newInstance();
                authorityAction.setSource(jComponent);
                return authorityAction;
            }
            catch (Throwable throwable) {
                logger.trace("Class is not initialized :" + throwable);
            }
        }
        return null;
    }

    public static enum StartupCommandType {
        COMMAND,
        ACTION,
        EXECUTABLE;

    }
}

