/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.systemsettingsmanagement.BaseClientSettings;
import com.swimap.iview.framework.systemsettingsmanagement.SystemSettingsManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.omg.CORBA.ORB;

public class DisplayStyleSetting
extends BaseClientSettings {
    private static IviewLogger logger = IviewLogger.getLogger(DisplayStyleSetting.class, "IVIEW");
    static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/applicationmanagement/Res");
    private static final String FILE_NAME = "conf/mainfrm/displaystylesettings";
    private static final String AREADESC_NAME = "DisplayStyle";
    private static final String DESC_NAME = "DisplayStyleSetting";
    private static final String PARA_NAME = "loadStyle";
    private JPanel displaySettingPanel = null;
    private ButtonGroup bg = new ButtonGroup();
    private JRadioButton rb_traditional = new JRadioButton(res.getString("traditionalLabel_key"));
    private JRadioButton rb_application = new JRadioButton(res.getString("applicationLabel_key"));
    public boolean changed = false;
    private FrameworkCommandProcessor.LoadStyle currentStyle = null;
    private static final String DISPLAY_SETTING = "DisplayStyleSetting";

    public DisplayStyleSetting(ModuleManager moduleManager) throws ModuleManagementException {
        super(moduleManager);
    }

    public DisplayStyleSetting(ModuleManager moduleManager, ORB oRB, String string, String string2) throws ModuleManagementException {
        super(moduleManager, oRB, string, string2);
    }

    @Override
    public boolean apply() {
        if (this.changed) {
            this.doApplyActions();
            return true;
        }
        return false;
    }

    private void doApplyActions() {
        FrameworkCommandProcessor.LoadStyle loadStyle = this.getLoadingStyle();
        if (this.currentStyle == loadStyle) {
            return;
        }
        SystemSettingsManager systemSettingsManager = FrameworkUtilities.getSystemSettingsManager();
        try {
            this.saveSettingsInformation(loadStyle);
            systemSettingsManager.setSystemSettingStatus(this.getTabLabel(), true, res.getString("relogin_message_key"));
            this.currentStyle = loadStyle;
        }
        catch (IOException iOException) {
            logger.debug("IOException during the apply." + iOException);
            systemSettingsManager.setSystemSettingStatus(this.getTabLabel(), false, res.getString("Fail_msg"));
            if (this.currentStyle == FrameworkCommandProcessor.LoadStyle.application) {
                this.rb_application.setSelected(true);
            }
            this.rb_traditional.setSelected(true);
        }
        this.changed = false;
    }

    @Override
    public void reinitialize() {
        super.reinitialize();
        this.loadSettingsInformation();
    }

    private void saveSettingsInformation(FrameworkCommandProcessor.LoadStyle loadStyle) throws IOException {
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        CommStyleInfo commStyleInfo = commStyleManager.getCommonStyleFile(FILE_NAME);
        if (null == commStyleInfo) {
            commStyleInfo = new CommStyleInfo();
            AreaDescContainer areaDescContainer = new AreaDescContainer();
            areaDescContainer.setAreaName(AREADESC_NAME);
            DescContainer descContainer = new DescContainer();
            descContainer.setDescName("DisplayStyleSetting");
            PARA pARA = new PARA();
            pARA.setName(PARA_NAME);
            pARA.setValue(loadStyle.name());
            descContainer.addParasItem(pARA);
            areaDescContainer.addDescContainer(descContainer);
            commStyleInfo.addAreaDescContainer(areaDescContainer);
            commStyleInfo.setFileName("style/defaultstyle/conf/mainfrm/displaystylesettings.xml");
            CommStyleManager.getInstance().writeToServer(commStyleInfo);
            return;
        }
        DescContainer descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer("DisplayStyleSetting");
        if (null != descContainer) {
            descContainer.setParasItem(PARA_NAME, loadStyle.name(), false);
            CommStyleManager.getInstance().writeToServer(commStyleInfo);
        }
    }

    private void loadSettingsInformation() {
        FrameworkCommandProcessor.LoadStyle loadStyle = null;
        loadStyle = FrameworkCommandProcessor.getInstance().getUserLoadStyle();
        if (FrameworkCommandProcessor.LoadStyle.application.equals((Object)loadStyle)) {
            this.rb_application.setSelected(true);
        } else {
            this.rb_traditional.setSelected(true);
        }
        this.currentStyle = loadStyle;
    }

    @Override
    public boolean exit() {
        if (this.changed) {
            if (this.currentStyle == FrameworkCommandProcessor.LoadStyle.application) {
                this.rb_application.setSelected(true);
            } else {
                this.rb_traditional.setSelected(true);
            }
            this.changed = false;
        }
        return true;
    }

    @Override
    public JPanel getSettingsPanel() {
        if (null == this.displaySettingPanel) {
            this.displaySettingPanel = new JPanel();
            this.displaySettingPanel.setLayout(new BorderLayout());
            this.displaySettingPanel.add((Component)this.createSettingPanel(), "North");
            this.displaySettingPanel.putClientProperty("HELP_ID_PROPERTY", "iVIEW.systemsetting.loadingStyle");
            HelpManager.getInstance().enableHelpKey(this.displaySettingPanel, "iVIEW.systemsetting.loadingStyle");
        }
        return this.displaySettingPanel;
    }

    private JPanel createSettingPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 5, 0));
        this.bg.add(this.rb_traditional);
        this.bg.add(this.rb_application);
        jPanel.add(this.rb_traditional);
        jPanel.add(this.rb_application);
        this.rb_application.setName("radiobutton_application");
        this.rb_traditional.setName("radiobutton_traditional");
        jPanel.setName("radio button panel");
        this.rb_application.setSelected(true);
        jPanel.add((Component)this.rb_application, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 2, 0, 0), 0, 0));
        jPanel.add((Component)this.rb_traditional, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 2, 0, 0), 0, 0));
        this.rb_application.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisplayStyleSetting.this.changed = true;
                DisplayStyleSetting.this.notifyChange();
            }
        });
        this.rb_traditional.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DisplayStyleSetting.this.changed = true;
                DisplayStyleSetting.this.notifyChange();
            }
        });
        return jPanel;
    }

    private void notifyChange() {
        FrameworkUtilities.getSystemSettingsManager().clientSettingChanged(this.getModuleName(), this.isChanged());
    }

    @Override
    public Icon getTabIcon() {
        return null;
    }

    @Override
    public String getTabLabel() {
        return res.getString("DisplayStyleSetting_TabLabel");
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public int getTitleDescription() {
        return 1;
    }

    @Override
    public String getModuleName() {
        return "DisplayStyleSetting";
    }

    @Override
    public String getSettingDescription() {
        return res.getString("displaySetting_description");
    }

    private FrameworkCommandProcessor.LoadStyle getLoadingStyle() {
        if (this.rb_application.isSelected()) {
            return FrameworkCommandProcessor.LoadStyle.application;
        }
        return FrameworkCommandProcessor.LoadStyle.traditional;
    }
}

