/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement;

import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.ToggleButton;
import com.swimap.iview.commstyle.commini.ToolBarButton;
import com.swimap.iview.commstyle.commini.ToolBarHandle;
import com.swimap.iview.commstyle.commini.ToolGroup;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.SecondaryStartupXMLReader;
import com.swimap.iview.framework.StartupXMLReader;
import com.swimap.iview.framework.applicationmanagement.AppCheckboxMenuItem;
import com.swimap.iview.framework.applicationmanagement.AppMenu;
import com.swimap.iview.framework.applicationmanagement.AppMenuItem;
import com.swimap.iview.framework.applicationmanagement.AppMenuItemProperties;
import com.swimap.iview.framework.applicationmanagement.AppModuleData;
import com.swimap.iview.framework.applicationmanagement.AppRadioButtonMenuItem;
import com.swimap.iview.framework.applicationmanagement.Application;
import com.swimap.iview.framework.applicationmanagement.ApplicationData;
import com.swimap.iview.framework.applicationmanagement.ApplicationLauncher;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.applicationmanagement.ModuleAppData;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.pluginmanagement.PluginSubsystemUtilities;
import com.swimap.iview.framework.toolbarmanagement.ToolbarManager;
import com.swimap.iview.framework.util.IStartupElement;
import com.swimap.iview.framework.util.LinkUtil;
import com.swimap.iview.framework.util.StartupFactory;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class ApplicationUtilities {
    private static final IviewLogger logger = IviewLogger.getLogger(ApplicationUtilities.class);
    static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/applicationmanagement/Res");
    public static final String APPLICATIONS_DIR = "applications";
    public static final String EMPTY_INTERNAL_FRAME = "empty internal frame";
    private static MenuManager baseMenuManager = null;
    private static ToolbarManager toolbarManager = null;
    public static final int POPUPMENU_PAGE_SIZE = 100;
    private static List<String> allPluginNames = new ArrayList<String>(16);
    private static String[] configuredValidPluginNames = null;
    private static JPanel rightPanel = null;
    private static String[] extsFromRequiredLinks = null;
    private static String[] extsFromPortalLinks = null;
    private static final String IVIEW_APP_ID = "iview_app";
    private static Map<String, AppModuleData> appModules = new ConcurrentHashMap<String, AppModuleData>(10);
    private static Map<String, ModuleAppData> moduleApps = new ConcurrentHashMap<String, ModuleAppData>(10);

    public static List<String> getFilteredStartupPlugins(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list2 = PluginSubsystemUtilities.getStartupPluginNamesList();
        if (null == list2) {
            logger.trace("Startup Plugins and Links are not configured");
            arrayList.addAll(list);
            Collections.sort(arrayList);
            return arrayList;
        }
        if (list2.size() == 0) {
            logger.trace("Plugins are not configured but Links are configured");
            return arrayList;
        }
        for (String string : list) {
            if (!list2.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    static List<IStartupElement> getFilteredStartupLinks(List<IStartupElement> list) {
        ArrayList<IStartupElement> arrayList = new ArrayList<IStartupElement>();
        List<IStartupElement> list2 = StartupFactory.getStartupElements(3);
        if (null == list2) {
            logger.trace("Startup Plugins and Links are not configured");
            arrayList.addAll(list);
            return arrayList;
        }
        if (list2.size() == 0) {
            logger.trace("Links are not configured but Plugins are configured");
            return arrayList;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (IStartupElement iStartupElement : list2) {
            arrayList2.add(iStartupElement.getName());
        }
        for (IStartupElement iStartupElement : list) {
            String string = iStartupElement.getName();
            if (!arrayList2.contains(string)) continue;
            arrayList.add(iStartupElement);
        }
        return arrayList;
    }

    public static List<String> getModuleIds(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (appModules.get(string) != null) {
            arrayList = new ArrayList<String>(appModules.get(string).getModuleIds());
        }
        return arrayList;
    }

    public static List<String> getAppIds(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (null != moduleApps.get(string)) {
            arrayList = new ArrayList<String>(moduleApps.get(string).getAppList());
        }
        return arrayList;
    }

    public static void populatesData(String string, String string2) {
        if (string2 == null) {
            return;
        }
        if (null == string) {
            string = IVIEW_APP_ID;
        }
        AppModuleData appModuleData = appModules.get(string);
        if (null == appModules.get(string)) {
            appModuleData = new AppModuleData();
            appModules.put(string, appModuleData);
        }
        appModuleData.registerModuleId(string2);
        ModuleAppData moduleAppData = moduleApps.get(string2);
        if (null == moduleApps.get(string2)) {
            moduleAppData = new ModuleAppData();
            moduleApps.put(string2, moduleAppData);
        }
        moduleAppData.registerAppId(string);
    }

    public static void clearAppModules() {
        Set<String> set = appModules.keySet();
        AppModuleData appModuleData = null;
        for (String object : set) {
            appModuleData = appModules.get(object);
            if (null == appModuleData) continue;
            appModuleData.clear();
        }
        set = moduleApps.keySet();
        Object object = null;
        for (String string : set) {
            object = moduleApps.get(string);
            if (null == object) continue;
            ((ModuleAppData)object).clear();
        }
        appModules.clear();
        moduleApps.clear();
    }

    public static void addModuleIds(String string, List<String> list) {
        if (null != list) {
            for (String string2 : list) {
                ApplicationUtilities.populatesData(string, string2);
            }
        }
    }

    private static void removeAppModulesData(String string) {
        if (appModules.containsKey(string)) {
            appModules.remove(string);
        }
    }

    private static void removeModulesAppData(String string) {
        if (moduleApps.containsKey(string)) {
            moduleApps.remove(string);
        }
    }

    public static void removeModuleId(String string) {
        ModuleAppData moduleAppData = moduleApps.get(string);
        if (null != moduleAppData) {
            Set<String> set = moduleAppData.getAppList();
            AppModuleData appModuleData = null;
            for (String string2 : set) {
                appModuleData = appModules.get(string2);
                if (appModuleData == null) continue;
                appModuleData.removeModuleId(string);
            }
        }
        ApplicationUtilities.removeModulesAppData(string);
    }

    public static void removeAppId(String string) {
        AppModuleData appModuleData = appModules.get(string);
        if (null != appModuleData) {
            Set<String> set = appModuleData.getModuleIds();
            ModuleAppData moduleAppData = null;
            for (String string2 : set) {
                moduleAppData = moduleApps.get(string2);
                if (moduleAppData == null) continue;
                moduleAppData.removeAppId(string);
            }
        }
        ApplicationUtilities.removeAppModulesData(string);
    }

    public static ApplicationData getApplicationData(String string) {
        return ApplicationLauncher.getAppLauncher().getApplicationData(string);
    }

    public static String getCurrentLaunchAppId() {
        return ApplicationLauncher.getAppLauncher().getCurrentLaunchAppId();
    }

    public static void setBaseMenuManager(MenuManager menuManager) {
        baseMenuManager = menuManager;
    }

    public static MenuManager getBaseMenuManager() {
        return baseMenuManager;
    }

    public static void setBaseToolbarManager(ToolbarManager toolbarManager) {
        ApplicationUtilities.toolbarManager = toolbarManager;
    }

    public static ToolbarManager getBaseToolbarManager() {
        return toolbarManager;
    }

    public static List<String> getPluginNamesOfAllApplications() {
        if (allPluginNames.isEmpty()) {
            List<String> list = StartupXMLReader.getPortalPlugins();
            List<Application> list2 = ApplicationManager.getInstance().getApplications();
            HashSet<String> hashSet = new HashSet<String>(16);
            hashSet.addAll(StartupXMLReader.getNormalAndRequiredPluginList());
            hashSet.addAll(SecondaryStartupXMLReader.getNormalPlugins());
            hashSet.addAll(SecondaryStartupXMLReader.getRequiredPlugins());
            if (null != list2) {
                for (Application application : list2) {
                    hashSet.addAll(application.getAllPluginNames());
                }
            }
            if (null != list) {
                hashSet.addAll(list);
            }
            allPluginNames = new ArrayList<String>(hashSet);
        }
        return allPluginNames;
    }

    public static String[] getValidPluginNamesFromApps() {
        List<String> list;
        if (null == configuredValidPluginNames && null != (list = ApplicationUtilities.getPluginNamesOfAllApplications()) && 0 < list.size()) {
            configuredValidPluginNames = PluginSubsystemUtilities.getAllPluginNames(list);
        }
        return configuredValidPluginNames;
    }

    public static void clear() {
        allPluginNames.clear();
        configuredValidPluginNames = null;
    }

    public static void updateToobarComponent(ToolGroup toolGroup, String string) {
        Component[] componentArray = toolGroup.getComponents();
        if (null == componentArray) {
            return;
        }
        List<String> list = null;
        for (Component component : componentArray) {
            list = null;
            if (component instanceof ToolGroup) {
                list = ((ToolGroup)component).getVisibleAppIDs();
                if (!list.isEmpty()) {
                    ApplicationUtilities.updateToobarComponent((ToolGroup)component, string);
                    if (!ApplicationUtilities.isToolGroupContainsItems((ToolGroup)component)) {
                        toolGroup.remove(component);
                    }
                }
                return;
            }
            if (component instanceof ToolBarButton) {
                list = ((ToolBarButton)component).getVisibleAppIDs();
            } else if (component instanceof ToggleButton) {
                list = ((ToggleButton)component).getVisibleAppIDs();
            } else if (component instanceof JToolBar.Separator || component instanceof ToolBarHandle) continue;
            if (null == list || list.isEmpty() || list.contains(string)) continue;
            toolGroup.remove(component);
        }
    }

    public static boolean isToolGroupContainsItems(ToolGroup toolGroup) {
        Component[] componentArray = toolGroup.getComponents();
        if (null == componentArray) {
            return false;
        }
        for (Component component : componentArray) {
            if (!(component instanceof ToolGroup) && !(component instanceof ToolBarButton) && !(component instanceof ToggleButton)) continue;
            return true;
        }
        return false;
    }

    public static void updateMenuComponent(AppMenuItemProperties appMenuItemProperties, String string, boolean bl) {
        Component[] componentArray = ((AppMenu)appMenuItemProperties).getMenuComponents();
        if (null == componentArray) {
            return;
        }
        for (Component component : componentArray) {
            if (!(component instanceof AppMenuItemProperties)) continue;
            AppMenuItemProperties appMenuItemProperties2 = (AppMenuItemProperties)((Object)component);
            if (bl && !appMenuItemProperties2.isShowInPortal()) {
                ((AppMenu)appMenuItemProperties).remove(component);
                continue;
            }
            List<String> list = appMenuItemProperties2.getVisibleAppIDs();
            if (list.size() == 0) continue;
            if (appMenuItemProperties2 instanceof AppMenu) {
                ApplicationUtilities.updateMenuComponent(appMenuItemProperties2, string, bl);
                if (ApplicationUtilities.isMenuContainsMenuItems(appMenuItemProperties2)) continue;
                ((AppMenu)appMenuItemProperties).remove(component);
                continue;
            }
            if (list.contains(string)) continue;
            ((AppMenu)appMenuItemProperties).remove(component);
        }
    }

    public static boolean isMenuContainsMenuItems(AppMenuItemProperties appMenuItemProperties) {
        Component[] componentArray;
        for (Component component : componentArray = ((AppMenu)appMenuItemProperties).getMenuComponents()) {
            if (!(component instanceof AppMenu) && !(component instanceof AppMenuItem) && !(component instanceof AppRadioButtonMenuItem) && !(component instanceof AppCheckboxMenuItem)) continue;
            return true;
        }
        return false;
    }

    public static boolean isComponentsHasMenuItems(List<JComponent> list) {
        for (JComponent jComponent : list) {
            if (!(jComponent instanceof AppMenu) && !(jComponent instanceof AppMenuItem) && !(jComponent instanceof AppRadioButtonMenuItem) && !(jComponent instanceof AppCheckboxMenuItem)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidapp(AppMenuItemProperties appMenuItemProperties, String string) {
        List<String> list = appMenuItemProperties.getVisibleAppIDs();
        if (list.size() != 0) {
            return true == list.contains(string);
        }
        return true;
    }

    public static String replacePopupMenuMnemonic(String string) {
        Locale locale = ResourceMng.getInstance().getLocale();
        if (null != locale && !locale.getLanguage().equalsIgnoreCase("en") && null != string && string.contains("(") && string.contains(")")) {
            return string.replaceAll("\\([a-zA-Z]*\\)", "");
        }
        return string;
    }

    public static void setRightPanel(JPanel jPanel) {
        rightPanel = jPanel;
    }

    public static JPanel getRightPanel() {
        return rightPanel;
    }

    public static List<Plugin> getAllStartupPluginsList() {
        ArrayList<Plugin> arrayList = new ArrayList<Plugin>(10);
        HashSet<String> hashSet = new HashSet<String>(10);
        List<Application> list = ApplicationManager.getInstance().getApplications();
        for (Application object : list) {
            hashSet.addAll(object.getNormalPluginNames());
        }
        List<String> list2 = new ArrayList(hashSet);
        Collections.sort(list2);
        list2 = ApplicationUtilities.getFilteredStartupPlugins(list2);
        for (String string : list2) {
            Plugin plugin = PluginManager.getInstance().getPluginFromFolder(string);
            if (null == plugin) continue;
            arrayList.add(plugin);
        }
        return arrayList;
    }

    public static final String getString(String string) {
        try {
            if (null == string) {
                logger.error("Invalid NULL Key");
                return "";
            }
            return res.getString(string);
        }
        catch (Exception exception) {
            logger.error("Failed to get Resource : " + string + ' ' + exception.getMessage());
            return string;
        }
    }

    public static String[] getExtsFromRequiredLinks() {
        if (null == extsFromRequiredLinks) {
            ApplicationUtilities.populateExtsFromConfigLinks();
        }
        return extsFromRequiredLinks;
    }

    public static String[] getExtsFromPortalLinks() {
        if (null == extsFromPortalLinks) {
            ApplicationUtilities.populateExtsFromConfigLinks();
        }
        return extsFromPortalLinks;
    }

    private static synchronized void populateExtsFromConfigLinks() {
        if (null != extsFromPortalLinks && null != extsFromRequiredLinks) {
            logger.trace("exts already populated");
            return;
        }
        List<String> list = CommStyleManager.getLinkPathOrder();
        if (null == list) {
            extsFromRequiredLinks = new String[0];
            extsFromPortalLinks = new String[0];
            return;
        }
        List<String> list2 = SecondaryStartupXMLReader.getRequiredlinks();
        List<String> list3 = SecondaryStartupXMLReader.getPortallinks();
        ArrayList<String> arrayList = null;
        arrayList = null != list3 ? new ArrayList<String>(list3) : new ArrayList(10);
        HashSet hashSet = new HashSet(16);
        HashSet hashSet2 = new HashSet(16);
        List<Object> list4 = new ArrayList(10);
        if (null != list2) {
            for (String string : list2) {
                if (!list.contains(string) || null == (list4 = LinkUtil.getExts(string))) continue;
                hashSet.addAll(list4);
                if (!arrayList.contains(string)) continue;
                arrayList.remove(string);
                hashSet2.addAll(list4);
            }
        }
        extsFromRequiredLinks = new String[hashSet.size()];
        if (0 != hashSet.size()) {
            hashSet.toArray(extsFromRequiredLinks);
            Arrays.sort(extsFromRequiredLinks);
        }
        if (null != arrayList && arrayList.size() > 0) {
            for (String string : arrayList) {
                if (!list.contains(string) || null == (list4 = LinkUtil.getExts(string))) continue;
                hashSet2.addAll(list4);
            }
        }
        extsFromPortalLinks = new String[hashSet2.size()];
        if (0 != hashSet2.size()) {
            hashSet2.toArray(extsFromPortalLinks);
            Arrays.sort(extsFromPortalLinks);
        }
    }
}

