/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.applicationfavourites.FavouriteUI;
import com.swimap.iview.framework.applicationmanagement.AppPopupMenuManager;
import com.swimap.iview.framework.applicationmanagement.Application;
import com.swimap.iview.framework.applicationmanagement.ApplicationCallBack;
import com.swimap.iview.framework.applicationmanagement.ApplicationLauncher;
import com.swimap.iview.framework.applicationmanagement.ApplicationUtilities;
import com.swimap.iview.framework.applicationmanagement.InvalidApplicationException;
import com.swimap.iview.framework.applicationmanagement.gui.AppRoundButton;
import com.swimap.iview.framework.applicationmanagement.gui.ApplicationPanel;
import com.swimap.iview.framework.applicationmanagement.gui.FloatingAppPanel;
import com.swimap.iview.framework.applicationsearch.SearchPanel;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.framework.toolbarmanagement.ToolbarManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.textfield.TipComponent;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.SystemColor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ApplicationManager {
    static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/applicationmanagement/Res");
    private static IviewLogger logger = IviewLogger.getLogger(ApplicationManager.class);
    private static final int MAX_APPLICATIONS = 24;
    private TipComponent tipComp = null;
    private static ApplicationManager instance = null;
    private List<Application> applications = new ArrayList<Application>();
    private ApplicationPanel applicationPanel = null;
    private HashMap<Integer, String> levelMap = new HashMap();
    private volatile boolean blankFrameFlag = true;
    static HashMap<String, Application> applicationMaps = new HashMap();

    private ApplicationManager() {
        this.initialize();
    }

    public List<Application> getApplications() {
        return new ArrayList<Application>(this.applications);
    }

    private void initialize() {
        String string = System.getProperty("user.dir");
        File file = new File(string + File.separator + "applications");
        if (!file.exists()) {
            logger.debug("Application directory is not exists in client directory");
            return;
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        Application application = null;
        for (File file2 : fileArray) {
            try {
                application = new Application(file2.getName());
                this.applications.add(application);
                applicationMaps.put(application.getId(), application);
            }
            catch (InvalidApplicationException invalidApplicationException) {
                logger.error("Invalid application: ", invalidApplicationException);
            }
        }
        Collections.sort(this.applications, new Comparator<Application>(){

            @Override
            public int compare(Application application, Application application2) {
                int n;
                int n2 = application.getSerialNumber();
                if (n2 == (n = application2.getSerialNumber())) {
                    return 0;
                }
                if (n2 < n) {
                    return -1;
                }
                return 1;
            }
        });
        int n = this.applications.size();
        Application application2 = null;
        while (n > 24) {
            application2 = this.applications.remove(this.applications.size() - 1);
            applicationMaps.remove(application2.getId());
            logger.debug("Max application size reached hence application " + application2.getId() + "is not loaded");
            n = this.applications.size();
        }
    }

    public static synchronized ApplicationManager getInstance() {
        if (null == instance) {
            if (FrameworkCommandProcessor.getInstance().isAppStyle()) {
                logger.info("ApplicationManager init start");
                instance = new ApplicationManager();
                logger.info("ApplicationManager init end");
            } else {
                logger.info("Applicationm Manager instance will not create in traditional style launch");
            }
        }
        return instance;
    }

    private void addDefaultTabs() {
        FloatingAppPanel floatingAppPanel = FloatingAppPanel.getInstance();
        floatingAppPanel.removeTabs();
        FloatingAppPanel.getInstance().setLocation(20, 45);
        ImageIcon imageIcon = (ImageIcon)ResourceMng.getInstance().getIconDirect("portal/favourites.png");
        floatingAppPanel.addTab(res.getString("favorite"), imageIcon, FavouriteUI.getInstance().getFavouriteSplitPanel(new Dimension(1040, 650)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)this.getApplicationPanel(), gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBorder(null);
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.getViewport().add(jPanel);
        HelpManager.getInstance().enableHelpKey(jScrollPane, "topics_portal_t_application");
        ImageIcon imageIcon2 = (ImageIcon)ResourceMng.getInstance().getIconDirect("portal/appcenter.png");
        floatingAppPanel.addTab(res.getString("applications"), imageIcon2, jScrollPane);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setBorder(null);
        jScrollPane2.setOpaque(false);
        jScrollPane2.getViewport().setOpaque(false);
        jScrollPane2.getViewport().add(SearchPanel.getInstance());
        jScrollPane2.getViewport().setBackground(Color.white);
        jScrollPane2.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                JTextField jTextField = SearchPanel.getInstance().getSearchFiled();
                if (jTextField.getText().equals("")) {
                    jTextField.setForeground(SystemColor.textInactiveText);
                    jTextField.setText(res.getString("Searchkey"));
                }
                SearchPanel.getInstance().setFocusOnText();
            }
        });
        ImageIcon imageIcon3 = (ImageIcon)ResourceMng.getInstance().getIconDirect("portal/search.png");
        floatingAppPanel.addTab(res.getString("search"), imageIcon3, jScrollPane2);
        floatingAppPanel.selectTab(0);
    }

    public AppPopupMenuManager getAppPopUpMenuManager(String string) {
        if (!applicationMaps.containsKey(string)) {
            logger.debug("Application with this  " + string + " not exists in application folder");
            return null;
        }
        return applicationMaps.get(string).getPopupMenuManager();
    }

    private void initApplicatinGUI() {
        this.getApplicationPanel().initialize(this.applications);
    }

    public ApplicationPanel getApplicationPanel() {
        if (null == this.applicationPanel) {
            this.applicationPanel = new ApplicationPanel();
        }
        return this.applicationPanel;
    }

    public Application getApplication(String string) {
        if (!applicationMaps.containsKey(string)) {
            logger.debug("Application with this  " + string + " not exists in application folder");
            return null;
        }
        return applicationMaps.get(string);
    }

    public String getActiveAppId() {
        return ApplicationLauncher.getAppLauncher().getVisibleAppId();
    }

    public void clear() {
        FloatingAppPanel.getInstance().setVisible(false);
        AppRoundButton.getInstance().setVisible(false);
        FavouriteUI.getInstance().clear();
        this.applicationPanel.clear();
        for (Application application : applicationMaps.values()) {
            application.clear();
        }
        FrameworkUtilities.setMenuManager(ApplicationUtilities.getBaseMenuManager());
        FrameworkUtilities.setToolbarManager(ApplicationUtilities.getBaseToolbarManager());
        ApplicationUtilities.clearAppModules();
        ApplicationLauncher.getAppLauncher().clearAppInfo();
        ApplicationUtilities.setRightPanel(null);
        this.tipComp = null;
        this.levelMap.clear();
    }

    public void saveState() {
        this.getApplicationPanel().saveState();
        FavouriteUI.getInstance().save();
    }

    public void cleanWhileOSGIExit() {
        applicationMaps.clear();
        this.applications = null;
        instance = null;
        this.levelMap.clear();
    }

    public void launchApplication(String string) throws InvalidApplicationException {
        this.launchApplication(string, false);
    }

    public void launchApplication(String string, boolean bl) throws InvalidApplicationException {
        this.launchApplication(string, bl, null);
    }

    public void launchApplication(String string, boolean bl, ApplicationCallBack applicationCallBack) throws InvalidApplicationException {
        if (!applicationMaps.containsKey(string)) {
            logger.debug("Application is not launched because " + string + " not exists in application folder");
            throw new InvalidApplicationException("application folder not exists");
        }
        ApplicationLauncher.getAppLauncher().launchApplication(string, bl, applicationCallBack);
    }

    public MenuManager getAppMenuManager(String string) {
        if (!applicationMaps.containsKey(string)) {
            logger.debug("Application folder with this " + string + "is Not Exists");
            return null;
        }
        return applicationMaps.get(string).getMenuManager();
    }

    public ToolbarManager getAppToolbarManager(String string) {
        if (!applicationMaps.containsKey(string)) {
            logger.debug("Application folder with this " + string + "is Not Exists");
            return null;
        }
        return applicationMaps.get(string).getToolbarManager();
    }

    public void registerCallBack(String string, ApplicationCallBack applicationCallBack) {
        if (null == applicationCallBack) {
            logger.debug("Call back is null");
            return;
        }
        if (!applicationMaps.containsKey(string)) {
            logger.debug("Application folder with this " + string + "is Not Exists so registering callback to this " + string + "not success");
            return;
        }
        ApplicationManager.getInstance().getApplication(string).addAppCallBackListeners(applicationCallBack);
    }

    public boolean showApplication(final String string) throws InvalidApplicationException {
        logger.debug("Showing the application started for App: " + string);
        if (!applicationMaps.containsKey(string)) {
            logger.debug("Application folder with this " + string + "is not Exists ");
            throw new InvalidApplicationException("Invalid application id");
        }
        if (FrameworkCommandProcessor.getInstance().isApplicationLaunchStopped()) {
            logger.debug("Logout started.. Application - " + string + " cannot be shown");
            return false;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            return ApplicationLauncher.getAppLauncher().showApplication(string);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationLauncher.getAppLauncher().showApplication(string);
            }
        });
        return true;
    }

    public boolean showApplicationNoBlank(final String string) throws InvalidApplicationException {
        if (SwingUtilities.isEventDispatchThread()) {
            ApplicationManager.getInstance().setBlankFrame(false);
            return ApplicationLauncher.getAppLauncher().showApplication(string);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getInstance().setBlankFrame(false);
                ApplicationLauncher.getAppLauncher().showApplication(string);
            }
        });
        ApplicationManager.getInstance().setBlankFrame(true);
        return true;
    }

    public List<String> getAppIds(String string) {
        return ApplicationUtilities.getAppIds(string);
    }

    public boolean getBlankFrame() {
        return this.blankFrameFlag;
    }

    public void setBlankFrame(boolean bl) {
        this.blankFrameFlag = bl;
    }

    public void init() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.validateLicenseForApplications();
            this.addDefaultTabs();
            this.initApplicatinGUI();
            FavouriteUI.getInstance().initPanel();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.this.init();
                }
            });
        }
    }

    private void validateLicenseForApplications() {
        for (Application application : this.applications) {
            application.validateLicense();
        }
    }

    float getAppMenuLevelFont(int n) {
        float f = UIManager.getFont("MenuItem.font").getSize2D();
        try {
            if (null != this.levelMap.get(n)) {
                f = Float.valueOf(this.levelMap.get(n)).floatValue();
            } else {
                DescContainer descContainer;
                CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFromDefaultAndProductStyle("conf/mainfrm/app/portalstyleConfig");
                if (null != commStyleInfo && null != (descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer("AppPopupMenuFontSetting"))) {
                    String string = descContainer.getParasItemValue(n);
                    f = Float.parseFloat(string);
                    this.levelMap.put(n, string);
                }
            }
        }
        catch (Exception exception) {
            logger.trace("Invalid configuration for font size");
        }
        return f;
    }

    Color getAppMenuColor() {
        Color color = new Color(0, 0, 255);
        try {
            String string;
            DescContainer descContainer;
            CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFromDefaultAndProductStyle("conf/mainfrm/app/portalstyleConfig");
            if (null != commStyleInfo && null != (descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer("AppPopupMenuFontSetting")) && (string = descContainer.getParasItemValue("color")) != null) {
                String[] stringArray = string.split(",");
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                int n3 = Integer.parseInt(stringArray[2]);
                color = new Color(n, n2, n3);
            }
        }
        catch (Exception exception) {
            logger.trace("Invalid configuration for font size");
        }
        return color;
    }

    public boolean isApplcationLaunched(String string) {
        return ApplicationLauncher.getAppLauncher().isAppLaunched(string);
    }

    public TipComponent getFavouriteTooltip() {
        if (null == this.tipComp) {
            this.tipComp = new FaviconTooltip();
        }
        return this.tipComp;
    }

    private class FaviconTooltip
    extends TipComponent {
        private Component parent = null;

        private FaviconTooltip() {
        }

        @Override
        public void setInvoker(Component component) {
            if (this.parent != component) {
                super.setInvoker(component);
                if (component instanceof JPopupMenu) {
                    ((JPopupMenu)component).addPopupMenuListener(this.getPopUpMenuListener());
                }
            }
        }

        private PopupMenuListener getPopUpMenuListener() {
            return new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    ((JPopupMenu)popupMenuEvent.getSource()).removePopupMenuListener(this);
                    FaviconTooltip.this.setVisible(false);
                    FaviconTooltip.this.parent = null;
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    ((JPopupMenu)popupMenuEvent.getSource()).removePopupMenuListener(this);
                    FaviconTooltip.this.setVisible(false);
                    FaviconTooltip.this.parent = null;
                }
            };
        }
    }
}

