/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityAction;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityView;
import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.applicationfavourites.FavouriteParser;
import com.swimap.iview.framework.applicationmanagement.Application;
import com.swimap.iview.framework.applicationmanagement.ApplicationCallBack;
import com.swimap.iview.framework.applicationmanagement.ApplicationData;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.applicationmanagement.ApplicationUtilities;
import com.swimap.iview.framework.applicationmanagement.InvalidApplicationException;
import com.swimap.iview.framework.applicationmanagement.StartupCommand;
import com.swimap.iview.framework.applicationmanagement.gui.FloatingAppPanel;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.toolbarmanagement.ToolbarManager;
import com.swimap.iview.framework.util.BackGroundLauncherTask;
import com.swimap.iview.framework.util.BackGroundThread;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import com.swimap.iview.framework.windowmanagement.WindowManager;
import com.swimap.iview.templates.toolbar.Toolbar;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.SyncCommand;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ApplicationLauncher {
    private static final int DEFAULT_LOCK_TIME = 10;
    private static IviewLogger logger = IviewLogger.getLogger(ApplicationLauncher.class);
    private Map<String, ApplicationData> appMap = new ConcurrentHashMap<String, ApplicationData>(10);
    private boolean isSet = false;
    private String activeFrameAppId = null;
    private boolean isEmptyFrameDisposing;
    private String visibleAppId = null;
    private InternalFrame lastActiveFrame = null;
    private static ApplicationLauncher instance = null;
    private static MenuManager baseMenuMng = null;
    private static ToolbarManager baseToolbarMng = null;
    private String current_launch_appId = null;
    final Lock App_Silent_load_Thread_Lock = new ReentrantLock();
    private int lockTime = 10;
    private ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
    private final Object LOCK_OBJECT = new ReentrantLock();
    private ConcurrentHashMap<String, Boolean> mainLaunchingApps = new ConcurrentHashMap(10);

    public static ApplicationLauncher getAppLauncher() {
        if (null == instance) {
            instance = new ApplicationLauncher();
        }
        return instance;
    }

    private ApplicationLauncher() {
        String string = System.getProperty("iview.appLagTime");
        try {
            if (null != string) {
                this.lockTime = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.error(numberFormatException.getMessage(), numberFormatException);
            logger.error("lock time is not valid.");
        }
        logger.debug("iview.appLagTime property value is:" + this.lockTime);
    }

    public void setBaseMenuMgr(MenuManager menuManager) {
        baseMenuMng = menuManager;
    }

    public static MenuManager getBaseMenuManager() {
        return baseMenuMng;
    }

    public static ToolbarManager getBaseToolbarManager() {
        return baseToolbarMng;
    }

    public void setBaseToolBarMgr(ToolbarManager toolbarManager) {
        baseToolbarMng = toolbarManager;
    }

    void populateData(String string, ApplicationData applicationData) {
        if (null != string && null != applicationData) {
            this.appMap.put(string, applicationData);
        }
    }

    public ApplicationData getApplicationData(String string) {
        if (string != null) {
            return this.appMap.get(string);
        }
        return null;
    }

    public void launchApplication(String string) {
        this.launchApplication(string, false);
    }

    public void launchApplication(String string, boolean bl) {
        this.launchApplication(string, bl, null);
    }

    private void addApplicationInvocationEvent(String string, boolean bl, ApplicationCallBack applicationCallBack, boolean bl2, boolean bl3) {
        if (FrameworkCommandProcessor.getInstance().isApplicationLaunchStopped()) {
            logger.error("Logout started.. Application - " + string + " cannot launch");
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            new ApplicationInvocation(string, bl, applicationCallBack, bl2, bl3).dispatch();
        } else {
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new ApplicationInvocation(string, bl, applicationCallBack, bl2, bl3));
        }
    }

    public void launchApplication(String string, boolean bl, ApplicationCallBack applicationCallBack) {
        this.addApplicationInvocationEvent(string, bl, applicationCallBack, false, false);
    }

    public void launchApplication(String string, boolean bl, ApplicationCallBack applicationCallBack, boolean bl2) {
        this.addApplicationInvocationEvent(string, bl, applicationCallBack, false, bl2);
    }

    public synchronized boolean showApplication(String string) {
        if (!this.isAppLaunched(string)) {
            logger.debug("Application with this " + string + "is Not Launched so this application will not be activated");
            return false;
        }
        FloatingAppPanel.getInstance().setVisible(false);
        this.updateMDIFrame(string);
        ApplicationManager.getInstance().getApplication(string).invokeActivationDeactivationCallback(string);
        this.setAPPFrameStatus(string);
        logger.debug("Showing the application finished for App: " + string);
        return true;
    }

    public void invokeStartupCommand(String string) {
        Application application;
        StartupCommand startupCommand;
        logger.debug("invoke startupcommand for applicaiton:" + string + "active appID:" + this.visibleAppId);
        if (!string.equals(this.visibleAppId)) {
            try {
                ApplicationManager.getInstance().showApplication(string);
            }
            catch (InvalidApplicationException invalidApplicationException) {
                logger.debug("Invalid Application exception occcured");
            }
        }
        if (null != (startupCommand = (application = ApplicationManager.getInstance().getApplication(string)).getStartupCommand())) {
            if (!application.getState().equals((Object)Application.ApplicationState.Launched)) {
                return;
            }
            if (StartupCommand.StartupCommandType.COMMAND == startupCommand.getType()) {
                String string2 = startupCommand.getValue();
                boolean bl = this.checkForCommandExecution(string2, string);
                if (!bl) {
                    ApplicationManager.getInstance().setBlankFrame(true);
                    try {
                        ApplicationManager.getInstance().showApplication(string);
                    }
                    catch (InvalidApplicationException invalidApplicationException) {
                        logger.debug("Invalid Application exception occcured while showingBlankFrame");
                    }
                    return;
                }
                CommandManager commandManager = CommandManager.getInstance();
                CommandManager.getInstance().setExceptionFlag(startupCommand.toString(), false);
                commandManager.invoke(startupCommand.getValue());
                boolean bl2 = CommandManager.getInstance().getExceptionFlag(startupCommand.toString());
                if (bl2) {
                    ApplicationManager.getInstance().setBlankFrame(true);
                    try {
                        ApplicationManager.getInstance().showApplication(string);
                    }
                    catch (InvalidApplicationException invalidApplicationException) {
                        logger.debug("Invalid Application exception occcured while showingBlankFrame");
                    }
                    CommandManager.getInstance().setExceptionFlag(startupCommand.toString(), false);
                }
            } else if (StartupCommand.StartupCommandType.ACTION == startupCommand.getType()) {
                startupCommand.invokeStartupCommand();
            } else if (StartupCommand.StartupCommandType.EXECUTABLE == startupCommand.getType()) {
                CommonUtil.executeCommand(startupCommand.getValue(), false);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkForCommandExecution(String string, String string2) {
        try {
            CommandManager commandManager = CommandManager.getInstance();
            AuthorityAction authorityAction = commandManager.getAction(string);
            if (!commandManager.isCommandLicensed(string)) {
                logger.warn("The startup command has not valid license " + string);
                return false;
            }
            if (!commandManager.securityInfoCheck(string)) {
                logger.warn("The startup command has no security rights " + string);
                ApplicationManager.getInstance().setBlankFrame(true);
                return false;
            }
            if (null != authorityAction) {
                boolean bl = authorityAction.isActionVisible();
                boolean bl2 = authorityAction.isActionEnabled();
                if (bl && bl2) return true;
                return false;
            } else {
                boolean bl;
                AuthorityView authorityView = commandManager.getAuthorityViewAction(string);
                if (null == authorityView) return true;
                boolean bl3 = commandManager.securityInfoCheck(string);
                boolean bl4 = bl3 && authorityView.isVisible(string);
                boolean bl5 = bl = bl3 && authorityView.isEnabled(string);
                if (bl4 && bl) return true;
                return false;
            }
        }
        catch (Exception exception) {}
        finally {
            logger.debug("Some Exception StartupCommand checking");
            return false;
        }
    }

    public String getCurrentLaunchAppId() {
        return this.current_launch_appId;
    }

    public String getVisibleAppId() {
        return this.visibleAppId;
    }

    void clearCurrentLaunchAppId() {
        logger.debug("clear the current launch appid" + this.current_launch_appId);
        this.current_launch_appId = null;
    }

    public void updateMDIFrame(String string) {
        Object object;
        logger.debug("Updating the MDIFrame statrted for App: " + string);
        this.visibleAppId = string;
        if (ScreenToolKit.getFullScreenFlg() || FrameworkUtilities.getTerminalManager().isTerminalLocked() && !FrameworkUtilities.getTerminalManager().isMainwindowVisibleOnLock()) {
            return;
        }
        ApplicationData applicationData = this.getApplicationData(string);
        if (null != applicationData) {
            logger.debug("Setting application : " + string + " toolbar and menu bar");
            if (!(applicationData.isAppSuccessProcessExecute() || FrameworkCommandProcessor.getInstance().isLoggingOut() && Main.instance().isCallExit())) {
                FrameworkCommandProcessor.getInstance().loadSuccessProcessProcesAndInvokeStartupcommand(string, false);
            }
            object = applicationData.getMenuManager();
            ((MenuManager)object).addMenu(FavouriteParser.getInstance().getFavMenu());
            this.setMenuManager((MenuManager)object);
            ToolbarManager toolbarManager = applicationData.getToolbarManager();
            this.setToolbarManager(toolbarManager);
            WindowManager windowManager = FrameworkUtilities.getWindowManager();
            windowManager.refreshAppWindowMenus();
            ((Toolbar)toolbarManager.getToolbar()).updateToolbarSafely();
        } else {
            logger.debug("Setting base menu manager & toolbar manager");
            baseMenuMng.addMenu(FavouriteParser.getInstance().getFavMenu());
            int n = baseMenuMng.getMenuBar().getMenuCount();
            this.setMenuManager(baseMenuMng);
            this.setToolbarManager(baseToolbarMng);
            ((Toolbar)baseToolbarMng.getToolbar()).updateToolbarSafely();
        }
        object = (MDIFrame)FrameworkUtilities.getMainFrame();
        if (SwingUtilities.isEventDispatchThread()) {
            ((MDIFrame)object).showToolbar(true);
        } else {
            SwingUtilities.invokeLater(new Runnable((MDIFrame)object){
                final /* synthetic */ MDIFrame val$mainFrame;
                {
                    this.val$mainFrame = mDIFrame;
                }

                @Override
                public void run() {
                    this.val$mainFrame.showToolbar(true);
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable((MDIFrame)object){
            final /* synthetic */ MDIFrame val$mainFrame;
            {
                this.val$mainFrame = mDIFrame;
            }

            @Override
            public void run() {
                try {
                    FrameworkUtilities.getMainFrame().validate();
                }
                catch (Exception exception) {
                    logger.error(exception);
                }
                this.val$mainFrame.updateMenuBarHeight();
            }
        });
        FrameworkUtilities.getWindowManager().setEnableRelativeMenuItem(false, true);
        logger.debug("Updating the MDIFrame finished for App: " + string);
    }

    public void addToolbarPanelForEachApp(ToolbarManager toolbarManager) {
        if (null == toolbarManager) {
            return;
        }
        JPanel jPanel = ApplicationUtilities.getRightPanel();
        if (null != jPanel) {
            toolbarManager.addToolbarPanel(jPanel);
        }
    }

    public void setAPPFrameStatus(String string) {
        InternalFrame internalFrame = FrameworkUtilities.getWindowManager().getActiveAppFrame(string);
        if (null != internalFrame && internalFrame.isSelected()) {
            ApplicationManager.getInstance().setBlankFrame(true);
            return;
        }
        this.setActiveFrameForApp(string);
    }

    private void setActiveFrameForApp(String string) {
        String string2 = this.visibleAppId;
        this.visibleAppId = string;
        InternalFrame internalFrame = FrameworkUtilities.getWindowManager().getActiveAppFrame(string);
        ApplicationData applicationData = null;
        boolean bl = ApplicationManager.getInstance().getBlankFrame();
        logger.debug("Blank frame value set as " + bl + " for app " + this.visibleAppId);
        if (null == internalFrame && bl && null != (applicationData = this.getApplicationData(string)) && null != (internalFrame = applicationData.getWindow())) {
            FrameworkUtilities.getWindowManager().registerWindow(internalFrame);
        }
        if (null != internalFrame && !internalFrame.isSelected() && null == applicationData) {
            FrameworkUtilities.getWindowManager().activateWindow(internalFrame.getWindowId());
        } else {
            this.setLastActiveFrame(internalFrame);
        }
        this.visibleAppId = string2;
        ApplicationManager.getInstance().setBlankFrame(true);
    }

    public void setLastActiveFrame(InternalFrame internalFrame) {
        this.lastActiveFrame = internalFrame;
    }

    public InternalFrame getLastActiveInternalFrame() {
        return this.lastActiveFrame;
    }

    public boolean isLastActiveFrameset() {
        return this.isSet;
    }

    public void setLastActiveFrameset(boolean bl) {
        this.isSet = bl;
    }

    private void setMenuManager(MenuManager menuManager) {
        MDIFrame mDIFrame = (MDIFrame)FrameworkUtilities.getMainFrame();
        if (FrameworkUtilities.getMenuManager() != menuManager) {
            FrameworkUtilities.setMenuManager(menuManager);
        }
        if (mDIFrame.getMenuManager() != menuManager) {
            mDIFrame.setMenuManager(menuManager);
        }
    }

    private void setToolbarManager(ToolbarManager toolbarManager) {
        MDIFrame mDIFrame = (MDIFrame)FrameworkUtilities.getMainFrame();
        if (FrameworkUtilities.getToolbarManager() != toolbarManager) {
            FrameworkUtilities.setToolbarManager(toolbarManager);
        }
        if (mDIFrame.getToolbarManager() != toolbarManager) {
            mDIFrame.setToolbarManager(toolbarManager);
        }
        this.addToolbarPanelForEachApp(toolbarManager);
    }

    public void setActiveFrameAppId(String string) {
        this.activeFrameAppId = string;
    }

    public String getActiveFrameAppId() {
        return this.activeFrameAppId;
    }

    public void setIsAppEmptyFrameDisposing(boolean bl) {
        this.isEmptyFrameDisposing = bl;
    }

    public boolean isAppEmptyFrameDisposing() {
        return this.isEmptyFrameDisposing;
    }

    public void clearAppInfo() {
        if (null != this.appMap && !this.appMap.isEmpty()) {
            Set<String> set = this.appMap.keySet();
            for (String string : set) {
                this.appMap.get(string).clear();
            }
            this.appMap.clear();
        }
        this.current_launch_appId = null;
        this.visibleAppId = null;
    }

    public void removeAppDataFromMap(String string) {
        if (null != this.appMap) {
            this.appMap.remove(string);
            logger.debug("appId " + string + "has unloaded from launcher");
        }
    }

    public void cleanWhileOSGIExit() {
        this.clearAppInfo();
        baseMenuMng = null;
        baseToolbarMng = null;
        this.executor = null;
        this.appMap.clear();
        instance = null;
    }

    private void launchApplicationProcess(final String string, boolean bl, ApplicationCallBack applicationCallBack, final boolean bl2) {
        logger.debug("Launching application has started " + string + " oldAppId" + this.current_launch_appId + "isSilentlaunch" + bl);
        final String string2 = this.current_launch_appId;
        if (null == baseMenuMng) {
            baseMenuMng = FrameworkUtilities.getMenuManager();
        }
        if (null == baseToolbarMng) {
            baseToolbarMng = FrameworkUtilities.getToolbarManager();
        }
        Application application = ApplicationManager.getInstance().getApplication(string);
        ApplicationData applicationData = this.getApplicationData(string);
        if (null == applicationData) {
            if (bl) {
                FloatingAppPanel.getInstance().setVisible(false);
            }
            applicationData = new ApplicationData(string, bl, applicationCallBack);
        }
        final ApplicationData applicationData2 = applicationData;
        Application application2 = ApplicationManager.getInstance().getApplication(string);
        if (application2.getState() == Application.ApplicationState.PreInit) {
            this.populateData(string, applicationData2);
            applicationData2.launchAppProcess(applicationCallBack);
            application.setState(Application.ApplicationState.Starting);
        }
        if (!bl) {
            SyncCommand syncCommand = new SyncCommand(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object call() throws Exception {
                    boolean bl = false;
                    try {
                        bl = applicationData2.getLock().tryLock(ApplicationLauncher.this.lockTime, TimeUnit.SECONDS);
                        if (!bl) {
                            Object var2_2 = null;
                            return var2_2;
                        }
                        logger.debug("current launch AppId has set to " + string);
                        ApplicationLauncher.this.current_launch_appId = string;
                        logger.debug("Launching the load Modules thread has started" + string);
                        ApplicationManager.getInstance().getAppMenuManager(string);
                        ApplicationManager.getInstance().getAppToolbarManager(string);
                        applicationData2.loadSilentAppModulesThread();
                        logger.debug("Silent launch: resetting the current app id to : " + string2);
                        ApplicationLauncher.this.current_launch_appId = string2;
                    }
                    finally {
                        if (bl) {
                            logger.debug("unlock the  load Modules thread " + string);
                            applicationData2.getLock().unlock();
                        }
                    }
                    return null;
                }
            };
            if (BackGroundLauncherTask.getInstance().getBackGroundThread() != null && BackGroundLauncherTask.getInstance().getBackGroundThread().isAlive()) {
                syncCommand.startCall(null, false);
            } else {
                syncCommand.startCall(null, true);
            }
            if (application2.getState() == Application.ApplicationState.Starting) {
                application2.setState(Application.ApplicationState.Launched);
                ApplicationData applicationData3 = this.getApplicationData(string);
                if (null != applicationData3) {
                    ApplicationManager.getInstance().getApplication(string).notifyApplicationLaunched(string);
                } else {
                    logger.debug("application " + string + " has failed, so no need to execute the callbacks");
                }
            }
            if (this.visibleAppId != null) {
                ApplicationManager.getInstance().getAppToolbarManager(this.visibleAppId).updateToolbars();
            } else {
                ((Toolbar)baseToolbarMng.getToolbar()).updateToolbarSafely();
            }
        } else if (!application.isShowApplication()) {
            FloatingAppPanel.getInstance().setVisible(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    logger.debug("current launch AppId has set to " + string);
                    ApplicationLauncher.this.current_launch_appId = string;
                    applicationData2.setLaunchGUI(true);
                    ApplicationManager.getInstance().getAppMenuManager(string);
                    ApplicationManager.getInstance().getAppToolbarManager(string);
                    applicationData2.startLoadModulesThread(string, bl2);
                    ApplicationLauncher.this.current_launch_appId = string2;
                }
            });
            FrameworkCommandProcessor.getInstance().showProgressForApplication(true);
            applicationData2.setLaunchGUI(false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        FrameworkUtilities.getMainFrame().validate();
                    }
                    catch (Exception exception) {
                        logger.error(exception);
                    }
                    ((MDIFrame)FrameworkUtilities.getMainFrame()).updateMenuBarHeight();
                }
            });
            FloatingAppPanel.getInstance().setVisible(false);
            this.visibleAppId = string;
            this.current_launch_appId = string;
            logger.debug("current launch AppId has set to " + string);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    applicationData2.setLaunchGUI(true);
                    applicationData2.startLoadModulesThread(string, bl2);
                }
            });
            FrameworkCommandProcessor.getInstance().showProgressForApplication(true);
            applicationData2.setLaunchGUI(false);
        }
        logger.debug("application launching has completed" + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchApplicaitonBackGround(final String string, boolean bl, ApplicationCallBack applicationCallBack) {
        Object object;
        Object object2;
        logger.debug("launching applicaiton in background started:" + string);
        try {
            object2 = this.current_launch_appId;
            if (null == baseMenuMng) {
                baseMenuMng = FrameworkUtilities.getMenuManager();
            }
            if (null == baseToolbarMng) {
                baseToolbarMng = FrameworkUtilities.getToolbarManager();
            }
            if (null == (object = this.getApplicationData(string))) {
                object = new ApplicationData(string, bl, applicationCallBack);
            }
            final ApplicationData applicationData = object;
            Application application = ApplicationManager.getInstance().getApplication(string);
            if (application.getState() == Application.ApplicationState.PreInit) {
                application.setState(Application.ApplicationState.Starting);
                this.populateData(string, applicationData);
                applicationData.launchAppProcess(applicationCallBack);
            }
            this.current_launch_appId = string;
            logger.debug("current launch AppId has set to " + string);
            SyncCommand syncCommand = new SyncCommand(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object call() throws Exception {
                    boolean bl = false;
                    try {
                        bl = applicationData.getLock().tryLock(ApplicationLauncher.this.lockTime, TimeUnit.SECONDS);
                        if (!bl) {
                            Object var2_2 = null;
                            return var2_2;
                        }
                        logger.debug("Launching the load Modules thread has started" + string);
                        ApplicationManager.getInstance().getAppMenuManager(string);
                        ApplicationManager.getInstance().getAppToolbarManager(string);
                        applicationData.loadSilentAppModulesBackGroundThread();
                    }
                    finally {
                        if (bl) {
                            applicationData.getLock().unlock();
                        }
                    }
                    return null;
                }
            };
            syncCommand.startCall(null, false);
            this.current_launch_appId = object2;
            logger.debug("Silent launch: resetting the current app id to : " + (String)object2);
            if (application.getState() == Application.ApplicationState.Starting) {
                ApplicationData applicationData2 = this.getApplicationData(string);
                if (null != applicationData2) {
                    ApplicationManager.getInstance().getApplication(string).notifyApplicationLaunched(string);
                    application.setState(Application.ApplicationState.Launched);
                } else {
                    logger.debug("application " + string + " has failed, so no need to execute the callbacks");
                }
            }
            if (this.visibleAppId != null) {
                ApplicationManager.getInstance().getAppToolbarManager(this.visibleAppId).updateToolbars();
            } else {
                ((Toolbar)baseToolbarMng.getToolbar()).updateToolbarSafely();
            }
        }
        finally {
            object2 = BackGroundLauncherTask.getInstance().getBackGroundThread();
            if (null != object2) {
                object = object2;
                synchronized (object) {
                    object2.notifyAll();
                }
            }
        }
    }

    private boolean isLaunchingApp() {
        Set set = this.mainLaunchingApps.keySet();
        for (String string : set) {
            if (!this.mainLaunchingApps.get(string).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Object getBackLaunchLock() {
        return this.LOCK_OBJECT;
    }

    public boolean isAppLaunched(String string) {
        if (null == string) {
            return false;
        }
        return this.appMap.containsKey(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchApplicationInBackGround(String string) {
        if (BackGroundLauncherTask.getInstance().getBackGroundThread().isRequestStop()) {
            return;
        }
        logger.debug("launchApplication BackGround Started..." + string);
        if (SwingUtilities.isEventDispatchThread()) {
            Main.instance().getModuleManager().setBackGroundAppIsFailed(false);
            this.addApplicationInvocationEvent(string, false, null, true, false);
        } else {
            if (BackGroundLauncherTask.getInstance().getBackGroundThread().isRequestStop()) {
                return;
            }
            Main.instance().getModuleManager().setBackGroundAppIsFailed(false);
            this.addApplicationInvocationEvent(string, false, null, true, false);
            try {
                BackGroundThread backGroundThread = BackGroundLauncherTask.getInstance().getBackGroundThread();
                synchronized (backGroundThread) {
                    BackGroundLauncherTask.getInstance().getBackGroundThread().wait();
                }
            }
            catch (InterruptedException interruptedException) {
                logger.debug("Interrupted exception occured");
            }
        }
        logger.debug("launchApplication BackGround complted..." + string);
    }

    private class ApplicationInvocation
    extends InvocationEvent {
        public ApplicationInvocation(final String string, final boolean bl, final ApplicationCallBack applicationCallBack, final boolean bl2, final boolean bl3) {
            super((Object)Toolkit.getDefaultToolkit(), new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block20: {
                        try {
                            Object object;
                            Application application;
                            if (bl3) {
                                boolean bl4 = true;
                                application = ApplicationManager.getInstance().getApplication(string);
                                object = application.getStartupCommand();
                                if (null != object) {
                                    bl4 = ((StartupCommand)object).isBlankFrame();
                                    ApplicationManager.getInstance().setBlankFrame(bl4);
                                }
                            }
                            if (Thread.interrupted()) {
                                logger.error("EDT Thread is interrupted, application invocation event not processed.");
                                return;
                            }
                            if (ModuleManager.getAfterLoadThread() == null) {
                                logger.debug("Not started initial module loading of startup.xml files");
                                return;
                            }
                            ApplicationData applicationData = ApplicationLauncher.this.getApplicationData(string);
                            application = ApplicationManager.getInstance().getApplication(string);
                            if (application.getState() != Application.ApplicationState.Launched) {
                                if (bl2) {
                                    boolean bl5 = ApplicationLauncher.this.isLaunchingApp();
                                    if (bl5) {
                                        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new ApplicationInvocation(string, bl, applicationCallBack, bl2, bl3));
                                    } else {
                                        logger.debug("started launching the applicaiton in background" + string);
                                        ApplicationLauncher.this.launchApplicaitonBackGround(string, bl, applicationCallBack);
                                    }
                                    break block20;
                                }
                                ApplicationLauncher.this.mainLaunchingApps.put(string, true);
                                try {
                                    logger.debug("started launching the applicaiton" + string + "silent:" + !bl);
                                    ApplicationLauncher.this.launchApplicationProcess(string, bl, applicationCallBack, bl3);
                                    break block20;
                                }
                                finally {
                                    ApplicationLauncher.this.mainLaunchingApps.put(string, false);
                                }
                            }
                            if (bl) {
                                try {
                                    ApplicationManager.getInstance().showApplication(string);
                                }
                                catch (InvalidApplicationException invalidApplicationException) {
                                    logger.error("trying to launch invalid application");
                                }
                                if (bl3) {
                                    ApplicationLauncher.this.invokeStartupCommand(string);
                                }
                                break block20;
                            }
                            if (!bl2 || bl) break block20;
                            object = BackGroundLauncherTask.getInstance().getBackGroundThread();
                            synchronized (object) {
                                BackGroundLauncherTask.getInstance().getBackGroundThread().notifyAll();
                            }
                        }
                        catch (Exception exception) {
                            logger.error("Exception in launching Application " + string, exception);
                            logger.error("While launching the application, exception occured");
                        }
                    }
                }
            });
        }

        @Override
        public String paramString() {
            return "iview_Application_Event";
        }
    }
}

