/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.framework.applicationmanagement.ApplicationStartupElement;
import com.swimap.iview.framework.applicationmanagement.StartupCommand;
import com.swimap.iview.framework.subsystemmanagement.SubsystemManager;
import com.swimap.iview.framework.util.IStartupElement;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ApplicationInfo {
    private static final String STARTUP_ELEMENT_LIST = "startupElementList";
    private static final String PLUGINS = "plugins";
    private static final String PRODUCT_LIBS = "productlibs";
    private static final String FEATURES = "features";
    private static final String STARTUP_COMMANDS = "startupcommands";
    private static final String COMMAND = "command";
    private static final String ACTION = "action";
    private static final String EXECUTABLE = "executable";
    private static final String APPLICATION_CALL_BACKS = "ApplicationCallBacks";
    private static final String APPLICATION_LICENSE = "License";
    private static final String PARAM_LICENSE = "license";
    private StartupCommand startupCommand = null;
    private List<String> appCallBackList = new ArrayList<String>(2);
    private Set<IStartupElement> startupElementsSet = new LinkedHashSet<IStartupElement>();
    private Set<IStartupElement> requiredPluginSet = new LinkedHashSet<IStartupElement>();
    private String licenseKeys = null;

    public ApplicationInfo(File file) {
        Object object;
        Object object2;
        File file2 = new File(file, "application.xml");
        if (file2.exists() && null != (object2 = CommStyleManager.getInstance().getCommonStyleFileByPath(file2.getParent() + "/application")) && null != (object = ((CommStyleInfo)object2).getAreaDescContainer(0))) {
            this.readStartupCommandsDescContainer((AreaDescContainer)object);
            this.readStartupCallbacksDescContainer((AreaDescContainer)object);
            DescContainer descContainer = ((AreaDescContainer)object).getDescContainer(STARTUP_ELEMENT_LIST);
            this.storeStartupElements(descContainer);
            this.readLicenseDesc((AreaDescContainer)object);
        }
        for (File file3 : object2 = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith("_application.xml");
            }
        })) {
            this.storeStartupElements(file3);
        }
    }

    private void readLicenseDesc(AreaDescContainer areaDescContainer) {
        DescContainer descContainer = areaDescContainer.getDescContainer(APPLICATION_LICENSE);
        if (null != descContainer) {
            this.populateLicense(descContainer);
        }
    }

    public ApplicationInfo() {
    }

    public StartupCommand getStartupCommand() {
        return this.startupCommand;
    }

    public List<String> getAppCallBackList() {
        return this.appCallBackList;
    }

    public List<IStartupElement> getStartupElements() {
        ArrayList<IStartupElement> arrayList = new ArrayList<IStartupElement>();
        arrayList.addAll(this.startupElementsSet);
        return arrayList;
    }

    public List<IStartupElement> getRequiredPlugins() {
        ArrayList<IStartupElement> arrayList = new ArrayList<IStartupElement>();
        arrayList.addAll(this.requiredPluginSet);
        return arrayList;
    }

    private void storeStartupElements(File file) {
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFileByPath(file.getParent() + '/' + file.getName().substring(0, file.getName().lastIndexOf(".xml")));
        if (null == commStyleInfo) {
            return;
        }
        AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer(0);
        if (null == areaDescContainer) {
            return;
        }
        if (null == this.startupCommand) {
            this.readStartupCommandsDescContainer(areaDescContainer);
        }
        this.readStartupCallbacksDescContainer(areaDescContainer);
        DescContainer descContainer = areaDescContainer.getDescContainer(STARTUP_ELEMENT_LIST);
        this.storeStartupElements(descContainer);
        this.readLicenseDesc(areaDescContainer);
    }

    private void readStartupCommandsDescContainer(AreaDescContainer areaDescContainer) {
        DescContainer descContainer = areaDescContainer.getDescContainer(STARTUP_COMMANDS);
        if (null != descContainer) {
            this.populateStartupCommands(descContainer);
        }
    }

    private void readStartupCallbacksDescContainer(AreaDescContainer areaDescContainer) {
        DescContainer descContainer = areaDescContainer.getDescContainer(APPLICATION_CALL_BACKS);
        if (null != descContainer) {
            this.populateAppCallBackListeners(descContainer);
        }
    }

    private void storeStartupElements(DescContainer descContainer) {
        DescContainer descContainer2;
        int n;
        Object object;
        ArrayList<ApplicationStartupElement> arrayList = new ArrayList<ApplicationStartupElement>();
        DescContainer descContainer3 = descContainer.getDescContainer(PLUGINS);
        if (null != descContainer3) {
            int n2 = descContainer3.getParasItemCount();
            object = null;
            for (n = 0; n < n2; ++n) {
                object = descContainer3.getParasItem(n).getName();
                arrayList.add(new ApplicationStartupElement((String)object, 1));
            }
        }
        if (null != (descContainer2 = descContainer.getDescContainer(PRODUCT_LIBS))) {
            int n3 = descContainer2.getParasItemCount();
            String string = null;
            for (int i = 0; i < n3; ++i) {
                string = descContainer2.getParasItem(i).getName();
                arrayList.add(new ApplicationStartupElement(string, 3));
            }
        }
        if (null != (object = descContainer.getDescContainer(FEATURES))) {
            n = ((DescContainer)object).getParasItemCount();
            String string = null;
            for (int i = 0; i < n; ++i) {
                string = ((DescContainer)object).getParasItem(i).getName();
                arrayList.add(new ApplicationStartupElement(string, 2));
                this.populatePluginsFromFeature(string);
            }
        }
        this.startupElementsSet.addAll(arrayList);
    }

    private void populatePluginsFromFeature(String string) {
        List<String> list = SubsystemManager.getInstance().getLoadedSubsystemPluginList(string);
        for (String object2 : list) {
            this.startupElementsSet.add(new ApplicationStartupElement(object2, 1));
        }
        List<String> list2 = SubsystemManager.getInstance().getLoadedSubsystemRequiredPluginList(string);
        Object var4_5 = null;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            ApplicationStartupElement applicationStartupElement = new ApplicationStartupElement(string2, 1);
            if (this.startupElementsSet.contains(applicationStartupElement)) continue;
            this.requiredPluginSet.add(applicationStartupElement);
        }
    }

    private void populateAppCallBackListeners(DescContainer descContainer) {
        int n = descContainer.getParasItemCount();
        PARA pARA = null;
        String string = null;
        for (int i = 0; i < n; ++i) {
            pARA = descContainer.getParasItem(i);
            string = pARA.getName();
            if (null == string || this.appCallBackList.contains(string.trim())) continue;
            this.appCallBackList.add(string.trim());
        }
    }

    private void populateStartupCommands(DescContainer descContainer) {
        String string;
        PARA pARA = descContainer.getParasItem(COMMAND);
        PARA pARA2 = descContainer.getParasItem(ACTION);
        PARA pARA3 = descContainer.getParasItem(EXECUTABLE);
        PARA pARA4 = descContainer.getParasItem("showBlankInternalFrame");
        boolean bl = true;
        if (null != pARA4 && (string = pARA4.getValue()).equalsIgnoreCase("false")) {
            bl = false;
        }
        if (null != pARA) {
            this.startupCommand = new StartupCommand(StartupCommand.StartupCommandType.COMMAND, pARA.getValue(), bl);
            return;
        }
        if (null != pARA2) {
            this.startupCommand = new StartupCommand(StartupCommand.StartupCommandType.ACTION, pARA2.getValue(), bl);
            return;
        }
        if (null != pARA3) {
            this.startupCommand = new StartupCommand(StartupCommand.StartupCommandType.EXECUTABLE, pARA3.getValue(), bl);
        }
    }

    private void populateLicense(DescContainer descContainer) {
        String string = descContainer.getParasItemValue(PARAM_LICENSE);
        if (null != string) {
            this.licenseKeys = null == this.licenseKeys ? string : this.licenseKeys + ',' + string;
        }
    }

    public String getLicenseKeys() {
        return this.licenseKeys;
    }
}

