/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement;

import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.applicationmanagement.AppMenuManager;
import com.swimap.iview.framework.applicationmanagement.AppToolbarManager;
import com.swimap.iview.framework.applicationmanagement.Application;
import com.swimap.iview.framework.applicationmanagement.ApplicationCallBack;
import com.swimap.iview.framework.applicationmanagement.ApplicationLauncher;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.applicationmanagement.gui.FloatingAppPanel;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.framework.modulemanagement.ModuleList;
import com.swimap.iview.framework.statusbarmanagement.StatusBarManager;
import com.swimap.iview.framework.terminalmanagement.MultilineLabel;
import com.swimap.iview.framework.toolbarmanagement.ToolbarManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import com.swimap.iview.framework.windowmanagement.MainDesktopPane;
import com.swimap.iview.util.adapter.FrameworkHelper;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ApplicationData {
    private static IviewLogger logger = IviewLogger.getLogger(ApplicationData.class, "IVIEW");
    private String appId = null;
    private ApplicationCallBack callBack = null;
    private InternalFrame window = null;
    private Thread loadThread = null;
    private Lock appLaunchLock = new ReentrantLock();
    private boolean isCommandConfigured;
    private boolean isAppSuccessProcessExecute = false;
    private volatile boolean isLaunchGUI = false;

    public boolean isLaunchGUI() {
        return this.isLaunchGUI;
    }

    public void setLaunchGUI(boolean bl) {
        this.isLaunchGUI = bl;
    }

    public Lock getLock() {
        return this.appLaunchLock;
    }

    public boolean isAppSuccessProcessExecute() {
        return this.isAppSuccessProcessExecute;
    }

    public void setAppSuccessProcessExecute(boolean bl) {
        this.isAppSuccessProcessExecute = bl;
    }

    public ApplicationData(String string) {
        this(string, false, null);
    }

    public ApplicationData(String string, boolean bl, ApplicationCallBack applicationCallBack) {
        this.appId = string;
        this.callBack = applicationCallBack;
        this.isCommandConfigured = bl;
        if (this.isCommandConfigured) {
            this.activateMenuManager();
            this.activateToolbarMng();
        }
    }

    public ApplicationData(String string, boolean bl) {
        this(string, bl, null);
    }

    private void activateMenuManager() {
        Application application = ApplicationManager.getInstance().getApplication(this.appId);
        if (this.isCommandConfigured && application.isShowApplication()) {
            AppMenuManager appMenuManager = application.getMenuManager();
            FrameworkUtilities.setMenuManager(appMenuManager);
            ((MDIFrame)FrameworkUtilities.getMainFrame()).setMenuManager(appMenuManager);
        }
    }

    public void launchAppProcess(ApplicationCallBack applicationCallBack) {
        Application application = ApplicationManager.getInstance().getApplication(this.appId);
        MDIFrame mDIFrame = (MDIFrame)FrameworkUtilities.getMainFrame();
        StatusBarManager statusBarManager = mDIFrame.getStatusBarManager();
        if (null != statusBarManager) {
            statusBarManager.loadPostLoginStatusBarFromPlugin(this.appId);
        }
        this.loadCommands();
        this.createAppInternalFrame();
        application.notifyApplicationStarting(this.appId, applicationCallBack);
    }

    public void loadExtModules(ModuleList moduleList) {
        String[] stringArray = ApplicationManager.getInstance().getApplication(this.appId).getExtsFromLinks();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                moduleList.loadAppExtModuleList("conf/" + stringArray[i] + "/modulelist", stringArray[i], this.appId);
            }
        }
    }

    public String getAppId() {
        return this.appId;
    }

    private void loadCommands() {
    }

    public MenuManager getMenuManager() {
        return ApplicationManager.getInstance().getApplication(this.appId).getMenuManager();
    }

    public ToolbarManager getToolbarManager() {
        return ApplicationManager.getInstance().getApplication(this.appId).getToolbarManager();
    }

    private void activateToolbarMng() {
        Application application = ApplicationManager.getInstance().getApplication(this.appId);
        if (this.isCommandConfigured && application.isShowApplication()) {
            AppToolbarManager appToolbarManager = application.getToolbarManager();
            MDIFrame mDIFrame = (MDIFrame)FrameworkUtilities.getMainFrame();
            FrameworkUtilities.setToolbarManager(appToolbarManager);
            mDIFrame.setToolbarManager(appToolbarManager);
        }
    }

    public ApplicationCallBack getCallBack() {
        return this.callBack;
    }

    private void createAppInternalFrame() {
        InternalFrame internalFrame = new InternalFrame(this.appId){

            @Override
            public void dispose() {
                super.dispose();
                this.setCursor(Cursor.getDefaultCursor());
                ApplicationData.this.window = null;
            }

            @Override
            protected void closeFullScreen() {
                if (!ApplicationLauncher.getAppLauncher().isAppEmptyFrameDisposing()) {
                    super.closeFullScreen();
                }
            }
        };
        Application application = ApplicationManager.getInstance().getApplication(this.appId);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setSize(800, 800);
        MultilineLabel multilineLabel = new MultilineLabel();
        if (null != application) {
            multilineLabel.setText(application.getBlankName());
        } else {
            multilineLabel.setText("");
        }
        multilineLabel.setFont(multilineLabel.getFont().deriveFont(1, 26.0f));
        MultilineLabel multilineLabel2 = new MultilineLabel();
        if (null != application) {
            multilineLabel2.setText(application.getBlankDesc());
        } else {
            multilineLabel2.setText("");
        }
        multilineLabel2.setFont(multilineLabel2.getFont().deriveFont(0, 16.0f));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(22, 38, 0, 0);
        jPanel.add((Component)multilineLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(17, 38, 0, 0);
        gridBagConstraints.gridheight = 10;
        jPanel.add((Component)multilineLabel2, gridBagConstraints);
        internalFrame.add(jPanel);
        internalFrame.setName("empty internal frame");
        if (null != application) {
            internalFrame.setTitle(application.getName());
            String string = application.getDefaultHelpKey();
            if (null != string) {
                HelpManager.getInstance().enableHelpKey(internalFrame, string);
            }
        } else {
            internalFrame.setTitle("");
        }
        this.window = internalFrame;
    }

    public InternalFrame getWindow() {
        if (this.window == null) {
            this.createAppInternalFrame();
        }
        return this.window;
    }

    void loadSilentAppModulesThread() {
        if (Main.instance().getModuleManager().loadApplicationModules(this.appId)) {
            logger.debug("Loading Application Modules are completed");
        } else {
            this.loadSilentAppFailProcess();
        }
    }

    void loadSilentAppModulesBackGroundThread() {
        Main.instance().getModuleManager().loadApplicationModulesInBackGroundThread(this.appId);
        if (!Main.instance().getModuleManager().isBackGroundAppIsFailed()) {
            logger.debug("Loading Application Modules are completed");
        } else {
            Application application = ApplicationManager.getInstance().getApplication(this.appId);
            application.setState(Application.ApplicationState.PreInit);
            ApplicationLauncher.getAppLauncher().removeAppDataFromMap(this.appId);
            logger.debug("Loading modules are failed:");
        }
    }

    void startLoadModulesThread(final String string, final boolean bl) {
        this.loadThread = new Thread("loadThread_" + string){

            @Override
            public void run() {
                if (Main.instance().getModuleManager().loadApplicationModules(string)) {
                    logger.debug("Loading Application Modules are completed" + string);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            logger.debug("Application launching success,so perform GUI operations");
                            Application application = ApplicationManager.getInstance().getApplication(string);
                            if (application.getState() == Application.ApplicationState.Starting) {
                                application.setState(Application.ApplicationState.Launched);
                                ApplicationManager.getInstance().getApplication(string).notifyApplicationLaunched(string);
                            }
                            if (application.isShowApplication()) {
                                ApplicationLauncher.getAppLauncher().setAPPFrameStatus(string);
                            }
                            ApplicationManager.getInstance().getApplication(string).invokeActivationDeactivationCallback(string);
                        }
                    });
                    FrameworkCommandProcessor.getInstance().loadSuccessProcessProcesAndInvokeStartupcommand(string, bl);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((MDIFrame)FrameworkUtilities.getMainFrame()).updateMenuBarHeight();
                        }
                    });
                } else {
                    ApplicationData.this.loadFailProcess();
                }
            }
        };
        this.loadThread.start();
    }

    public void loadSilentAppFailProcess() {
        if (FrameworkHelper.isOSGIClient() && null == Main.instance()) {
            logger.debug("client exit has called");
            return;
        }
        ApplicationLauncher.getAppLauncher().removeAppDataFromMap(this.appId);
        FloatingAppPanel.getInstance().setVisible(false);
        FrameworkUtilities.getMainFrame().getGlassPane().setVisible(false);
        Main.instance().getModuleManager().setHasCrashedApp(false);
        ApplicationManager.getInstance().getApplication(this.appId).setState(Application.ApplicationState.PreInit);
        logger.debug("Launching Application " + this.appId + " failed.");
    }

    public void loadFailProcess() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FrameworkCommandProcessor.getInstance().loadProgressDialog != null) {
                    FrameworkCommandProcessor.getInstance().loadProgressDialog.dispose();
                    FrameworkCommandProcessor.getInstance().loadProgressDialog = null;
                    logger.trace("Progress dialog disposed due to load fail.");
                }
                if (FrameworkHelper.isOSGIClient() && null == Main.instance()) {
                    logger.debug("client exit has called");
                    return;
                }
                ApplicationLauncher.getAppLauncher().removeAppDataFromMap(ApplicationData.this.appId);
                Application application = ApplicationManager.getInstance().getApplication(ApplicationData.this.appId);
                application.setState(Application.ApplicationState.PreInit);
                FloatingAppPanel.getInstance().setVisible(true);
                MainDesktopPane mainDesktopPane = FrameworkUtilities.getWindowManager().getDesktopPane();
                JInternalFrame jInternalFrame = mainDesktopPane.getSelectedFrame();
                if (jInternalFrame instanceof InternalFrame) {
                    InternalFrame internalFrame = (InternalFrame)jInternalFrame;
                    ApplicationLauncher.getAppLauncher().updateMDIFrame(internalFrame.getAppID());
                } else {
                    ApplicationLauncher.getAppLauncher().updateMDIFrame(null);
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrameworkUtilities.getMainFrame().getGlassPane().setVisible(false);
                Main.instance().getModuleManager().setHasCrashedApp(false);
            }
        });
        logger.debug("Launching Application " + this.appId + " failed.");
    }

    public void clear() {
        ApplicationManager.getInstance().getApplication(this.appId).clear();
    }

    public boolean isCommandConfigured() {
        return this.isCommandConfigured;
    }
}

