/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.framework.applicationmanagement.InvalidDescException;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class ApplicationBaseInfo {
    private static IviewLogger logger = IviewLogger.getLogger(ApplicationBaseInfo.class, "IVIEW");
    private static final String APPLICATION_INFO = "applicationInfo";
    private static final String BLANK_PAGE_INFO = "blankPageInfo";
    private static final String ID = "id";
    private static final String SERIAL_NUMBER = "serialnumber";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String ICON = "icon";
    private static final String BLANK_NAME = "name";
    private static final String BLANK_PAGE_DESCRIPTION = "description";
    private static final String HELP_ID = "helpid";
    private String appId = null;
    private Integer serialNumber = Integer.MAX_VALUE;
    private String name = null;
    private String description = null;
    private String iconPath = null;
    private String blankName = "";
    private String blankDesc = "";
    private String blankHelpId = "";
    private ResourceBundle resBundle = null;

    String getAppId() {
        return this.appId;
    }

    int getSerialNumber() {
        return this.serialNumber;
    }

    String getName() {
        return this.name;
    }

    String getDescription() {
        return this.description;
    }

    String getIconPath() {
        return this.iconPath;
    }

    String getblankName() {
        return this.blankName;
    }

    String getblankDesc() {
        return this.blankDesc;
    }

    String getblankHelpId() {
        return this.blankHelpId;
    }

    ApplicationBaseInfo(File file) throws InvalidDescException {
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFileByPath(file.getParent() + "/application_base");
        if (null == commStyleInfo) {
            throw new InvalidDescException("No info in the file");
        }
        AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer(0);
        if (null == areaDescContainer) {
            throw new InvalidDescException("No AreaDescContainer");
        }
        DescContainer descContainer = areaDescContainer.getDescContainer(APPLICATION_INFO);
        DescContainer descContainer2 = areaDescContainer.getDescContainer(BLANK_PAGE_INFO);
        if (null == descContainer) {
            throw new InvalidDescException("No DescContainer defined");
        }
        PARA pARA = descContainer.getParasItem(ID);
        PARA pARA2 = descContainer.getParasItem(SERIAL_NUMBER);
        PARA pARA3 = descContainer.getParasItem("name");
        PARA pARA4 = descContainer.getParasItem("description");
        PARA pARA5 = descContainer.getParasItem(ICON);
        this.checkForNull(pARA, pARA2, pARA3, pARA4, pARA5);
        String string = pARA.getValue();
        String string2 = pARA2.getValue();
        String string3 = pARA3.getValue();
        String string4 = pARA4.getValue();
        String string5 = pARA5.getValue();
        this.checkForNull(string, string2, string3, string4, string5);
        this.appId = string;
        try {
            this.serialNumber = Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            logger.debug(numberFormatException.getMessage());
        }
        this.name = string3;
        this.description = string4;
        this.iconPath = string5;
        try {
            String string6 = "";
            String string7 = "";
            String string8 = "";
            if (null != descContainer2) {
                PARA pARA6 = descContainer2.getParasItem("name");
                PARA pARA7 = descContainer2.getParasItem("description");
                PARA pARA8 = descContainer2.getParasItem(HELP_ID);
                if (pARA6 != null) {
                    string6 = pARA6.getValue();
                }
                if (pARA7 != null) {
                    string7 = pARA7.getValue();
                }
                if (pARA8 != null) {
                    string8 = pARA8.getValue();
                }
                this.blankName = string6;
                this.blankDesc = string7;
                this.blankHelpId = string8;
            }
        }
        catch (Exception exception) {
            logger.debug(exception.getMessage());
        }
    }

    private <T> void checkForNull(T ... TArray) throws InvalidDescException {
        for (T t : TArray) {
            if (null != t) continue;
            throw new InvalidDescException("PARA definition is not proper");
        }
    }

    void setResource(ResourceBundle resourceBundle) {
        this.resBundle = resourceBundle;
        if (null != this.resBundle) {
            try {
                this.name = this.resBundle.getString(this.name);
            }
            catch (MissingResourceException missingResourceException) {
                logger.debug("Resource not found");
            }
            try {
                this.description = this.resBundle.getString(this.description);
            }
            catch (MissingResourceException missingResourceException) {
                logger.debug("Resource not found");
            }
            try {
                this.blankDesc = this.resBundle.getString(this.blankDesc);
            }
            catch (MissingResourceException missingResourceException) {
                logger.debug("Resource not found");
            }
            try {
                this.blankName = this.resBundle.getString(this.blankName);
            }
            catch (MissingResourceException missingResourceException) {
                logger.debug("Resource not found");
            }
        }
    }
}

