/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement;

import com.swimap.iview.commstyle.resource.PropertyResourceBundleEx;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.Utils;
import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.applicationmanagement.AppMenuManager;
import com.swimap.iview.framework.applicationmanagement.AppPopupMenuManager;
import com.swimap.iview.framework.applicationmanagement.AppToolbarManager;
import com.swimap.iview.framework.applicationmanagement.ApplicationBaseInfo;
import com.swimap.iview.framework.applicationmanagement.ApplicationCallBack;
import com.swimap.iview.framework.applicationmanagement.ApplicationData;
import com.swimap.iview.framework.applicationmanagement.ApplicationInfo;
import com.swimap.iview.framework.applicationmanagement.ApplicationLauncher;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.applicationmanagement.ApplicationUtilities;
import com.swimap.iview.framework.applicationmanagement.InvalidApplicationException;
import com.swimap.iview.framework.applicationmanagement.InvalidDescException;
import com.swimap.iview.framework.applicationmanagement.StartupCommand;
import com.swimap.iview.framework.licensemanagement.LicenseService;
import com.swimap.iview.framework.licensemanagement.LicenseUtilities;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.IStartupElement;
import com.swimap.iview.framework.util.LinkUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public class Application {
    private static final long serialVersionUID = 1L;
    private static final IviewLogger logger = IviewLogger.getLogger(Application.class);
    private ResourceBundle resBundle = null;
    private String appFolderName = null;
    private ApplicationBaseInfo applicationBaseInfo = null;
    private ApplicationInfo applicationInfo = null;
    private final String localeFolder;
    private List<ApplicationCallBack> appCallBackListeners = new ArrayList<ApplicationCallBack>(10);
    Map<String, ApplicationCallBack> appClasses = new HashMap<String, ApplicationCallBack>(10);
    private AppPopupMenuManager appPopupMenuManager = null;
    private String[] extPaths = null;
    private AppMenuManager menuManager = null;
    private AppToolbarManager toolbarManager = null;
    private volatile ApplicationState state = ApplicationState.PreInit;
    private final Object LOCK_MENU = new Object();
    private final Object LOCK_TOOL = new Object();
    private final Object LOCK_POPUP = new Object();
    private boolean licensed = true;
    private volatile boolean showApplication = true;

    public Application() {
        this.localeFolder = "";
        this.applicationInfo = new ApplicationInfo();
    }

    public boolean isShowApplication() {
        return this.showApplication;
    }

    public void setShowApplication(boolean bl) {
        this.showApplication = bl;
    }

    public Application(String string) throws InvalidApplicationException {
        if (null == string) {
            throw new IllegalArgumentException("The application Name cannot be null.");
        }
        this.appFolderName = string;
        String string2 = System.getProperty("user.dir");
        File file = new File(string2 + File.separator + "applications", this.appFolderName);
        File file2 = new File(file, "application_base.xml");
        if (!file2.exists()) {
            throw new InvalidApplicationException("No base file in app dir: " + this.appFolderName);
        }
        try {
            this.applicationBaseInfo = new ApplicationBaseInfo(file2);
        }
        catch (InvalidDescException invalidDescException) {
            InvalidApplicationException invalidApplicationException = new InvalidApplicationException("Invalid application : " + this.appFolderName);
            invalidApplicationException.initCause(invalidDescException);
            throw invalidApplicationException;
        }
        if (ApplicationManager.applicationMaps.containsKey(this.applicationBaseInfo.getAppId())) {
            InvalidApplicationException invalidApplicationException = new InvalidApplicationException("Application with id : " + this.applicationBaseInfo.getAppId() + " is already loaded!");
            throw invalidApplicationException;
        }
        this.localeFolder = "applications/" + this.appFolderName + '/' + "style/locale/" + ResourceMng.getInstance().getLocaleString() + '/';
        this.resBundle = this.getResourceBundle("res");
        this.applicationInfo = new ApplicationInfo(file);
        this.applicationBaseInfo.setResource(this.resBundle);
        logger.debug("Application created :" + string);
        this.printApplicationInfo(this.applicationInfo, string);
    }

    public ResourceBundle getResourceBundle(String string) {
        InputStream inputStream;
        String string2 = this.localeFolder + string + ".properties";
        String string3 = null;
        Properties properties = ResourceMng.getProperties(string2);
        PropertyResourceBundleEx propertyResourceBundleEx = new PropertyResourceBundleEx(properties);
        if (null != properties && null != (inputStream = Utils.getInputStream(string2))) {
            string3 = Utils.getEncoding(inputStream);
        }
        propertyResourceBundleEx.setEncoding(string3);
        return propertyResourceBundleEx;
    }

    public String getRelativeResourcePath(String string) {
        return this.localeFolder + string;
    }

    public ImageIcon getResourceImageIcon(String string) {
        ImageIcon imageIcon = null;
        String string2 = this.localeFolder + string;
        File file = new File(string2);
        if (file.exists()) {
            return new ImageIcon(string2);
        }
        return imageIcon;
    }

    public String getResourceString(String string) {
        if (null == this.resBundle) {
            return string;
        }
        String string2 = null;
        try {
            string2 = this.resBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            logger.warn("MissingResourceException for Resource");
        }
        return null != string2 ? string2 : string;
    }

    public String getId() {
        return this.applicationBaseInfo.getAppId();
    }

    public String getBlankName() {
        return this.applicationBaseInfo.getblankName();
    }

    public String getBlankDesc() {
        return this.applicationBaseInfo.getblankDesc();
    }

    public String getName() {
        return this.applicationBaseInfo.getName();
    }

    public String getDescription() {
        return this.applicationBaseInfo.getDescription();
    }

    public int getSerialNumber() {
        return this.applicationBaseInfo.getSerialNumber();
    }

    public String getIconPath() {
        return this.getRelativeResourcePath(this.applicationBaseInfo.getIconPath());
    }

    public StartupCommand getStartupCommand() {
        return this.applicationInfo.getStartupCommand();
    }

    public List<IStartupElement> getAppStartupElements() {
        return this.applicationInfo.getStartupElements();
    }

    public String getDefaultHelpKey() {
        return this.applicationBaseInfo.getblankHelpId();
    }

    public void addAppCallBackListeners(ApplicationCallBack applicationCallBack) {
        if (null != applicationCallBack && !this.appCallBackListeners.contains(applicationCallBack)) {
            this.appCallBackListeners.add(applicationCallBack);
            logger.debug("Registered callback :" + applicationCallBack + "for the application:" + this.getId());
        }
    }

    public boolean removeAppCallBackListeners(ApplicationCallBack applicationCallBack) {
        return this.appCallBackListeners.remove(applicationCallBack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppPopupMenuManager getPopupMenuManager() {
        Object object = this.LOCK_POPUP;
        synchronized (object) {
            if (null == this.appPopupMenuManager) {
                if (Thread.interrupted()) {
                    logger.error("EDT Thread is interrupted, popupmenumanager creation will  not happen.");
                    return null;
                }
                if (FrameworkCommandProcessor.getInstance().isLogoutInProcess()) {
                    logger.error("login has not started yet so not created AppPopUpMenuManager");
                    return null;
                }
                logger.debug("creating the AppPopupMenuManager for " + this.getName());
                this.appPopupMenuManager = new AppPopupMenuManager(this);
            }
        }
        return this.appPopupMenuManager;
    }

    public List<String> getNormalPluginNames() {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        List<IStartupElement> list = this.getAppStartupElements();
        if (null != list) {
            for (IStartupElement iStartupElement : list) {
                if (iStartupElement.getType() != 1) continue;
                arrayList.add(iStartupElement.getName());
            }
        }
        return arrayList;
    }

    public List<String> getRequiredPluginNames() {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        List<IStartupElement> list = this.applicationInfo.getRequiredPlugins();
        for (IStartupElement iStartupElement : list) {
            arrayList.add(iStartupElement.getName());
        }
        return arrayList;
    }

    public List<String> getAllPluginNames() {
        List<String> list = this.getNormalPluginNames();
        list.addAll(this.getRequiredPluginNames());
        return list;
    }

    public String toString() {
        return "Application[ID=" + this.applicationBaseInfo.getAppId() + ']';
    }

    public List<String> getReaderPlugins() {
        List<String> list = this.getAllPluginNames();
        return ApplicationUtilities.getFilteredStartupPlugins(list);
    }

    public List<String> getAllLinks() {
        List<IStartupElement> list = this.getAppStartupElements();
        ArrayList<String> arrayList = new ArrayList<String>(10);
        if (null == list) {
            return arrayList;
        }
        Iterator<IStartupElement> iterator = list.iterator();
        boolean bl = iterator.hasNext();
        IStartupElement iStartupElement = null;
        while (bl) {
            iStartupElement = iterator.next();
            if (iStartupElement.getType() != 3) {
                iterator.remove();
            }
            bl = iterator.hasNext();
        }
        List<IStartupElement> list2 = ApplicationUtilities.getFilteredStartupLinks(list);
        for (IStartupElement iStartupElement2 : list2) {
            arrayList.add(iStartupElement2.getName());
        }
        return arrayList;
    }

    public void notifyApplicationStarting(String string, ApplicationCallBack applicationCallBack) {
        logger.debug("Started notifyApplicationStarting() for Application:" + string);
        ApplicationCallBack applicationCallBack2 = null;
        if (null != applicationCallBack) {
            this.executeCallBackStarting(applicationCallBack, string);
            logger.debug("ApplicationCallback applicationStarting() has Executed  from :" + applicationCallBack.getClass().getName());
        }
        int n = this.appCallBackListeners.size();
        for (int i = 0; i < n; ++i) {
            applicationCallBack2 = this.appCallBackListeners.get(i);
            this.executeCallBackStarting(applicationCallBack2, string);
        }
        List<String> list = this.applicationInfo.getAppCallBackList();
        Class<?> clazz = null;
        int n2 = list.size();
        ApplicationCallBack applicationCallBack3 = null;
        for (int i = 0; i < n2; ++i) {
            try {
                clazz = Class.forName(list.get(i));
                logger.debug(" Begin invoke className " + clazz.getName());
                applicationCallBack3 = (ApplicationCallBack)clazz.newInstance();
                this.appClasses.put(clazz.getName(), applicationCallBack3);
                this.executeCallBackStarting(applicationCallBack3, string);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.error("Exception while notifyApplicationStarting");
                logger.error(classNotFoundException.getMessage(), classNotFoundException);
                continue;
            }
            catch (InstantiationException instantiationException) {
                logger.error("Exception while notifyApplicationStarting");
                logger.error(instantiationException.getMessage(), instantiationException);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.error("Exception while notifyApplicationStarting");
                logger.error(illegalAccessException.getMessage(), illegalAccessException);
                continue;
            }
            catch (Exception exception) {
                logger.error(exception.getMessage(), exception);
            }
        }
        logger.debug("Completed notifyApplicationStarting() for Application:" + string);
    }

    private void executeCallBackStarting(ApplicationCallBack applicationCallBack, String string) {
        try {
            if (null != applicationCallBack) {
                applicationCallBack.applicationStarting(string);
            }
        }
        catch (Exception exception) {
            logger.error("Exception while notifyApplicationStarting");
            logger.error(exception.getMessage(), exception);
        }
        catch (Throwable throwable) {
            logger.error("Error while notifyApplicationStarting");
            logger.error(throwable.getMessage(), throwable);
        }
    }

    private void executeCallBackLaunched(ApplicationCallBack applicationCallBack, String string) {
        try {
            applicationCallBack.applicationLaunched(string);
        }
        catch (Exception exception) {
            logger.error("Exception while notifyApplicationLaunched");
            logger.error(exception.getMessage(), exception);
        }
        catch (Throwable throwable) {
            logger.error("Error while notifyApplicationLaunched");
            logger.error(throwable.getMessage(), throwable);
        }
    }

    private void executeCallBackActivated(ApplicationCallBack applicationCallBack, String string) {
        try {
            if (null != applicationCallBack) {
                applicationCallBack.applicationActivated(string);
            }
        }
        catch (Exception exception) {
            logger.error("Exception while notifyApplicationActivated");
            logger.error(exception.getMessage(), exception);
        }
        catch (Throwable throwable) {
            logger.error("Error while notifyApplicationActivated");
            logger.error(throwable.getMessage(), throwable);
        }
    }

    private void executeCallBackDeactivated(ApplicationCallBack applicationCallBack, String string) {
        try {
            if (null != applicationCallBack) {
                applicationCallBack.applicationDeactivated(string);
            }
        }
        catch (Exception exception) {
            logger.error("Exception while notifyApplicationDeactivated");
            logger.error(exception.getMessage(), exception);
        }
        catch (Throwable throwable) {
            logger.error("Error while notifyApplicationDeactivated");
            logger.error(throwable.getMessage(), throwable);
        }
    }

    public void notifyApplicationLaunched(String string) {
        logger.debug("Started notifyApplicationLaunched() for Application:" + string);
        ApplicationData applicationData = ApplicationLauncher.getAppLauncher().getApplicationData(string);
        if (null == applicationData) {
            return;
        }
        ApplicationCallBack applicationCallBack = applicationData.getCallBack();
        if (null != applicationCallBack) {
            this.executeCallBackLaunched(applicationCallBack, string);
            logger.debug("ApplicationCallback applicationLaunched() has Executed  from :" + applicationCallBack.getClass().getName() + "for applicaiton:" + string);
        }
        int n = this.appCallBackListeners.size();
        for (int i = 0; i < n; ++i) {
            applicationCallBack = this.appCallBackListeners.get(i);
            if (null == applicationCallBack) continue;
            this.executeCallBackLaunched(applicationCallBack, string);
            logger.debug("ApplicationCallback applicationLaunched() has Executed  from :" + applicationCallBack.getClass().getName() + "for applicaiton:" + string);
        }
        List<String> list = this.applicationInfo.getAppCallBackList();
        int n2 = list.size();
        ApplicationCallBack applicationCallBack2 = null;
        for (int i = 0; i < n2; ++i) {
            applicationCallBack2 = this.appClasses.get(list.get(i));
            if (null == applicationCallBack2) continue;
            this.executeCallBackLaunched(applicationCallBack2, string);
            logger.debug("ApplicationCallback applicationLaunched() has Executed  from :" + applicationCallBack2.getClass().getName() + "for applicaiton:" + string);
        }
        logger.debug("Completed notifyApplicationLaunched() for Application:" + string);
    }

    public void notifyApplicationActivated(String string) {
        ApplicationLauncher.getAppLauncher().setActiveFrameAppId(string);
        ApplicationData applicationData = ApplicationLauncher.getAppLauncher().getApplicationData(string);
        if (null == applicationData) {
            return;
        }
        ApplicationCallBack applicationCallBack = applicationData.getCallBack();
        this.executeCallBackActivated(applicationCallBack, string);
        int n = this.appCallBackListeners.size();
        for (int i = 0; i < n; ++i) {
            applicationCallBack = this.appCallBackListeners.get(i);
            this.executeCallBackActivated(applicationCallBack, string);
        }
        List<String> list = this.applicationInfo.getAppCallBackList();
        int n2 = list.size();
        ApplicationCallBack applicationCallBack2 = null;
        for (int i = 0; i < n2; ++i) {
            applicationCallBack2 = this.appClasses.get(list.get(i));
            this.executeCallBackActivated(applicationCallBack2, string);
        }
    }

    public void notifyApplicationDeActivated(String string) {
        ApplicationData applicationData = ApplicationLauncher.getAppLauncher().getApplicationData(string);
        if (null == applicationData) {
            return;
        }
        ApplicationCallBack applicationCallBack = applicationData.getCallBack();
        this.executeCallBackDeactivated(applicationCallBack, string);
        int n = this.appCallBackListeners.size();
        for (int i = 0; i < n; ++i) {
            applicationCallBack = this.appCallBackListeners.get(i);
            this.executeCallBackDeactivated(applicationCallBack, string);
        }
        List<String> list = this.applicationInfo.getAppCallBackList();
        int n2 = list.size();
        ApplicationCallBack applicationCallBack2 = null;
        for (int i = 0; i < n2; ++i) {
            applicationCallBack2 = this.appClasses.get(list.get(i));
            this.executeCallBackDeactivated(applicationCallBack2, string);
        }
    }

    public void invokeActivationDeactivationCallback(String string) {
        String string2 = ApplicationLauncher.getAppLauncher().getActiveFrameAppId();
        if (!string.equals(string2) && !ApplicationLauncher.getAppLauncher().isAppEmptyFrameDisposing()) {
            Application application;
            if (null != string2) {
                application = ApplicationManager.getInstance().getApplication(string2);
                application.notifyApplicationDeActivated(string2);
            }
            application = ApplicationManager.getInstance().getApplication(string);
            application.notifyApplicationActivated(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppMenuManager getMenuManager() {
        Object object = this.LOCK_MENU;
        synchronized (object) {
            if (null == this.menuManager) {
                if (Thread.interrupted()) {
                    logger.error("EDT Thread is interrupted, menumnagaer creation will  not happen.");
                    return null;
                }
                if (FrameworkCommandProcessor.getInstance().isLogoutInProcess()) {
                    logger.error("login has not started yet so not created appmenumanager");
                    return null;
                }
                this.createMenuManager(this.applicationBaseInfo.getAppId());
            }
        }
        return this.menuManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppToolbarManager getToolbarManager() {
        Object object = this.LOCK_TOOL;
        synchronized (object) {
            if (null == this.toolbarManager) {
                if (Thread.interrupted()) {
                    logger.error("EDT Thread is interrupted, toolbarmanager creation will  not happen.");
                    return null;
                }
                if (FrameworkCommandProcessor.getInstance().isLogoutInProcess()) {
                    logger.error("login has not started yet so not created toolbarmanager");
                    return null;
                }
                this.createToolbarManager(this.applicationBaseInfo.getAppId());
            }
        }
        return this.toolbarManager;
    }

    private void createToolbarManager(String string) {
        if (null != this.toolbarManager) {
            logger.debug("Toolbar manager for this application " + string + "already created");
            return;
        }
        try {
            logger.debug("Creating Toolbar Manager for app: " + string);
            String string2 = "maintoolbarmanager_" + string;
            this.toolbarManager = new AppToolbarManager(Main.instance().getModuleManager(), string2, string);
            BaseModule baseModule = Main.instance().getModuleManager().getLocalModule(string2, false);
            baseModule.reinitialize();
        }
        catch (ModuleManagementException moduleManagementException) {
            logger.error("ModuleManagementException While creating toolbar");
            logger.error(moduleManagementException.getMessage(), moduleManagementException);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
    }

    private void createMenuManager(String string) {
        if (null != this.menuManager) {
            logger.debug("Menu manager for this application " + string + "already created");
            return;
        }
        try {
            logger.debug("Creating Menu Manager for app: " + string);
            String string2 = "mainmenumanager_" + string;
            this.menuManager = new AppMenuManager(Main.instance().getModuleManager(), string2, string);
            BaseModule baseModule = Main.instance().getModuleManager().getLocalModule(string2, false);
            baseModule.reinitialize();
        }
        catch (ModuleManagementException moduleManagementException) {
            logger.error(moduleManagementException.getMessage());
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
    }

    public String[] getExtsFromLinks() {
        if (this.extPaths == null) {
            this.extPaths = this.populateExtsFromLinks();
        }
        return this.extPaths;
    }

    private String[] populateExtsFromLinks() {
        List<String> list = this.getAllLinks();
        HashSet<String> hashSet = new HashSet<String>(10);
        for (String string : list) {
            hashSet.addAll(LinkUtil.getExts(string));
        }
        Object[] objectArray = new String[hashSet.size()];
        hashSet.toArray(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public void validateLicense() {
        String string = this.applicationInfo.getLicenseKeys();
        this.licensed = true;
        if (null != string && string.length() > 1) {
            try {
                LicenseUtilities.loadLicenseService();
                LicenseService licenseService = LicenseUtilities.getLicenseService();
                this.licensed = null == licenseService ? false : licenseService.checkLicense(string.split("( )*,( )*"));
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
                this.licensed = false;
            }
        }
    }

    public boolean isLicensed() {
        return this.licensed;
    }

    public void clear() {
        if (null != this.menuManager) {
            this.menuManager.clear();
            Main.instance().getModuleManager().shutdownLocalModule(this.menuManager.getModuleName());
        }
        if (null != this.toolbarManager) {
            this.toolbarManager.clear();
            Main.instance().getModuleManager().shutdownLocalModule(this.toolbarManager.getModuleName());
        }
        if (null != this.appPopupMenuManager) {
            this.appPopupMenuManager.clear();
        }
        this.appPopupMenuManager = null;
        this.menuManager = null;
        this.toolbarManager = null;
    }

    private void printApplicationInfo(ApplicationInfo applicationInfo, String string) {
        if (null == applicationInfo) {
            return;
        }
        List<IStartupElement> list = applicationInfo.getStartupElements();
        ArrayList<String> arrayList = new ArrayList<String>(10);
        ArrayList<String> arrayList2 = new ArrayList<String>(10);
        ArrayList<String> arrayList3 = new ArrayList<String>(10);
        for (IStartupElement iStartupElement : list) {
            if (iStartupElement.getType() == 1) {
                arrayList.add(iStartupElement.getName());
                continue;
            }
            if (iStartupElement.getType() == 3) {
                arrayList2.add(iStartupElement.getName());
                continue;
            }
            if (iStartupElement.getType() != 2) continue;
            arrayList3.add(iStartupElement.getName());
        }
        logger.info("Application ID :" + string + " ->" + "CallBacks ;" + applicationInfo.getAppCallBackList() + "StartupCommands ;" + applicationInfo.getStartupCommand() + "Plugins ;" + arrayList + "ProductLib ;" + arrayList2 + "Features ;" + arrayList3);
    }

    public ApplicationState getState() {
        return this.state;
    }

    public void setState(ApplicationState applicationState) {
        logger.debug("State of the application has set:" + (Object)((Object)this.state) + " for appId:" + this.getId());
        this.state = applicationState;
    }

    public static enum ApplicationState {
        PreInit,
        Starting,
        Launched,
        Failed;

    }
}

