/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.ToolGroupSet;
import com.swimap.iview.framework.applicationmanagement.AppToolbar;
import com.swimap.iview.framework.applicationmanagement.Application;
import com.swimap.iview.framework.applicationmanagement.ApplicationLauncher;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.lookandfeel.UIStyleTool;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.toolbarmanagement.ToolbarManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.log.IviewLogger;
import java.util.List;
import javax.swing.plaf.PanelUI;
import org.omg.CORBA.ORB;

public class AppToolbarManager
extends ToolbarManager {
    private static IviewLogger logger = IviewLogger.getLogger(ToolbarManager.class, "IVIEW");
    private static final String MAINTOOL_GROUPSET_NAME = "mainTool";
    private static final String UNDEFINED_MODULE_NAME = "toolbar module(undefined)";
    private String appId = null;

    public AppToolbarManager(ModuleManager moduleManager, String string, String string2) throws ModuleManagementException {
        this(moduleManager, null, null, null, string, string2);
    }

    public AppToolbarManager(ModuleManager moduleManager, ORB oRB, String string, String string2, String string3, String string4) throws ModuleManagementException {
        super(moduleManager, oRB, string, string2, string3, string4);
        this.moduleName = string3;
        this.appId = string4;
    }

    @Override
    public void init(String string) {
        this.toolbarComponent = new AppToolbar(null, string);
        this.toolbarComponent.setSaveLock("main_toolbar_component");
        this.toolbarComponent.setBackground(UIStyleTool.getTOOLBAR_BACKGROUND());
    }

    @Override
    public void reinitialize() {
        this.menuManager = ApplicationManager.getInstance().getAppMenuManager(this.appId);
        if (this.menuManager != null) {
            this.menuManager.addMouseListener(this.toolbarComponent.getPopupMenuListener());
        }
        this.toolbarComponent.clearSettings();
        this.toolbarComponent.removeAll();
        this.toolbarComponent.enableCurrentSettings(false);
        ToolGroupSet toolGroupSet = null;
        toolGroupSet = null == ApplicationLauncher.getBaseToolbarManager() ? FrameworkUtilities.getToolbarManager().getToolGroupSet(MAINTOOL_GROUPSET_NAME) : ApplicationLauncher.getBaseToolbarManager().getToolGroupSet(MAINTOOL_GROUPSET_NAME);
        if (null != toolGroupSet) {
            this.toolbarComponent.addToolGroupSet(new ToolGroupSet(toolGroupSet));
        } else {
            this.loadToolbarButtonGroups("conf/mainfrm/toolbar", MAINTOOL_GROUPSET_NAME);
        }
        ((AppToolbar)this.toolbarComponent).setAppId(this.appId);
        Application application = ApplicationManager.getInstance().getApplication(this.appId);
        String[] stringArray = FrameworkCommandProcessor.getInstance().getFilteredExtPaths(application.getExtsFromLinks());
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.loadDynamicToolbarGroupOfExtPath("conf/" + stringArray[i] + "/app/toolbar", MAINTOOL_GROUPSET_NAME, stringArray[i]);
            }
        }
        this.loadToolbarGroupFromPlugin();
        if (this.menuManager != null) {
            this.menuManager.addMouseListener(this.toolbarComponent.getPopupMenuListener());
        }
        try {
            this.toolbarComponent.resetLockInfo();
        }
        catch (Exception exception) {
            logger.warn(exception);
        }
        this.toolbarComponent.setOriginalComponentsPositions();
        this.toolbarComponent.refreshOriginal();
        this.toolbarComponent.enableCurrentSettings(true);
    }

    @Override
    public void launchCustomizeDialog() {
        this.toolbarComponent.validateToolbar();
        this.toolbarComponent.launchCustomizeDialog();
    }

    @Override
    protected void loadToolbarGroupFromPlugin() {
        List<Plugin> list = PluginManager.getInstance().getStartupPluginList(this.appId);
        Plugin plugin2 = null;
        CommStyleInfo commStyleInfo = null;
        if (null != list) {
            for (Plugin plugin2 : list) {
                if (!FrameworkUtilities.isInState(plugin2.getModuleInfomation().getStates()) || null == (commStyleInfo = plugin2.getIntegrateCommStyleReader().getUserCommStyleInfo("toolbar"))) continue;
                this.loadDynamicToolbarGroup(commStyleInfo, MAINTOOL_GROUPSET_NAME);
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (null != this.toolbarComponent) {
            PanelUI panelUI = this.toolbarComponent.getUI();
            panelUI.uninstallUI(this.toolbarComponent);
            this.toolbarComponent = null;
        }
    }
}

