/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.ToolGroup;
import com.swimap.iview.commstyle.commini.ToolGroupSet;
import com.swimap.iview.framework.applicationmanagement.AppMenuManager;
import com.swimap.iview.framework.applicationmanagement.ApplicationUtilities;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.toolbar.Toolbar;
import com.swimap.iview.util.log.IviewLogger;

public class AppToolbar
extends Toolbar {
    private static IviewLogger logger = IviewLogger.getLogger(AppToolbar.class, "IVIEW");
    private String appId = null;

    public AppToolbar(CommStyleInfo[] commStyleInfoArray) {
        super(commStyleInfoArray);
    }

    public AppToolbar(CommStyleInfo[] commStyleInfoArray, String string) {
        super(commStyleInfoArray);
        this.appId = string;
    }

    @Override
    protected void updateToolGroupSet(ToolGroupSet toolGroupSet) {
        logger.trace("Begin Updating the Tool Group Set for App: " + this.appId);
        int n = toolGroupSet.getToolGroupCount();
        ToolGroup toolGroup = null;
        for (int i = 0; i < n; ++i) {
            toolGroup = toolGroupSet.getToolGroup(i);
            ApplicationUtilities.updateToobarComponent(toolGroup, this.appId);
        }
        this.validateToolbar();
        logger.trace("End Updating the Tool Group Set for App: " + this.appId);
    }

    @Override
    public void updateToolbarSafely() {
        logger.trace("updating the toolbar for app: " + this.appId);
        super.updateToolbarSafely();
    }

    @Override
    public boolean updateToolbars() {
        MenuManager menuManager = FrameworkUtilities.getMenuManager();
        String string = null;
        if (menuManager instanceof AppMenuManager) {
            string = ((AppMenuManager)menuManager).getAppId();
        }
        logger.trace("Active app id is :" + string);
        if (null != string && string.equals(this.appId)) {
            logger.trace("updating the toolbar for app : " + this.appId);
            return super.updateToolbars();
        }
        logger.debug("Can not update the tool bar for non active app: " + this.appId);
        return false;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String string) {
        this.appId = string;
    }

    @Override
    public void clear() {
        super.clear();
        this.uninstallListeners();
    }
}

