/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement;

import com.swimap.iview.commstyle.commini.MenuItemUI;
import com.swimap.iview.commstyle.commini.foldingmenus.FoldingMenuKeyListener;
import com.swimap.iview.framework.lookandfeel.skin.SkinManager;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.PopupMenuUI;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import sun.swing.SwingUtilities2;

class AppPopupUIFactory {
    private static final String POPUPLABLE = "Popuplabel.gif";
    private static final String PORTAL_IMG_TYPE = "portal";
    private static final ImageIcon popupLabelImg = SkinManager.getInstance().getSkinImage("portal", "Popuplabel.gif");

    AppPopupUIFactory() {
    }

    public static PopupMenuUI getPopupMenuUI() {
        return new BasicPopupMenuUI(){

            @Override
            protected void installListeners() {
                MenuKeyListener[] menuKeyListenerArray;
                super.installListeners();
                for (MenuKeyListener menuKeyListener : menuKeyListenerArray = this.popupMenu.getMenuKeyListeners()) {
                    this.popupMenu.removeMenuKeyListener(menuKeyListener);
                }
                this.popupMenu.addMenuKeyListener(new FoldingMenuKeyListener(){

                    @Override
                    public MenuElement[] getPopupSubElements() {
                        return popupMenu.getSubElements();
                    }
                });
            }
        };
    }

    public static MenuItemUI getHeaderPopupMenuUI() {
        return new MenuItemUI(){

            @Override
            protected MouseInputListener createMouseInputListener(JComponent jComponent) {
                return new AppMouseInputHandler();
            }

            @Override
            protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
                return null;
            }

            @Override
            protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
                AppPopupUIFactory.paintText(graphics, jMenuItem, rectangle, string);
            }

            @Override
            protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
                graphics.drawImage(popupLabelImg.getImage(), 0, 0, jMenuItem.getWidth(), jMenuItem.getHeight(), null);
            }

            class AppMouseInputHandler
            extends BasicMenuItemUI.MouseInputHandler {
                AppMouseInputHandler() {
                    super(this);
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    Object object = mouseEvent.getSource();
                    if (object instanceof JMenuItem) {
                        return;
                    }
                }
            }
        };
    }

    private static void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        ButtonModel buttonModel = jMenuItem.getModel();
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics((JComponent)jMenuItem, graphics);
        int n = jMenuItem.getDisplayedMnemonicIndex();
        Color color = UIManager.getColor("MenuItem.selectionForeground");
        if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
            graphics.setColor(color);
        }
        SwingUtilities2.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
    }
}

