/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.IComminiProperties;
import com.swimap.iview.commstyle.commini.Menu;
import com.swimap.iview.commstyle.commini.MenuItemUI;
import com.swimap.iview.commstyle.commini.MenuSet;
import com.swimap.iview.commstyle.commini.UIObjMng;
import com.swimap.iview.commstyle.commini.UIObjectDescriptionNotCorrectException;
import com.swimap.iview.commstyle.commini.foldingmenus.FoldingMenu;
import com.swimap.iview.framework.applicationmanagement.AppCheckboxMenuItem;
import com.swimap.iview.framework.applicationmanagement.AppMenu;
import com.swimap.iview.framework.applicationmanagement.AppMenuItem;
import com.swimap.iview.framework.applicationmanagement.AppMenuItemProperties;
import com.swimap.iview.framework.applicationmanagement.AppPopupLayout;
import com.swimap.iview.framework.applicationmanagement.AppPopupMenu;
import com.swimap.iview.framework.applicationmanagement.AppRadioButtonMenuItem;
import com.swimap.iview.framework.applicationmanagement.Application;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.applicationmanagement.ApplicationUtilities;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.framework.pluginmanagement.CommStyleParser;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.pluginmanagement.Resource;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkGlobalInfo;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.PopupMenuUI;

public class AppPopupMenuManager {
    private static final IviewLogger logger = IviewLogger.getLogger(AppPopupMenuManager.class);
    private static final String MENUSET_ID = "mainMenu";
    private MenuSet menuSet = null;
    private Application application = null;
    private ArrayList<Component> visibleComplist = null;
    private Component nextComp = null;
    private Component previousComp = null;
    private AppMenuItem previousButton = null;
    private boolean isNextpage = false;
    private boolean isPreviousPage = false;
    private AppMenuItem nextButton = null;
    private Color menuColor = new Color(0, 0, 255);
    private AppPopupMenu popupMenu;
    private boolean isCancel = false;
    private static final String SEPARATOR = "- ";

    AppPopupMenuManager(Application application) {
        this.application = application;
        this.loadExtMenus();
        this.loadPluginMenus();
        this.updateAppPopUP();
        this.menuColor = ApplicationManager.getInstance().getAppMenuColor();
    }

    public void updateAppPopUP() {
        boolean bl = false;
        if (Thread.interrupted()) {
            logger.error("EDT Thread is interrupted, popupmenus updation will  not happen.");
            return;
        }
        if (null != this.menuSet) {
            Map<KeyHolder, List<JComponent>> map;
            logger.debug("updating the AppPopUp menu for app: " + this.application);
            if (null != this.popupMenu && this.popupMenu.isVisible()) {
                bl = true;
                this.popupMenu.setVisible(false);
            }
            if ((map = this.getSortedMenus()).size() > 0) {
                this.getNonNullPopupMenu().removeAll();
                Set<KeyHolder> set = map.keySet();
                AppPopupLayout appPopupLayout = new AppPopupLayout(0, 1, 0, 1);
                this.getNonNullPopupMenu().setLayout(appPopupLayout);
                KeyHolder keyHolder2 = null;
                for (KeyHolder keyHolder2 : set) {
                    this.loadMenus(map.get(keyHolder2), 0, keyHolder2, true);
                }
                this.validateAppMenuSeparator(this.getNonNullPopupMenu().getComponents());
                appPopupLayout.setFixedSize(this.getNonNullPopupMenu().getComponents());
                this.nextComp = null;
                this.previousComp = null;
            }
        }
        if (bl && null != this.popupMenu) {
            this.popupMenu.setVisible(true);
        }
    }

    public void updatePopupMenu() {
        if (Thread.interrupted()) {
            logger.error("EDT Thread is interrupted, popupmenus updation will  not happen.");
            return;
        }
        if (null == this.menuSet) {
            return;
        }
        int n = this.menuSet.getMenuCount();
        for (int i = 0; i < n; ++i) {
            AppMenu appMenu = (AppMenu)this.menuSet.getMenu(i);
            if (!appMenu.isShowInPortal()) continue;
            appMenu.updateMenu();
        }
    }

    private void updateParent(AppPopupMenu appPopupMenu) {
        if (this.getNextButton().getParent() != null) {
            this.getNextButton().getParent().remove(this.getNextButton());
        }
        if (this.getPreviousBtn().getParent() != null) {
            this.getPreviousBtn().getParent().remove(this.getPreviousBtn());
        }
        int n = 100;
        if (this.isPreviousPage) {
            this.nextComp = this.previousComp;
            int n2 = this.getNonNullPopupMenu().getComponentIndex(this.previousComp);
            Component component = null;
            if (this.isPreviousPage) {
                appPopupMenu.insert(this.getNextButton(), n2);
            }
            this.updateChildVisibilty(++n2, false);
            for (int i = 0; i <= n; ++i) {
                if (n2 < 0) {
                    this.updateChildVisibilty(n2, true);
                    break;
                }
                component = appPopupMenu.getComponent(n2);
                if (i >= 100) {
                    this.previousComp = appPopupMenu.getComponent(n2 + 2);
                    appPopupMenu.insert(this.getPreviousBtn(), n2 + 2);
                    this.updateChildVisibilty(n2 + 2, true);
                    break;
                }
                --n2;
                if (!component.isVisible()) {
                    --i;
                    continue;
                }
                if (!(component instanceof JSeparator)) continue;
                --i;
            }
        } else {
            int n3;
            int n4 = appPopupMenu.getComponentCount();
            if (n4 - (n3 = this.getNonNullPopupMenu().getComponentIndex(this.nextComp)) < n) {
                n = n4 - n3;
            }
            this.previousComp = this.nextComp;
            int n5 = n3;
            int n6 = n5 = n5 == -1 ? 0 : n5;
            if (this.isNextpage) {
                appPopupMenu.insert(this.getPreviousBtn(), n5);
            }
            Component component = null;
            this.updateChildVisibilty(n5, true);
            for (int i = 0; i <= n && n5 < n4; ++i) {
                component = appPopupMenu.getComponent(n5);
                if (i >= 100) {
                    appPopupMenu.insert(this.getNextButton(), n5 - 1);
                    this.nextComp = appPopupMenu.getComponent(n5);
                    this.updateChildVisibilty(n5, false);
                    break;
                }
                ++n5;
                if (!component.isVisible()) {
                    --i;
                    continue;
                }
                if (!(component instanceof JSeparator)) continue;
                --i;
            }
        }
    }

    private void updateChildVisibilty(int n, boolean bl) {
        Component component = null;
        if (this.visibleComplist == null) {
            this.visibleComplist = new ArrayList();
        }
        if (bl) {
            for (int i = 0; i < n; ++i) {
                component = this.getNonNullPopupMenu().getComponent(i);
                if (!component.isVisible()) continue;
                this.visibleComplist.add(component);
                component.setVisible(false);
            }
        } else {
            for (int i = n; i < this.getNonNullPopupMenu().getComponentCount(); ++i) {
                component = this.getNonNullPopupMenu().getComponent(i);
                if (!component.isVisible()) continue;
                this.visibleComplist.add(component);
                component.setVisible(false);
            }
        }
    }

    private AppMenuItem getNextButton() {
        if (null == this.nextButton) {
            this.nextButton = new AppMenuItem(){

                @Override
                public AppMenuItemProperties.MenuItemType getMenuType() {
                    return AppMenuItemProperties.MenuItemType.NotAItem;
                }
            };
            String string = ApplicationUtilities.getString("NextPage");
            this.nextButton.setText(string);
            this.nextButton.setForeground(this.menuColor);
            this.nextButton.setName("Appmenu.nextButton");
            this.nextButton.setMnemonic('N');
            this.nextButton.setLevel(1);
            this.nextButton.setAction(this.getNextAction());
        }
        return this.nextButton;
    }

    private Action getNextAction() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppPopupMenu appPopupMenu = AppPopupMenuManager.this.getNonNullPopupMenu();
                AppPopupMenuManager.this.isNextpage = true;
                AppPopupMenuManager.this.isPreviousPage = false;
                appPopupMenu.setVisible(true);
            }
        };
        return abstractAction;
    }

    private AppMenuItem getPreviousBtn() {
        if (null == this.previousButton) {
            this.previousButton = new AppMenuItem(){

                @Override
                public AppMenuItemProperties.MenuItemType getMenuType() {
                    return AppMenuItemProperties.MenuItemType.NotAItem;
                }
            };
            String string = ApplicationUtilities.getString("PreviousPage");
            this.previousButton.setText(string);
            this.previousButton.setForeground(this.menuColor);
            this.previousButton.setName("Appmenu.PreviousButton");
            this.previousButton.setMnemonic('P');
            this.previousButton.setLevel(1);
            this.previousButton.setAction(this.getPreviousAction());
        }
        return this.previousButton;
    }

    private Action getPreviousAction() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppPopupMenu appPopupMenu = AppPopupMenuManager.this.getNonNullPopupMenu();
                AppPopupMenuManager.this.isPreviousPage = true;
                AppPopupMenuManager.this.isNextpage = false;
                appPopupMenu.setVisible(true);
            }
        };
        return abstractAction;
    }

    private void validateAppMenuSeparator(Component[] componentArray) {
        int n;
        boolean bl = true;
        Component component = null;
        for (n = 0; n < componentArray.length; ++n) {
            component = componentArray[n];
            if (component instanceof JSeparator) {
                if (bl) {
                    component.setVisible(false);
                } else {
                    component.setVisible(true);
                }
                bl = true;
                continue;
            }
            if (!(component instanceof JMenu) && !(component instanceof JMenuItem) || !component.isVisible()) continue;
            bl = false;
        }
        for (n = componentArray.length - 1; n > 0; --n) {
            component = componentArray[n];
            if (component instanceof JSeparator) {
                component.setVisible(false);
                continue;
            }
            if (component.isVisible()) break;
        }
        for (n = 0; n < componentArray.length; ++n) {
            component = componentArray[n];
            if (!(component instanceof AppMenuItem) || ((AppMenuItem)component).getMenuType() != AppMenuItemProperties.MenuItemType.NotAItem || n + 1 > componentArray.length - 1 || !((component = componentArray[n + 1]) instanceof JSeparator)) continue;
            component.setVisible(false);
        }
    }

    private void loadMenus(List<JComponent> list, int n, KeyHolder keyHolder, boolean bl) {
        boolean bl2 = false;
        AppMenuItem appMenuItem = new AppMenuItem(){

            @Override
            public AppMenuItemProperties.MenuItemType getMenuType() {
                return AppMenuItemProperties.MenuItemType.NotAItem;
            }

            @Override
            public void updateUI() {
                this.setUI(new MenuItemUI());
            }

            @Override
            public boolean isConsumeEvent(MouseEvent mouseEvent) {
                return true;
            }
        };
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).isVisible()) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            logger.debug("No child visible for parent Menu" + keyHolder.id);
            return;
        }
        appMenuItem.setText(ApplicationUtilities.replacePopupMenuMnemonic(keyHolder.name));
        appMenuItem.setLevel(n);
        appMenuItem.setName(keyHolder.id);
        appMenuItem.setEnabled(true);
        Color color = Color.BLACK;
        appMenuItem.setForeground(color);
        float f = ApplicationManager.getInstance().getAppMenuLevelFont(0);
        Font font = UIManager.getFont("MenuItem.font").deriveFont(1, f);
        appMenuItem.setFont(font);
        this.getNonNullPopupMenu().add(appMenuItem);
        this.loadSubMenus(list, ++n);
    }

    private void loadSubMenus(List<JComponent> list, int n) {
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            if (n2 <= i) continue;
            JComponent jComponent = list.get(i);
            jComponent.setBackground(new Color(239, 239, 239));
            if (jComponent instanceof AppMenu) {
                AppMenu appMenu = (AppMenu)jComponent;
                KeyHolder keyHolder = new KeyHolder(appMenu.getText(), appMenu.getID());
                Component[] componentArray = appMenu.getMenuComponents();
                ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
                for (Component component : componentArray) {
                    if (!(component instanceof JComponent)) continue;
                    this.addMenuToMap((JComponent)component, arrayList);
                }
                this.loadMenus(arrayList, n, keyHolder, false);
                continue;
            }
            if (jComponent instanceof AppMenuItemProperties) {
                ((AppMenuItemProperties)((Object)jComponent)).setLevel(n);
            }
            this.getNonNullPopupMenu().add(jComponent);
        }
    }

    private Map<KeyHolder, List<JComponent>> getSortedMenus() {
        LinkedHashMap<KeyHolder, List<JComponent>> linkedHashMap = new LinkedHashMap<KeyHolder, List<JComponent>>();
        if (null == this.menuSet) {
            return linkedHashMap;
        }
        int n = this.menuSet.getMenuCount();
        Menu menu = null;
        for (int i = 0; i < n; ++i) {
            AppMenu appMenu;
            menu = this.menuSet.getMenu(i);
            if (!(menu instanceof AppMenu) || !(appMenu = (AppMenu)menu).isShowInPortal()) continue;
            KeyHolder keyHolder = new KeyHolder(appMenu.getText(), appMenu.getID());
            Component[] componentArray = appMenu.getMenuComponents();
            ArrayList<JComponent> arrayList = (ArrayList<JComponent>)linkedHashMap.get(keyHolder);
            if (null == arrayList) {
                arrayList = new ArrayList<JComponent>();
            }
            for (Component component : componentArray) {
                if (!(component instanceof JComponent)) continue;
                this.addMenuToMap((JComponent)component, arrayList);
            }
            if (arrayList.isEmpty() || !ApplicationUtilities.isComponentsHasMenuItems(arrayList)) continue;
            linkedHashMap.put(keyHolder, arrayList);
        }
        return linkedHashMap;
    }

    private void addMenuToMap(JComponent jComponent, List<JComponent> list) {
        AppMenuItemProperties appMenuItemProperties;
        if (jComponent instanceof AppMenuItemProperties && (appMenuItemProperties = (AppMenuItemProperties)((Object)jComponent)).isShowInPortal()) {
            if (appMenuItemProperties instanceof AppMenu) {
                ApplicationUtilities.updateMenuComponent(appMenuItemProperties, this.application.getId(), true);
                if (ApplicationUtilities.isMenuContainsMenuItems(appMenuItemProperties)) {
                    list.add(jComponent);
                }
            } else if (appMenuItemProperties instanceof AppMenuItemProperties && ApplicationUtilities.isValidapp(appMenuItemProperties, this.application.getId())) {
                list.add(jComponent);
            }
        }
    }

    private AppPopupMenu getNonNullPopupMenu() {
        if (null == this.popupMenu) {
            this.popupMenu = new AppPopupMenu(this.application.getId());
            this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    AppPopupMenuManager.this.updateColorAndFont(false);
                    if (null != AppPopupMenuManager.this.visibleComplist) {
                        int n = AppPopupMenuManager.this.visibleComplist.size();
                        for (int i = 0; i < n; ++i) {
                            ((Component)AppPopupMenuManager.this.visibleComplist.get(i)).setVisible(true);
                        }
                        AppPopupMenuManager.this.visibleComplist.clear();
                    }
                    AppPopupMenuManager.this.isPreviousPage = false;
                    AppPopupMenuManager.this.isNextpage = false;
                    AppPopupMenuManager.this.isCancel = true;
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    if (!AppPopupMenuManager.this.isCancel) {
                        AppPopupMenuManager.this.updateColorAndFont(false);
                        CommonUtil.hideShowTooltip();
                        if (null != AppPopupMenuManager.this.visibleComplist) {
                            int n = AppPopupMenuManager.this.visibleComplist.size();
                            for (int i = 0; i < n; ++i) {
                                ((Component)AppPopupMenuManager.this.visibleComplist.get(i)).setVisible(true);
                            }
                            AppPopupMenuManager.this.visibleComplist.clear();
                        }
                        AppPopupMenuManager.this.isPreviousPage = false;
                        AppPopupMenuManager.this.isNextpage = false;
                        AppPopupMenuManager.this.isCancel = true;
                    }
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    AppPopupMenuManager.this.isCancel = false;
                    logger.debug("Popup menu become visible");
                    if (!AppPopupMenuManager.this.isNextpage && !AppPopupMenuManager.this.isPreviousPage) {
                        AppPopupMenuManager.this.updateAppPopUP();
                    }
                    AppPopupMenuManager.this.updateParent(AppPopupMenuManager.this.getNonNullPopupMenu());
                    AppPopupMenuManager.this.updateColorAndFont(true);
                }
            });
        }
        return this.popupMenu;
    }

    private void updateColorAndFont(boolean bl) {
        this.getNonNullPopupMenu().setBackground(new Color(239, 239, 239));
        Component[] componentArray = this.getNonNullPopupMenu().getComponents();
        Color color = null;
        Font font = null;
        Font font2 = null;
        Font font3 = null;
        Font font4 = UIManager.getFont("MenuItem.font");
        if (bl) {
            color = ApplicationManager.getInstance().getAppMenuColor();
            float f = ApplicationManager.getInstance().getAppMenuLevelFont(1);
            font2 = font4.deriveFont(1, f);
            font3 = font4.deriveFont(f);
            f = ApplicationManager.getInstance().getAppMenuLevelFont(2);
            font = font4.deriveFont(f);
        } else {
            color = UIManager.getColor("MenuItem.foreground");
            font2 = font3 = font4;
            font = font3;
        }
        for (Component component : componentArray) {
            component.setBackground(new Color(239, 239, 239));
            if (!(component instanceof AppMenuItemProperties)) continue;
            AppMenuItemProperties appMenuItemProperties = (AppMenuItemProperties)((Object)component);
            if (appMenuItemProperties.getLevel() == 1) {
                if (this.isLeaf(appMenuItemProperties.getMenuType())) {
                    component.setForeground(color);
                    component.setFont(font3);
                    continue;
                }
                component.setFont(font2);
                continue;
            }
            if (appMenuItemProperties.getLevel() != 2) continue;
            JMenuItem jMenuItem = (JMenuItem)component;
            if (bl) {
                jMenuItem.setText(SEPARATOR + jMenuItem.getText());
            } else {
                jMenuItem.setText(jMenuItem.getText().substring(2));
            }
            char c = (char)jMenuItem.getMnemonic();
            jMenuItem.setMnemonic(c);
            component.setFont(font);
            component.setForeground(color);
        }
    }

    private boolean isLeaf(AppMenuItemProperties.MenuItemType menuItemType) {
        return menuItemType != AppMenuItemProperties.MenuItemType.NotAItem;
    }

    private void loadExtMenus() {
        String[] stringArray;
        String[] stringArray2 = this.application.getExtsFromLinks();
        for (String string : stringArray = FrameworkCommandProcessor.getInstance().getFilteredExtPaths(stringArray2)) {
            String string2 = "conf/" + string + "/app/menu";
            MenuSet menuSet = null;
            menuSet = UIObjMng.getInstance().getApppopupMenuSetOfExtPath(string2, MENUSET_ID, string);
            if (null == menuSet) continue;
            this.storeMenuSet(menuSet);
        }
    }

    private void storeMenuSet(MenuSet menuSet) {
        if (null == menuSet) {
            return;
        }
        CommandManager.getInstance().addCommandSourceToMenuSet(menuSet, FrameworkCommandProcessor.getInstance());
        MenuManager menuManager = FrameworkUtilities.getMenuManager();
        if (null == this.menuSet) {
            this.menuSet = menuSet;
        } else {
            menuManager.mergeIndepndtMenuSet(menuSet, this.menuSet);
        }
        menuManager.setInsertIndex(FrameworkGlobalInfo.MenuStyle.INSERT_INDEX);
    }

    public MenuSet getMenuset() {
        return this.menuSet;
    }

    private void loadPluginMenus() {
        List<String> list = this.application.getNormalPluginNames();
        list = ApplicationUtilities.getFilteredStartupPlugins(list);
        for (String string : list) {
            CommStyleInfo commStyleInfo;
            Plugin plugin = PluginManager.getInstance().getPluginFromFolder(string);
            if (null == plugin) continue;
            CommStyleParser commStyleParser = plugin.getIntegrateCommStyleReader();
            Resource resource = plugin.getResource();
            if (null == commStyleParser || null == (commStyleInfo = commStyleParser.getCommStyleInfo("menu"))) continue;
            AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer(0);
            ResourceBundle resourceBundle = null;
            for (int i = 0; i < areaDescContainer.getDescContainerCount(); ++i) {
                String string2;
                DescContainer descContainer = areaDescContainer.getDescContainer(i);
                String string3 = descContainer.getParasItemValue("type");
                if ("ResourceBundle".equals(string3)) {
                    string2 = descContainer.getParasItemValue("resourceBundleName");
                    resourceBundle = resource.getResourceBundleFromPropertyFile(string2);
                } else if ("PropertyFile".equals(string3)) {
                    string2 = descContainer.getParasItemValue("resourceBundleName");
                    resourceBundle = resource.getResourceBundleFromXmlFile(string2);
                } else if ("XmlFile".equals(string3)) {
                    string2 = descContainer.getParasItemValue("resourceBundleName");
                    resourceBundle = resource.getResourceBundleFromXmlFile(string2);
                }
                commStyleInfo.setResourceBundle(resourceBundle);
            }
            MenuSet menuSet = UIObjMng.getInstance().getAppPopupMenuSet(commStyleInfo, MENUSET_ID);
            if (null == menuSet) continue;
            this.storeMenuSet(menuSet);
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public AppMenuItem getMenuItem(String string) {
        return this.getMenuItem(string, false);
    }

    public void addMenuItem(String string, AppMenuItem appMenuItem) {
        if (this.menuSet == null || appMenuItem == null) {
            return;
        }
        Menu menu = this.menuSet.getMenu(string);
        if (null == menu) {
            return;
        }
        menu.addMenuItem(appMenuItem);
        this.updateAppPopUP();
    }

    public AppMenuItem getMenuItem(String string, boolean bl) {
        Component[] componentArray;
        if (null == this.popupMenu) {
            return null;
        }
        for (Component component : componentArray = this.popupMenu.getComponents()) {
            Component component2;
            String string2;
            String string3 = string2 = component instanceof IComminiProperties ? ((IComminiProperties)((Object)component)).getID() : null;
            if (string2 != null && string2.equals(string) && component instanceof AppMenuItem) {
                return (AppMenuItem)component;
            }
            if (!(component instanceof Menu) || !bl || null == (component2 = ((Menu)component).getMenuItem(string, true)) || !(component2 instanceof AppMenuItem)) continue;
            return (AppMenuItem)component2;
        }
        return null;
    }

    public void addMenu(String string, AppMenu appMenu) {
        if (this.menuSet == null || appMenu == null) {
            return;
        }
        Menu menu = this.menuSet.getMenu(string);
        if (null != menu) {
            this.menuSet.removeMenu(menu);
        }
        this.menuSet.insertMenu(appMenu);
        this.updateAppPopUP();
    }

    public AppMenu getMenu(String string) {
        AppMenu appMenu = null;
        if (this.menuSet == null) {
            return appMenu;
        }
        appMenu = (AppMenu)this.menuSet.getMenu(string);
        return appMenu;
    }

    public void hidePopupMenu() {
        if (null == this.popupMenu || !this.popupMenu.isVisible()) {
            return;
        }
        this.popupMenu.setVisible(false);
    }

    public void addMenuItem(String string, AppCheckboxMenuItem appCheckboxMenuItem) {
        if (this.menuSet == null || appCheckboxMenuItem == null) {
            return;
        }
        Menu menu = this.menuSet.getMenu(string);
        if (null == menu) {
            return;
        }
        menu.addMenuItem(appCheckboxMenuItem);
        this.updateAppPopUP();
    }

    public void addMenuItem(String string, AppRadioButtonMenuItem appRadioButtonMenuItem) {
        if (this.menuSet == null || appRadioButtonMenuItem == null) {
            return;
        }
        Menu menu = this.menuSet.getMenu(string);
        if (null == menu) {
            return;
        }
        menu.addMenuItem(appRadioButtonMenuItem);
        this.updateAppPopUP();
    }

    public AppRadioButtonMenuItem getRadioButtonMenuItem(String string, boolean bl) {
        Component[] componentArray;
        if (null == this.popupMenu) {
            return null;
        }
        for (Component component : componentArray = this.popupMenu.getComponents()) {
            Component component2;
            String string2;
            String string3 = string2 = component instanceof IComminiProperties ? ((IComminiProperties)((Object)component)).getID() : null;
            if (string2 != null && string2.equals(string) && component instanceof AppRadioButtonMenuItem) {
                return (AppRadioButtonMenuItem)component;
            }
            if (!(component instanceof Menu) || !bl || null == (component2 = ((Menu)component).getMenuItem(string, true)) || !(component2 instanceof AppRadioButtonMenuItem)) continue;
            return (AppRadioButtonMenuItem)component2;
        }
        return null;
    }

    public AppCheckboxMenuItem getCheckBoxMenuItem(String string, boolean bl) {
        Component[] componentArray;
        if (null == this.popupMenu) {
            return null;
        }
        for (Component component : componentArray = this.popupMenu.getComponents()) {
            Component component2;
            String string2;
            String string3 = string2 = component instanceof IComminiProperties ? ((IComminiProperties)((Object)component)).getID() : null;
            if (string2 != null && string2.equals(string) && component instanceof AppCheckboxMenuItem) {
                return (AppCheckboxMenuItem)component;
            }
            if (!(component instanceof Menu) || !bl || null == (component2 = ((Menu)component).getMenuItem(string, true)) || !(component2 instanceof AppCheckboxMenuItem)) continue;
            return (AppCheckboxMenuItem)component2;
        }
        return null;
    }

    public AppMenuItemProperties getAppMenuItemProperties(String string, boolean bl) {
        Component[] componentArray;
        if (null == this.popupMenu) {
            return null;
        }
        for (Component component : componentArray = this.popupMenu.getComponents()) {
            Component component2;
            String string2;
            String string3 = string2 = component instanceof IComminiProperties ? ((IComminiProperties)((Object)component)).getID() : null;
            if (string2 != null && string2.equals(string) && component instanceof AppMenuItemProperties && ((AppMenuItemProperties)((Object)component)).getMenuType() != AppMenuItemProperties.MenuItemType.NotAItem) {
                return (AppMenuItemProperties)((Object)component);
            }
            if (!(component instanceof Menu) || !bl || null == (component2 = ((Menu)component).getMenuItem(string, true)) || !(component2 instanceof AppMenuItemProperties) || ((AppMenuItemProperties)((Object)component2)).getMenuType() == AppMenuItemProperties.MenuItemType.NotAItem) continue;
            return (AppMenuItemProperties)((Object)component2);
        }
        return null;
    }

    private DescContainer getaDesc(String string, String string2, String string3, String string4, String string5, String string6) {
        DescContainer descContainer = new DescContainer();
        descContainer.setDescName(string);
        descContainer.setParasItem("name", string2, true);
        descContainer.setParasItem("type", "JMenuItem", true);
        descContainer.setParasItem("description", string3, true);
        descContainer.setParasItem("showInPortalPanel", "true", true);
        descContainer.setParasItem("isFavourite", "false", true);
        descContainer.setParasItem("command", string5, true);
        descContainer.setParasItem("mnemonic", string4, true);
        descContainer.setParasItem("accelarator", string6, true);
        CommStyleInfo commStyleInfo = new CommStyleInfo();
        commStyleInfo.addAreaDescContainer(new AreaDescContainer());
        commStyleInfo.getAreaDescContainer()[0].addDescContainer(descContainer);
        return descContainer;
    }

    public AppMenuItem getAppMenuItem(String string, String string2, String string3, String string4, String string5, String string6, Action action) {
        AppMenuItem appMenuItem = null;
        try {
            if (null == string) {
                string = string2;
            }
            appMenuItem = new AppMenuItem(this.getaDesc(string, string2, string3, string4, string5, string6));
            if (null == string5) {
                appMenuItem.setAction(action);
            }
        }
        catch (UIObjectDescriptionNotCorrectException uIObjectDescriptionNotCorrectException) {
            uIObjectDescriptionNotCorrectException.printStackTrace();
        }
        return appMenuItem;
    }

    public AppCheckboxMenuItem getAppCheckboxMenuItem(String string, String string2, String string3, String string4, String string5, String string6, Action action) {
        AppCheckboxMenuItem appCheckboxMenuItem = null;
        try {
            if (null == string) {
                string = string2;
            }
            appCheckboxMenuItem = new AppCheckboxMenuItem(this.getaDesc(string, string2, string3, string4, string5, string6));
            if (null == string5) {
                appCheckboxMenuItem.setAction(action);
            }
        }
        catch (UIObjectDescriptionNotCorrectException uIObjectDescriptionNotCorrectException) {
            uIObjectDescriptionNotCorrectException.printStackTrace();
        }
        return appCheckboxMenuItem;
    }

    public AppRadioButtonMenuItem getAppRadioMenuItem(String string, String string2, String string3, String string4, String string5, String string6, Action action) {
        AppRadioButtonMenuItem appRadioButtonMenuItem = null;
        try {
            if (null == string) {
                string = string2;
            }
            appRadioButtonMenuItem = new AppRadioButtonMenuItem(this.getaDesc(string, string2, string3, string4, string5, string6));
            if (null == string5) {
                appRadioButtonMenuItem.setAction(action);
            }
        }
        catch (UIObjectDescriptionNotCorrectException uIObjectDescriptionNotCorrectException) {
            uIObjectDescriptionNotCorrectException.printStackTrace();
        }
        return appRadioButtonMenuItem;
    }

    public void clear() {
        if (null != this.popupMenu) {
            int n = this.popupMenu.getComponentCount();
            Component component = null;
            for (int i = 0; i < n; ++i) {
                JMenuItem jMenuItem;
                component = this.popupMenu.getComponent(i);
                if (component instanceof FoldingMenu) {
                    jMenuItem = (FoldingMenu)component;
                    ((FoldingMenu)jMenuItem).uninstallListners();
                    ((FoldingMenu)jMenuItem).removeAll();
                    ButtonUI buttonUI = jMenuItem.getUI();
                    buttonUI.uninstallUI(jMenuItem);
                    continue;
                }
                if (!(component instanceof JMenuItem)) continue;
                jMenuItem = (JMenuItem)component;
                jMenuItem.removeAll();
                jMenuItem.getUI().uninstallUI(jMenuItem);
            }
            this.popupMenu.removeAll();
            PopupMenuUI popupMenuUI = this.popupMenu.getUI();
            if (null != popupMenuUI) {
                popupMenuUI.uninstallUI(this.popupMenu);
            }
        }
    }

    private class KeyHolder {
        String name = null;
        String id = null;

        KeyHolder(String string, String string2) {
            this.name = string;
            this.id = string2;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + (this.id == null ? 0 : this.id.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            KeyHolder keyHolder = (KeyHolder)object;
            if (!this.getOuterType().equals(keyHolder.getOuterType())) {
                return false;
            }
            return !(this.id == null ? keyHolder.id != null : !this.id.equals(keyHolder.id));
        }

        public String toString() {
            return this.id + " : " + this.name;
        }

        private AppPopupMenuManager getOuterType() {
            return AppPopupMenuManager.this;
        }
    }
}

