/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement;

import com.swimap.iview.framework.applicationmanagement.AppMenu;
import com.swimap.iview.framework.applicationmanagement.AppMenuItemProperties;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JSeparator;

public class AppPopupLayout
implements LayoutManager {
    private static final int MENU_WIDTH = 220;
    private static final int MENU_HEIGHT = 28;
    private static final int OTHER_HEIGHT = 2;
    private static Dimension dim = new Dimension(220, 28);
    private static Dimension otherDim = new Dimension(220, 2);
    private int rows = 0;
    private int cols = 0;
    private int hgap = 0;
    private int vgap = 0;
    private static final int LEVEL_WIDTH = 8;
    private int colSize = 25;

    public AppPopupLayout(int n, int n2, int n3, int n4) {
        if (n == 0 && n2 == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        this.rows = n;
        this.cols = n2;
        this.hgap = n3;
        this.vgap = n4;
    }

    public AppPopupLayout(int n, int n2) {
        this(n, n2, 0, 0);
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            Insets insets = container.getInsets();
            int n2 = container.getComponentCount();
            int n3 = this.rows;
            int n4 = this.cols;
            if (n2 == 0) {
                return;
            }
            int n5 = 0;
            for (n = 0; n < n2; ++n) {
                if (container.getComponent(n) instanceof JSeparator) {
                    ++n5;
                    continue;
                }
                if (container.getComponent(n).isVisible()) continue;
                ++n5;
            }
            n = n2 - n5;
            if (n > 100) {
                n = 100;
            }
            n4 = n / this.colSize;
            int n6 = n4 = n % this.colSize == 0 ? n4 : n4 + 1;
            if (n3 > 0) {
                n4 = (n + n3 - 1) / n3;
            } else {
                n3 = (n + n4 - 1) / n4;
            }
            int n7 = container.getWidth() - (insets.left + insets.right);
            n7 = (n7 - (n4 - 1) * this.hgap) / n4;
            int n8 = 0;
            int n9 = 0;
            int n10 = insets.left;
            while (n9 < n4) {
                int n11 = insets.top;
                for (int i = 0; i < n3; ++i) {
                    if (n8 >= n2) continue;
                    Component component = container.getComponent(n8);
                    ++n8;
                    if (!component.isVisible()) {
                        --i;
                        continue;
                    }
                    if (!component.isVisible()) continue;
                    int n12 = component.getPreferredSize().height;
                    if (component instanceof AppMenuItemProperties) {
                        int n13 = ((AppMenuItemProperties)((Object)component)).getLevel();
                        if (n13 == 2) {
                            --n13;
                        }
                        ((JComponent)component).setBorder(BorderFactory.createEmptyBorder(2, n13 * 8, 2, 2));
                    }
                    if (component instanceof JSeparator) {
                        ((JSeparator)component).setBorder(BorderFactory.createEmptyBorder(2, 20, 2, 10));
                        component.setBounds(n10 + 16, n11, n7 - 22, n12);
                        --i;
                    } else {
                        component.setBounds(n10, n11, n7, n12);
                    }
                    n11 += n12 + this.vgap;
                }
                ++n9;
                n10 += n7 + this.hgap;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            return this.layoutSize(container, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            return this.layoutSize(container, false);
        }
    }

    private Dimension layoutSize(Container container, boolean bl) {
        int n;
        int n2;
        Insets insets = container.getInsets();
        int n3 = container.getComponentCount();
        int n4 = this.rows;
        int n5 = this.cols;
        int n6 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (container.getComponent(n2) instanceof JSeparator) {
                ++n6;
                continue;
            }
            if (container.getComponent(n2).isVisible()) continue;
            ++n6;
        }
        n2 = n3 - n6;
        if (n2 > 100) {
            n2 = 100;
        }
        n5 = n2 / this.colSize;
        int n7 = n5 = n2 % this.colSize == 0 ? n5 : n5 + 1;
        if (n4 > 0) {
            n5 = (n2 + n4 - 1) / n4;
        } else {
            n4 = (n2 + n5 - 1) / n5;
        }
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (int i = 0; i < n5; ++i) {
            n = 0;
            for (int j = 0; j < n4; ++j) {
                Dimension dimension;
                if (n10 >= n3) continue;
                Component component = container.getComponent(n10);
                ++n10;
                if (!component.isVisible()) {
                    --j;
                    continue;
                }
                int n11 = component.getPreferredSize().height;
                if (!component.isVisible()) continue;
                Dimension dimension2 = dimension = bl ? component.getMinimumSize() : component.getPreferredSize();
                if (component instanceof JSeparator) {
                    --j;
                }
                n += n11 + this.vgap;
                if (n9 >= dimension.width) continue;
                n9 = dimension.width;
            }
            n8 = Math.max(n8, n);
        }
        Dimension dimension = new Dimension(insets.left + insets.right + n5 * n9 + (n5 - 1) * this.hgap, insets.top + insets.bottom + n8);
        n = ScreenToolKit.getScreenWidth();
        if (dimension.width > n) {
            dimension.width = n;
        }
        return dimension;
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    public static Dimension getMenuDimension() {
        return dim;
    }

    public static Dimension getOthrDimension() {
        return otherDim;
    }

    public void setFixedSize(Component[] componentArray) {
        AppMenu appMenu = null;
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof AppMenu) || !componentArray[i].isEnabled()) continue;
            appMenu.setVisible((appMenu = (AppMenu)componentArray[i]).isShowInPortal() && appMenu.isVisible());
            appMenu.validateMenuSeparators();
            this.setFixedSize(appMenu.getMenuComponents());
        }
    }
}

