/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement;

import com.swimap.iview.framework.applicationmanagement.AppMenuSetComponent;
import com.swimap.iview.framework.applicationmanagement.Application;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.mainframe.LayoutButtonBoxEx;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkGlobalInfo;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.FlowLayout;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import org.omg.CORBA.ORB;

public class AppMenuManager
extends MenuManager {
    private static IviewLogger logger = IviewLogger.getLogger(AppMenuManager.class, "IVIEW");
    private String appId = null;

    public AppMenuManager(ModuleManager moduleManager, ORB oRB, String string, String string2, String string3, String string4) throws ModuleManagementException {
        super(moduleManager, oRB, string, string2, string3);
        this.appId = string4;
        this.moduleName = string3;
        this.init();
    }

    public AppMenuManager(ModuleManager moduleManager, String string, String string2) throws ModuleManagementException {
        this(moduleManager, null, null, null, string, string2);
    }

    @Override
    public void init() {
        this.menuSetComponent = new AppMenuSetComponent(this.appId);
    }

    @Override
    public void reinitialize() {
        try {
            this.loadMenus("conf/mainfrm/app/menu", "mainMenu");
            this.setBaseMenuSetId("mainMenu");
            this.setInsertIndex(FrameworkGlobalInfo.MenuStyle.INSERT_INDEX);
        }
        catch (Exception exception) {
            logger.error("loading menu bar is failed");
        }
        String[] stringArray = FrameworkCommandProcessor.getInstance().getExtPathsFromProductAndDefault();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.menuSetComponent.loadDynamicMenusOfExtPath("conf/" + stringArray[i] + "/app/menu", "mainMenu", stringArray[i]);
            }
        }
        Application application = ApplicationManager.getInstance().getApplication(this.appId);
        stringArray = FrameworkCommandProcessor.getInstance().getFilteredExtPaths(application.getExtsFromLinks());
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.menuSetComponent.loadDynamicMenusOfExtPath("conf/" + stringArray[i] + "/app/menu", "mainMenu", stringArray[i]);
            }
        }
        this.menuSetComponent.loadMenusFromPlugin();
        this.menuSetComponent.reinitializeMenuBar();
        FrameworkCommandProcessor frameworkCommandProcessor = FrameworkCommandProcessor.getInstance();
        this.menuSetComponent.getMenuBar().setLayout(new FlowLayout(0, 0, 0));
        this.menuSetComponent.getMenuBar().addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                if (containerEvent.getChild() instanceof LayoutButtonBoxEx) {
                    logger.debug("Unexpected event:" + containerEvent.toString() + ", child:" + containerEvent.getChild());
                    return;
                }
                ((MDIFrame)FrameworkUtilities.getMainFrame()).updateMenuBarHeight();
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                ((MDIFrame)FrameworkUtilities.getMainFrame()).updateMenuBarHeight();
            }
        });
    }

    public String getAppId() {
        return this.appId;
    }
}

