/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.MenuItem;
import com.swimap.iview.commstyle.commini.MenuItemArrowIconFactory;
import com.swimap.iview.commstyle.commini.UIObjectDescriptionNotCorrectException;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.commini.xmlbind.VALUE;
import com.swimap.iview.framework.applicationfavourites.FavouriteStateMgr;
import com.swimap.iview.framework.applicationmanagement.AppMenuItemProperties;
import com.swimap.iview.framework.applicationmanagement.AppPopupMenu;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.textfield.TipComponent;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class AppMenuItem
extends MenuItem
implements AppMenuItemProperties {
    private Boolean isFavorite = null;
    private transient MouseAdapter showPopupMenuMouseAdapter = new MouseAdapter(){

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ApplicationManager.getInstance().getFavouriteTooltip().setVisible(false);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (AppMenuItem.this.isFavourite() && AppMenuItem.this.isEnabled()) {
                if (AppMenuItem.this.getWidth() - mouseEvent.getX() <= MenuItemArrowIconFactory.getMenuItemArrowIcon().getIconWidth()) {
                    TipComponent tipComponent = ApplicationManager.getInstance().getFavouriteTooltip();
                    String string = FavouriteStateMgr.getInstance().getTooltipText(AppMenuItem.this);
                    if (!string.equals(tipComponent.getToolTipText())) {
                        tipComponent.setText(string);
                    }
                    tipComponent.setInvoker(AppMenuItem.this.getParent());
                    Point point = mouseEvent.getLocationOnScreen();
                    if (FrameworkUtilities.getMainFrame().getExtendedState() == 6) {
                        tipComponent.setLocation(point);
                    } else {
                        SwingUtilities.convertPointFromScreen(point, FrameworkUtilities.getMainFrame());
                        if (FrameworkUtilities.getMainFrame().getWidth() > point.x + tipComponent.getWidth()) {
                            tipComponent.setLocation(point);
                        } else {
                            tipComponent.setLocation(point.x - tipComponent.getWidth(), point.y);
                        }
                    }
                    int n = tipComponent.getWidth() + point.x;
                    if (n > ScreenToolKit.getScreenWidth()) {
                        tipComponent.setLocation(point.x - tipComponent.getWidth(), point.y);
                    }
                    tipComponent.setVisible(true);
                } else {
                    ApplicationManager.getInstance().getFavouriteTooltip().setVisible(false);
                }
            }
        }
    };
    int level = 0;

    public AppMenuItem() {
    }

    public AppMenuItem(DescContainer descContainer) throws UIObjectDescriptionNotCorrectException {
        super(descContainer);
        this.setMenuClickListener(FavouriteStateMgr.getInstance());
        if (this.isFavourite()) {
            this.addMouseMotionListener(this.showPopupMenuMouseAdapter);
            this.addMouseListener(this.showPopupMenuMouseAdapter);
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.getWidth() - mouseEvent.getX() <= MenuItemArrowIconFactory.getMenuItemArrowIcon().getIconWidth()) {
            return null;
        }
        return super.getToolTipText(mouseEvent);
    }

    @Override
    protected boolean isShowIcon() {
        if (null == this.isFavorite) {
            String string = this.getParaValue("isFavorite");
            this.isFavorite = "true".equalsIgnoreCase(string) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (null == this.hasArrowIconObj) {
            this.hasArrowIconObj = this.isFavorite;
        }
        return this.isFavorite;
    }

    @Override
    protected boolean isShowArrowIcon() {
        if (null == this.isFavorite) {
            return this.isShowIcon();
        }
        return this.isFavorite;
    }

    @Override
    protected boolean isEnableShortcut() {
        return this.isShowIcon();
    }

    @Override
    public boolean isShowInPortal() {
        String string = this.getParaValue("showInPortalPanel");
        return "true".equalsIgnoreCase(string);
    }

    @Override
    protected PARA getPara(String string) {
        return super.getPara(string);
    }

    @Override
    public List<String> getVisibleAppIDs() {
        VALUE[] vALUEArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        PARA pARA = this.getPara("visibleApps");
        if (null != pARA && null != (vALUEArray = pARA.getVALUE())) {
            for (VALUE vALUE : vALUEArray) {
                String string = vALUE.getValue();
                if (null == string) continue;
                arrayList.add(vALUE.getValue());
            }
        }
        return arrayList;
    }

    @Override
    public String getAPPId() {
        Component component = this.getParent();
        while (null != component) {
            if (component instanceof AppPopupMenu) {
                return ((AppPopupMenu)component).getAppID();
            }
            if (component instanceof JPopupMenu) {
                JPopupMenu jPopupMenu = (JPopupMenu)component;
                component = jPopupMenu.getInvoker();
            }
            if (null == component) continue;
            component = component.getParent();
        }
        return ApplicationManager.getInstance().getActiveAppId();
    }

    @Override
    public String getPlugin() {
        CommStyleInfo commStyleInfo = (CommStyleInfo)this.m_desc._getRootParent();
        return commStyleInfo.getPluginName();
    }

    @Override
    public String getResource() {
        CommStyleInfo commStyleInfo = (CommStyleInfo)this.m_desc._getRootParent();
        String string = null;
        String string2 = null;
        AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer(0);
        int n = areaDescContainer.getDescCount();
        for (int i = 0; i < n; ++i) {
            DescContainer descContainer = areaDescContainer.getDescContainer(i);
            String string3 = descContainer.getParasItemValue("type");
            if (!"ResourceBundle".equals(string3) && !"PropertyFile".equals(string3) && !"XmlFile".equals(string3)) continue;
            string = descContainer.getParasItemValue("resourceBundleName");
            string2 = "property";
            if (!string3.equals("XmlFile")) continue;
            string2 = "xml";
        }
        return string2 + ':' + string;
    }

    @Override
    public String getExtPath() {
        if (this.getPlugin() == null) {
            CommStyleInfo commStyleInfo = (CommStyleInfo)this.m_desc._getRootParent();
            File file = new File(commStyleInfo.getFileName());
            if (file != null) {
                for (File file2 = file.getParentFile(); file2 != null; file2 = file2.getParentFile()) {
                    if (!file2.getName().startsWith("ext_")) continue;
                    File file3 = file2.getParentFile();
                    if (file3.getName().equals("conf")) {
                        return file2.getName();
                    }
                    String string = file2.getPath().replace("\\", "/");
                    String string2 = "style/productstyle/conf/";
                    string = string.substring(string2.length());
                    return string;
                }
            }
            return "";
        }
        return "";
    }

    @Override
    protected void initAction() {
        super.initAction();
    }

    @Override
    public void createAction() {
    }

    @Override
    public boolean isFavourite() {
        boolean bl = false;
        String string = this.getParaValue("isFavorite");
        bl = "true".equalsIgnoreCase(string) ? Boolean.TRUE.booleanValue() : Boolean.FALSE.booleanValue();
        return bl;
    }

    @Override
    public AppMenuItemProperties.MenuItemType getMenuType() {
        return AppMenuItemProperties.MenuItemType.Normal;
    }

    @Override
    public boolean isCommand() {
        return this.isCommandDefined();
    }

    @Override
    public void setLevel(int n) {
        this.level = n;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public boolean isBlankInteralFrame() {
        String string = "true";
        PARA pARA = this.getPara("showBlankInternalFrame");
        if (null != pARA) {
            string = pARA.getValue();
        }
        return !string.equalsIgnoreCase("false");
    }
}

