/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationmanagement;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commandmng.CommandSource;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityAction;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityView;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.applicationmanagement.AppCheckboxMenuItem;
import com.swimap.iview.framework.applicationmanagement.AppMenuItem;
import com.swimap.iview.framework.applicationmanagement.AppMenuItemProperties;
import com.swimap.iview.framework.applicationmanagement.AppRadioButtonMenuItem;
import com.swimap.iview.framework.applicationmanagement.ApplicationLauncher;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.applicationmanagement.InvalidApplicationException;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;

public class AppMenuCmdSrc
extends CommandSource {
    private static IviewLogger logger = IviewLogger.getLogger(AppMenuCmdSrc.class);
    static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/applicationmanagement/Res");

    @Override
    public AbstractButton getButton() {
        return this.m_button;
    }

    public AppMenuCmdSrc(AbstractButton abstractButton) {
        super(abstractButton);
        if (this.m_button != null && this.m_button.getAction() != null) {
            EventListener[] eventListenerArray = this.m_button.getListeners(ActionListener.class);
            for (int i = 0; i < eventListenerArray.length; ++i) {
                if (!(eventListenerArray[i] instanceof CommandSource)) continue;
                this.m_button.removeActionListener((ActionListener)eventListenerArray[i]);
            }
            this.m_button.addActionListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_button instanceof AppMenuItemProperties) {
            AppMenuItemProperties appMenuItemProperties = (AppMenuItemProperties)((Object)this.m_button);
            boolean bl = appMenuItemProperties.isBlankInteralFrame();
            ApplicationManager.getInstance().setBlankFrame(bl);
            String string = appMenuItemProperties.getAPPId();
            try {
                if (ApplicationLauncher.getAppLauncher().isAppLaunched(string)) {
                    ApplicationManager.getInstance().showApplication(string);
                } else {
                    ApplicationManager.getInstance().launchApplication(string, true);
                }
            }
            catch (InvalidApplicationException invalidApplicationException) {
                logger.trace("Application is not launched because " + string + " not exists in application folder");
                return;
            }
            if (!ApplicationLauncher.getAppLauncher().isAppLaunched(string)) {
                logger.trace("launching the application " + string + " has failed");
                return;
            }
            boolean bl2 = appMenuItemProperties.isCommand();
            if (bl2) {
                String string2 = this.getCommand();
                if (!this.checkViewAndActionForCommand(string2)) {
                    this.showBlankFrame(string);
                    OptionPane.showErrorDialog(FrameworkUtilities.getMainFrame(), res.getString("commandFailed"));
                    return;
                }
                CommandManager.getInstance().setExceptionFlag(this.getCommand().toString(), false);
                CommandManager.getInstance().invoke(this, actionEvent);
                boolean bl3 = CommandManager.getInstance().getExceptionFlag(this.getCommand().toString());
                if (bl3) {
                    this.showBlankFrame(string);
                    CommandManager.getInstance().setExceptionFlag(this.getCommand().toString(), false);
                }
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private void showBlankFrame(String string) {
        ApplicationManager.getInstance().setBlankFrame(true);
        try {
            ApplicationManager.getInstance().showApplication(string);
        }
        catch (InvalidApplicationException invalidApplicationException) {
            logger.trace("Application is not launched");
        }
    }

    private boolean checkViewAndActionForCommand(String string) {
        AbstractAction abstractAction;
        boolean bl;
        boolean bl2;
        CommandManager commandManager = CommandManager.getInstance();
        AuthorityAction authorityAction = commandManager.getAction(string);
        if (null != authorityAction) {
            boolean bl3 = authorityAction.isActionVisible();
            bl2 = authorityAction.isActionEnabled();
            if (!bl3 || !bl2) {
                return false;
            }
        } else {
            AuthorityView authorityView = commandManager.getAuthorityViewAction(string);
            if (null != authorityView) {
                boolean bl4;
                bl2 = commandManager.securityInfoCheck(string);
                bl = authorityView.isVisible(string);
                boolean bl5 = bl4 = bl2 && authorityView.isEnabled(string);
                if (!bl || !bl4) {
                    return false;
                }
            }
        }
        if (null != (abstractAction = this.getAuthorityAction(this.m_button)) && abstractAction instanceof AuthorityAction && null != abstractAction) {
            bl2 = ((AuthorityAction)abstractAction).isActionVisible();
            bl = ((AuthorityAction)abstractAction).isActionEnabled();
            if (!bl2 || !bl) {
                return false;
            }
        }
        return true;
    }

    private AbstractAction getAuthorityAction(AbstractButton abstractButton) {
        if (abstractButton instanceof AppMenuItem) {
            return ((AppMenuItem)abstractButton).getMenuItemAction();
        }
        if (abstractButton instanceof AppRadioButtonMenuItem) {
            return ((AppRadioButtonMenuItem)abstractButton).getMenuItemAction();
        }
        if (abstractButton instanceof AppCheckboxMenuItem) {
            return ((AppCheckboxMenuItem)abstractButton).getMenuItemAction();
        }
        return null;
    }
}

