/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationfavourites;

import com.swimap.iview.framework.applicationfavourites.FavouriteConst;
import com.swimap.iview.framework.applicationfavourites.TreeNode;
import com.swimap.iview.templates.filtertreetable.AbstractTreeTableModel;
import com.swimap.iview.util.Parameter;
import java.util.HashMap;

class TreeTableViewModel
extends AbstractTreeTableModel {
    private HashMap indexMap = new HashMap(2);
    private String myfavourite = FavouriteConst.getString("myfavourite");
    private static TreeNode favroot = null;
    private String[] colNames = new String[]{"   "};
    private static TreeNode treeRoot = new TreeNode("root");

    public TreeTableViewModel() {
        super(treeRoot);
        this.setFavroot(new TreeNode(this.myfavourite));
        treeRoot.addChild(this.getFavroot());
    }

    public static void setTreeRootasEmpty() {
        treeRoot.getChildren().clear();
    }

    @Override
    public Class getColumnClass(int n) {
        if (n == 0) {
            return Parameter.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        return super.isCellEditable(object, n);
    }

    @Override
    public String getColumnName(int n) {
        return this.colNames[n];
    }

    @Override
    public Object getValueAt(Object object, int n) {
        TreeNode treeNode = (TreeNode)object;
        return treeNode.name;
    }

    @Override
    public Object getChild(Object object, int n) {
        int[] nArray = (int[])this.indexMap.get(object);
        if (nArray != null) {
            n = nArray[n];
        }
        TreeNode treeNode = (TreeNode)object;
        return treeNode.getChildren().get(n);
    }

    @Override
    public int getChildCount(Object object) {
        TreeNode treeNode = (TreeNode)object;
        return treeNode.children == null ? 0 : treeNode.getChildren().size();
    }

    @Override
    public boolean isColumnSortable(int n) {
        return true;
    }

    @Override
    public int getColumnCount() {
        return this.colNames.length;
    }

    public void refreshModel() {
        this.fireTreeStructureChanged(this, new Object[]{this.getRoot()}, null, null);
    }

    public TreeNode getFavroot() {
        return favroot;
    }

    public void setFavroot(TreeNode treeNode) {
        favroot = treeNode;
    }
}

