/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationfavourites;

import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.framework.applicationfavourites.FavouriteButton;
import com.swimap.iview.framework.applicationfavourites.FavouriteConst;
import com.swimap.iview.framework.applicationfavourites.FavouriteExp;
import com.swimap.iview.framework.applicationfavourites.FavouriteMsgDialog;
import com.swimap.iview.framework.applicationfavourites.FavouritePanel;
import com.swimap.iview.framework.applicationfavourites.FavouriteParser;
import com.swimap.iview.framework.applicationfavourites.FavouriteStateMgr;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class FavouriteUI {
    private String myfavourite = FavouriteConst.getString("myfavourite");
    private FavouritePanel favPanel = null;
    private static FavouriteUI ui = new FavouriteUI();
    private static IviewLogger logger = IviewLogger.getLogger(FavouriteUI.class);

    public static FavouriteUI getInstance() {
        return ui;
    }

    public JSplitPane getFavouriteSplitPanel(Dimension dimension) {
        if (null == this.favPanel) {
            this.jbInit(dimension);
        }
        this.favPanel.init();
        return this.favPanel.getSplitPane();
    }

    @Deprecated
    public JScrollPane getFavouritePanel(Dimension dimension) {
        if (null == this.favPanel) {
            this.jbInit(dimension);
        }
        this.favPanel.init();
        return this.favPanel.getScrollPane();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFavourite(DescContainer descContainer) {
        block9: {
            try {
                this.favPanel.setCursor(Cursor.getPredefinedCursor(3));
                boolean bl = FavouriteStateMgr.getInstance().isAllowAddOper();
                if (bl) {
                    try {
                        logger.debug("Adding favourites " + descContainer);
                        FavouriteParser.getInstance().addFavourite(descContainer);
                        boolean bl2 = Boolean.parseBoolean(descContainer.getParasItemValue("isExecutable"));
                        if (!bl2 || this.favPanel.getPopupPoint() == null) {
                            this.favPanel.setPopupPoint(new Point(0, 0));
                        }
                        FavouriteButton favouriteButton = FavouriteButton.getUIObject(descContainer);
                        boolean bl3 = FavouriteStateMgr.getInstance().addButton(favouriteButton);
                        if (!bl3) {
                            throw new FavouriteExp("Button already present");
                        }
                        this.favPanel.refreshPanel(FavouritePanel.getSelectedFolder());
                        FavouriteStateMgr.getInstance().saveState();
                        break block9;
                    }
                    catch (FavouriteExp favouriteExp) {
                        logger.error("Failed to add favourite ");
                        boolean bl4 = false;
                        this.favPanel.setCursor(Cursor.getDefaultCursor());
                        return bl4;
                    }
                }
                logger.error("Favourite addition not allowed");
                FavouriteMsgDialog.showErrorDialog(FavouriteConst.getString("FavouriteMsg.Error"), FavouriteConst.getString("ExceedMaxLimit"), null);
                boolean bl5 = false;
                return bl5;
            }
            finally {
                this.favPanel.setCursor(Cursor.getDefaultCursor());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFavourite(DescContainer descContainer, String string) {
        block9: {
            try {
                this.favPanel.setCursor(Cursor.getPredefinedCursor(3));
                boolean bl = FavouriteStateMgr.getInstance().isAllowAddOper();
                if (bl) {
                    try {
                        logger.debug("Adding favourites " + descContainer);
                        FavouriteParser.getInstance().addFavourite(descContainer);
                        boolean bl2 = Boolean.parseBoolean(descContainer.getParasItemValue("isExecutable"));
                        if (!bl2 || this.favPanel.getPopupPoint() == null) {
                            this.favPanel.setPopupPoint(new Point(0, 0));
                        }
                        FavouriteButton favouriteButton = FavouriteButton.getUIObject(descContainer);
                        FavouriteStateMgr.getInstance().addButtonToFolder(string, favouriteButton);
                        if (favouriteButton.isVisible()) {
                            FavouriteStateMgr.getInstance().addToMenu(string, favouriteButton);
                        }
                        FavouriteStateMgr.getInstance().addButton(favouriteButton);
                        this.favPanel.refreshPanel(FavouritePanel.getSelectedFolder());
                        FavouriteStateMgr.getInstance().saveState();
                        break block9;
                    }
                    catch (FavouriteExp favouriteExp) {
                        logger.error("Failed to add favourite ");
                        boolean bl3 = false;
                        this.favPanel.setCursor(Cursor.getDefaultCursor());
                        return bl3;
                    }
                }
                logger.error("Favourite addition not allowed");
                FavouriteMsgDialog.showErrorDialog(FavouriteConst.getString("FavouriteMsg.Error"), FavouriteConst.getString("ExceedMaxLimit"), null);
                boolean bl4 = false;
                return bl4;
            }
            finally {
                this.favPanel.setCursor(Cursor.getDefaultCursor());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteAll() {
        boolean bl = true;
        try {
            this.favPanel.setCursor(Cursor.getPredefinedCursor(3));
            List<FavouriteButton> list = FavouriteStateMgr.getInstance().getSelectedButtons();
            for (FavouriteButton favouriteButton : list) {
                try {
                    logger.debug("Deleting favourite " + favouriteButton.getDescName());
                    FavouriteParser.getInstance().delFavourite(favouriteButton.getDescName());
                    FavouriteStateMgr.getInstance().delButton(favouriteButton.getDescContainer());
                    favouriteButton.remove();
                }
                catch (FavouriteExp favouriteExp) {
                    logger.error("Failed to delete " + favouriteButton.getDescName());
                    bl = false;
                }
            }
            this.favPanel.refreshPanel(this.myfavourite);
            FavouriteStateMgr.getInstance().saveState();
        }
        finally {
            this.favPanel.setCursor(Cursor.getDefaultCursor());
        }
        return bl;
    }

    public boolean delFavourite(DescContainer descContainer) {
        this.favPanel.setCursor(Cursor.getPredefinedCursor(3));
        logger.debug("Deleting favourite " + descContainer);
        FavouriteStateMgr.getInstance().delButton(descContainer);
        this.favPanel.refreshPanel(FavouritePanel.getSelectedFolder());
        FavouriteStateMgr.getInstance().saveState();
        this.favPanel.setCursor(Cursor.getDefaultCursor());
        return true;
    }

    @Deprecated
    public boolean delFavourite(String string) {
        this.favPanel.setCursor(Cursor.getPredefinedCursor(3));
        logger.debug("Deleting favourite " + string);
        FavouriteStateMgr.getInstance().delButton(string);
        this.favPanel.refreshPanel(FavouritePanel.getSelectedFolder());
        FavouriteStateMgr.getInstance().saveState();
        this.favPanel.setCursor(Cursor.getDefaultCursor());
        return true;
    }

    public void initPanel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FavouriteUI.this.initilizeBUttons();
            }
        });
    }

    private void initilizeBUttons() {
        if (null != this.favPanel) {
            ArrayList<FavouriteButton> arrayList = new ArrayList<FavouriteButton>(2);
            Collection<DescContainer> collection = FavouriteParser.getInstance().getAllFavourites();
            for (DescContainer descContainer : collection) {
                FavouriteButton favouriteButton = FavouriteButton.getUIObject(descContainer);
                arrayList.add(favouriteButton);
            }
            FavouriteStateMgr.getInstance().setContainer(FavouriteParser.getInstance().getAllFavouriteBs());
        }
    }

    public void save() {
        FavouritePanel favouritePanel = FavouriteUI.getInstance().getPanel();
        if (null != favouritePanel) {
            FavouriteParser.getInstance().updateToFile();
        }
    }

    public void clear() {
        if (null != this.favPanel) {
            this.favPanel.removeAll();
        }
        this.favPanel = null;
        FavouriteParser.setNullInstance();
        FavouriteStateMgr.setNullInstance();
    }

    private void jbInit(Dimension dimension) {
        this.favPanel = new FavouritePanel(dimension);
    }

    private FavouriteUI() {
    }

    FavouritePanel getPanel() {
        return this.favPanel;
    }
}

