/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationfavourites;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityAction;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityView;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.applicationfavourites.FavouriteButton;
import com.swimap.iview.framework.applicationfavourites.FavouriteConst;
import com.swimap.iview.framework.applicationfavourites.FavouriteExp;
import com.swimap.iview.framework.applicationfavourites.FavouritePanel;
import com.swimap.iview.framework.applicationfavourites.FavouriteStateMgr;
import com.swimap.iview.framework.applicationfavourites.FavouriteUI;
import com.swimap.iview.framework.applicationfavourites.MenuScroller;
import com.swimap.iview.framework.applicationmanagement.AppPopupMenuManager;
import com.swimap.iview.framework.applicationmanagement.Application;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.applicationmanagement.ApplicationUtilities;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.util.LinkUtil;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public final class FavouriteParser {
    private String myfavourite = FavouriteConst.getString("myfavourite");
    private String favourite = FavouriteConst.getString("favourite");
    private static IviewLogger logger = IviewLogger.getLogger(FavouriteParser.class);
    private Map<String, DescContainer> favList = new LinkedHashMap<String, DescContainer>();
    private List<FavouriteButton> fbList = new ArrayList<FavouriteButton>();
    private static FavouriteParser instance = null;
    private CommStyleInfo favouriteInfo = null;
    private DescContainer execDescContainer = null;
    private DescContainer cmdDescContainer = null;
    private int[] available = new int[200];
    private JMenu favMenu = new JMenu(this.favourite);
    private static final String FAV_MENU_SETID = "mainMenu";

    public static void setNullInstance() {
        if (null != instance) {
            if (FavouriteParser.instance.cmdDescContainer != null) {
                FavouriteParser.instance.cmdDescContainer.clear();
            }
            FavouriteParser.instance.cmdDescContainer = null;
            if (FavouriteParser.instance.execDescContainer != null) {
                FavouriteParser.instance.execDescContainer.clear();
            }
            FavouriteParser.instance.execDescContainer = null;
        }
        instance = null;
    }

    public String addFavourite(DescContainer descContainer) throws FavouriteExp {
        if (null == descContainer) {
            logger.error("Desc is null");
            throw new FavouriteExp("Desc is null");
        }
        String string = this.getPara(descContainer.getParasItem("isExecutable"));
        if (!(string = string.trim()).equalsIgnoreCase("true") && !string.equalsIgnoreCase("false")) {
            logger.error("Failed to get executable type " + descContainer.getDescName());
            throw new FavouriteExp("Failed to get executable type");
        }
        boolean bl = Boolean.parseBoolean(string);
        this.parseDesc(descContainer, bl, true);
        this.favList.put(descContainer.getDescName(), descContainer);
        return descContainer.getDescName();
    }

    public void delFavourite(String string) throws FavouriteExp {
        if (null == this.favList.get(string)) {
            logger.error("Favourite not found " + string);
            throw new FavouriteExp("Favourite Not found");
        }
        DescContainer descContainer = this.favList.remove(string);
        this.fbList.remove(FavouriteButton.getUIObject(descContainer));
    }

    public Collection<DescContainer> getAllFavourites() {
        return Collections.unmodifiableCollection(this.favList.values());
    }

    public List<FavouriteButton> getAllFavouriteBs() {
        return this.fbList;
    }

    public static FavouriteParser getInstance() {
        if (null == instance) {
            logger.trace("Instance begin ");
            instance = new FavouriteParser();
            logger.trace("Instance end ");
        }
        return instance;
    }

    public void updateToFile() {
        logger.trace("Save favourites.xml start ");
        this.fbList.clear();
        FavouriteStateMgr.getInstance().writeFavToFile();
        FavouritePanel.setSelectedFolder(FavouriteConst.getString("myfavourite"));
        this.favMenu.removeAll();
        FavouriteStateMgr.getInstance().clearVal();
        FavouritePanel.setNoOfUserFolder(0);
        FavouriteStateMgr.getInstance().setTotalCount(0);
        FavouriteUI.getInstance().getPanel().removeAllNodes();
        FavouriteStateMgr.getInstance().clearFavouriteMap();
        logger.trace("Save favourites.xml end ");
    }

    public Map<String, String> getInfo(String string, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>(5);
        if (null == string || null == stringArray || stringArray.length == 0) {
            logger.error("Invalid input parameters");
            return hashMap;
        }
        DescContainer descContainer = this.favList.get(string);
        if (null != descContainer) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].trim().isEmpty()) continue;
                hashMap.put(stringArray[i].trim(), descContainer.getParasItemValue(stringArray[i].trim()));
            }
        }
        return hashMap;
    }

    private synchronized int getNumber() throws FavouriteExp {
        int n = 0;
        boolean bl = false;
        for (n = 0; n < this.available.length; ++n) {
            if (this.available[n] != 0) continue;
            this.available[n] = 1;
            bl = true;
            break;
        }
        if (!bl) {
            logger.warn("Favourites reached maximum");
            throw new FavouriteExp("Favourites reached maximum");
        }
        return n;
    }

    private synchronized void setNumber(int n) {
        if (n >= 0 && n < 200) {
            this.available[n] = 0;
        }
    }

    private FavouriteParser() {
        FavouriteUI.getInstance().getPanel().initializeFolders();
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        CommStyleInfo commStyleInfo = commStyleManager.getUserCommonStyleFile("favourites");
        if (null != commStyleInfo) {
            AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer(0);
            DescContainer descContainer = areaDescContainer.getDescContainer("favourites");
            if (null != descContainer) {
                DescContainer descContainer2 = descContainer.getDescContainer("commands");
                int n = descContainer2.getDescContainerCount();
                for (int i = 0; i < n; ++i) {
                    DescContainer descContainer3 = descContainer2.getDescContainer(i);
                    try {
                        this.parseDesc(descContainer3, false, true);
                        FavouriteButton favouriteButton = FavouriteButton.getUIObject(descContainer3);
                        FavouriteStateMgr.getInstance().addButtonToFolder(this.myfavourite, favouriteButton);
                        this.favList.put(descContainer3.getDescName(), descContainer3);
                        this.fbList.add(favouriteButton);
                        continue;
                    }
                    catch (FavouriteExp favouriteExp) {
                        logger.error("Removing favourite " + favouriteExp.getMessage());
                        descContainer3.removeDescContainer(descContainer3);
                    }
                }
            } else {
                this.initialise();
            }
        } else {
            commStyleInfo = new CommStyleInfo();
            commStyleInfo.setFileName(CommStyleManager.getInstance().getUserDir() + "favourites.xml");
            AreaDescContainer areaDescContainer = new AreaDescContainer();
            commStyleInfo.setAreaDescContainer(areaDescContainer, true);
            DescContainer descContainer = new DescContainer();
            descContainer.setDescName("My Favourites");
            areaDescContainer.addDescContainer(descContainer);
            this.setParaValue("name", this.myfavourite, descContainer);
            this.setParaValue("type", "JMenu", descContainer);
        }
        CommStyleManager.getInstance().writeToUser(commStyleInfo);
        this.createFavouriteMenu();
    }

    private void createFavouriteMenu() {
        ArrayList arrayList;
        Object object;
        Object object2;
        CharSequence charSequence;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        this.favMenu.removeAll();
        char[] cArray = new char[]{};
        int n = this.calculateMenuHeight();
        this.addNoneMenu();
        MenuScroller.setScrollerFor(this.favMenu, n, 200);
        int n2 = FavouriteStateMgr.getInstance().valSize();
        Map map = FavouriteStateMgr.getInstance().getFolderMap();
        for (int i = 1; i < n2; ++i) {
            object6 = new StringBuffer();
            if (FavouriteStateMgr.getInstance().getValElementAt(i).length() > 50) {
                object6 = ((StringBuffer)object6).append(FavouriteStateMgr.getInstance().getValElementAt(i).substring(0, 50));
                ((StringBuffer)object6).append("...");
            } else {
                ((StringBuffer)object6).append(FavouriteStateMgr.getInstance().getValElementAt(i));
            }
            object5 = new JMenu(((StringBuffer)object6).toString());
            MenuScroller.setScrollerFor((JMenu)object5, n - 1, 200);
            List list = (List)map.get(FavouriteStateMgr.getInstance().getValElementAt(i));
            if (null != list) {
                if (list.size() == 0) {
                    object4 = new JMenuItem(FavouriteConst.getString("None"));
                    ((JMenu)object5).add((JMenuItem)object4);
                    ((JMenuItem)object4).setEnabled(false);
                } else {
                    object4 = null;
                    object3 = null;
                    for (int j = 0; j < list.size(); ++j) {
                        charSequence = ((FavouriteButton)list.get(j)).getDescContainer().getParasItemValue("AppId");
                        object4 = ApplicationManager.getInstance().getApplication((String)charSequence);
                        if (null == object4 || null == (object3 = ((Application)object4).getPopupMenuManager()) || (object2 = ((AppPopupMenuManager)object3).getAppMenuItemProperties(((FavouriteButton)list.get(j)).getDescContainer().getParasItemValue("menuid"), true)) == null) continue;
                        object = object2.getParaValue("mnemonic");
                        if (object != null) {
                            cArray = ((String)object).toCharArray();
                        }
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(((FavouriteButton)list.get(j)).getFunctionName());
                        if (ResourceMng.getInstance().getLocaleString().equalsIgnoreCase("zh_cn")) {
                            stringBuffer.append("(");
                            if (cArray.length > 0) {
                                stringBuffer.append(cArray[0]);
                            }
                            stringBuffer.append(")");
                        }
                        String string = stringBuffer.toString();
                        JMenuItem jMenuItem = new JMenuItem(string);
                        jMenuItem.addActionListener(new FavMenuActionListener((FavouriteButton)list.get(j)));
                        ((JMenu)object5).add(jMenuItem);
                        if (cArray.length <= 0) continue;
                        jMenuItem.setMnemonic(cArray[0]);
                    }
                }
            } else {
                object4 = new JMenuItem(FavouriteConst.getString("None"));
                ((JMenu)object5).add((JMenuItem)object4);
                ((JMenuItem)object4).setEnabled(false);
            }
            this.removeNoneMenu();
            this.favMenu.add((JMenuItem)object5);
        }
        if (n2 > 1) {
            this.favMenu.add(new JSeparator());
        }
        if (null == map.get(this.myfavourite)) {
            ArrayList arrayList2 = new ArrayList(10);
            map.put(this.myfavourite, arrayList2);
        }
        if ((arrayList = (ArrayList)map.get(this.myfavourite)).size() > 0 || n2 > 1) {
            this.favMenu.setEnabled(true);
        }
        object6 = null;
        object5 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            object4 = ((FavouriteButton)arrayList.get(i)).getDescContainer().getParasItemValue("AppId");
            object6 = ApplicationManager.getInstance().getApplication((String)object4);
            if (null == object6 || null == (object5 = ((Application)object6).getPopupMenuManager()) || null == (object3 = ((AppPopupMenuManager)object5).getAppMenuItemProperties(((FavouriteButton)arrayList.get(i)).getDescContainer().getParasItemValue("menuid"), true))) continue;
            String string = object3.getParaValue("mnemonic");
            if (string != null) {
                cArray = string.toCharArray();
            }
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(((FavouriteButton)arrayList.get(i)).getFunctionName());
            if (ResourceMng.getInstance().getLocaleString().equalsIgnoreCase("zh_cn")) {
                ((StringBuffer)charSequence).append("(");
                if (cArray.length > 0) {
                    ((StringBuffer)charSequence).append(cArray[0]);
                }
                ((StringBuffer)charSequence).append(")");
            }
            object2 = ((StringBuffer)charSequence).toString();
            object = new JMenuItem((String)object2);
            ((AbstractButton)object).addActionListener(new FavMenuActionListener((FavouriteButton)arrayList.get(i)));
            if (cArray.length > 0) {
                ((AbstractButton)object).setMnemonic(cArray[0]);
            }
            this.removeNoneMenu();
            this.favMenu.add((JMenuItem)object);
        }
        MenuManager menuManager = FrameworkUtilities.getMenuManager();
        this.favMenu.setMnemonic('Y');
        menuManager.addMenu(this.favMenu);
        this.favMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                FavouriteParser.this.checkForVisibility();
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
    }

    protected void addNoneMenu() {
        JMenuItem jMenuItem = new JMenuItem(FavouriteConst.getString("None"));
        this.favMenu.add(jMenuItem);
        jMenuItem.setEnabled(false);
    }

    protected void removeNoneMenu() {
        Component[] componentArray;
        for (Component component : componentArray = this.favMenu.getMenuComponents()) {
            JMenuItem jMenuItem;
            String string;
            if (!(component instanceof JMenuItem) || !(string = (jMenuItem = (JMenuItem)component).getText()).equals(FavouriteConst.getString("None"))) continue;
            this.favMenu.remove(jMenuItem);
        }
    }

    protected void checkForVisibility() {
        int n;
        int n2;
        Map map = FavouriteStateMgr.getInstance().getFolderMap();
        List list = (List)map.get(FavouriteStateMgr.getInstance().getValElementAt(0));
        int n3 = FavouriteStateMgr.getInstance().getVal().size();
        for (n2 = 0; n2 < list.size(); ++n2) {
            JMenuItem jMenuItem;
            JMenuItem jMenuItem2;
            String string;
            boolean bl = this.isVisible((FavouriteButton)list.get(n2));
            n = this.isEnabled((FavouriteButton)list.get(n2));
            Component[] componentArray = this.favMenu.getMenuComponents();
            if (!bl) {
                for (Component component : componentArray) {
                    if (!(component instanceof JMenuItem) || !(string = (jMenuItem2 = (JMenuItem)component).getText()).equals(((FavouriteButton)list.get(n2)).localeName((FavouriteButton)list.get(n2)))) continue;
                    jMenuItem = (JMenuItem)component;
                    jMenuItem.setVisible(false);
                }
            }
            if (n != 0) continue;
            for (Component component : componentArray) {
                if (!(component instanceof JMenuItem) || !(string = (jMenuItem2 = (JMenuItem)component).getText()).equals(((FavouriteButton)list.get(n2)).localeName((FavouriteButton)list.get(n2)))) continue;
                jMenuItem = (JMenuItem)component;
                jMenuItem.setEnabled(false);
            }
        }
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            List list2 = (List)map.get(FavouriteStateMgr.getInstance().getValElementAt(n2 + 1));
            if (list2 == null) continue;
            for (n = 0; n < list2.size(); ++n) {
                Component[] componentArray;
                JMenuItem jMenuItem;
                JMenuItem jMenuItem3;
                String string;
                Component component;
                int n4;
                boolean bl = this.isVisible((FavouriteButton)list2.get(n));
                boolean bl2 = this.isEnabled((FavouriteButton)list2.get(n));
                Component component2 = this.favMenu.getMenuComponent(n2);
                if (!(component2 instanceof JMenu)) continue;
                JMenu jMenu = (JMenu)component2;
                if (!bl) {
                    Component[] componentArray2;
                    Component[] componentArray3 = componentArray2 = jMenu.getMenuComponents();
                    int n5 = componentArray3.length;
                    for (n4 = 0; n4 < n5; ++n4) {
                        component = componentArray3[n4];
                        if (!(component instanceof JMenuItem) || !(string = (jMenuItem3 = (JMenuItem)component).getText()).equals(((FavouriteButton)list2.get(n)).localeName((FavouriteButton)list2.get(n)))) continue;
                        jMenuItem = (JMenuItem)component;
                        jMenuItem.setVisible(false);
                    }
                }
                if (!bl2) {
                    Component[] componentArray4;
                    Component[] componentArray5 = componentArray4 = jMenu.getMenuComponents();
                    int n6 = componentArray5.length;
                    for (n4 = 0; n4 < n6; ++n4) {
                        component = componentArray5[n4];
                        if (!(component instanceof JMenuItem) || !(string = (jMenuItem3 = (JMenuItem)component).getText()).equals(((FavouriteButton)list2.get(n)).localeName((FavouriteButton)list2.get(n)))) continue;
                        jMenuItem = (JMenuItem)component;
                        jMenuItem.setEnabled(false);
                    }
                }
                Component[] componentArray6 = componentArray = jMenu.getMenuComponents();
                int n7 = componentArray6.length;
                for (n4 = 0; n4 < n7; ++n4) {
                    component = componentArray6[n4];
                    if (!(component instanceof JMenuItem) || !(string = (jMenuItem3 = (JMenuItem)component).getText()).equals(FavouriteConst.getString("None"))) continue;
                    jMenu.remove(jMenuItem3);
                }
                boolean bl3 = this.checkForVisibility(jMenu.getText());
                if (bl3) continue;
                JMenuItem jMenuItem4 = new JMenuItem(FavouriteConst.getString("None"));
                jMenuItem4.setEnabled(false);
                jMenu.add(jMenuItem4);
            }
        }
    }

    private boolean checkForVisibility(String string) {
        Map map = FavouriteStateMgr.getInstance().getFolderMap();
        ArrayList arrayList = (ArrayList)map.get(string);
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                boolean bl = ((FavouriteButton)arrayList.get(i)).isVisible();
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isVisible(FavouriteButton favouriteButton) {
        boolean bl = favouriteButton.isVisible();
        try {
            AuthorityAction authorityAction = null;
            if (null == favouriteButton.getAction()) {
                favouriteButton.initAction(favouriteButton);
            }
            if (null != (authorityAction = favouriteButton.getAction())) {
                bl = authorityAction.isActionVisible();
            } else {
                String string = favouriteButton.getCommand();
                CommandManager commandManager = CommandManager.getInstance();
                AuthorityView authorityView = commandManager.getAuthorityViewAction(string);
                if (null != authorityView) {
                    bl = authorityView.isVisible(string);
                }
            }
        }
        catch (Throwable throwable) {
            logger.trace("IView Handled Error while updating  Visibilityof Favouritebuttons " + favouriteButton.getButtonName(), throwable);
        }
        return bl;
    }

    private boolean isEnabled(FavouriteButton favouriteButton) {
        boolean bl = favouriteButton.isEnabled();
        try {
            AuthorityAction authorityAction = null;
            if (null == favouriteButton.getAction()) {
                favouriteButton.initAction(favouriteButton);
            }
            if (null != (authorityAction = favouriteButton.getAction())) {
                bl = authorityAction.isActionEnabled();
            } else {
                String string = favouriteButton.getCommand();
                CommandManager commandManager = CommandManager.getInstance();
                AuthorityView authorityView = commandManager.getAuthorityViewAction(string);
                if (null != authorityView) {
                    boolean bl2 = commandManager.securityInfoCheck(string);
                    bl = authorityView.isEnabled(string);
                    bl = bl2 && bl;
                }
            }
        }
        catch (Throwable throwable) {
            logger.trace("IView Handled Error while updating  Visibilityof Favouritebuttons " + favouriteButton.getButtonName(), throwable);
        }
        return bl;
    }

    private int calculateMenuHeight() {
        int n = 23;
        int n2 = (ScreenToolKit.getScreenHeight() - 30) / n;
        return n2;
    }

    public void validateFavMenu() {
        this.favMenu.getPopupMenu().pack();
        this.favMenu.getPopupMenu().repaint();
    }

    public void renameMenu(String string, String string2) {
        Component[] componentArray;
        for (Component component : componentArray = this.favMenu.getMenuComponents()) {
            JMenu jMenu;
            String string3;
            if (!(component instanceof JMenu) || !(string3 = (jMenu = (JMenu)component).getText()).equals(string)) continue;
            jMenu.setText(string2);
            break;
        }
    }

    private void setParaValue(String string, String string2, DescContainer descContainer) {
        String string3;
        if (string2 == null) {
            string2 = "";
        }
        if (null == (string3 = descContainer.getParasItemValue(string))) {
            PARA pARA = new PARA();
            pARA.setName(string);
            pARA.setValue(string2);
            descContainer.addParasItem(pARA);
        } else {
            descContainer.setParasItem(string, string2);
        }
    }

    private void initialise() {
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        CommStyleInfo commStyleInfo = commStyleManager.getUserCommonStyleFile("favourites");
        AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer(0);
        DescContainer descContainer = areaDescContainer.getDescContainer("My Favourites");
        FavouriteStateMgr.getInstance().clearFavouriteMap();
        int n = descContainer.getDescContainerCount();
        for (int i = 0; i < n; ++i) {
            DescContainer descContainer2 = descContainer.getDescContainer(i);
            String string = descContainer2.getParasItemValue("type");
            if (null == string) {
                string = "JMenuItem";
            }
            if (string.equals("JMenuItem")) {
                try {
                    this.parseDesc(descContainer2, false, false);
                    FavouriteButton favouriteButton = FavouriteButton.getUIObject(descContainer2);
                    FavouriteStateMgr.getInstance().addButtonToFolder(this.myfavourite, favouriteButton);
                    this.favList.put(descContainer2.getDescName(), descContainer2);
                    this.fbList.add(favouriteButton);
                }
                catch (FavouriteExp favouriteExp) {
                    logger.error("Removing favourite " + favouriteExp.getMessage());
                    descContainer2.removeDescContainer(descContainer2);
                }
                continue;
            }
            this.addFavouriteFromFavMenu(descContainer2, descContainer2.getDescContainer(), false);
        }
    }

    private String getPara(PARA pARA) {
        String string = "";
        if (null != pARA) {
            string = pARA.getValue() == null ? "" : pARA.getValue().trim();
        }
        return string;
    }

    public void validate(String string, String string2, String string3, String string4, boolean bl, String string5) throws FavouriteExp {
        if (!bl) {
            Object object;
            Application application = null;
            if (null != string) {
                string = string.trim();
                application = ApplicationManager.getInstance().getApplication(string);
            }
            if (null == application) {
                logger.error("Application not found " + string);
                throw new FavouriteExp("Favourites application not found");
            }
            String string6 = null == string3 ? "" : string3.trim();
            List<String> list = null;
            if (string6.contains("ext_")) {
                list = application.getAllLinks();
                object = new ArrayList<String>();
                for (String string7 : list) {
                    object.addAll(LinkUtil.getExts(string7));
                }
                list = object;
            } else {
                object = ApplicationUtilities.getFilteredStartupPlugins(application.getNormalPluginNames());
                list = object;
            }
            if (list == null || !list.contains(string6)) {
                logger.error("Plugin for application not found " + string6);
                throw new FavouriteExp("Plugin for application not found ");
            }
            Object object2 = object = null == string4 ? "" : string4.trim();
            if (((String)object).isEmpty()) {
                logger.error("Invalid Menuid");
                throw new FavouriteExp("Invalid Resource Descriptor " + string4);
            }
        }
        boolean bl2 = false;
        if (null == string2 || string2.trim().isEmpty()) {
            logger.warn("Invalid command " + string2);
            bl2 = true;
        }
        if (bl2 && (null == string5 || string5.trim().isEmpty())) {
            logger.error("Invalid Action " + string5);
            throw new FavouriteExp("Invalid Action ");
        }
    }

    private void parseDesc(DescContainer descContainer, boolean bl, boolean bl2) throws FavouriteExp {
        String string = this.getPara(descContainer.getParasItem("name"));
        String string2 = this.getPara(descContainer.getParasItem("AppId"));
        String string3 = this.getPara(descContainer.getParasItem("pluginid"));
        String string4 = this.getPara(descContainer.getParasItem("menuid"));
        String string5 = this.getPara(descContainer.getParasItem("description"));
        String string6 = this.getPara(descContainer.getParasItem("command"));
        String string7 = this.getPara(descContainer.getParasItem("icon"));
        String string8 = this.getPara(descContainer.getParasItem("action"));
        if (bl) {
            string2 = "Executable";
            string3 = "";
            string4 = "";
        }
        String string9 = this.getPara(descContainer.getParasItem("xIndex"));
        String string10 = this.getPara(descContainer.getParasItem("yIndex"));
        if (bl2) {
            this.validate(string2, string6, string3, string4, bl, string8);
        }
        try {
            Integer.parseInt(string9);
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn("Failed to get X value " + string);
            string9 = "-1";
        }
        try {
            Integer.parseInt(string10);
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn("Failed to get Y value " + string);
            string10 = "-1";
        }
        string = string.isEmpty() ? string2 + '_' + string6 : string;
        string7 = null == string7 ? "" : string7.trim();
        descContainer.setParasItem("AppId", string2, false);
        descContainer.setParasItem("pluginid", string3, false);
        descContainer.setParasItem("menuid", string4, false);
        descContainer.setParasItem("description", string5, true);
        descContainer.setParasItem("name", string, true);
        descContainer.setParasItem("isExecutable", String.valueOf(bl), true);
        descContainer.setParasItem("xIndex", string9, true);
        descContainer.setParasItem("yIndex", string10, true);
        descContainer.setParasItem("icon", string7, true);
        descContainer.setParasItem("command", string6.trim(), true);
        descContainer.setParasItem("action", string8.trim(), true);
        FavouriteButton favouriteButton = FavouriteButton.getUIObject(descContainer);
        descContainer.setDescName(favouriteButton.getFunctionName());
    }

    private void addFavouriteFromFavMenu(DescContainer descContainer, DescContainer[] descContainerArray, boolean bl) {
        if (null == descContainerArray) {
            logger.debug("No Elements in descArray");
            return;
        }
        if (descContainerArray.length == 0) {
            FavouriteStateMgr.getInstance().addButtonToFolder(descContainer.getDescName(), null);
        }
        for (int i = 0; i < descContainerArray.length; ++i) {
            try {
                if (null == descContainerArray[i]) continue;
                this.parseDesc(descContainerArray[i], bl, false);
                this.favList.put(descContainerArray[i].getDescName(), descContainerArray[i]);
                FavouriteButton favouriteButton = FavouriteButton.getUIObject(descContainerArray[i]);
                FavouriteStateMgr.getInstance().addButtonToFolder(descContainer.getDescName(), favouriteButton);
                this.fbList.add(favouriteButton);
                continue;
            }
            catch (FavouriteExp favouriteExp) {
                logger.error("Removing favourite " + favouriteExp.getMessage());
                descContainer.removeDescContainer(descContainerArray[i]);
            }
        }
    }

    public JMenu getFavMenu() {
        return this.favMenu;
    }

    public class FavMenuActionListener
    implements ActionListener {
        FavouriteButton fb = null;

        FavMenuActionListener(FavouriteButton favouriteButton) {
            this.fb = favouriteButton;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.fb.processClick(this.fb);
        }
    }
}

