/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationfavourites;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityAction;
import com.swimap.iview.commstyle.commandmng.authority.AuthorityView;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.IComminiProperties;
import com.swimap.iview.commstyle.commini.Menu;
import com.swimap.iview.commstyle.commini.MenuSet;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.applicationfavourites.FavTreecolRender;
import com.swimap.iview.framework.applicationfavourites.FavouriteButton;
import com.swimap.iview.framework.applicationfavourites.FavouriteConst;
import com.swimap.iview.framework.applicationfavourites.FavouriteMsgDialog;
import com.swimap.iview.framework.applicationfavourites.FavouriteParser;
import com.swimap.iview.framework.applicationfavourites.FavouriteStateMgr;
import com.swimap.iview.framework.applicationfavourites.FavouriteUI;
import com.swimap.iview.framework.applicationfavourites.MenuScroller;
import com.swimap.iview.framework.applicationfavourites.TreeNode;
import com.swimap.iview.framework.applicationfavourites.TreeTable;
import com.swimap.iview.framework.applicationfavourites.TreeTableViewModel;
import com.swimap.iview.framework.applicationmanagement.AppMenuItemProperties;
import com.swimap.iview.framework.applicationmanagement.AppPopupMenuManager;
import com.swimap.iview.framework.applicationmanagement.Application;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.applicationmanagement.ApplicationUtilities;
import com.swimap.iview.framework.applicationmanagement.gui.FloatingAppPanel;
import com.swimap.iview.templates.extendedtable.EditableRenderer;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import com.swimap.iview.util.Parameter;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;

public class FavouritePanel
extends JPanel {
    private static String myfavourite;
    private static String selectedFol;
    private TreeNode node0 = null;
    private static int scrollRectTo;
    private ImageIcon favIcon = (ImageIcon)ResourceMng.getInstance().getIconDirect("portal/favourites.png");
    private ImageIcon folIcon = (ImageIcon)ResourceMng.getInstance().getIconDirect("portal/folderIcon.png");
    private static int noOfUserFolders;
    static JSplitPane splitpane;
    private TreeTableViewModel treemodel = null;
    private static TreeTable treeTable;
    private TableCellRenderer cellrender = null;
    private JPanel treePanel = null;
    private static FavouriteButton buttonToCopy;
    private static final IviewLogger logger;
    private static final String MIME_TYPE;
    private static DataFlavor dragAndDropPanelDataFlavor;
    private Point popupPoint = null;
    private JScrollPane scrollPane = null;
    private JPanel tablePanel = null;
    JTable table = null;
    private boolean isDrag = false;
    private static final int TABLE_WIDTH = 780;
    private static final int TABLE_HEIGHT = 600;
    private static final int ROWHEIGHT = 30;
    private DefaultTableModel dataModel = null;
    private static final int TABLE_VISIBLE_MAXROW = 16;
    private float fontSize = 12.0f;
    protected boolean invalidChar = false;

    public FavouritePanel() {
        this(new Dimension(FloatingAppPanel.FLOAT_PANEL_WIDTH, FloatingAppPanel.FLOAT_PANEL_HEIGHT));
    }

    public FavouritePanel(Dimension dimension) {
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 20));
        this.setLayout(new BorderLayout());
        this.setForeground(Color.white);
        this.setBackground(Color.white);
        this.setOpaque(false);
        splitpane.setRightComponent(this.getTablePanel());
        this.getTreeTable();
        splitpane.setLeftComponent(this.treePanel);
        splitpane.setDividerSize(8);
        this.setOpaque(false);
        this.setSize(dimension);
        this.readFavouritePanelSettings();
    }

    private void getTreeTable() {
        JScrollPane jScrollPane = new JScrollPane();
        treeTable = new TreeTable();
        this.treemodel = new TreeTableViewModel();
        this.cellrender = new FavTreecolRender(treeTable, this.treemodel);
        this.treePanel = new JPanel();
        this.treePanel.setSize(230, FloatingAppPanel.FLOAT_PANEL_HEIGHT);
        this.treePanel.setLayout(new BorderLayout());
        treeTable.setDefaultRenderer(Parameter.class, this.cellrender);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setPreferredSize(new Dimension(230, 384));
        treeTable.setFillsViewportHeight(true);
        this.treePanel.setBackground(Color.white);
        treeTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TreeTable treeTable = (TreeTable)mouseEvent.getSource();
                Point point = mouseEvent.getPoint();
                int n = treeTable.columnAtPoint(point);
                int n2 = treeTable.rowAtPoint(point);
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    try {
                        JTree jTree = treeTable.getTree();
                        Object object = jTree.getLastSelectedPathComponent();
                        if (object != null) {
                            selectedFol = object.toString();
                        }
                        FavouritePanel.this.refreshPanel(selectedFol);
                    }
                    catch (Exception exception) {
                        logger.debug("No Node to click");
                    }
                } else if ((mouseEvent.getModifiers() & 4) != 0) {
                    JPopupMenu jPopupMenu = this.getFolderMenu(mouseEvent);
                    ScreenToolKit.showPopupMenu(jPopupMenu, mouseEvent);
                }
            }

            private JPopupMenu getFolderMenu(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem(FavouriteConst.getString("newFolder"));
                JMenuItem jMenuItem2 = new JMenuItem(FavouriteConst.getString("delFolder"));
                JMenuItem jMenuItem3 = new JMenuItem(FavouriteConst.getString("renameFolder"));
                jMenuItem3.setName("Rename");
                jMenuItem3.setMnemonic('R');
                jMenuItem2.setName("Delete");
                jMenuItem2.setMnemonic('D');
                TreeTable treeTable = (TreeTable)mouseEvent.getSource();
                Point point = mouseEvent.getPoint();
                int n = treeTable.columnAtPoint(point);
                final int n2 = treeTable.rowAtPoint(point);
                treeTable.changeSelection(n2, n, false, false);
                JTree jTree = treeTable.getTree();
                Object object = jTree.getLastSelectedPathComponent();
                if (object != null) {
                    selectedFol = object.toString();
                    jMenuItem2.setEnabled(true);
                    if (selectedFol.equals(myfavourite)) {
                        jMenuItem2.setEnabled(false);
                    }
                }
                if (!selectedFol.equals(myfavourite)) {
                    boolean bl = FavouritePanel.this.checkForVisibility(selectedFol);
                    jMenuItem2.setEnabled(bl);
                }
                jMenuItem.setName("New Folder");
                jMenuItem.setMnemonic('N');
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (noOfUserFolders >= 20) {
                            FavouriteMsgDialog.showErrorDialog(FavouriteConst.getString("FavouriteMsg.Error"), FavouriteConst.getString("LimitExceeded"), FloatingAppPanel.getInstance());
                            return;
                        }
                        String string = FavouriteMsgDialog.showInputDialog(FloatingAppPanel.getInstance(), FavouriteConst.getString("enterFolderName"), FavouriteConst.getString("folderSelect"), -1, null, null, null);
                        if (string == null) {
                            logger.debug("Operation cancelled");
                            return;
                        }
                        boolean bl = this.validateName(string = string.trim());
                        if (!bl) {
                            if (!FavouritePanel.this.invalidChar) {
                                FavouriteMsgDialog.showErrorDialog(FavouriteConst.getString("FavouriteMsg.Error"), FavouriteConst.getString("cannotCreateFolder"), FloatingAppPanel.getInstance());
                            }
                            return;
                        }
                        FavouritePanel.this.node0 = new TreeNode(string);
                        FavouritePanel.this.treemodel.getFavroot().addChild(FavouritePanel.this.node0);
                        noOfUserFolders++;
                        int n = 0;
                        Component[] componentArray = FavouriteParser.getInstance().getFavMenu().getMenuComponents();
                        for (Component component : componentArray) {
                            if (!(component instanceof JMenu)) continue;
                            ++n;
                        }
                        JMenu jMenu = new JMenu(string);
                        FavouriteParser.getInstance().removeNoneMenu();
                        FavouriteParser.getInstance().getFavMenu().insert(jMenu, n);
                        if (n == 0) {
                            JSeparator jSeparator = new JSeparator();
                            FavouriteParser.getInstance().getFavMenu().add((Component)jSeparator, n + 1);
                        }
                        MenuScroller.setScrollerFor(jMenu, (ScreenToolKit.getScreenHeight() - 50) / 23, 200);
                        JMenuItem jMenuItem = new JMenuItem(FavouriteConst.getString("None"));
                        jMenu.add(jMenuItem);
                        jMenuItem.setEnabled(false);
                        FavouriteParser.getInstance().validateFavMenu();
                        FavouriteStateMgr.getInstance().addToVal(string);
                        FavouritePanel.this.treemodel.refreshModel();
                        FavouritePanel.this.refreshPanel(myfavourite);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                treeTable.changeSelection(0, 0, false, false);
                            }
                        });
                    }

                    private boolean validateName(String string) {
                        String string2 = "*\"?,/|<>";
                        FavouritePanel.this.invalidChar = false;
                        char[] cArray = string2.toCharArray();
                        if (null == string || string.length() <= 0 || FavouriteStateMgr.getInstance().isValContains(string) || string.length() > 255) {
                            return false;
                        }
                        for (int i = 0; i < cArray.length; ++i) {
                            int n = string.indexOf(cArray[i]);
                            if (n == -1) continue;
                            FavouriteMsgDialog.showErrorDialog(FavouriteConst.getString("FavouriteMsg.Error"), FavouriteConst.getString("InvalidStr"), FloatingAppPanel.getInstance());
                            FavouritePanel.this.invalidChar = true;
                            return false;
                        }
                        return true;
                    }
                });
                JMenuItem jMenuItem4 = new JMenuItem(FavouriteConst.getString("pasteFavourites"));
                jMenuItem4.setName("Paste");
                jMenuItem4.setMnemonic('P');
                jMenuItem4.setEnabled(true);
                if (buttonToCopy == null) {
                    jMenuItem4.setEnabled(false);
                }
                jMenuItem4.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (null != buttonToCopy) {
                            int n = FavouriteStateMgr.getInstance().getButtonInFolder(selectedFol, buttonToCopy);
                            if (n == -1) {
                                FavouriteUI.getInstance().addFavourite(buttonToCopy.getDescContainer(), selectedFol);
                                FavouritePanel.this.refreshPanel(selectedFol);
                            } else {
                                FavouriteMsgDialog.showErrorDialog(FavouriteConst.getString("FavouriteMsg.Error"), FavouriteConst.getString("alreadyAdded"), FloatingAppPanel.getInstance());
                            }
                        }
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (FavouriteStateMgr.getInstance().getButtonCountInFolder(selectedFol) > 0) {
                            FavouriteMsgDialog.showErrorDialog(FavouriteConst.getString("FavouriteMsg.Error"), FavouriteConst.getString("cannotDeleteFolder"), FloatingAppPanel.getInstance());
                            return;
                        }
                        int n = FavouriteMsgDialog.showConfDialog(FavouriteConst.getString("FavouriteMsg.Confirm"), FavouriteConst.getString("DeleteFolder"), FloatingAppPanel.getInstance());
                        if (n == 0) {
                            for (int i = 0; i < FavouriteStateMgr.getInstance().getButtonCountInFolder(selectedFol); ++i) {
                                FavouriteButton favouriteButton = FavouriteStateMgr.getInstance().getFolderButton(selectedFol, i);
                                FavouriteStateMgr.getInstance().removeButtonFromFolder(selectedFol, favouriteButton);
                                FavouriteUI.getInstance().delFavourite(favouriteButton.getDescContainer());
                            }
                            FavouriteStateMgr.getInstance().removeFolderMenu(selectedFol);
                            ((FavouritePanel)FavouritePanel.this).treemodel.getFavroot().children.remove(n2 - 1);
                            noOfUserFolders--;
                            FavouritePanel.this.treemodel.refreshModel();
                            FavouriteStateMgr.getInstance().removeFromVal(selectedFol);
                            selectedFol = myfavourite;
                            scrollRectTo = 0;
                            treeTable.expandAllNodes();
                            FavouritePanel.this.refreshPanel(myfavourite);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    treeTable.changeSelection(0, 0, false, false);
                                }
                            });
                        }
                    }
                });
                jMenuItem3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = FavouriteMsgDialog.showInputDialog(FloatingAppPanel.getInstance(), FavouriteConst.getString("enterFolderName"), FavouriteConst.getString("folderRename"), -1, null, null, selectedFol);
                        if (string == null) {
                            logger.debug("Operation cancelled");
                            return;
                        }
                        boolean bl = this.validateName(string = string.trim());
                        if (!bl) {
                            if (string.equals(selectedFol)) {
                                return;
                            }
                            if (!FavouritePanel.this.invalidChar) {
                                FavouriteMsgDialog.showErrorDialog(FavouriteConst.getString("FavouriteMsg.Error"), FavouriteConst.getString("cannotCreateFolder"), FloatingAppPanel.getInstance());
                                return;
                            }
                        } else {
                            FavouriteStateMgr.getInstance().renameFolder(selectedFol, string);
                            ((FavouritePanel)FavouritePanel.this).treemodel.getFavroot().children.get((int)(n2 - 1)).name = string;
                            FavouritePanel.this.treemodel.refreshModel();
                            FavouriteStateMgr.getInstance().renameVal(selectedFol, string);
                            selectedFol = string;
                            FavouritePanel.this.refreshPanel(string);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JTree jTree = treeTable.getTree();
                                    for (int i = 0; i <= noOfUserFolders; ++i) {
                                        String string;
                                        TreePath treePath = jTree.getPathForRow(i);
                                        Object object = treePath.getLastPathComponent();
                                        if (object == null || !(string = object.toString()).equals(FavouritePanel.getSelectedFolder())) continue;
                                        treeTable.changeSelection(i, 0, false, false);
                                        break;
                                    }
                                }
                            });
                        }
                    }

                    private boolean validateName(String string) {
                        String string2 = "*\"?,/|<>";
                        FavouritePanel.this.invalidChar = false;
                        char[] cArray = string2.toCharArray();
                        if (null == string || string.length() <= 0 || FavouriteStateMgr.getInstance().isValContains(string) || string.length() > 255) {
                            return false;
                        }
                        for (int i = 0; i < cArray.length; ++i) {
                            int n = string.indexOf(cArray[i]);
                            if (n == -1) continue;
                            FavouriteMsgDialog.showErrorDialog(FavouriteConst.getString("FavouriteMsg.Error"), FavouriteConst.getString("InvalidStr"), FloatingAppPanel.getInstance());
                            FavouritePanel.this.invalidChar = true;
                            return false;
                        }
                        return true;
                    }
                });
                if (selectedFol.equals(myfavourite) && n2 != -1) {
                    jPopupMenu.add(jMenuItem);
                    jPopupMenu.add(jMenuItem4);
                } else if (n2 != -1) {
                    jPopupMenu.add(jMenuItem4);
                    jPopupMenu.add(jMenuItem2);
                    jPopupMenu.add(jMenuItem3);
                }
                return jPopupMenu;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        treeTable.getTableHeader().setReorderingAllowed(false);
        treeTable.getTableHeader().setPreferredSize(new Dimension(this.table.getTableHeader().getPreferredSize().width, 30));
        treeTable.getTableHeader().setOpaque(false);
        jScrollPane.getViewport().add(treeTable);
        treeTable.setTreeTableModel(this.treemodel);
        treeTable.setView(0);
        this.treePanel.add((Component)jScrollPane, "Center");
        treeTable.setShowGrid(false);
        treeTable.setBackground(Color.WHITE);
        treeTable.setSortable(true);
        treeTable.setSelectionMode(0);
    }

    public TreeTableModel getTreeModel() {
        return this.treemodel;
    }

    @Deprecated
    public JScrollPane getScrollPane() {
        JScrollPane jScrollPane = new JScrollPane(this.table);
        return jScrollPane;
    }

    public JSplitPane getSplitPane() {
        return splitpane;
    }

    private void readFavouritePanelSettings() {
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFromDefaultAndProductStyle("conf/mainfrm/app/portalstyleConfig");
        if (null != commStyleInfo) {
            try {
                DescContainer descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer("FavouritePanelSettings");
                if (null != descContainer) {
                    String string = descContainer.getParasItemValue("fontsize");
                    this.fontSize = Float.parseFloat(string);
                }
            }
            catch (Exception exception) {
                logger.trace("Excetpion while reading the font size from configuration " + exception);
            }
        }
    }

    public void initializeFolders() {
        AreaDescContainer areaDescContainer;
        DescContainer descContainer;
        FavouriteStateMgr.getInstance().addToVal(myfavourite);
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        CommStyleInfo commStyleInfo = commStyleManager.getUserCommonStyleFile("favourites");
        if (null != commStyleInfo && (descContainer = (areaDescContainer = commStyleInfo.getAreaDescContainer(0)).getDescContainer("My Favourites")) != null) {
            int n = descContainer.getDescContainerCount();
            for (int i = 0; i < n; ++i) {
                String string = "";
                string = descContainer.getDescContainer(i).getParasItemValue("type");
                if (null == string) {
                    string = "JMenuItem";
                }
                if (!string.equals("JMenu")) continue;
                String string2 = descContainer.getDescContainer(i).getDescName();
                string2 = string2.replaceAll(",", "    ");
                FavouriteStateMgr.getInstance().addToVal(string2);
                this.node0 = new TreeNode(string2);
                ++noOfUserFolders;
                this.treemodel.getFavroot().addChild(this.node0);
            }
        }
    }

    public void removeAllNodes() {
        treeTable = null;
        TreeTableViewModel.setTreeRootasEmpty();
        buttonToCopy = null;
    }

    void init() {
        if (this.treePanel.getParent() != null) {
            this.treePanel.getParent().remove(this.treePanel);
        }
        splitpane.setLeftComponent(this.treePanel);
        splitpane.setContinuousLayout(true);
        if (this.tablePanel.getParent() != null) {
            this.tablePanel.getParent().remove(this.tablePanel);
        }
        this.tablePanel.setBackground(Color.white);
        this.tablePanel.setOpaque(true);
        splitpane.setRightComponent(this.tablePanel);
        treeTable.expandAllNodes();
    }

    private JPanel getTablePanel() {
        if (null == this.tablePanel) {
            this.tablePanel = new JPanel();
            this.tablePanel.setLayout(new GridBagLayout());
            this.tablePanel.setBorder(BorderFactory.createEtchedBorder());
            this.tablePanel.setOpaque(false);
            this.tablePanel.setVisible(false);
            this.createTable();
            JScrollPane jScrollPane = new JScrollPane(this.table);
            this.table.setOpaque(false);
            this.table.getTableHeader().setReorderingAllowed(false);
            this.table.getTableHeader().setOpaque(false);
            final JTableHeader jTableHeader = this.table.getTableHeader();
            jTableHeader.setResizingAllowed(true);
            jTableHeader.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    TableColumn tableColumn;
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && (tableColumn = FavouritePanel.this.getResizingColumn(mouseEvent)) != null && jTableHeader.getResizingAllowed() && tableColumn.getResizable()) {
                        int n = FavouritePanel.this.getPreferredWidthForContent(tableColumn);
                        tableColumn.setPreferredWidth(n);
                    }
                }
            });
            this.table.getTableHeader().setPreferredSize(new Dimension(this.table.getWidth(), 30));
            this.table.addComponentListener(new ComponentAdapter(){
                boolean firstTime = false;

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    if (this.firstTime) {
                        FavouritePanel.this.table.getTableHeader().setPreferredSize(new Dimension(componentEvent.getComponent().getWidth(), 30));
                    } else {
                        this.firstTime = true;
                    }
                }
            });
            jScrollPane.getViewport().setOpaque(false);
            jScrollPane.setOpaque(false);
            jScrollPane.setBorder(BorderFactory.createEtchedBorder());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 11;
            this.tablePanel.add((Component)jScrollPane, gridBagConstraints);
            this.table.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    int n = FavouritePanel.this.table.rowAtPoint(point);
                    if (n == -1 && (mouseEvent.getModifiers() & 4) != 0) {
                        JPopupMenu jPopupMenu = this.getFolderMenu(mouseEvent);
                        ScreenToolKit.showPopupMenu(jPopupMenu, mouseEvent);
                    }
                }

                private JPopupMenu getFolderMenu(MouseEvent mouseEvent) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem(FavouriteConst.getString("pasteFavourites"));
                    jMenuItem.setName("Paste");
                    jMenuItem.setMnemonic('P');
                    jMenuItem.setEnabled(true);
                    if (buttonToCopy == null) {
                        jMenuItem.setEnabled(false);
                    }
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (null != buttonToCopy) {
                                int n = FavouriteStateMgr.getInstance().getButtonInFolder(selectedFol, buttonToCopy);
                                if (n == -1) {
                                    FavouriteUI.getInstance().addFavourite(buttonToCopy.getDescContainer(), selectedFol);
                                    FavouritePanel.this.refreshPanel(selectedFol);
                                } else {
                                    FavouriteMsgDialog.showErrorDialog(FavouriteConst.getString("FavouriteMsg.Error"), FavouriteConst.getString("alreadyAdded"), FloatingAppPanel.getInstance());
                                }
                            }
                        }
                    });
                    jPopupMenu.add(jMenuItem);
                    return jPopupMenu;
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                }
            });
        }
        return this.tablePanel;
    }

    protected int getPreferredWidthForContent(TableColumn tableColumn) {
        int n;
        int n2 = 0;
        int n3 = this.table.convertColumnIndexToView(tableColumn.getModelIndex());
        TableCellRenderer tableCellRenderer = null;
        Object object = null;
        Component component = null;
        JLabel jLabel = new JLabel();
        FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        int n4 = this.table.getRowCount();
        for (n = 0; n < n4; ++n) {
            tableCellRenderer = this.table.getCellRenderer(n, n3);
            object = this.table.getValueAt(n, n3);
            component = tableCellRenderer.getTableCellRendererComponent(this.table, object, false, false, n, n3);
            if (n3 == 0) {
                try {
                    FavouriteButton favouriteButton = (FavouriteButton)this.table.getValueAt(n, n3);
                    object = favouriteButton.getFunctionName();
                }
                catch (ClassCastException classCastException) {
                    logger.trace("Class cast exception while calculation width");
                }
            }
            int n5 = fontMetrics.stringWidth(object.toString());
            n2 = Math.max(n5, n2);
            if (n3 != 0) continue;
            n2 += 30;
        }
        n = fontMetrics.stringWidth(this.table.getColumnName(n3));
        n2 = Math.max(n, n2);
        return n2 + 15;
    }

    protected TableColumn getResizingColumn(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            throw new IllegalArgumentException("e is null.");
        }
        Point point = mouseEvent.getPoint();
        int n = this.table.getTableHeader().columnAtPoint(point);
        if (n == -1) {
            return null;
        }
        JTableHeader jTableHeader = this.table.getTableHeader();
        Rectangle rectangle = jTableHeader.getHeaderRect(n);
        rectangle.grow(-3, 0);
        if (rectangle.contains(point)) {
            return null;
        }
        int n2 = rectangle.x + rectangle.width / 2;
        int n3 = 0;
        if (jTableHeader.getComponentOrientation().isLeftToRight()) {
            n3 = point.x < n2 ? n - 1 : n;
        } else {
            int n4 = n3 = point.x < n2 ? n : n - 1;
        }
        if (n3 == -1) {
            return null;
        }
        return jTableHeader.getColumnModel().getColumn(n3);
    }

    private void createTable() {
        if (this.table == null) {
            Object[] objectArray = new String[]{FavouriteConst.getString("function"), FavouriteConst.getString("menupath"), FavouriteConst.getString("application")};
            this.table = new FavoriteTable(this.getFavouriteTableModel(objectArray));
        }
    }

    private TableModel getFavouriteTableModel(Object[] objectArray) {
        if (null == this.dataModel) {
            this.dataModel = new DefaultTableModel(objectArray, 0){

                public Class getColumnClass(int n) {
                    switch (n) {
                        case 0: {
                            return FavouriteButton.class;
                        }
                        case 1: {
                            return FavouriteButton.class;
                        }
                        case 2: {
                            return FavouriteButton.class;
                        }
                    }
                    return String.class;
                }

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
        }
        return this.dataModel;
    }

    public void setSelected(FavouriteButton favouriteButton) {
        int n = this.getComponentZOrder(favouriteButton);
        if (n > 0) {
            this.setComponentZOrder(favouriteButton, 0);
        }
    }

    public void refreshPanel() {
        this.refreshPanel(myfavourite);
    }

    public void refreshPanel(String string) {
        FavouriteStateMgr favouriteStateMgr;
        int n;
        treeTable.expandAllNodes();
        ArrayList arrayList = FavouriteStateMgr.getInstance().getVal();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!arrayList.get(i).equals(string)) continue;
            treeTable.changeSelection(i, 0, false, false);
            break;
        }
        Object[] objectArray = new Object[1];
        this.table.clearSelection();
        this.dataModel.getDataVector().clear();
        if (string.equals(myfavourite)) {
            int n2 = FavouriteStateMgr.getInstance().valSize();
            for (n = 1; n < n2; ++n) {
                Object[] objectArray2 = new Object[]{FavouriteStateMgr.getInstance().getValElementAt(n), "", ""};
                this.dataModel.addRow(objectArray2);
            }
        }
        if ((n = (favouriteStateMgr = FavouriteStateMgr.getInstance()).getButtonCountInFolder(string)) == 0) {
            this.updateTable();
            this.tablePanel.setVisible(true);
            return;
        }
        this.tablePanel.setVisible(true);
        int n3 = 0;
        FavouriteButton favouriteButton = null;
        Application application = null;
        AppPopupMenuManager appPopupMenuManager = null;
        AppMenuItemProperties appMenuItemProperties = null;
        for (int i = 0; i < n; ++i) {
            favouriteButton = favouriteStateMgr.getFolderButton(string, i);
            if (null == favouriteButton) continue;
            String string2 = favouriteButton.getAppId();
            String string3 = favouriteButton.getMenuID();
            application = ApplicationManager.getInstance().getApplication(string2);
            if (null == application || null == (appPopupMenuManager = application.getPopupMenuManager()) || null == (appMenuItemProperties = appPopupMenuManager.getAppMenuItemProperties(string3, true))) continue;
            String string4 = this.getMenupath(appMenuItemProperties);
            if (i >= 200) {
                logger.trace("Maximum nuber of favourtes are reached ");
                break;
            }
            try {
                boolean bl = favouriteButton.isVisible();
                boolean bl2 = favouriteButton.isEnabled();
                AuthorityAction authorityAction = null;
                if (null == favouriteButton.getAction()) {
                    favouriteButton.initAction(favouriteButton);
                }
                if (null != (authorityAction = favouriteButton.getAction())) {
                    bl = authorityAction.isActionVisible();
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    bl2 = authorityAction.isActionEnabled();
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    favouriteButton.setVisible(bl);
                    favouriteButton.setEnabled(bl2);
                } else {
                    String string5 = favouriteButton.getCommand();
                    CommandManager commandManager = CommandManager.getInstance();
                    AuthorityView authorityView = commandManager.getAuthorityViewAction(string5);
                    if (null != authorityView) {
                        boolean bl3 = commandManager.securityInfoCheck(string5);
                        bl = authorityView.isVisible(string5);
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        bl2 = authorityView.isEnabled(string5);
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        favouriteButton.setEnabled(bl3 && bl2);
                        favouriteButton.setVisible(bl);
                    }
                }
            }
            catch (Throwable throwable) {
                logger.trace("IView Handled Error while updating  Visibilityof Favouritebuttons " + favouriteButton.getButtonName(), throwable);
            }
            if (!favouriteButton.isVisible()) continue;
            objectArray[0] = favouriteButton;
            favouriteButton.setXIndex(n3);
            favouriteButton.setNeedCommit(true);
            Object[] objectArray3 = new Object[]{favouriteButton, string4, favouriteButton.getAppName()};
            this.dataModel.addRow(objectArray3);
            ++n3;
        }
        this.updateTable();
    }

    private String getMenupath(AppMenuItemProperties appMenuItemProperties) {
        String string = null;
        String string2 = appMenuItemProperties.getAPPId();
        AppPopupMenuManager appPopupMenuManager = ApplicationManager.getInstance().getAppPopUpMenuManager(string2);
        MenuSet menuSet = appPopupMenuManager.getMenuset();
        int n = menuSet.getMenuCount();
        Menu menu = null;
        Menu menu2 = null;
        StringBuffer stringBuffer = null;
        for (int i = 0; i < n; ++i) {
            menu = menuSet.getMenu(i);
            menu2 = this.getParentMenu(menu, appMenuItemProperties.getID());
            if (menu2 == null) continue;
            stringBuffer = new StringBuffer(3);
            stringBuffer.append(ApplicationUtilities.replacePopupMenuMnemonic(menu.getText()));
            if (menu != menu2) {
                stringBuffer.append(" - ");
                stringBuffer.append(ApplicationUtilities.replacePopupMenuMnemonic(menu2.getText()));
            }
            string = stringBuffer.toString();
            return string;
        }
        return string;
    }

    private Menu getParentMenu(Menu menu, String string) {
        String string2 = null;
        int n = menu.getMenuComponentCount();
        Component component = null;
        Menu menu2 = null;
        for (int i = 0; i < n; ++i) {
            component = menu.getMenuComponent(i);
            if (component instanceof Menu && null != (menu2 = this.getParentMenu((Menu)component, string))) {
                return menu2;
            }
            String string3 = string2 = component instanceof IComminiProperties ? ((IComminiProperties)((Object)component)).getID() : null;
            if (string2 == null || !string2.equals(string)) continue;
            return menu;
        }
        return null;
    }

    private void updateTable() {
        if (this.dataModel.getRowCount() <= 16) {
            this.table.setPreferredScrollableViewportSize(new Dimension(780, this.dataModel.getRowCount() * 30));
        } else {
            this.table.setPreferredScrollableViewportSize(new Dimension(780, 600));
        }
        this.table.clearSelection();
        this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(scrollRectTo, 0, true)));
        this.table.revalidate();
        this.table.repaint();
    }

    JTable getFavouriteTable() {
        if (this.table == null) {
            this.createTable();
        }
        return this.table;
    }

    public void setPopupPoint(Point point) {
        this.popupPoint = point;
    }

    public Point getPopupPoint() {
        return this.popupPoint;
    }

    public static DataFlavor getDragAndDropPanelDataFlavor() {
        if (dragAndDropPanelDataFlavor == null) {
            try {
                dragAndDropPanelDataFlavor = new DataFlavor(MIME_TYPE);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.trace("un supported data flavour");
            }
        }
        return dragAndDropPanelDataFlavor;
    }

    private boolean isPointInPreferredSize(JTable jTable, Point point, boolean bl) {
        Object object;
        int n = jTable.rowAtPoint(point);
        int n2 = jTable.columnAtPoint(point);
        if (n == -1 || n2 == -1) {
            return false;
        }
        TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n, n2);
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object = jTable.getValueAt(n, 0), false, false, n, n2);
        if (!component.isEnabled()) {
            return false;
        }
        Dimension dimension = component.getPreferredSize();
        Insets insets = ((JComponent)component).getInsets();
        Rectangle rectangle = jTable.getCellRect(n, n2, false);
        if (bl) {
            rectangle.width = dimension.width - insets.right - insets.left;
        }
        rectangle.translate(insets.left, insets.top);
        return rectangle.contains(point);
    }

    public static int getNoOfUserFolder() {
        return noOfUserFolders;
    }

    private String getCurrentFolder(FavouriteButton favouriteButton) {
        Map map = FavouriteStateMgr.getInstance().getFolderMap();
        int n = FavouriteStateMgr.getInstance().valSize();
        for (int i = 0; i < n; ++i) {
            ArrayList arrayList = (ArrayList)map.get(FavouriteStateMgr.getInstance().getValElementAt(i));
            if (arrayList == null || arrayList.size() <= 0) continue;
            for (int j = 0; j < arrayList.size(); ++j) {
                FavouriteButton favouriteButton2 = (FavouriteButton)arrayList.get(j);
                if (favouriteButton2 != favouriteButton) continue;
                return FavouriteStateMgr.getInstance().getValElementAt(i);
            }
        }
        return myfavourite;
    }

    public JPopupMenu getFolderPopupMenu(MouseEvent mouseEvent, String string) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(FavouriteConst.getString("delFolder"));
        JMenuItem jMenuItem2 = new JMenuItem(FavouriteConst.getString("renameFolder"));
        jMenuItem2.setName("Rename");
        jMenuItem2.setMnemonic('R');
        jMenuItem.setName("Delete");
        jMenuItem.setMnemonic('D');
        JTable jTable = (JTable)mouseEvent.getSource();
        Point point = mouseEvent.getPoint();
        int n = jTable.columnAtPoint(point);
        final int n2 = jTable.rowAtPoint(point);
        selectedFol = string;
        if (!selectedFol.equals(myfavourite)) {
            boolean bl = this.checkForVisibility(selectedFol);
            jMenuItem.setEnabled(bl);
        }
        JMenuItem jMenuItem3 = new JMenuItem(FavouriteConst.getString("pasteFavourites"));
        jMenuItem3.setName("Paste");
        jMenuItem3.setMnemonic('P');
        jMenuItem3.setEnabled(true);
        if (buttonToCopy == null) {
            jMenuItem3.setEnabled(false);
        }
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (null != buttonToCopy) {
                    int n = FavouriteStateMgr.getInstance().getButtonInFolder(selectedFol, buttonToCopy);
                    if (n == -1) {
                        FavouriteUI.getInstance().addFavourite(buttonToCopy.getDescContainer(), selectedFol);
                        FavouritePanel.this.refreshPanel(selectedFol);
                        treeTable.changeSelection(n2 + 1, 0, false, false);
                    } else {
                        FavouriteMsgDialog.showErrorDialog(FavouriteConst.getString("FavouriteMsg.Error"), FavouriteConst.getString("alreadyAdded"), FloatingAppPanel.getInstance());
                    }
                }
            }
        });
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FavouriteStateMgr.getInstance().getButtonCountInFolder(selectedFol) > 0) {
                    FavouriteMsgDialog.showErrorDialog(FavouriteConst.getString("FavouriteMsg.Error"), FavouriteConst.getString("cannotDeleteFolder"), FloatingAppPanel.getInstance());
                    return;
                }
                int n = FavouriteMsgDialog.showConfDialog(FavouriteConst.getString("FavouriteMsg.Confirm"), FavouriteConst.getString("DeleteFolder"), FloatingAppPanel.getInstance());
                if (n == 0) {
                    for (int i = 0; i < FavouriteStateMgr.getInstance().getButtonCountInFolder(selectedFol); ++i) {
                        FavouriteButton favouriteButton = FavouriteStateMgr.getInstance().getFolderButton(selectedFol, i);
                        FavouriteStateMgr.getInstance().removeButtonFromFolder(selectedFol, favouriteButton);
                        FavouriteUI.getInstance().delFavourite(favouriteButton.getDescContainer());
                    }
                    FavouriteStateMgr.getInstance().removeFolderMenu(selectedFol);
                    ((FavouritePanel)FavouritePanel.this).treemodel.getFavroot().children.remove(n2);
                    noOfUserFolders--;
                    FavouritePanel.this.treemodel.refreshModel();
                    FavouriteStateMgr.getInstance().removeFromVal(selectedFol);
                    selectedFol = myfavourite;
                    scrollRectTo = 0;
                    FavouritePanel.this.refreshPanel(myfavourite);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            treeTable.changeSelection(0, 0, false, false);
                        }
                    });
                }
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = "";
                string = FavouriteMsgDialog.showInputDialog(FloatingAppPanel.getInstance(), FavouriteConst.getString("enterFolderName"), FavouriteConst.getString("folderRename"), -1, null, null, selectedFol);
                if (string == null) {
                    logger.debug("Operation cancelled");
                    return;
                }
                boolean bl = this.validateName(string = string.trim());
                if (!bl) {
                    if (string.equals(selectedFol)) {
                        return;
                    }
                    if (!FavouritePanel.this.invalidChar) {
                        FavouriteMsgDialog.showErrorDialog(FavouriteConst.getString("FavouriteMsg.Error"), FavouriteConst.getString("cannotCreateFolder"), FloatingAppPanel.getInstance());
                        return;
                    }
                } else {
                    FavouriteStateMgr.getInstance().renameFolder(selectedFol, string);
                    ((FavouritePanel)FavouritePanel.this).treemodel.getFavroot().children.get((int)n2).name = string;
                    FavouritePanel.this.treemodel.refreshModel();
                    FavouriteStateMgr.getInstance().renameVal(selectedFol, string);
                    selectedFol = string;
                    FavouritePanel.this.refreshPanel(string);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JTree jTree = treeTable.getTree();
                            for (int i = 0; i <= noOfUserFolders; ++i) {
                                String string;
                                TreePath treePath = jTree.getPathForRow(i);
                                Object object = treePath.getLastPathComponent();
                                if (object == null || !(string = object.toString()).equals(FavouritePanel.getSelectedFolder())) continue;
                                treeTable.changeSelection(i, 0, false, false);
                                break;
                            }
                        }
                    });
                }
            }

            private boolean validateName(String string) {
                String string2 = "*\"?,/|<>";
                FavouritePanel.this.invalidChar = false;
                char[] cArray = string2.toCharArray();
                if (null == string || string.length() <= 0 || FavouriteStateMgr.getInstance().isValContains(string) || string.length() > 255) {
                    return false;
                }
                for (int i = 0; i < cArray.length; ++i) {
                    int n = string.indexOf(cArray[i]);
                    if (n == -1) continue;
                    FavouriteMsgDialog.showErrorDialog(FavouriteConst.getString("FavouriteMsg.Error"), FavouriteConst.getString("InvalidStr"), FloatingAppPanel.getInstance());
                    FavouritePanel.this.invalidChar = true;
                    return false;
                }
                return true;
            }
        });
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        return jPopupMenu;
    }

    private boolean checkForVisibility(String string) {
        Map map = FavouriteStateMgr.getInstance().getFolderMap();
        ArrayList arrayList = (ArrayList)map.get(string);
        if (arrayList == null) {
            return true;
        }
        if (arrayList != null) {
            if (arrayList.size() == 0) {
                return true;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                boolean bl = ((FavouriteButton)arrayList.get(i)).isVisible();
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    public static void setDividerLocation(double d) {
        splitpane.setDividerLocation(d);
    }

    public static void setNoOfUserFolder(int n) {
        noOfUserFolders = n;
    }

    public static String getSelectedFolder() {
        return selectedFol;
    }

    public static void setSelectedFolder(String string) {
        selectedFol = string;
    }

    static {
        selectedFol = myfavourite = FavouriteConst.getString("myfavourite");
        scrollRectTo = 0;
        noOfUserFolders = 0;
        splitpane = new JSplitPane();
        treeTable = null;
        buttonToCopy = null;
        logger = IviewLogger.getLogger(FavouritePanel.class);
        MIME_TYPE = "application/x-java-jvm-local-objectref;class=" + FavouriteButton.class.getName();
        dragAndDropPanelDataFlavor = null;
    }

    private class FixedTableUI
    extends BasicTableUI {
        private BasicTableUI.MouseInputHandler handler = new BasicTableUI.MouseInputHandler(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                JTable jTable = (JTable)mouseEvent.getSource();
                TransferHandler transferHandler = jTable.getTransferHandler();
                super.mouseDragged(mouseEvent);
                transferHandler.exportAsDrag(jTable, mouseEvent, 1);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (FavouritePanel.this.isPointInPreferredSize(FixedTableUI.this.table, mouseEvent.getPoint(), true)) {
                    super.mousePressed(mouseEvent);
                }
            }
        };

        private FixedTableUI() {
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            super.paint(graphics, jComponent);
            this.paintDropLines(graphics);
        }

        private void paintDropLines(Graphics graphics) {
            Color color = new Color(255, 255, 255);
            JTable.DropLocation dropLocation = this.table.getDropLocation();
            if (dropLocation == null) {
                return;
            }
            Color color2 = this.table.getForeground();
            if (color == null && color2 == null) {
                return;
            }
            Rectangle rectangle = this.getHDropLineRect(dropLocation);
            if (rectangle != null) {
                int n = rectangle.x;
                int n2 = rectangle.width;
                if (color != null) {
                    this.extendRect(rectangle, true);
                    graphics.setColor(color);
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                if (!dropLocation.isInsertColumn() && color2 != null) {
                    graphics.setColor(color2);
                    graphics.fillRect(n, rectangle.y, n2, rectangle.height);
                }
            }
        }

        private Rectangle getHDropLineRect(JTable.DropLocation dropLocation) {
            if (!dropLocation.isInsertRow()) {
                return null;
            }
            int n = dropLocation.getRow();
            int n2 = dropLocation.getColumn();
            if (n2 >= this.table.getColumnCount()) {
                --n2;
            }
            Rectangle rectangle = this.table.getCellRect(n, n2, true);
            if (n >= this.table.getRowCount()) {
                Rectangle rectangle2 = this.table.getCellRect(--n, n2, true);
                rectangle.y = rectangle2.y + rectangle2.height;
            }
            rectangle.y = rectangle.y == 0 ? -1 : (rectangle.y -= 2);
            rectangle.height = 3;
            return rectangle;
        }

        private Rectangle extendRect(Rectangle rectangle, boolean bl) {
            if (rectangle == null) {
                return rectangle;
            }
            if (bl) {
                rectangle.x = 0;
                rectangle.width = this.table.getWidth();
            } else {
                rectangle.y = 0;
                if (this.table.getRowCount() != 0) {
                    Rectangle rectangle2 = this.table.getCellRect(this.table.getRowCount() - 1, 0, true);
                    rectangle.height = rectangle2.y + rectangle2.height;
                } else {
                    rectangle.height = this.table.getHeight();
                }
            }
            return rectangle;
        }

        @Override
        protected MouseInputListener createMouseInputListener() {
            return this.handler;
        }
    }

    private class FavouriteTransferHandler
    extends TransferHandler {
        private FavouriteTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            JTable jTable = (JTable)jComponent;
            FavouriteButton favouriteButton = null;
            DefaultTableModel defaultTableModel = (DefaultTableModel)jTable.getModel();
            int n = jTable.getSelectedRow();
            int n2 = jTable.getSelectedColumn();
            try {
                favouriteButton = (FavouriteButton)defaultTableModel.getValueAt(n, 0);
            }
            catch (ClassCastException classCastException) {
                logger.debug("Cannot drag folder");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                logger.debug("Button not available in the specified index");
            }
            return favouriteButton;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            JTable jTable = (JTable)transferSupport.getComponent();
            Point point = transferSupport.getDropLocation().getDropPoint();
            String string = myfavourite;
            JTable.DropLocation dropLocation = (JTable.DropLocation)transferSupport.getDropLocation();
            boolean bl = transferSupport.isDrop() && transferSupport.isDataFlavorSupported(FavouritePanel.getDragAndDropPanelDataFlavor());
            try {
                Object object;
                int n = jTable.rowAtPoint(point);
                int n2 = jTable.columnAtPoint(point);
                int n3 = n;
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n3 >= jTable.getRowCount()) {
                    --n3;
                }
                if (null == (object = jTable.getModel().getValueAt(n, 0))) {
                    bl = false;
                }
                if (FavouritePanel.this.isPointInPreferredSize(jTable, point, false)) {
                    jTable.changeSelection(n, n2, false, false);
                    bl = false;
                } else {
                    jTable.clearSelection();
                }
                try {
                    Object object2 = transferSupport.getTransferable().getTransferData(dragAndDropPanelDataFlavor);
                    string = FavouritePanel.this.getCurrentFolder((FavouriteButton)object2);
                    bl = !string.equals(myfavourite) || n3 >= noOfUserFolders || !dropLocation.isInsertRow();
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    unsupportedFlavorException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                jTable.setCursor(bl ? DragSource.DefaultMoveDrop : Cursor.getDefaultCursor());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                logger.debug("iview handled exception");
                jTable.setCursor(Cursor.getDefaultCursor());
            }
            return bl;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 3;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            int n;
            JTable jTable = (JTable)transferSupport.getComponent();
            JTable.DropLocation dropLocation = (JTable.DropLocation)transferSupport.getDropLocation();
            String string = myfavourite;
            int n2 = dropLocation.getRow() - 1;
            if (n2 == -1) {
                n2 = 0;
            }
            if (n2 >= jTable.getRowCount()) {
                --n2;
            }
            if ((n = dropLocation.getRow()) < 0) {
                n = 0;
            }
            if (n >= jTable.getRowCount()) {
                --n;
            }
            scrollRectTo = n;
            try {
                Object object = transferSupport.getTransferable().getTransferData(dragAndDropPanelDataFlavor);
                if (object instanceof FavouriteButton) {
                    string = FavouritePanel.this.getCurrentFolder((FavouriteButton)object);
                    if (string.equals(myfavourite)) {
                        if (n < noOfUserFolders) {
                            String string2 = jTable.getValueAt(n, 0).toString();
                            this.pasteToFolder(string2, (FavouriteButton)object);
                        } else {
                            FavouriteStateMgr.getInstance().moveButton((FavouriteButton)object, n -= noOfUserFolders);
                            FavouritePanel.this.refreshPanel(string);
                        }
                    } else {
                        FavouriteStateMgr.getInstance().moveButton((FavouriteButton)object, n);
                        FavouritePanel.this.refreshPanel(string);
                    }
                }
                jTable.setCursor(Cursor.getDefaultCursor());
                return true;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                logger.trace("Exception while importdata ");
            }
            catch (IOException iOException) {
                logger.trace("Exception while importdata ");
            }
            jTable.setCursor(Cursor.getDefaultCursor());
            return false;
        }

        private void pasteToFolder(String string, FavouriteButton favouriteButton) {
            if (null != favouriteButton) {
                int n = FavouriteStateMgr.getInstance().getButtonInFolder(string, favouriteButton);
                if (n == -1) {
                    FavouriteUI.getInstance().addFavourite(favouriteButton.getDescContainer(), string);
                    FavouriteStateMgr.getInstance().removeButtonFromFolder(selectedFol, favouriteButton);
                    FavouriteUI.getInstance().delFavourite(favouriteButton.getDescContainer());
                    FavouritePanel.this.refreshPanel(selectedFol);
                } else {
                    FavouriteMsgDialog.showErrorDialog(FavouriteConst.getString("FavouriteMsg.Error"), FavouriteConst.getString("alreadyAdded"), FloatingAppPanel.getInstance());
                }
            }
        }

        @Override
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            FavouritePanel.this.isDrag = false;
            FavouritePanel.this.table.setCursor(Cursor.getDefaultCursor());
        }
    }

    private class HyperLinkRender
    extends EditableRenderer
    implements MouseListener,
    MouseMotionListener {
        private Rectangle actaulRect = new Rectangle();
        private Rectangle iconRect = new Rectangle();
        private Rectangle textRect = new Rectangle();
        private int rowIndex = -1;
        private int colIndex = -1;
        private boolean isRollover = false;
        private int colval = -1;
        private ImageIcon favIcon = new ImageIcon(FavouritePanel.class.getResource("default_favourite.png"));

        private HyperLinkRender() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.colval = n2;
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setFont(this.getFont().deriveFont(0, FavouritePanel.this.fontSize));
            int n3 = jTable.getColumnModel().getColumnMargin();
            int n4 = jTable.getRowMargin();
            int n5 = jTable.getColumnModel().getColumn(n2).getWidth();
            int n6 = jTable.getRowHeight(n);
            Insets insets = this.getInsets();
            this.actaulRect.x = insets.left;
            this.actaulRect.y = insets.top;
            this.actaulRect.width = n5 - n3 - insets.right - this.actaulRect.x;
            this.actaulRect.height = n6 - n4 - insets.bottom - this.actaulRect.y;
            String string = SwingUtilities.layoutCompoundLabel(this, this.getFontMetrics(this.getFont()), this.getText(), this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), this.actaulRect, this.iconRect, this.textRect, this.getIconTextGap());
            int n7 = this.iconRect.width + this.textRect.width + 5;
            this.setPreferredSize(new Dimension(n7, this.getPreferredSize().height));
            if (this.isEnabled()) {
                if (!jTable.isEditing() && this.rowIndex == n && this.colIndex == n2 && this.isRollover && !FavouritePanel.this.isDrag && n2 == 0) {
                    this.setText("<html><font>" + string + "</html>");
                    if (!FavouritePanel.this.isDrag) {
                        jTable.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                if (component instanceof JComponent) {
                    this.setBorder(null);
                    ((JComponent)component).setOpaque(false);
                }
                if (bl) {
                    ((JComponent)component).setOpaque(true);
                    component.setForeground(UIManager.getColor("Table.selectionForeground"));
                    component.setBackground(UIManager.getColor("Table.selectionBackground"));
                } else {
                    component.setForeground(jTable.getForeground());
                    component.setBackground(jTable.getBackground());
                }
            } else {
                this.setBorder(null);
                ((JComponent)component).setOpaque(false);
            }
            return component;
        }

        @Override
        public void setValue(Object object) {
            if (object instanceof FavouriteButton) {
                FavouriteButton favouriteButton = (FavouriteButton)object;
                this.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0));
                this.setIconTextGap(5);
                ImageIcon imageIcon = favouriteButton.getImage();
                if (favouriteButton.isExecutable() && null != imageIcon) {
                    Image image = imageIcon.getImage().getScaledInstance(25, 25, 4);
                    imageIcon = new ImageIcon(image);
                    this.setIcon(imageIcon);
                } else {
                    this.setIcon(this.favIcon);
                }
                this.setText(favouriteButton.getFunctionName());
                this.setEnabled(favouriteButton.isEnabled());
            } else {
                this.setText(object.toString());
                this.setIcon(null);
                if (FavouriteStateMgr.getInstance().isValContains(object.toString()) && this.colval == 0) {
                    this.setIcon(FavouritePanel.this.folIcon);
                }
                this.setEnabled(true);
            }
        }

        private boolean isHyperColumn(JTable jTable, int n) {
            return n >= 0 && jTable.getColumnClass(n).equals(FavouriteButton.class);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            block13: {
                Point point;
                JTable jTable = (JTable)mouseEvent.getSource();
                int n = jTable.rowAtPoint(point = mouseEvent.getPoint());
                if (n > jTable.getRowCount() || n < 0) {
                    return;
                }
                String string = jTable.getValueAt(n, 0).toString();
                FavouriteButton favouriteButton = null;
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    try {
                        favouriteButton = (FavouriteButton)jTable.getValueAt(n, 0);
                        if (null != favouriteButton) {
                            ScreenToolKit.setSystemBusy(true);
                            favouriteButton.processClick(favouriteButton);
                            ScreenToolKit.setSystemBusy(false);
                        }
                    }
                    catch (Exception exception) {
                        if (FavouriteStateMgr.getInstance().isValContains(string)) {
                            FavouritePanel.this.refreshPanel(string);
                            selectedFol = string;
                            treeTable.changeSelection(n + 1, 0, false, false);
                        }
                        ScreenToolKit.setSystemBusy(false);
                    }
                    if (FavouriteStateMgr.getInstance().isValContains(string)) {
                        FavouritePanel.this.refreshPanel(string);
                        selectedFol = string;
                    }
                } else {
                    if ((mouseEvent.getModifiers() & 4) != 0) {
                        try {
                            favouriteButton = (FavouriteButton)jTable.getValueAt(n, 0);
                            if (null != favouriteButton && favouriteButton.isEnabled()) {
                                JPopupMenu jPopupMenu = this.getDeletePopupMenu(favouriteButton);
                                jTable.changeSelection(n, 0, false, false);
                                ScreenToolKit.showPopupMenu(jPopupMenu, mouseEvent);
                            }
                            break block13;
                        }
                        catch (ClassCastException classCastException) {
                            if (FavouriteStateMgr.getInstance().isValContains(string)) {
                                JPopupMenu jPopupMenu = FavouritePanel.this.getFolderPopupMenu(mouseEvent, string);
                                jTable.changeSelection(n, 0, false, false);
                                ScreenToolKit.showPopupMenu(jPopupMenu, mouseEvent);
                            }
                            break block13;
                        }
                    }
                    jTable.setRowSelectionInterval(n, n);
                }
            }
        }

        private JPopupMenu getDeletePopupMenu(final FavouriteButton favouriteButton) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem(FavouriteConst.getString("DeleteFavourites"));
            JMenuItem jMenuItem2 = new JMenuItem(FavouriteConst.getString("CopyFavourites"));
            jMenuItem2.setName("Copy");
            jMenuItem2.setMnemonic('C');
            jMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    buttonToCopy = favouriteButton;
                }
            });
            jMenuItem.setName("Delete");
            jMenuItem.setMnemonic('D');
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = FavouriteMsgDialog.showConfDialog(FavouriteConst.getString("FavouriteMsg.Confirm"), FavouriteConst.getString("DeleteConfirm"), FloatingAppPanel.getInstance());
                    if (n == 0) {
                        FavouriteStateMgr.getInstance().removeButtonFromFolder(selectedFol, favouriteButton);
                        FavouriteUI.getInstance().delFavourite(favouriteButton.getDescContainer());
                        FavouritePanel.this.refreshPanel(selectedFol);
                    }
                }
            });
            jPopupMenu.add(jMenuItem2);
            jPopupMenu.add(jMenuItem);
            return jPopupMenu;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            FavouritePanel.this.isDrag = true;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            FavouritePanel.this.isDrag = true;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            FavouritePanel.this.isDrag = false;
        }
    }

    private class FavoriteTable
    extends JTable {
        FavoriteTable(TableModel tableModel) {
            super(tableModel);
            this.init();
        }

        private void init() {
            logger.trace("begin to initilize favourite table ");
            this.setIntercellSpacing(new Dimension(0, 5));
            this.setShowGrid(false);
            this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
            this.setFillsViewportHeight(true);
            this.setRowHeight(30);
            this.setPreferredScrollableViewportSize(new Dimension(780, 600));
            this.setAutoResizeMode(0);
            this.getTableHeader().setOpaque(false);
            TableColumn tableColumn = this.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(260);
            tableColumn.setWidth(260);
            tableColumn.setResizable(true);
            tableColumn = this.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(260);
            tableColumn.setWidth(260);
            tableColumn.setResizable(true);
            tableColumn = this.getColumnModel().getColumn(2);
            tableColumn.setPreferredWidth(260);
            tableColumn.setWidth(260);
            tableColumn.setResizable(true);
            HyperLinkRender hyperLinkRender = new HyperLinkRender();
            this.setDefaultRenderer(FavouriteButton.class, hyperLinkRender);
            this.addMouseListener(hyperLinkRender);
            this.addMouseMotionListener(hyperLinkRender);
            this.setDropMode(DropMode.ON_OR_INSERT_ROWS);
            this.setTransferHandler(new FavouriteTransferHandler());
            this.setSelectionMode(0);
            this.getSelectionModel().setSelectionInterval(0, 0);
            logger.trace("end to initilize favourite table ");
        }

        @Override
        public void updateUI() {
            this.setUI(new FixedTableUI());
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = this.columnAtPoint(point);
            int n2 = this.rowAtPoint(point);
            if (n2 < FavouritePanel.this.table.getRowCount() && n2 >= 0) {
                try {
                    Object object = FavouritePanel.this.table.getValueAt(n2, n);
                    if (object instanceof FavouriteButton) {
                        FavouriteButton favouriteButton = (FavouriteButton)object;
                        return favouriteButton.getFunctionName();
                    }
                    if (null != object) {
                        String string = (String)object;
                        return string.length() == 0 ? null : string;
                    }
                }
                catch (Exception exception) {
                    logger.debug("Exception caught while showing tooltip");
                }
            }
            return super.getToolTipText();
        }
    }
}

