/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationfavourites;

import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.framework.applicationfavourites.FavouriteConst;
import com.swimap.iview.framework.applicationfavourites.FavouriteMsgDialog;
import com.swimap.iview.framework.applicationfavourites.FavouriteStateMgr;
import com.swimap.iview.framework.applicationfavourites.FavouriteUI;
import com.swimap.iview.framework.applicationmanagement.gui.FloatingAppPanel;
import com.swimap.iview.framework.windowmanagement.welcomepage.ExecutableLinkDialog;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.ScreenUIToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.List;

public class FavouriteExeDialog
extends ExecutableLinkDialog {
    private static final long serialVersionUID = 1L;
    private static final IviewLogger logger = IviewLogger.getLogger(FavouriteExeDialog.class);

    public FavouriteExeDialog(Window window, boolean bl, String string) {
        super(window, bl, string);
        this.infoLabel.setText(FavouriteConst.getString(FavouriteConst.getString("FavouriteDlg.Tip")));
        this.iconText.setText("default_favourite.png");
        ScreenUIToolKit.centerLocate(this, FavouriteUI.getInstance().getPanel());
    }

    @Override
    protected void createExeButton() {
        String string;
        if (!FavouriteExeDialog.checkPermittedPath(this.executionPathText.getText(), true)) {
            return;
        }
        String string2 = this.nameText.getText().trim();
        List<String> list = FavouriteStateMgr.getInstance().getAllCmdNames();
        if (null != list && list.contains(string2)) {
            this.showErrorMsg(FavouriteConst.getString("FavouriteDlg.NameExist"), string2);
            return;
        }
        String string3 = this.descriptionText.getText();
        if (null != string3) {
            string3 = string3.trim();
        }
        if (null == (string = this.executionPathText.getText()) || string.trim().isEmpty()) {
            this.showErrorMsg(FavouriteConst.getString("FavouriteDlg.CommandEmpty"), new String[0]);
            return;
        }
        String string4 = this.iconText.getText();
        string4 = string4 == null ? "default_favourite.png" : string4.trim();
        DescContainer descContainer = new DescContainer();
        descContainer.setParasItem("name", string2, true);
        descContainer.setParasItem("description", string3, true);
        descContainer.setParasItem("command", string.trim(), true);
        descContainer.setParasItem("icon", string4, true);
        descContainer.setParasItem("isExecutable", "true", true);
        if (FavouriteUI.getInstance().addFavourite(descContainer)) {
            this.dispose();
        } else {
            this.showErrorMsg(FavouriteConst.getString("AdditionFailed"), new String[0]);
        }
    }

    @Override
    protected void testCommand() {
        if (!FavouriteExeDialog.checkPermittedPath(this.executionPathText.getText(), true)) {
            return;
        }
        String string = this.executionPathText.getText();
        logger.info("Testing command " + string);
        boolean bl = CommonUtil.executeCommand(string, false);
        logger.info("Test result " + bl);
        if (!bl) {
            FavouriteMsgDialog.showMsgDtlDialog(FavouriteConst.getString("FavouriteMsg.Error"), FavouriteConst.getString("ExecutableError.Title"), MessageFormat.format(FavouriteConst.getString("ExecutableError"), string), this);
        }
    }

    private void showErrorMsg(String string, String ... stringArray) {
        if (null == string || string.trim().isEmpty()) {
            logger.warn("Message to be shown is invalid.");
            return;
        }
        String string2 = string.trim();
        if (stringArray != null && stringArray.length > 0) {
            string2 = MessageFormat.format(string2, stringArray);
        }
        logger.info("Exe dialog msg : " + string2);
        FavouriteMsgDialog.showErrorDialog(FavouriteConst.getString("FavouriteMsg.Error"), string2, FloatingAppPanel.getInstance());
    }
}

