/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationfavourites;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.IComminiProperties;
import com.swimap.iview.commstyle.commini.Menu;
import com.swimap.iview.commstyle.commini.MenuSet;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.applicationfavourites.FavouriteConst;
import com.swimap.iview.framework.applicationfavourites.FavouriteExp;
import com.swimap.iview.framework.applicationfavourites.FavouriteMsgDialog;
import com.swimap.iview.framework.applicationfavourites.FavouritePanel;
import com.swimap.iview.framework.applicationfavourites.FavouriteParser;
import com.swimap.iview.framework.applicationfavourites.FavouriteStateMgr;
import com.swimap.iview.framework.applicationfavourites.FavouriteUI;
import com.swimap.iview.framework.applicationmanagement.AppMenuItemProperties;
import com.swimap.iview.framework.applicationmanagement.AppPopupMenuManager;
import com.swimap.iview.framework.applicationmanagement.Application;
import com.swimap.iview.framework.applicationmanagement.ApplicationLauncher;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.applicationmanagement.ApplicationUtilities;
import com.swimap.iview.framework.applicationmanagement.InvalidApplicationException;
import com.swimap.iview.framework.applicationmanagement.gui.FloatingAppPanel;
import com.swimap.iview.framework.applicationmanagement.gui.PortalDraggableButton;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.pluginmanagement.Resource;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.LinkUtil;
import com.swimap.iview.framework.windowmanagement.welcomepage.ExecutableLinkDialog;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeTextButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableButton;
import com.swimap.iview.framework.windowmanagement.welcomepage.draggable.DraggableButtonDropTargetListener;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;

public class FavouriteButton
extends PortalDraggableButton {
    private static final long serialVersionUID = 1L;
    private static final IviewLogger logger = IviewLogger.getLogger(FavouriteButton.class);

    public static FavouriteButton getUIObject(DescContainer descContainer) {
        String string;
        Object object;
        String string2 = descContainer.getParasItemValue("isExecutable");
        CommStyleInfo commStyleInfo = new CommStyleInfo();
        commStyleInfo.addAreaDescContainer(new AreaDescContainer());
        Application application = null;
        String string3 = "";
        if (!"true".equalsIgnoreCase(string2)) {
            object = descContainer.getParasItemValue("AppId");
            application = ApplicationManager.getInstance().getApplication((String)object);
            if (null != application) {
                string3 = descContainer.getParasItemValue("pluginid");
                string = descContainer.getParasItemValue("menuid");
                if (string3.startsWith("ext_")) {
                    FavouriteButton.setExtResourceBundle(application, string, string3, commStyleInfo);
                } else {
                    commStyleInfo.setPluginName(string3);
                    FavouriteButton.setResourceBundle(application, string, string3, commStyleInfo);
                }
            }
        }
        commStyleInfo.getAreaDescContainer(0).addDescContainer(descContainer);
        object = new FavouriteButton(descContainer);
        ((FavouriteButton)object).initializeButton();
        string = descContainer.getParasItemValue("xIndex");
        String string4 = descContainer.getParasItemValue("yIndex");
        ((DraggableButton)object).setXIndex(Integer.parseInt(string));
        ((DraggableButton)object).setYIndex(Integer.parseInt(string4));
        if (!"true".equalsIgnoreCase(string2) && null != application && !FavouriteButton.validatePluginOrExt(application, string3)) {
            ((WelcomeTextButton)object).setEnabled(false);
            ((JComponent)object).setVisible(false);
            return object;
        }
        if (!((FavouriteButton)object).validateLicense()) {
            ((WelcomeTextButton)object).setEnabled(false);
            return object;
        }
        ((FavouriteButton)object).setFavPopupMenu(descContainer.getDescName());
        return object;
    }

    private static boolean validatePluginOrExt(Application application, String string) {
        if (!application.isLicensed()) {
            logger.debug("application  associated with this button is not have license");
            return false;
        }
        String string2 = null == string ? "" : string.trim();
        List<String> list = null;
        if (string2.contains("ext_")) {
            String[] stringArray = FrameworkCommandProcessor.getInstance().getFilteredExtPaths(application.getExtsFromLinks());
            list = Arrays.asList(stringArray);
        } else {
            List<String> list2;
            list = list2 = ApplicationUtilities.getFilteredStartupPlugins(application.getNormalPluginNames());
        }
        if (list == null || !list.contains(string2)) {
            logger.warn("The plugin Associated with the button  not exist in server" + string2);
            return false;
        }
        return true;
    }

    public FavouriteButton(DescContainer descContainer) {
        super(descContainer, "default_favourite.png", new Dimension(65, 65), 65);
    }

    @Override
    protected String getUpdatedButtonName() {
        return ApplicationUtilities.replacePopupMenuMnemonic(this.getFullName());
    }

    @Override
    public synchronized void initializeButton() {
        super.initializeButton();
        this.addSelectionListener(FavouriteStateMgr.getInstance());
        DraggableButtonDropTargetListener draggableButtonDropTargetListener = this.getDragListener();
        DropTarget dropTarget = new DropTarget(this, draggableButtonDropTargetListener);
        this.setDropTarget(dropTarget);
        Component[] componentArray = this.getComponents();
        if (null != componentArray) {
            for (Component component : componentArray) {
                if (null == component) continue;
                component.setDropTarget(dropTarget);
            }
        } else {
            logger.trace("Favourite Button in unknown state");
        }
    }

    protected void setMouseAdapter() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                FavouriteButton.this.setBorder(new BevelBorder(0));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                FavouriteButton.this.setBorder(new EmptyBorder(2, 2, 2, 2));
            }
        };
    }

    protected void setFavPopupMenu(String string) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(FavouriteConst.getString("DeleteFavourites"));
        jMenuItem.setName("Delete");
        jMenuItem.setMnemonic('D');
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = FavouriteMsgDialog.showConfDialog(FavouriteConst.getString("FavouriteMsg.Confirm"), FavouriteConst.getString("DeleteConfirm"), FloatingAppPanel.getInstance());
                if (n == 0) {
                    FavouriteUI.getInstance().deleteAll();
                } else {
                    FavouriteStateMgr.getInstance().resetSelectedState();
                }
            }
        });
        jPopupMenu.add(jMenuItem);
        this.setPopupMenu(jPopupMenu);
    }

    protected void remove() {
        for (Component component : this.getComponents()) {
            MouseMotionListener[] mouseMotionListenerArray;
            component.setDropTarget(null);
            if (component instanceof JComponent) {
                ((JComponent)component).getComponentPopupMenu().removeAll();
                ((JComponent)component).setTransferHandler(null);
            }
            if (null == (mouseMotionListenerArray = component.getMouseMotionListeners())) continue;
            for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
                if (null == mouseMotionListenerArray[i]) continue;
                component.removeMouseMotionListener(mouseMotionListenerArray[i]);
                mouseMotionListenerArray[i] = null;
            }
        }
        this.setPopupMenu(null);
        this.setDropTarget(null);
        this.removeIconComponent();
        this.removeImageComponent();
        this.removeAll();
    }

    @Override
    protected void executeCommand() {
        String string = this.getCommand();
        if (!ExecutableLinkDialog.checkPermittedPath(string, true)) {
            return;
        }
        logger.info("Executing command " + string);
        boolean bl = CommonUtil.executeCommand(string, false);
        logger.info("Command Result " + bl);
        if (!bl) {
            DescContainer descContainer = this.getDescContainer();
            int n = FavouriteMsgDialog.showConfDialog(FavouriteConst.getString("FavouriteMsg.Confirm"), FavouriteConst.getString("ExecutableError.Title") + FavouriteConst.getString("CmdFavouriteError"), FloatingAppPanel.getInstance());
            if (n == 0) {
                FavouriteUI.getInstance().delFavourite(descContainer);
            }
        }
    }

    protected boolean validateLicense() {
        boolean bl = this.hasValidCommand();
        String string = this.getCommand();
        CommandManager commandManager = CommandManager.getInstance();
        if (null != string && bl) {
            if (!commandManager.isCommandLicensed(string)) {
                logger.warn("The startup command has not licensed " + string);
                return false;
            }
            if (!commandManager.securityInfoCheck(string)) {
                logger.warn("The startup command has no security rights " + string);
                return false;
            }
        }
        return true;
    }

    @Override
    protected void processClick(Object object) {
        block18: {
            if (this.isExecutable()) {
                String string = FavouriteConst.getString("infoDialog_title");
                String string2 = FavouriteConst.getString("exeFav_info");
                OptionPane.showMessageDialog(this, string2 + this.getCommand(), string, 1);
                return;
            }
            if (!this.isEnabled()) {
                logger.debug("button is disabled so processClick will not happen");
                return;
            }
            DescContainer descContainer = this.getDescContainer();
            try {
                AppMenuItemProperties appMenuItemProperties;
                Object object2;
                FavouriteParser.getInstance().validate(descContainer.getParasItemValue("AppId"), descContainer.getParasItemValue("command"), descContainer.getParasItemValue("pluginid"), descContainer.getParasItemValue("menuid"), false, descContainer.getParasItemValue("action"));
                String string = descContainer.getParasItemValue("AppId");
                boolean bl = this.hasValidCommand();
                String string3 = this.getCommand();
                CommandManager commandManager = CommandManager.getInstance();
                if (!this.validateLicense()) {
                    logger.trace("License and Security is Invalid for Button");
                    return;
                }
                boolean bl2 = true;
                Application application = ApplicationManager.getInstance().getApplication(string);
                if (null != application && null != (object2 = application.getPopupMenuManager()) && null != (appMenuItemProperties = ((AppPopupMenuManager)object2).getAppMenuItemProperties(descContainer.getParasItemValue("menuid"), true))) {
                    bl2 = appMenuItemProperties.isBlankInteralFrame();
                }
                ApplicationManager.getInstance().setBlankFrame(bl2);
                if (ApplicationLauncher.getAppLauncher().isAppLaunched(string)) {
                    ApplicationManager.getInstance().showApplication(string);
                } else {
                    ApplicationManager.getInstance().launchApplication(string, true);
                }
                if (!ApplicationLauncher.getAppLauncher().isAppLaunched(string)) {
                    logger.trace("launching the application " + string + " has failed");
                    throw new FavouriteExp("application launching has failed");
                }
                CommandManager.getInstance().setExceptionFlag(string3, false);
                if (null != string3 && bl) {
                    if (this.m_commandProcessor != null) {
                        commandManager.invoke(string3, this.m_commandProcessor);
                    } else {
                        commandManager.invoke(string3, this);
                    }
                    boolean bl3 = CommandManager.getInstance().getExceptionFlag(string3);
                    if (!bl3) break block18;
                    ApplicationManager.getInstance().setBlankFrame(true);
                    try {
                        ApplicationManager.getInstance().showApplication(string);
                    }
                    catch (InvalidApplicationException invalidApplicationException) {
                        logger.trace("Application cannotbe launched");
                    }
                    CommandManager.getInstance().setExceptionFlag(string3, false);
                    break block18;
                }
                if (null == this.getAction()) {
                    super.initAction();
                }
                if (null != this.getAction() && this.getAction().isActionEnabled()) {
                    object2 = new ActionEvent(object, 1001, null);
                    this.getAction().actionPerformed((ActionEvent)object2);
                    break block18;
                }
                throw new FavouriteExp("Favourite execution failed");
            }
            catch (FavouriteExp favouriteExp) {
                int n = FavouriteMsgDialog.showConfDialog(FavouriteConst.getString("FavouriteMsg.Confirm"), FavouriteConst.getString("ExecutableError.Title") + FavouriteConst.getString("CmdFavouriteError"), FloatingAppPanel.getInstance());
                if (n == 0) {
                    FavouriteUI.getInstance().delFavourite(descContainer);
                }
            }
            catch (InvalidApplicationException invalidApplicationException) {
                logger.trace(invalidApplicationException.getMessage());
            }
        }
    }

    @Override
    protected void processTextClick(Object object) {
        this.processClick(object);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[]{FavouriteConst.getDataFlavor()};
        return dataFlavorArray;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return null != dataFlavor ? dataFlavor.equals(FavouriteConst.getDataFlavor()) : false;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor != null && dataFlavor.equals(FavouriteConst.getDataFlavor())) {
            return this;
        }
        logger.info("Flavours mismatch " + dataFlavor + " : FavouriteButton Flavor");
        return null;
    }

    @Override
    protected String getAppName() {
        if (!this.isExecutable()) {
            String string = this.getDescContainer().getParasItemValue("AppId");
            Application application = ApplicationManager.getInstance().getApplication(string);
            if (null != application) {
                return application.getName();
            }
        }
        return "";
    }

    public String getAppId() {
        String string = this.getDescContainer().getParasItemValue("AppId");
        return string;
    }

    protected String getFunctionName() {
        String string;
        if (this.isExecutable()) {
            return this.getDescContainer().getParasItemValue("name");
        }
        CommStyleInfo commStyleInfo = (CommStyleInfo)this.getDescContainer()._getRootParent();
        if (null != commStyleInfo.getResString(string = this.getDescContainer().getParasItemValue("name"))) {
            string = commStyleInfo.getResString(string);
        }
        string = ApplicationUtilities.replacePopupMenuMnemonic(string);
        commStyleInfo = null;
        return string;
    }

    @Override
    protected void initAction(FavouriteButton favouriteButton) {
        super.initAction(favouriteButton);
    }

    @Override
    protected void initAction() {
        super.initAction();
    }

    protected String getFavbuttonTooltip() {
        if (this.isExecutable()) {
            return this.getDescription();
        }
        String string = this.getDescContainer().getParasItemValue("AppId");
        AppPopupMenuManager appPopupMenuManager = ApplicationManager.getInstance().getAppPopUpMenuManager(string);
        MenuSet menuSet = appPopupMenuManager.getMenuset();
        int n = menuSet.getMenuCount();
        Menu menu = null;
        Menu menu2 = null;
        StringBuffer stringBuffer = null;
        for (int i = 0; i < n; ++i) {
            menu = menuSet.getMenu(i);
            menu2 = this.getParentMenu(menu, this.getMenuID());
            if (menu2 == null) continue;
            stringBuffer = new StringBuffer(5);
            stringBuffer.append(this.getAppName()).append(" - ");
            stringBuffer.append(ApplicationUtilities.replacePopupMenuMnemonic(menu.getText()));
            if (menu2 != menu) {
                stringBuffer.append(" - ").append(ApplicationUtilities.replacePopupMenuMnemonic(menu2.getText()));
            }
            stringBuffer.append(" - ").append(this.getFunctionName());
            return stringBuffer.toString();
        }
        return null;
    }

    private Menu getParentMenu(Menu menu, String string) {
        String string2 = null;
        int n = menu.getMenuComponentCount();
        Component component = null;
        Menu menu2 = null;
        for (int i = 0; i < n; ++i) {
            component = menu.getMenuComponent(i);
            if (component instanceof Menu && null != (menu2 = this.getParentMenu((Menu)component, string))) {
                return menu2;
            }
            String string3 = string2 = component instanceof IComminiProperties ? ((IComminiProperties)((Object)component)).getID() : null;
            if (string2 == null || !string2.equals(string)) continue;
            return menu;
        }
        return null;
    }

    protected void saveState() {
        FavouritePanel favouritePanel = FavouriteUI.getInstance().getPanel();
        Point point = favouritePanel.getPopupPoint();
        if (null == point) {
            point = new Point(0, 0);
        }
        Point point2 = DraggableButton.getAvailableXY(favouritePanel, favouritePanel.getPopupPoint());
        this.setXIndex(point2.x);
        this.setYIndex(point2.y);
        this.storeXYInfo();
        this.setNeedCommit(true);
    }

    @Override
    public void fireControlClick() {
        if (this.isSingleSelected()) {
            this.setSingleSelected(false);
            this.setState(0);
        } else {
            this.setSingleSelected(true);
            this.setState(1);
        }
        this.getTitleComponent().repaint();
    }

    private static void setExtResourceBundle(Application application, String string, String string2, CommStyleInfo commStyleInfo) {
        List<String> list = application.getAllLinks();
        if (null == list) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        String string3 = LinkUtil.getDefaultLink(string2);
        String string4 = LinkUtil.getProductLink(string2);
        CommStyleInfo commStyleInfo2 = null;
        bl = list.contains(string3);
        bl2 = list.contains(string4);
        String string5 = "conf/" + string2 + "/app/menu";
        if (bl && bl2) {
            commStyleInfo2 = CommStyleManager.getInstance().getCommonStyleFromDefaultAndProductStyleOfExtPath(string5, string2);
        } else if (bl) {
            commStyleInfo2 = CommStyleManager.getInstance().getCommonStyleFileByPath("style/defaultstyle/" + string5);
        } else if (bl2) {
            commStyleInfo2 = CommStyleManager.getInstance().getCommonStyleFileByPath("style/productstyle/" + string5);
        }
        if (null != commStyleInfo2) {
            commStyleInfo.setPluginName(string2);
            Resource resource = commStyleInfo2.getResource();
            if (null != resource) {
                commStyleInfo.setPluginResource(resource);
            }
            FavouriteConst.setResource(commStyleInfo2, commStyleInfo);
        }
    }

    private static void setResourceBundle(Application application, String string, String string2, CommStyleInfo commStyleInfo) {
        CommStyleInfo commStyleInfo2 = null;
        Object object = PluginManager.getInstance().getPluginFromFolder(string2);
        if (null != object) {
            commStyleInfo2 = object.getIntegrateCommStyleReader().getCommStyleInfo("menu");
        }
        if (null != commStyleInfo2) {
            object = commStyleInfo2.getResource();
            if (null != object) {
                commStyleInfo.setPluginResource((Resource)object);
            }
            FavouriteConst.setResource(commStyleInfo2, commStyleInfo);
        }
    }

    @Override
    protected ImageIcon getImage() {
        return super.getImage();
    }

    private DraggableButtonDropTargetListener getDragListener() {
        DraggableButtonDropTargetListener draggableButtonDropTargetListener = new DraggableButtonDropTargetListener(this, FavouriteStateMgr.getInstance(), FavouriteUI.getInstance().getPanel(), FavouriteConst.getDataFlavor()){

            @Override
            public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                Transferable transferable;
                if (null == this.dataFlavor) {
                    return;
                }
                if (dropTargetDragEvent.isDataFlavorSupported(this.dataFlavor) && null != (transferable = dropTargetDragEvent.getTransferable()) && transferable.isDataFlavorSupported(this.dataFlavor)) {
                    Object object = null;
                    try {
                        object = transferable.getTransferData(this.dataFlavor);
                    }
                    catch (Exception exception) {
                        logger.error("Failed to get drag object");
                    }
                    if (object instanceof DraggableButton) {
                        ((DraggableButton)object).fireClickAction(false);
                    }
                }
            }
        };
        return draggableButtonDropTargetListener;
    }

    public boolean isCommandConfigured() {
        return this.hasValidCommand();
    }

    public String localeName(FavouriteButton favouriteButton) {
        String string;
        Object object;
        Object object2;
        char[] cArray = new char[]{};
        String string2 = favouriteButton.getDescContainer().getParasItemValue("AppId");
        Application application = ApplicationManager.getInstance().getApplication(string2);
        if (null != application && null != (object2 = application.getPopupMenuManager()) && null != (object = ((AppPopupMenuManager)object2).getAppMenuItemProperties(favouriteButton.getDescContainer().getParasItemValue("menuid"), true)) && (string = object.getParaValue("mnemonic")) != null) {
            cArray = string.toCharArray();
        }
        object2 = new StringBuffer();
        ((StringBuffer)object2).append(favouriteButton.getFunctionName());
        if (ResourceMng.getInstance().getLocaleString().equalsIgnoreCase("zh_cn")) {
            ((StringBuffer)object2).append("(");
            if (cArray.length > 0) {
                ((StringBuffer)object2).append(cArray[0]);
            }
            ((StringBuffer)object2).append(")");
        }
        object = ((StringBuffer)object2).toString();
        return object;
    }
}

