/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.applicationfavourites;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.templates.filtertreetable.FilterTreeTable;
import com.swimap.iview.templates.filtertreetable.TreeTableModel;
import com.swimap.iview.templates.filtertreetable.TreeTableView;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;

public class FavRenderer
extends JPanel
implements TableCellRenderer {
    private static IviewLogger logger = IviewLogger.getLogger(FavRenderer.class, "IVIEW");
    protected JLabel contentLabel = new JLabel();
    private FilterTreeTable table = null;
    protected TreeTableModel tableModel = null;
    private TreePath path = null;
    private Object value = null;
    private Class renderClass = null;
    private final int TREE_COLUMN = 0;
    private boolean isExpend = false;
    private boolean isLeaf = true;
    private Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private int indentX = 0;
    private int iconIndetX = 0;
    private ImageIcon expandedIcon = (ImageIcon)ResourceMng.getInstance().getIconDirect("portal/favourites.png");
    private ImageIcon collapsedIcon = (ImageIcon)ResourceMng.getInstance().getIconDirect("portal/folderIcon.png");
    private boolean isShowToolTip = false;
    private Hashtable necessaryPropertyName = new Hashtable(10);
    private Vector notEditableProperty = new Vector(10);

    public FavRenderer(FilterTreeTable filterTreeTable, TreeTableModel treeTableModel) {
        this.setLayout(new BorderLayout());
        this.table = filterTreeTable;
        this.tableModel = treeTableModel;
        this.add(this.contentLabel);
        this.contentLabel.setOpaque(true);
        this.init();
    }

    private void init() {
        this.setBackground(Color.white);
        this.contentLabel.setFont(this.table.getFont());
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object instanceof TreePath) {
            this.path = (TreePath)object;
            this.value = object;
            if (null != object) {
                this.renderClass = object.getClass();
            }
            Object object2 = this.tableModel.getValueAt(((TreePath)object).getLastPathComponent(), 0);
            this.isExpend = ((TreeTableView)this.table).isExpanded(n);
            this.isLeaf = this.tableModel.isLeaf(((TreePath)object).getLastPathComponent());
            if (bl) {
                this.contentLabel.setBackground(jTable.getSelectionBackground());
                this.contentLabel.setForeground(jTable.getSelectionForeground());
            } else {
                this.contentLabel.setBackground(jTable.getBackground());
                this.contentLabel.setForeground(jTable.getForeground());
            }
            this.contentLabel.setText(object2.toString());
            this.indentX = this.getContentIndentX((TreePath)object);
            this.indentX -= 5;
            this.iconIndetX = this.getIconIndentX((TreePath)object);
        }
        return this;
    }

    @Override
    public void doLayout() {
        if (this.getComponentCount() == 0) {
            return;
        }
        if (this.path.getPathCount() == 2 && this.isLeaf) {
            this.indentX -= 22;
        }
        Component component = this.getComponent(0);
        Dimension dimension = this.getSize();
        component.setBounds(this.indentX, 0, dimension.width - this.indentX, dimension.height);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.isLeaf || this.path.getPathCount() == 2) {
            if (null != this.expandedIcon) {
                this.expandedIcon.paintIcon(this, graphics, this.iconIndetX, (this.getHeight() - this.expandedIcon.getIconHeight()) / 2);
            }
        } else if (null != this.collapsedIcon) {
            this.collapsedIcon.paintIcon(this, graphics, 10, (this.getHeight() - this.collapsedIcon.getIconHeight()) / 2);
        }
        if (this.table instanceof TreeTableView && ((TreeTableView)this.table).getTreeIconRender() == null) {
            return;
        }
    }

    private int getContentIndentX(TreePath treePath) {
        int n = this.getNodeIndent(treePath);
        if (this.isExpend && null != this.expandedIcon) {
            n += this.expandedIcon.getIconWidth();
        } else if (null != this.collapsedIcon) {
            n += this.collapsedIcon.getIconWidth();
        }
        return n;
    }

    private int getNodeIndent(TreePath treePath) {
        int n = treePath.getPath().length;
        if (!this.table.isRootVisible()) {
            --n;
        }
        if (this.table instanceof TreeTableView && !((TreeTableView)this.table).getShowsRootHandles()) {
            --n;
        }
        return this.getLevelIndent();
    }

    private int getLevelIndent() {
        int n = (Integer)UIManager.get("Tree.leftChildIndent");
        int n2 = (Integer)UIManager.get("Tree.rightChildIndent");
        return n + n2;
    }

    private int getIconIndentX(TreePath treePath) {
        int n = this.getLevelIndent();
        int n2 = this.getNodeIndent(treePath) / n - 1;
        int n3 = n / 2 + n2 * n;
        return n3;
    }

    protected void setNecessaryAndNotEditableProperty(Hashtable hashtable, Vector vector) {
        this.necessaryPropertyName = hashtable;
        this.notEditableProperty = vector;
    }

    protected void addNecessaryPropertyName(String string, Color color) {
        this.necessaryPropertyName.put(string, color);
    }

    protected void removeNecessaryPropertyName(String string) {
        if (this.necessaryPropertyName.containsKey(string)) {
            this.necessaryPropertyName.remove(string);
        }
    }

    protected void removeNecessaryPropertyName() {
        this.necessaryPropertyName.clear();
    }

    protected void addNotEditablePropertyName(String string) {
        this.notEditableProperty.addElement(string);
    }

    protected void removeNotEditablePropertyName(String string) {
        if (this.notEditableProperty.contains(string)) {
            this.notEditableProperty.remove(string);
        }
    }

    protected void setShowToolTip(boolean bl) {
        this.isShowToolTip = bl;
    }
}

