/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework;

import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StartupXMLReader {
    private static IviewLogger logger = IviewLogger.getLogger(StartupXMLReader.class, "IVIEW");
    private static final String STARTUP_XML = "/startup.xml";
    private static final String PLUGINSDESC = "startupplugins";
    private static final String STARTUPLINKSDESC = "startupLinks";
    private static final String STARTUPAPPLICATIONSDESC = "startupApplications";
    private static boolean isExists = StartupXMLReader.validStartupXmlFile();
    private static HashMap<String, LinkedHashSet<String>> primarySecurityPluginsMap = new HashMap(16);

    static void populatePluginsFromPrimaryStartupXmlFile() {
        File file = new File(System.getProperty("user.dir") + STARTUP_XML);
        if (file.exists()) {
            Document document = StartupXMLReader.createDocument(file);
            StartupXMLReader.populatePluginsMap(primarySecurityPluginsMap, document);
        }
        StartupXMLReader.readPrimaryStartupXMLFiles();
    }

    private static void readPrimaryStartupXMLFiles() {
        File file = new File(System.getProperty("user.dir"));
        File[] fileArray = file.listFiles(new StartupFileFilter());
        Document document = null;
        for (File file2 : fileArray) {
            document = StartupXMLReader.createDocument(file2);
            if (null == document) continue;
            StartupXMLReader.populatePluginsMap(primarySecurityPluginsMap, document);
        }
    }

    public static void populateApplications(HashMap<String, LinkedHashSet<String>> hashMap, Document document) {
        StartupXMLReader.populateMap(hashMap, document, STARTUPAPPLICATIONSDESC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document createDocument(File file) {
        Document document = null;
        if (!file.exists()) {
            return null;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = null;
        FileInputStream fileInputStream = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            fileInputStream = new FileInputStream(file);
            document = documentBuilder.parse(fileInputStream);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.error("ParserConfigurationException occured while reading the startup.xml file");
            Document document2 = null;
            return document2;
        }
        catch (SAXException sAXException) {
            logger.error("SAXException occured while reading the startup.xml file");
            Document document3 = null;
            return document3;
        }
        catch (IOException iOException) {
            logger.error("IOException occured while reading the startup.xml file");
            Document document4 = null;
            return document4;
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    logger.debug("Exception while closing stream ");
                }
            }
        }
        return document;
    }

    public static void populatePluginsMap(HashMap<String, LinkedHashSet<String>> hashMap, Document document) {
        StartupXMLReader.populateMap(hashMap, document, PLUGINSDESC);
    }

    public static void populateLinkMap(HashMap<String, LinkedHashSet<String>> hashMap, Document document) {
        StartupXMLReader.populateMap(hashMap, document, STARTUPLINKSDESC);
    }

    private static void populateMap(HashMap<String, LinkedHashSet<String>> hashMap, Document document, String string) {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        XPathExpression xPathExpression = null;
        XPathExpression xPathExpression2 = null;
        XPathExpression xPathExpression3 = null;
        Object object = null;
        Object object2 = null;
        Object object3 = null;
        try {
            xPathExpression = xPath.compile("/COMMINIDATA/AREADESC/DESC[@descname='" + string + "']/*");
            object2 = xPathExpression.evaluate(document, XPathConstants.NODESET);
            if (null != object2) {
                NodeList nodeList = (NodeList)object2;
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Object object4;
                    xPathExpression3 = xPath.compile("/COMMINIDATA/AREADESC/DESC[@descname='" + string + "']/DESC[" + (i + 1) + ']');
                    object = xPathExpression3.evaluate(document, XPathConstants.NODE);
                    if (object == null) continue;
                    Node node = (Node)object;
                    LinkedHashSet<String> linkedHashSet = null;
                    if (null != node && node.getAttributes() != null) {
                        object4 = node.getAttributes().item(0);
                        if (null == object4) continue;
                        String string2 = object4.getNodeValue();
                        linkedHashSet = hashMap.get(string2);
                        if (null == linkedHashSet) {
                            linkedHashSet = new LinkedHashSet(10);
                        }
                        hashMap.put(string2, linkedHashSet);
                    }
                    xPathExpression2 = xPath.compile("/COMMINIDATA/AREADESC/DESC[@descname='" + string + "']/DESC[" + (i + 1) + "]/PARAS/*");
                    object3 = xPathExpression2.evaluate(document, XPathConstants.NODESET);
                    object4 = (NodeList)object3;
                    int n2 = object4.getLength();
                    Node node2 = null;
                    for (int j = 0; j < n2; ++j) {
                        Node node3;
                        node2 = object4.item(j);
                        if (null == node2 || node2.getAttributes() == null || null == (node3 = node2.getAttributes().item(0)) || null == linkedHashSet) continue;
                        linkedHashSet.add(node3.getNodeValue());
                    }
                }
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            logger.error("Problem in XPathExpression:" + xPathExpressionException.toString());
        }
    }

    public static List<String> getNormalPlugins() {
        Set set;
        if (null != primarySecurityPluginsMap && null != (set = (Set)primarySecurityPluginsMap.get("securityplugins"))) {
            return new ArrayList<String>(set);
        }
        return new ArrayList<String>(1);
    }

    public static List<String> getRequiredPlugins() {
        Set set;
        if (null != primarySecurityPluginsMap && null != (set = (Set)primarySecurityPluginsMap.get("requiredplugins"))) {
            return new ArrayList<String>(set);
        }
        return new ArrayList<String>(1);
    }

    public static List<String> getPortalPlugins() {
        Set set;
        if (null != primarySecurityPluginsMap && null != (set = (Set)primarySecurityPluginsMap.get("portalStartupPlugins"))) {
            return new ArrayList<String>(set);
        }
        return new ArrayList<String>(2);
    }

    public static boolean checkStartupXMLExists() {
        return isExists;
    }

    public static List<String> getNormalAndRequiredPluginList() {
        Set set;
        HashSet hashSet = new HashSet(16);
        Set set2 = primarySecurityPluginsMap.get("securityplugins");
        if (null != set2) {
            hashSet.addAll(set2);
        }
        if (null != (set = (Set)primarySecurityPluginsMap.get("requiredplugins"))) {
            hashSet.addAll(set);
        }
        ArrayList<String> arrayList = new ArrayList<String>(hashSet);
        return arrayList;
    }

    public static FrameworkCommandProcessor.LoadStyle getLoadStyle_FromConfig() {
        if (StartupXMLReader.checkStartupXMLExists()) {
            String string = System.getProperty("SpecificLoadingState");
            logger.debug("Configured Specific Loading State= " + string);
            if (null != string) {
                return FrameworkCommandProcessor.LoadStyle.traditional;
            }
            HashSet hashSet = primarySecurityPluginsMap.get("portalStartupPlugins");
            ArrayList arrayList = null;
            if (null != hashSet) {
                arrayList = new ArrayList(hashSet);
            }
            if (arrayList == null || arrayList.isEmpty()) {
                return FrameworkCommandProcessor.LoadStyle.traditional;
            }
            return FrameworkCommandProcessor.LoadStyle.application;
        }
        return FrameworkCommandProcessor.LoadStyle.traditional;
    }

    private static boolean validStartupXmlFile() {
        File file = new File(System.getProperty("user.dir") + STARTUP_XML);
        File file2 = new File(System.getProperty("user.dir"));
        File[] fileArray = file2.listFiles(new StartupFileFilter());
        return false != file.exists() || fileArray.length != 0;
    }

    static void clear() {
        primarySecurityPluginsMap.clear();
    }

    private static class StartupFileFilter
    implements FilenameFilter {
        private StartupFileFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.endsWith("_startup.xml");
        }
    }
}

