/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.framework.StartupXMLReader;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.w3c.dom.Document;

public class SecondaryStartupXMLReader {
    private static HashMap<String, LinkedHashSet<String>> secondarySecurityPluginsMap = new HashMap(16);
    private static HashMap<String, LinkedHashSet<String>> linkMap = new HashMap(16);
    private static HashMap<String, LinkedHashSet<String>> applicationsMap = new HashMap(16);

    public static void readSecondaryStartupXMLFiles() {
        File[] fileArray;
        File file = new File(System.getProperty("user.dir"));
        File file2 = new File(System.getProperty("user.dir") + "/productlib");
        boolean bl = file2.exists();
        for (File file3 : fileArray = file.listFiles(new StartupFileFilter())) {
            Document document = StartupXMLReader.createDocument(file3);
            if (null == document) continue;
            StartupXMLReader.populatePluginsMap(secondarySecurityPluginsMap, document);
            if (bl) {
                StartupXMLReader.populateLinkMap(linkMap, document);
            }
            StartupXMLReader.populateApplications(applicationsMap, document);
        }
    }

    public static List<String> getNormalPlugins() {
        HashSet hashSet;
        if (null != secondarySecurityPluginsMap && null != (hashSet = (HashSet)secondarySecurityPluginsMap.get("securityplugins"))) {
            return new ArrayList<String>(hashSet);
        }
        return new ArrayList<String>(1);
    }

    public static List<String> getRequiredPlugins() {
        HashSet hashSet;
        if (null != secondarySecurityPluginsMap && null != (hashSet = (HashSet)secondarySecurityPluginsMap.get("requiredplugins"))) {
            return new ArrayList<String>(hashSet);
        }
        return new ArrayList<String>(1);
    }

    public static List<String> getApplicationsFromConfig() {
        HashSet hashSet;
        if (null != applicationsMap && null != (hashSet = (HashSet)applicationsMap.get("applications"))) {
            return new ArrayList<String>(hashSet);
        }
        return new ArrayList<String>(1);
    }

    public static List<String> getRequiredlinks() {
        HashSet hashSet;
        if (null != linkMap && null != (hashSet = (HashSet)linkMap.get("requiredLinks"))) {
            return new ArrayList<String>(hashSet);
        }
        return new ArrayList<String>(1);
    }

    public static List<String> getPortallinks() {
        HashSet hashSet;
        if (null != linkMap && null != (hashSet = (HashSet)linkMap.get("portalLinks"))) {
            return new ArrayList<String>(hashSet);
        }
        return new ArrayList<String>(1);
    }

    public static boolean isFavouriteApplicationsLaunch() {
        File[] fileArray;
        File file = new File(System.getProperty("user.dir"));
        for (File file2 : fileArray = file.listFiles(new StartupFileFilter())) {
            String string;
            DescContainer descContainer;
            AreaDescContainer areaDescContainer;
            CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getAbsCommStyleFile(System.getProperty("user.dir") + "/" + file2.getName());
            if (null == commStyleInfo || null == (areaDescContainer = commStyleInfo.getAreaDescContainer("startupresources")) || null == (descContainer = areaDescContainer.getDescContainer("favouriteApplications")) || null == (string = descContainer.getParasItem("isLaunchFavouriteApplications").getValue()) || !"false".equalsIgnoreCase(string)) continue;
            return false;
        }
        return true;
    }

    private static class StartupFileFilter
    implements FilenameFilter {
        private StartupFileFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.endsWith("_SecondStepStartup.xml");
        }
    }
}

