/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework;

import com.swimap.iview.framework.IProgressPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressPanel
extends JPanel
implements IProgressPanel {
    private JProgressBar progressBar = new JProgressBar();
    private int incrementSteps = 1;
    private int iMaxValue = 10;
    private int currentValue = 0;
    private static int preLoadingTime = -1;
    private static int cleanTime = -1;

    public ProgressPanel() {
        this.progressBar.setStringPainted(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.progressBar, "Center");
    }

    @Override
    public void setCurrentValue(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressPanel.this.progressBar.setValue(n);
            }
        });
    }

    @Override
    public int getCurrentValue() {
        return this.currentValue;
    }

    @Override
    public synchronized void incrementValue(int n) {
        this.currentValue += this.incrementSteps * n;
        this.setCurrentValue(this.currentValue);
    }

    @Override
    public void setMaxValue(int n) {
        this.iMaxValue = n;
        this.progressBar.setMaximum(this.iMaxValue);
    }

    @Override
    public int getMaxValue() {
        return this.iMaxValue;
    }

    @Override
    public void setIncrementSteps(int n) {
        this.incrementSteps = n;
    }

    @Override
    public int getIncrementSteps() {
        return this.incrementSteps;
    }

    @Override
    public void setIndeterminate() {
        this.progressBar.setIndeterminate(true);
        this.progressBar.setStringPainted(false);
    }

    public static int getPreLoadingTime() {
        if (preLoadingTime > -1) {
            return preLoadingTime;
        }
        String string = System.getProperty("iview.preload.ratio", "0");
        preLoadingTime = (int)(Double.parseDouble(string) * 100.0);
        return preLoadingTime;
    }

    public static int getLoadTime() {
        return 100 - (ProgressPanel.getPreLoadingTime() + ProgressPanel.getCleanTime());
    }

    public static int getCleanTime() {
        if (cleanTime > -1) {
            return cleanTime;
        }
        String string = System.getProperty("iview.postload.ratio", "0");
        cleanTime = (int)(Double.parseDouble(string) * 100.0);
        return cleanTime;
    }

    public static boolean isSmoothLoadingEnabled() {
        boolean bl;
        boolean bl2 = bl = System.getProperty("iview.preload.ratio") != null || System.getProperty("iview.postload.ratio") != null;
        if (bl) {
            int n = ProgressPanel.getPreLoadingTime();
            int n2 = ProgressPanel.getCleanTime();
            if (n >= 0 && n2 >= 0) {
                return n + n2 <= 100;
            }
            bl = false;
        }
        return bl;
    }
}

