/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework;

import com.oem.iview.startup.Bootstrap;
import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.CommStyleParserFactory;
import com.swimap.iview.commstyle.commini.IProfileParser;
import com.swimap.iview.commstyle.commini.IProfileParserGui;
import com.swimap.iview.commstyle.commini.MenuItemArrowIconFactory;
import com.swimap.iview.commstyle.commini.UIObjMng;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.utils.MergeUtil;
import com.swimap.iview.communicate.server.CommandListener;
import com.swimap.iview.communicate.server.CommandResult;
import com.swimap.iview.framework.IViewTimeZone;
import com.swimap.iview.framework.SecondaryStartupXMLReader;
import com.swimap.iview.framework.StartupXMLReader;
import com.swimap.iview.framework.applicationmanagement.ApplicationLauncher;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.applicationmanagement.ApplicationUtilities;
import com.swimap.iview.framework.applicationsearch.SearchPanel;
import com.swimap.iview.framework.licensemanagement.LicenseService;
import com.swimap.iview.framework.licensemanagement.LicenseUtilities;
import com.swimap.iview.framework.lookandfeel.UIStyleManager;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.menumanagement.MenuActivityStore;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.InternalLocalMsg;
import com.swimap.iview.framework.modulemanagement.ModuleList;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.outputmanagement.OutputManager;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginDefinitionHandler;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.pluginmanagement.PluginSubsystemUtilities;
import com.swimap.iview.framework.pluginmanagement.PluginUtil;
import com.swimap.iview.framework.securitymanagement.SecurityService;
import com.swimap.iview.framework.statusbarmanagement.StatusBarManager;
import com.swimap.iview.framework.subsystemmanagement.SubsystemManager;
import com.swimap.iview.framework.subsystemmanagement.SubsystemUtilities;
import com.swimap.iview.framework.systemsettingsmanagement.SystemSettingsManager;
import com.swimap.iview.framework.systemsettingsmanagement.treetype.PreferenceManager;
import com.swimap.iview.framework.terminalmanagement.TerminalManager;
import com.swimap.iview.framework.toolbarmanagement.ToolbarManager;
import com.swimap.iview.framework.util.BackGroundLauncherTask;
import com.swimap.iview.framework.util.BackGroundThread;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkGlobalInfo;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.util.ResourceAdapter;
import com.swimap.iview.framework.util.TrayUtilities;
import com.swimap.iview.framework.windowmanagement.WindowManager;
import com.swimap.iview.framework.windowmanagement.basedialog.AbstractConfirmDialog;
import com.swimap.iview.framework.windowmanagement.basedialog.CustomDialogManager;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedManager;
import com.swimap.iview.templates.utils.timer.IviewTimerTask;
import com.swimap.iview.templates.utils.timer.IviewUtilTimer;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.DebugTraceConfigurationDialog;
import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.FileMetaDataManager;
import com.swimap.iview.util.IviewTimerFactory;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ReflectionUtilities;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.SerializationHandler;
import com.swimap.iview.util.SplashScreen;
import com.swimap.iview.util.adapter.FrameworkHelper;
import com.swimap.iview.util.helpmanagement.HelpAdapter;
import com.swimap.iview.util.log.ExceptionHandler;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.startup.Startup;
import com.swimap.startup.StartupClassLoader;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.omg.CORBA.ORB;

public final class Main
implements CommandListener {
    private static IviewLogger logger = IviewLogger.getLogger(Main.class, "IVIEW");
    static ResourceBundle res = null;
    public static final String CONFIG_PROPERTIES = "config.properties";
    private static Main instance = null;
    public static ResourceBundle productRes = null;
    private static final String IS_SHOW_SPLASH_SCREEN = "-showsplashscreen";
    private static final String SPLASH_IMAGE = System.getProperty("iview.splashImgPath", "launch.gif");
    private static final String FULL_SCREEN_MODE = "-fullscreenmode";
    private static final String CUSTOM_CONFIG_PROPS = "configpath";
    private static final String CLIENTSIZE_FILE = "clientsize.properties";
    private static final String PROPERTY_WIDTH = "client.width.ratio";
    private static final String PROPERTY_HEIGHT = "client.height.ratio";
    private static List<String> mustLoadPlugins = null;
    private String sTerminalId = "11";
    private String sInstanceId = "1";
    private MDIFrame mdiframe = null;
    private ModuleManager mm = null;
    private TerminalManager terminalManager = null;
    private static SplashScreen welcomeSplash = null;
    private AbstractConfirmDialog exitConfirmDialog = null;
    private ORB orb = null;
    private String[] runtimeArgs = null;
    private String platform = System.getProperty("platform");
    private static final String SUBSYSTEM_NAME = "subsystem";
    private static final String STARTUP_FEATURE_NAME = "startupfeature";
    private Thread loadAllThread = null;
    private boolean isShowFullScreenMode = false;
    private static FrameworkCommandProcessor.LoadStyle loadStyle = null;
    private static boolean isExitWhileLoad = false;
    private volatile boolean callExit = false;
    private static FileFilter pathFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() && file.getName().indexOf("ext_") == 0;
        }
    };
    public static String[] extPaths = new String[0];
    public static String[] jarExtPaths = new String[0];
    public static final int OPENVIEW_PORT = 9808;
    private static boolean isIntegrateEnv = false;
    private static String command = null;
    public static final String INTEGRATE_ENV_PARAM = "-I";
    public static final String COMMAND_SEPERATOR = "#";
    public static boolean moduleInfoHasLoaded = false;
    public static final Object Lock = new Object();
    private Object server = null;
    private String versionID = null;
    public static final int EXIT = -1;
    private static final long GCPERIOD = 300000L;
    private IviewUtilTimer gcTimer = null;

    public String[] getRuntimeArgs() {
        return this.runtimeArgs;
    }

    static final synchronized ResourceBundle getResourceBundle() {
        if (res == null) {
            res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/Res");
        }
        return res;
    }

    public static final synchronized ResourceBundle getProductResourceBundle() {
        if (productRes == null) {
            productRes = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/Res");
        }
        return productRes;
    }

    private boolean initResource() {
        try {
            Locale locale = ResourceMng.getInstance().getLocale();
            Locale.setDefault(locale);
        }
        catch (NullPointerException nullPointerException) {
            Locale.setDefault(Locale.US);
        }
        res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/Res");
        productRes = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/Res");
        return res != null && productRes != null;
    }

    private boolean checkRunTimeArgsForSplash() {
        if (null == this.runtimeArgs || 0 == this.runtimeArgs.length) {
            logger.debug("Run time argument is not defined");
            return true;
        }
        int n = this.runtimeArgs.length;
        String string = null;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            string = this.runtimeArgs[i];
            if (null == string || !IS_SHOW_SPLASH_SCREEN.equalsIgnoreCase(string) || i + 1 >= n || null == this.runtimeArgs[i + 1]) continue;
            logger.debug("-showsplashscreen Run time argument found.");
            String string2 = this.runtimeArgs[i + 1];
            try {
                bl = Boolean.valueOf(string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                logger.warn("The input of -showsplashscreen is not correct. Unidentified value : " + string2);
            }
            return bl;
        }
        return bl;
    }

    private boolean checkArgsForFullScreenMode() {
        if (null == this.runtimeArgs || 0 == this.runtimeArgs.length) {
            logger.debug("Run time argument is not defined");
            return false;
        }
        int n = this.runtimeArgs.length;
        String string = null;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            string = this.runtimeArgs[i];
            if (null == string || !FULL_SCREEN_MODE.equalsIgnoreCase(string) || i + 1 >= n || null == this.runtimeArgs[i + 1]) continue;
            logger.debug("-fullscreenmode Run time argument found.");
            String string2 = this.runtimeArgs[i + 1];
            logger.debug("The input of -fullscreenmode is: " + string2);
            bl = Boolean.valueOf(string2);
            return bl;
        }
        return bl;
    }

    public Main() {
        instance = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Main(String[] stringArray) {
        String[] stringArray2;
        Object object;
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
        SerializationHandler.getInstance().readSerializedData();
        DebugTracer.identifyDebugParam(stringArray);
        IviewTimerFactory.identifyTimerParam(stringArray);
        IViewTimeZone iViewTimeZone = new IViewTimeZone();
        iViewTimeZone.setTimeZone();
        this.printSystemInfo();
        DebugTracer.resetCalendar();
        if (!this.initResource()) {
            this.initResourceFailed();
            return;
        }
        CommStyleManager.getInstance();
        instance = this;
        this.beforeAction();
        this.runtimeArgs = stringArray;
        String string = Main.getConfigFilePath();
        ResourceMng.propertiesMerge(System.getProperties(), ResourceMng.getProperties(string));
        FrameworkCommandProcessor.getInstance().setMainClass(this);
        System.setProperty("iView.ServerPlugins.Changed", "false");
        List<String> list = null;
        List<String> list2 = null;
        String string2 = System.getProperty(SUBSYSTEM_NAME);
        Main.loadSubsystemManager();
        if (StartupXMLReader.checkStartupXMLExists() && null == string2) {
            PluginSubsystemUtilities.reinitPatch();
            StartupXMLReader.populatePluginsFromPrimaryStartupXmlFile();
            SecondaryStartupXMLReader.readSecondaryStartupXMLFiles();
            PluginManager.getInstance().initializeBeforeLogin();
            list = Main.getPluginsList(true);
            list2 = StartupXMLReader.getNormalPlugins();
        } else {
            list2 = list = Main.getPluginsList(true);
        }
        Main.installPluginList(list, true);
        boolean bl = false;
        if (java.awt.SplashScreen.getSplashScreen() == null && !Startup.isSplashScreenShown() && (bl = this.checkRunTimeArgsForSplash())) {
            welcomeSplash = new SplashScreen((ImageIcon)ResourceAdapter.getSplashIcon());
        }
        UIStyleManager.loadUIStyleName();
        String string3 = System.getProperty("LightWeightPopupEnabled", "True");
        boolean bl2 = Boolean.valueOf(string3);
        JPopupMenu.setDefaultLightWeightPopupEnabled(bl2);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(bl2);
        int n = 4;
        try {
            n = Integer.parseInt(System.getProperty("iview.tooltip.delaytime").trim());
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage(), exception);
        }
        ToolTipManager.sharedInstance().setDismissDelay(n * 1000);
        final Thread thread = Main.createReader(list2, true);
        String string4 = System.getProperty("security");
        if (string4 == null || this.platform == null) {
            object = CommStyleManager.getInstance().getCommonStyleFile("conf/mainfrm/security");
            if (object != null) {
                stringArray2 = ((CommStyleInfo)object).getAreaDescContainer(0).getDescContainer("security");
                string4 = string4 != null ? string4 : stringArray2.getParasItemValue("security");
                String string5 = this.platform = this.platform != null ? this.platform : stringArray2.getParasItemValue("platform");
                if (this.platform != null) {
                    System.setProperty("platform", this.platform);
                }
                if (string4 != null) {
                    System.setProperty("security", string4);
                }
            }
            if (string4 == null || this.platform == null) {
                this.initFail(res.getString("MAIN_NO_SECURITY_CLASS"));
            }
        }
        this.mm = new ModuleManager();
        if ("1.5".equals(this.platform)) {
            FrameworkGlobalInfo.ModuleName.SECURITY_MANAGER_NAME = "SecurityModule";
        } else if ("1.2".equals(this.platform)) {
            object = System.getProperty("isCommIndependent");
            if (null == object) {
                try {
                    stringArray2 = (BaseModule)ReflectionUtilities.instantiateTheClass("com.swimap.iview.communicate.CommManager", new Class[]{ModuleManager.class}, new Object[]{this.mm});
                    ReflectionUtilities.callTheMethod((Object)this.mm, "register", new Class[]{String.class, BaseModule.class}, new Object[]{"communicateservice", stringArray2});
                }
                catch (Exception exception) {
                    logger.error("Please check whether the communicator module is initialized.");
                    logger.warn(exception.getMessage(), exception);
                }
            }
        } else {
            this.initFail(welcomeSplash, productRes.getString("MAIN_SECURITY_INCOMPATIBLE"));
            return;
        }
        this.versionID = productRes.getString("VersionID");
        logger.debug("versionID = " + this.versionID);
        this.mdiframe = new MDIFrame(ResourceAdapter.getTitle());
        FrameworkUtilities.setMainFrame(this.mdiframe);
        Bootstrap.getInstance().setMainFrame((JFrame)this.mdiframe);
        this.mdiframe.setDefaultCloseOperation(0);
        this.mdiframe.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (FrameworkUtilities.getWindowManager().isFullScreenLockEnabled() && ScreenToolKit.getFullScreenFlg()) {
                    return;
                }
                Main.this.exitInstanceWithConfirm();
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                Window[] windowArray = FrameworkUtilities.getMainFrame().getOwnedWindows();
                for (int i = 0; i < windowArray.length; ++i) {
                    String string = windowArray[i].getClass().toString();
                    if (!"class javax.swing.Popup$HeavyWeightWindow".equalsIgnoreCase(string)) continue;
                    windowArray[i].dispose();
                }
            }
        });
        if (Boolean.getBoolean("enabletrayicon") && SystemTray.isSupported()) {
            this.mdiframe.addWindowListener(FrameworkUtilities.getIconifyWindowListener());
        }
        this.mdiframe.pack();
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            this.mdiframe.setBounds(150, 150, 600, 500);
        } else {
            logger.debug("The state MAXIMIZED_BOTH is not supported on this platform.");
            this.mdiframe.setBounds(0, 0, ScreenToolKit.getScreenWidth(), ScreenToolKit.getScreenHeight() - 30);
        }
        this.loadAllThread = new Thread("LoadAll"){

            @Override
            public void run() {
                logger.debug("loadAllThread started work");
                Main.this.loadAll();
                if (null != thread && thread.isAlive()) {
                    try {
                        logger.debug("Started to join reader thread.");
                        thread.join();
                        logger.debug("Finished to join reader thread.");
                    }
                    catch (InterruptedException interruptedException) {
                        logger.error(interruptedException);
                    }
                }
                logger.debug("loadAllThread finished work");
            }
        };
        this.loadWindowManager();
        try {
            object = FrameworkUtilities.loadModule(string4, this.mm);
            this.mm.register(FrameworkGlobalInfo.ModuleName.SECURITY_MANAGER_NAME, (BaseModule)object);
            if (!(object instanceof SecurityService)) {
                this.initFail(res.getString("MAIN_SECURITY_INCOMPATIBLE"));
            }
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), exception);
            this.initFail(res.getString("MAIN_SECURITY_INIT_FAIL"));
        }
        if (bl) {
            welcomeSplash.close();
            welcomeSplash = null;
        } else if (Startup.isSplashScreenShown()) {
            Startup.closeStartupSplashScreen();
        }
        this.mdiframe.setExtendedState(6);
        if (isIntegrateEnv) {
            ScreenToolKit.adjustToScreen(this.mdiframe);
            object = new double[]{this.mdiframe.getWidth(), this.mdiframe.getHeight()};
            stringArray2 = new String[]{"width", "height"};
            FileInputStream fileInputStream = null;
            try {
                Properties properties = new Properties();
                fileInputStream = new FileInputStream(CommonUtil.getAbsolutePath("openview.properties"));
                properties.load(fileInputStream);
                for (int i = 0; i < 2; ++i) {
                    double d = Double.parseDouble(properties.getProperty(stringArray2[i]));
                    if (d > 0.0) {
                        if (d <= 1.0) {
                            object[i] = d * object[i];
                            continue;
                        }
                        if (!(d <= object[i])) continue;
                        object[i] = d;
                        continue;
                    }
                    if (!(object[i] + d > 0.0)) continue;
                    Object object2 = object;
                    int n2 = i;
                    object2[n2] = object2[n2] + d;
                }
            }
            catch (Exception exception) {
                logger.error(exception.getMessage(), exception);
            }
            finally {
                if (null != fileInputStream) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception) {
                        logger.warn(exception.getMessage(), exception);
                    }
                }
            }
            this.mdiframe.setSize((int)object[0], (int)object[1]);
        }
        this.isShowFullScreenMode = this.checkArgsForFullScreenMode();
        if (this.isShowFullScreenMode) {
            FrameworkUtilities.setFullScreenMode(true);
            this.mdiframe.showFullScreenMode();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!Main.this.callExit) {
                    Main.this.mdiframe.show();
                    Main.this.mdiframe.getRootPane().requestFocusInWindow();
                    Main.this.adjustMDIFrameToConfiguredSize();
                }
            }
        });
        this.addDebugTraceListener();
        FrameworkCommandProcessor.getInstance().login();
    }

    private void addDebugTraceListener() {
        AWTEventListener aWTEventListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                KeyEvent keyEvent;
                if (aWTEvent instanceof KeyEvent && 0 != ((keyEvent = (KeyEvent)aWTEvent).getModifiers() & 8) && 0 != (keyEvent.getModifiers() & 2) && 0 != (keyEvent.getModifiers() & 1) && 76 == keyEvent.getKeyCode()) {
                    DebugTraceConfigurationDialog debugTraceConfigurationDialog = DebugTraceConfigurationDialog.getInstance(FrameworkUtilities.getMainFrame());
                    debugTraceConfigurationDialog.setVisible(true);
                    ((KeyEvent)aWTEvent).consume();
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(aWTEventListener, 76L);
    }

    public boolean isLicenseSeviceFail() {
        return LicenseUtilities.isLicenseSeviceLoadFail();
    }

    private void loadAll() {
        try {
            this.sTerminalId = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            logger.error(unknownHostException.getMessage(), unknownHostException);
        }
        CommandManager.getInstance().setModuleManager(this.mm);
        CommandManager.getInstance().loadSecurityCommands("conf/mainfrm/frameworkcommand");
        this.mdiframe.jbInit();
        TrayUtilities.showTrayIcon();
        this.exitConfirmDialog = CustomDialogManager.getInstance().getExitDialog();
        if (this.exitConfirmDialog.getTitle() == null || this.exitConfirmDialog.getTitle().length() == 0) {
            this.exitConfirmDialog.setTitle(res.getString("Main_Exit_confirm"));
        }
        this.loadMenubar();
        ApplicationUtilities.setBaseMenuManager(FrameworkUtilities.getMenuManager());
        this.loadToolbar();
        ApplicationUtilities.setBaseToolbarManager(FrameworkUtilities.getToolbarManager());
        this.loadWindowTabbedManager();
        this.loadStatusBarManager();
        this.loadOutputManager();
        this.loadPreferenceManager();
        this.loadSystemSettingsManager();
        try {
            this.terminalManager = new TerminalManager(this.mm);
            FrameworkUtilities.setTerminalManager(this.terminalManager);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), exception);
            this.initFail(res.getString("Framework_init_fail"));
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                DebugTracer.cleanup();
            }
        });
        CommStyleManager.getInstance().setLoginFlag(true);
        this.startGCTimer();
    }

    private void loadSystemSettingsManager() {
        SystemSettingsManager systemSettingsManager = null;
        try {
            systemSettingsManager = new SystemSettingsManager(this.mm);
            FrameworkUtilities.setSystemSettingsManager(systemSettingsManager);
            systemSettingsManager.customizeSettingsDialog(productRes.getString("Main_System_Setting"), true);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), exception);
            this.initFail(res.getString("Framework_init_fail"));
        }
    }

    public static String getConfigFilePath() {
        String string = System.getProperty(CUSTOM_CONFIG_PROPS);
        String string2 = CONFIG_PROPERTIES;
        if (null != string && string.length() > 0) {
            DebugTracer.trace(1, "Main", "getConfigFilePath", "Config file given in the path" + string);
            File file = new File(string);
            if (file.isFile()) {
                string2 = string;
                DebugTracer.trace(1, "Main", "getConfigFilePath", "Product's config.props loaded from " + string);
            }
        }
        return string2;
    }

    public ModuleManager getModuleManager() {
        return this.mm;
    }

    public String getsTerminalId() {
        return this.getModuleManager().getTerminalId();
    }

    public String getsInstanceId() {
        return this.getModuleManager().getInstanceId();
    }

    public void exitInstanceWithConfirm() {
        if (this.isCallExit()) {
            return;
        }
        if (null != FrameworkUtilities.getTerminalManager() && FrameworkUtilities.getTerminalManager().isTerminalLocked()) {
            logger.error("Exit confirm dialog not shown since terminal is locked");
            return;
        }
        AbstractConfirmDialog abstractConfirmDialog = this.exitConfirmDialog;
        this.exitConfirmDialog = CustomDialogManager.getInstance().getExitDialog();
        if (this.exitConfirmDialog == null) {
            logger.debug("ExitConfirDialog is null.");
            this.exitConfirmDialog = CustomDialogManager.getInstance().getExitDialog();
            logger.debug("Reinit: " + this.exitConfirmDialog);
        } else if (this.exitConfirmDialog.getTitle() == null || this.exitConfirmDialog.getTitle().length() == 0) {
            this.exitConfirmDialog.setTitle(res.getString("Main_Exit_confirm"));
        }
        if (this.exitConfirmDialog.isShowing() || null != abstractConfirmDialog && abstractConfirmDialog.isShowing()) {
            logger.debug("exit dialog is already shown");
            return;
        }
        if (this.exitConfirmDialog.confirmShow() != 0) {
            logger.debug("Exit dialog is closed...");
            return;
        }
        if (this.isCallExit()) {
            this.exitTerminal();
        }
    }

    public boolean isCallExit() {
        return this.callExit;
    }

    public void exitTerminal() {
        if ("true".equals(System.getProperty("iview.osgi")) && "false".equals(System.getProperty("client.osgi.exit"))) {
            FrameworkHelper.stopBundle();
        } else {
            this.exitAndCleanUp(false);
        }
    }

    public static void exitOSGIClient() {
        if (null == instance) {
            return;
        }
        HelpAdapter.stopHelpBundle(true);
        FrameworkCommandProcessor.getInstance().setFirstLoginFlag(true);
        if (isExitWhileLoad) {
            instance.exitWhileLoadingAndCleanUp(true);
        } else {
            instance.exitAndCleanUp(true);
        }
        if (Startup.isSplashScreenShown()) {
            String string = System.getProperty("user.dir") + "/style/defaultstyle/launch/" + ResourceMng.getInstance().getLocaleString() + File.separator + SPLASH_IMAGE;
            String string2 = System.getProperty("user.dir") + "/configuration/launch/" + SPLASH_IMAGE;
            MergeUtil.copyFile(string, string2, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitAndCleanUp(boolean bl) {
        IProfileParser iProfileParser;
        OutputManager outputManager;
        WindowManager windowManager;
        logger.debug("--- Exit Terminal ---");
        loadStyle = FrameworkCommandProcessor.getInstance().getUserLoadStyle();
        if (!FrameworkCommandProcessor.getInstance().isReadyToExit() && !bl) {
            logger.debug("Some modules are not ready to exit!");
            return;
        }
        ScreenToolKit.setComponentCursorBusy(FrameworkUtilities.getMainFrame(), true);
        if (BackGroundLauncherTask.getInstance().getBackGroundThread() != null) {
            BackGroundLauncherTask.getInstance().getBackGroundThread().setRequestStop(true);
        }
        if (null != (windowManager = FrameworkUtilities.getWindowManager()) && !windowManager.closeAllWindowsWithCheck() && !bl) {
            logger.debug("Has a InternalFrame is busy,So exit return.");
            ScreenToolKit.setComponentCursorBusy(FrameworkUtilities.getMainFrame(), false);
            return;
        }
        this.callExit = true;
        FrameworkCommandProcessor.LoadStyle loadStyle = this.getLoadStyle();
        FileMetaDataManager.getInstance().dispose();
        logger.debug("processEvent:MSG_EXIT_TERMINAL begin");
        if (Main.loadStyle == FrameworkCommandProcessor.LoadStyle.application) {
            ApplicationManager.getInstance().saveState();
        }
        if (null != (outputManager = FrameworkUtilities.getOutputManager())) {
            outputManager.broadcastEvent(InternalLocalMsg.MSG_EXIT_TERMINAL);
        }
        logger.debug("processEvent:MSG_EXIT_TERMINAL end");
        Thread thread = FrameworkCommandProcessor.getInstance().getLoadThread();
        BackGroundThread backGroundThread = BackGroundLauncherTask.getInstance().getBackGroundThread();
        if (null != this.mm && (thread != null && thread.isAlive() || backGroundThread != null && backGroundThread.isAlive())) {
            this.mm.preExitProcess();
        }
        if (thread != null && thread.isAlive() || backGroundThread != null && backGroundThread.isAlive()) {
            this.getModuleManager().killLoadModuleThreads();
        }
        BackGroundLauncherTask.getInstance().stopBackGroundThread();
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                logger.error(interruptedException.getMessage(), interruptedException);
            }
        }
        SecurityService securityService = null;
        try {
            securityService = (SecurityService)this.getModuleManager().getReference(FrameworkGlobalInfo.ModuleName.SECURITY_MANAGER_NAME, "");
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), exception);
        }
        if (null != this.mm) {
            FrameworkUtilities.getWindowManager().closeAllWindowsAndDialogs();
            this.mm.shutdownAllModules();
        }
        if ((iProfileParser = CommStyleParserFactory.getInstance().createCacheProfileParser()) instanceof IProfileParserGui) {
            ((IProfileParserGui)iProfileParser).destroy();
        }
        logger.debug("--- Calling Security logout start---");
        if (securityService == null) {
            logger.debug("Reference to module returns null");
        } else {
            boolean bl2 = securityService.logout();
            logger.debug("logout value is:" + bl2);
        }
        logger.debug("--- Calling Security logout ends---");
        SerializationHandler.getInstance().writeSerializedData();
        if (Startup.isSplashScreenShown()) {
            String string = System.getProperty("user.dir") + "/style/defaultstyle/launch/" + ResourceMng.getInstance().getLocaleString() + File.separator + SPLASH_IMAGE;
            String string2 = System.getProperty("user.dir") + "/configuration/launch/" + SPLASH_IMAGE;
            MergeUtil.copyFile(string, string2, false);
        }
        if (this.server != null) {
            ReflectionUtilities.callTheMethod(this.server, "close", null, null);
        }
        IviewTimerFactory.cleanup();
        TrayUtilities.remove();
        try {
            if (FrameworkCommandProcessor.LoadStyle.application == Main.loadStyle) {
                ApplicationManager.getInstance().clear();
            }
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), exception);
        }
        ScreenToolKit.setComponentCursorBusy(FrameworkUtilities.getMainFrame(), false);
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.disposeTerminal();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Main.this.disposeTerminal();
                    }
                });
            }
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage(), exception);
        }
        finally {
            if ("true".equals(System.getProperty("iview.osgi")) && "false".equals(System.getProperty("client.osgi.exit"))) {
                logger.debug("......Cleaning Resources.....");
                this.cleanupWhileOSGIExit();
                StartupXMLReader.clear();
                logger.debug("......Cleaning finished successfully.....");
            } else {
                logger.debug("System exit!");
                System.exit(0);
            }
        }
    }

    public void exitWhileLoading() {
        isExitWhileLoad = true;
        if ("true".equals(System.getProperty("iview.osgi")) && "false".equals(System.getProperty("client.osgi.exit"))) {
            FrameworkHelper.stopBundle();
        } else {
            this.exitWhileLoadingAndCleanUp(false);
        }
        if (Startup.isSplashScreenShown()) {
            String string = System.getProperty("user.dir") + "/style/defaultstyle/launch/" + ResourceMng.getInstance().getLocaleString() + File.separator + SPLASH_IMAGE;
            String string2 = System.getProperty("user.dir") + "/configuration/launch/" + SPLASH_IMAGE;
            MergeUtil.copyFile(string, string2, false);
        }
    }

    private void exitWhileLoadingAndCleanUp(boolean bl) {
        logger.debug("--- Exit while loading ---");
        this.callExit = true;
        if (SwingUtilities.isEventDispatchThread()) {
            this.disposeTerminal();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Main.this.disposeTerminal();
                }
            });
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                Thread thread = FrameworkCommandProcessor.getInstance().getLoadThread();
                if (null != Main.this.mm && thread != null && thread.isAlive()) {
                    Main.this.mm.preExitProcess();
                }
                if (thread != null && thread.isAlive()) {
                    Main.this.getModuleManager().killLoadModuleThreads();
                }
                if (thread != null) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        logger.warn(interruptedException.getMessage(), interruptedException);
                    }
                }
                if (null != Main.this.mm) {
                    Main.this.mm.shutdownAllModules();
                }
                if (Main.this.orb != null) {
                    Main.this.orb.shutdown(true);
                }
                if (Main.this.server != null) {
                    ReflectionUtilities.callTheMethod(Main.this.server, "close", null, null);
                }
                logger.debug("System exit while client loading....!");
                if ("true".equals(System.getProperty("iview.osgi")) && "false".equals(System.getProperty("client.osgi.exit"))) {
                    logger.debug("......Cleaning Resources.....");
                    Main.this.cleanupWhileOSGIExit();
                    logger.debug("......Cleaning finished successfully.....");
                } else {
                    logger.debug("System exit!");
                    System.exit(0);
                }
            }
        };
        thread.start();
    }

    private void disposeTerminal() {
        JFrame jFrame = FrameworkUtilities.getMainFrame();
        if (null != jFrame) {
            jFrame.dispose();
        }
    }

    public static void main(String[] stringArray) {
        System.setProperty("java.awt.im.style", "below-the-spot");
        Main.identifyParam(stringArray);
        if (isIntegrateEnv) {
            try {
                Object object = ReflectionUtilities.instantiateTheClass("com.swimap.iview.communicate.client.CommandConnector", new Class[]{Integer.TYPE}, new Object[]{9808});
                ReflectionUtilities.callTheMethod(object, "sendCommand", new Class[]{String.class}, new Object[]{command});
                ReflectionUtilities.callTheMethod(object, "close", null, null);
            }
            catch (Exception exception) {
                if (command.indexOf("main#exit") >= 0) {
                    logger.debug("Exiting while CommandConnector...");
                    if (FrameworkHelper.isOSGIClient()) {
                        logger.debug(" Stoping IviewPlugin bundle.");
                        FrameworkHelper.stopBundle();
                        logger.debug("Bundle stopped successfully.");
                    } else {
                        logger.debug("System exit!");
                        System.exit(0);
                    }
                } else if (instance == null) {
                    instance = new Main(stringArray);
                }
                instance.startCommandServer();
                instance.execute(command);
            }
        } else if (instance == null) {
            instance = new Main(stringArray);
            if ("true".equals(System.getProperty("iview.osgi")) && Main.instance.callExit) {
                instance = null;
            }
        }
    }

    public static final Main instance() {
        return instance;
    }

    public static String[] getExtPath() {
        File[] fileArray;
        File file = CommonUtil.getAbsoluteFile("style/defaultstyle/conf/");
        if (file.exists() && (fileArray = file.listFiles(pathFilter)) != null && fileArray.length > 0) {
            Object[] objectArray = new String[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                objectArray[i] = fileArray[i].getName();
            }
            Arrays.sort(objectArray);
            return objectArray;
        }
        return null;
    }

    public void loadExtModules(ModuleList moduleList) {
        String[] stringArray = new String[]{};
        if (FrameworkCommandProcessor.getInstance().isAppStyle()) {
            File file = new File(System.getProperty("user.dir") + "/productlib");
            if (!file.exists()) {
                stringArray = FrameworkCommandProcessor.getInstance().getExtPathsFromProductAndDefault();
            }
        } else {
            stringArray = extPaths;
            if (jarExtPaths.length > 0) {
                stringArray = FrameworkCommandProcessor.mergeExtPath(jarExtPaths, extPaths);
            }
        }
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                moduleList.loadExtModuleList("conf/" + stringArray[i] + "/modulelist", stringArray[i]);
            }
        }
    }

    private boolean loadMenubar() {
        try {
            logger.debug("Start to load menu bar...");
            MenuManager menuManager = new MenuManager(this.mm, "mainmenumanager");
            FrameworkUtilities.setMenuManager(menuManager);
            boolean bl = menuManager.loadMenus("conf/mainfrm/menu", "mainMenu");
            logger.debug("MenuManager loading result is " + bl);
            menuManager.setBaseMenuSetId("mainMenu");
            menuManager.setInsertIndex(FrameworkGlobalInfo.MenuStyle.INSERT_INDEX);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
            return false;
        }
        return true;
    }

    private void loadPreferenceManager() {
        PreferenceManager preferenceManager = null;
        try {
            preferenceManager = new PreferenceManager(this.mm, "preferencemanager");
            FrameworkUtilities.setPreferenceManager(preferenceManager);
            preferenceManager.customizeSettingsDialog(productRes.getString("Main_System_Setting"), true);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), exception);
            this.initFail(res.getString("Framework_init_fail"));
        }
    }

    private boolean loadToolbar() {
        MDIFrame mDIFrame = (MDIFrame)FrameworkUtilities.getMainFrame();
        try {
            ToolbarManager toolbarManager = new ToolbarManager(this.mm, "maintoolbarmanager");
            FrameworkUtilities.setToolbarManager(toolbarManager);
            mDIFrame.setToolbarManager(toolbarManager);
            if (!this.isShowFullScreenMode) {
                mDIFrame.showToolbar(true);
            }
            toolbarManager.getToolbar().setVisible(false);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
            return false;
        }
        return true;
    }

    private void loadWindowTabbedManager() {
        MDIFrame mDIFrame = (MDIFrame)FrameworkUtilities.getMainFrame();
        try {
            WindowTabbedManager windowTabbedManager = new WindowTabbedManager(this.mm);
            FrameworkUtilities.setWindowTabbedManager(windowTabbedManager);
            mDIFrame.setWindowTabbedManager(windowTabbedManager);
            if (this.isShowFullScreenMode) {
                this.mdiframe.showWindowTabbedBar(false);
            }
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
    }

    private void initFail(final Component component, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Main.this.disposeAllWindows();
                if (component != null && component.isVisible()) {
                    OptionPane.showMessageDialog(component, string, res.getString("MAIN_INIT_FAIL"), 0);
                }
                if (null != welcomeSplash) {
                    ((Window)welcomeSplash.getParent()).dispose();
                    welcomeSplash = null;
                }
                FrameworkCommandProcessor.getInstance().stopSecurityModule();
                logger.debug("System exit!");
                Main.this.callExit = true;
                if (FrameworkHelper.isOSGIClient()) {
                    logger.debug("Stoping IviewPlugin bundle.");
                    FrameworkHelper.stopBundle();
                    logger.debug(" IviewPlugin bundle stopped successfully.");
                } else {
                    logger.debug("System exit!");
                    System.exit(-1);
                }
            }
        });
    }

    private void initResourceFailed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OptionPane.showMessageDialog(null, res.getString("MAIN_RES_INIT_FAIL"), res.getString("MAIN_INIT_FAIL"), 0);
                logger.debug("System exit!");
                Main.this.exit();
            }
        });
    }

    private void disposeAllWindows() {
        JFrame jFrame = FrameworkUtilities.getMainFrame();
        Window[] windowArray = null;
        if (null != jFrame) {
            windowArray = jFrame.getOwnedWindows();
        }
        if (windowArray == null || windowArray.length == 0) {
            return;
        }
        for (int i = 0; i < windowArray.length; ++i) {
            windowArray[i].dispose();
        }
    }

    public void unloadMenuAndToolbar() {
        MDIFrame mDIFrame = (MDIFrame)FrameworkUtilities.getMainFrame();
        mDIFrame.setMenuManager(null);
        mDIFrame.showToolbar(false);
        mDIFrame.setToolbarManager(null);
        try {
            this.mm.unregister("mainmenumanager", 1);
            this.mm.unregister("maintoolbarmanager", 1);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
    }

    public void postLoginAction() {
        try {
            OutputManager outputManager = new OutputManager(this.mm, this.orb, this.sTerminalId, this.sInstanceId, "mainoutputbarmanager");
            outputManager.setSettingItemName("mainoutputbarsetting");
            this.mdiframe.setOutputmanager(outputManager);
            FrameworkUtilities.setOutputManager(outputManager);
            this.mdiframe.showOutputPane(true);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), exception);
            this.initFail(this.mdiframe, res.getString("OutputManager_init_fail"));
        }
        try {
            this.terminalManager = new TerminalManager(this.mm, this.orb, this.sTerminalId, this.sInstanceId);
            FrameworkUtilities.setTerminalManager(this.terminalManager);
        }
        catch (Exception exception) {
            logger.debug(exception.getMessage(), exception);
            this.initFail(this.mdiframe, res.getString("TerminalManager_init_fail"));
        }
    }

    private void startCommandServer() {
        try {
            if (this.server != null) {
                ReflectionUtilities.callTheMethod(this.server, "close", null, null);
            }
            this.server = ReflectionUtilities.instantiateTheClass("com.swimap.iview.communicate.server.CommandServer", new Class[]{Integer.TYPE}, new Object[]{9808});
            ReflectionUtilities.callTheMethod(this.server, "addCommandListener", new Class[]{CommandListener.class}, new Object[]{this});
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage(), exception);
        }
    }

    public void initFail(String string) {
        if (welcomeSplash != null) {
            this.initFail(welcomeSplash, string);
        } else if (FrameworkUtilities.getMainFrame() != null) {
            this.initFail(FrameworkUtilities.getMainFrame(), string);
        } else {
            logger.error(string);
            this.initFail(new JFrame(), string);
        }
    }

    public String getVersionID() {
        return this.versionID;
    }

    public ResourceBundle[] getComponentVersionIDs() {
        return ResourceMng.getInstance().getComponentVersionIDs(true);
    }

    public ResourceBundle[] getComponentVersionIDs(boolean bl) {
        return ResourceMng.getInstance().getComponentVersionIDs(bl);
    }

    public boolean isIntegrateEnv() {
        return isIntegrateEnv;
    }

    private static void identifyParam(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!INTEGRATE_ENV_PARAM.equals(stringArray[i])) continue;
            isIntegrateEnv = true;
            if (i >= n - 1) break;
            StringBuffer stringBuffer = new StringBuffer(stringArray[i + 1]);
            for (int j = i + 2; j < n; ++j) {
                stringBuffer.append(' ').append(stringArray[j]);
            }
            command = stringBuffer.toString();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResult execute(String string) {
        Object object;
        Object object2;
        String string2 = null;
        String[] stringArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray2 = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray2[n] = stringTokenizer.nextToken();
            ++n;
        }
        n = stringArray2.length;
        if (n > 0) {
            object2 = stringArray2[0];
            int n2 = ((String)object2).indexOf(COMMAND_SEPERATOR);
            object = null;
            if (n2 > 0 && n2 < string.length() - 1) {
                string2 = ((String)object2).substring(0, n2);
                object = ((String)object2).substring(n2 + 1);
            }
            if (object != null && ((String)object).trim().length() > 0) {
                stringArray = new String[n];
                stringArray[0] = object;
                System.arraycopy(stringArray2, 1, stringArray, 1, n - 1);
            }
        }
        object2 = new InternalLocalMsg();
        ((InternalLocalMsg)object2).ID = -1000;
        ((InternalLocalMsg)object2).data = stringArray;
        Object var8_9 = null;
        try {
            object = Lock;
            synchronized (object) {
                try {
                    while (!moduleInfoHasLoaded) {
                        Lock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    logger.warn(interruptedException.getMessage(), interruptedException);
                }
            }
            FrameworkUtilities.getMainFrame().setVisible(false);
            FrameworkUtilities.getMainFrame().setState(1);
            FrameworkUtilities.getMainFrame().setVisible(true);
            FrameworkUtilities.getMainFrame().setState(0);
            if ("main".equalsIgnoreCase(string2)) {
                this.processEvent((InternalLocalMsg)object2);
            } else {
                object = this.mm.getLocalReference(string2);
                if (object != null) {
                    ((BaseModule)object).processEvent((InternalLocalMsg)object2);
                }
            }
            var8_9 = null;
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage(), exception);
            var8_9 = null;
        }
        return var8_9;
    }

    public void exit() {
        this.callExit = true;
        FrameworkCommandProcessor.getInstance().stopSecurityModule();
        logger.debug(new Exception("The exception for who invoke the exit method."));
        if (FrameworkHelper.isOSGIClient()) {
            logger.debug("......Stoping IviewPlugin bundle.....");
            FrameworkHelper.stopBundle();
            logger.debug("......IviewPlugin bundle stopped successfully.....");
        } else {
            logger.debug("System exit!");
            System.exit(-1);
        }
    }

    private void processEvent(InternalLocalMsg internalLocalMsg) {
        switch (internalLocalMsg.ID) {
            case -1000: {
                String string;
                Object[] objectArray;
                if (internalLocalMsg.data == null || (objectArray = (Object[])internalLocalMsg.data).length <= 0 || !"exit".equalsIgnoreCase(string = objectArray[0].toString())) break;
                this.exitInstanceWithConfirm();
                break;
            }
            default: {
                logger.debug("Main-processEvent,switch to the difault branch.");
            }
        }
    }

    protected void beforeAction() {
    }

    private void startGCTimer() {
        this.gcTimer = new IviewUtilTimer();
        IviewTimerTask iviewTimerTask = new IviewTimerTask(){

            @Override
            public void run() {
                logger.debug("invoke GC");
                System.gc();
            }
        };
        this.gcTimer.schedule(iviewTimerTask, 300000L, 300000L);
    }

    public static void loadSubsystemManager() {
        if (!CommonUtil.isStartupClassLoaded()) {
            return;
        }
        StartupClassLoader startupClassLoader = StartupClassLoader.getInstance();
        if (null != startupClassLoader) {
            String string = System.getProperty(SUBSYSTEM_NAME);
            SubsystemManager subsystemManager = SubsystemManager.getInstance();
            List<String> list = SubsystemUtilities.getSubsystemList(string);
            subsystemManager.setSubsystemLoaded(list, true);
        }
    }

    public static List<String> getPluginsList(boolean bl) {
        SubsystemManager subsystemManager = SubsystemManager.getInstance();
        List<Object> list = new ArrayList();
        if (bl) {
            if (System.getProperty(SUBSYSTEM_NAME) == null && StartupXMLReader.checkStartupXMLExists()) {
                mustLoadPlugins = StartupXMLReader.getNormalAndRequiredPluginList();
                if (null == mustLoadPlugins || 0 == mustLoadPlugins.size()) {
                    logger.trace("Specified subsystem in startupfeature has no plugins");
                }
                list = mustLoadPlugins;
            } else {
                list = Main.loadAllPlugins();
            }
        } else {
            list = FrameworkCommandProcessor.getInstance().isAppStyle() ? ApplicationUtilities.getPluginNamesOfAllApplications() : subsystemManager.getLoadedSubsystemAllPluginList();
            ArrayList<String> arrayList = new ArrayList<String>(list);
            List<Plugin> list2 = PluginManager.getInstance().getAllLoadedPlugins();
            if (mustLoadPlugins != null) {
                arrayList.removeAll(mustLoadPlugins);
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (Plugin plugin : list2) {
                if (!arrayList.contains(plugin.getPluginName())) continue;
                arrayList2.add(plugin.getPluginName());
            }
            list = arrayList2;
        }
        return list;
    }

    public static void installPluginList(List<String> list, boolean bl) {
        if (null != list) {
            logger.debug("List of Plugins going to add to the classpath:" + list + "isStartupValue: " + bl);
        }
        ArrayList<String> arrayList = new ArrayList<String>(list);
        if (bl) {
            Main.installPlugin(arrayList, false);
        } else {
            Main.installPlugin(arrayList, true);
        }
    }

    private static List<String> loadAllPlugins() {
        SubsystemManager subsystemManager = SubsystemManager.getInstance();
        ArrayList<String> arrayList = new ArrayList<String>(subsystemManager.getLoadedSubsystemAllPluginList());
        if (arrayList.size() > 0) {
            logger.debug("Loading all plugins as startupfeature is not mentioned.Total no. of plugins loaded" + arrayList.size());
        }
        return arrayList;
    }

    private static void installPlugin(List<String> list, boolean bl) {
        StartupClassLoader startupClassLoader = StartupClassLoader.getInstance();
        File[] fileArray = null;
        if (list.size() > 0) {
            Comparator<File> comparator = new Comparator<File>(){

                @Override
                public int compare(File file, File file2) {
                    String string = this.getNameWithoutJarExt(file.getName());
                    String string2 = this.getNameWithoutJarExt(file2.getName());
                    return string.compareTo(string2);
                }

                private String getNameWithoutJarExt(String string) {
                    if (PluginUtil.isPluginJar(string)) {
                        int n = string.lastIndexOf(".jar");
                        return string.substring(0, n);
                    }
                    return string;
                }
            };
            List<File> list2 = PluginDefinitionHandler.getPluginDefinitionHandler().getFileURLs();
            boolean bl2 = Main.checkPluginsChangedFromServer(list);
            if (bl2 && !FrameworkCommandProcessor.getInstance().isAppStyle() && !list2.isEmpty()) {
                ArrayList<File> arrayList = new ArrayList<File>(10);
                int n = 0;
                File file = null;
                String string = System.getProperty("user.dir") + "/plugins/";
                for (String string2 : list) {
                    file = new File(string + string2);
                    n = Collections.binarySearch(list2, file, comparator);
                    if (n < 0) continue;
                    arrayList.add(list2.get(n));
                }
                fileArray = arrayList.toArray(new File[arrayList.size()]);
            } else {
                fileArray = PluginUtil.getAllPluginFile(list);
            }
            if (null != fileArray && startupClassLoader != null) {
                startupClassLoader.installPlugins(fileArray, bl);
            }
        }
    }

    private static boolean checkPluginsChangedFromServer(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>(PluginDefinitionHandler.getPluginDefinitionHandler().getPluginNamesFromXML());
        if (null == arrayList || null == list) {
            return false;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(list);
        if (arrayList.size() == arrayList2.size()) {
            arrayList2.removeAll(arrayList);
            if (arrayList2.size() == 0) {
                return !FrameworkCommandProcessor.getInstance().isServerPluginsModified();
            }
            return false;
        }
        return false;
    }

    public static Thread createReader(List<String> list, final boolean bl) {
        PluginManager pluginManager = PluginManager.getInstance();
        List<Object> list2 = new ArrayList();
        String string = System.getProperty(SUBSYSTEM_NAME);
        list2 = bl ? (null == string && StartupXMLReader.checkStartupXMLExists() ? pluginManager.getStartupFeaturePluginLst() : pluginManager.getLoadedPluginList()) : (FrameworkCommandProcessor.getInstance().getUserLoadStyle() == FrameworkCommandProcessor.LoadStyle.application ? ApplicationUtilities.getAllStartupPluginsList() : pluginManager.getStartupPluginList());
        final List<Object> list3 = list2;
        final List<String> list4 = list;
        if (null == list3) {
            return null;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                logger.debug("start Reader Creation.");
                if (StartupXMLReader.checkStartupXMLExists() && bl && null == System.getProperty(Main.SUBSYSTEM_NAME)) {
                    logger.debug("End Reader Creation.");
                    return;
                }
                for (Plugin plugin : list3) {
                    if (!list4.contains(plugin.getPluginName())) continue;
                    plugin.getCommStyleParser();
                    plugin.getIntegrateCommStyleReader();
                }
                logger.debug("End Reader Creation.");
            }
        }, "PluginReader");
        thread.setPriority(1);
        thread.start();
        return thread;
    }

    public final Thread getLoadAllThread() {
        return this.loadAllThread;
    }

    private void loadWindowManager() {
        WindowManager windowManager = null;
        try {
            windowManager = new WindowManager(this.mm, "mainwindowmanager");
            windowManager.getDesktopPane().setBackGroundImage((ImageIcon)ResourceMng.getInstance().getIconDirect("mainfrm/background.gif"));
            this.mdiframe.setWindowManager(windowManager);
            FrameworkUtilities.setWindowManager(windowManager);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), exception);
            this.initFail(res.getString("Framework_init_fail"));
        }
    }

    private void loadStatusBarManager() {
        try {
            StatusBarManager statusBarManager = null;
            statusBarManager = new StatusBarManager(this.mm, "mainstatusbarmanager");
            statusBarManager.loadStatusBar("conf/mainfrm/statusbar");
            this.mdiframe.setStatusBarmanager(statusBarManager);
            FrameworkUtilities.setStatusBarManager(statusBarManager);
            if (!this.isShowFullScreenMode) {
                this.mdiframe.showStatusbar(true);
            }
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), exception);
            this.initFail(res.getString("Framework_init_fail"));
        }
    }

    private void loadOutputManager() {
        try {
            OutputManager outputManager = null;
            outputManager = new OutputManager(this.mm, "mainoutputbarmanager");
            outputManager.setSettingItemName("mainoutputbarsetting");
            this.mdiframe.setOutputmanager(outputManager);
            FrameworkUtilities.setOutputManager(outputManager);
            if (!this.isShowFullScreenMode) {
                this.mdiframe.showOutputPane(true);
                outputManager.setOutputWindowVisible(true);
            } else {
                this.mdiframe.setBottomComponent(null);
            }
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), exception);
            this.initFail(res.getString("Framework_init_fail"));
        }
    }

    public LicenseService getLicenseService() {
        return LicenseUtilities.getLicenseService();
    }

    public static void exitMain() {
        instance.exitTerminal();
    }

    private void cleanupWhileOSGIExit() {
        Object object;
        Object object2;
        logger.debug("CleanupWhileOSGIExit ..........Start");
        if (loadStyle == FrameworkCommandProcessor.LoadStyle.application) {
            SearchPanel.getInstance().clearCacheInformation();
            SearchPanel.getInstance().cleanWhileOSGIExit();
            ApplicationLauncher.getAppLauncher().cleanWhileOSGIExit();
            ApplicationManager.getInstance().cleanWhileOSGIExit();
            ApplicationUtilities.clear();
            loadStyle = null;
        }
        MenuItemArrowIconFactory.clear();
        PluginManager.getInstance().cleanupWhileOSGIExit();
        PluginSubsystemUtilities.clearAndReinitialize();
        SubsystemManager.getInstance().cleanUp();
        Main.instance().getModuleManager().cleanupWhileOSGIExit();
        ModuleList.cleanupModuleListWhileOSGIExit();
        this.disposeAllWindows();
        WindowTabbedManager windowTabbedManager = FrameworkUtilities.getWindowTabbedManager();
        if (null != windowTabbedManager) {
            windowTabbedManager.dispose();
        }
        try {
            object2 = "com.swimap.iview.framework.dockingmanagement.PerspectiveManager";
            object = Class.forName((String)object2);
            Field field = ((Class)object).getField("instance");
            field.setAccessible(true);
            Object object3 = field.get(null);
            if (null != object3) {
                ReflectionUtilities.callTheMethod(object3, "cleanupWhileOSGIExit", null, null);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error(classNotFoundException.getMessage());
        }
        catch (SecurityException securityException) {
            logger.error(securityException.getMessage());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            logger.error(noSuchFieldException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error(illegalArgumentException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.error(illegalAccessException.getMessage());
        }
        this.cleanMainFrm();
        if (null != this.gcTimer) {
            this.gcTimer.cancel();
            this.gcTimer = null;
        }
        if (null != this.loadAllThread && this.loadAllThread.isAlive()) {
            try {
                this.loadAllThread.join();
            }
            catch (InterruptedException interruptedException) {
                logger.error("Exception while joining the thread :" + interruptedException);
            }
        }
        if ((object2 = FrameworkUtilities.getSystemTimer()) != null) {
            ((Timer)object2).cancel();
            object2 = null;
        }
        UIObjMng.getInstance().cleanupWhileOSGIExit();
        CommandManager.getInstance().cleanupWhileOSGIExit();
        if (null != this.mm) {
            this.mm.clearFailedModules();
            this.mm.clearNoLoadModule();
        }
        if (null != (object = FrameworkUtilities.getMenuManager())) {
            ((MenuManager)object).cleanupWhileOSGIExit();
        }
        MenuActivityStore.getInstance().cleanupWhileOSGIExit();
        CommStyleManager.getInstance().setLoginFlag(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Window[] windowArray = Window.getWindows();
                for (int i = 0; i < windowArray.length; ++i) {
                    if (null == windowArray[i] || !(windowArray[i].getClass().getClassLoader() instanceof StartupClassLoader)) continue;
                    windowArray[i].dispose();
                    windowArray[i] = null;
                }
            }
        });
        if (null != this.exitConfirmDialog) {
            this.exitConfirmDialog.dispose();
            this.exitConfirmDialog = null;
        }
        FrameworkCommandProcessor.getInstance().clearLoadStyle();
        instance = null;
        logger.debug("CleanupWhileOSGIExit.............End");
    }

    public static void nullifyMain() {
        instance = null;
    }

    private void cleanMainFrm() {
        if (null != this.mdiframe) {
            WindowListener[] windowListenerArray = this.mdiframe.getWindowListeners();
            for (int i = 0; i < windowListenerArray.length; ++i) {
                this.mdiframe.removeWindowListener(windowListenerArray[i]);
                windowListenerArray[i] = null;
            }
            this.mdiframe.setMenuManager(null);
            this.mdiframe.resetTitleOnLogout();
            this.mdiframe.cleanupWhileOSGIExit();
            ScreenToolKit.cleanupFullScreenOnExit();
            this.mdiframe.removeAll();
            if (SwingUtilities.isEventDispatchThread()) {
                this.disposeTerminal();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Main.this.disposeTerminal();
                    }
                });
            }
            this.mdiframe = null;
        }
    }

    private FrameworkCommandProcessor.LoadStyle getLoadStyle() {
        if (SubsystemManager.getInstance().getClientLoadMode() == SubsystemManager.LoadMode.single) {
            return FrameworkCommandProcessor.LoadStyle.traditional;
        }
        FrameworkCommandProcessor.LoadStyle loadStyle = StartupXMLReader.getLoadStyle_FromConfig();
        if (loadStyle == FrameworkCommandProcessor.LoadStyle.traditional) {
            return loadStyle;
        }
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile("conf/mainfrm/displaystylesettings");
        if (null != commStyleInfo) {
            String string = commStyleInfo.getAreaDescContainer(0).getDescContainer(0).getParasItemValue(0);
            loadStyle = FrameworkCommandProcessor.LoadStyle.valueOf(string);
        }
        return loadStyle;
    }

    private void printSystemInfo() {
        Runtime runtime = Runtime.getRuntime();
        logger.debug("SYSINFO: Free Memory : " + runtime.freeMemory());
        logger.debug("SYSINFO: Total Memory : " + runtime.totalMemory());
        logger.debug("SYSINFO: Maximum Memory : " + runtime.maxMemory());
        logger.debug("SYSINFO: Available Processor : " + runtime.availableProcessors());
        logger.debug("SYSINFO: System Encoding : " + System.getProperty("file.encoding"));
        try {
            JarFile jarFile = new JarFile("startuploader.jar");
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            logger.debug("SYSINFO: IView Version :" + attributes.getValue("iView-For-Version"));
        }
        catch (Exception exception) {
            logger.debug("Iview Jar Version is not available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustMDIFrameToConfiguredSize() {
        double[] dArray = new double[]{this.mdiframe.getWidth(), this.mdiframe.getHeight()};
        String[] stringArray = new String[]{PROPERTY_WIDTH, PROPERTY_HEIGHT};
        FileInputStream fileInputStream = null;
        try {
            Properties properties = new Properties();
            fileInputStream = new FileInputStream(CommonUtil.getAbsolutePath(CLIENTSIZE_FILE));
            properties.load(fileInputStream);
            double d = 0.0;
            String string = null;
            for (int i = 0; i < stringArray.length; ++i) {
                string = properties.getProperty(stringArray[i]);
                if (null == string || string.length() == 0) continue;
                try {
                    d = Double.parseDouble(string);
                    if (!(d >= 0.1) || !(d <= 1.0)) continue;
                    dArray[i] = d * dArray[i];
                    continue;
                }
                catch (Exception exception) {
                    logger.debug("Exception occured for property " + stringArray[i]);
                }
            }
            this.mdiframe.setSize((int)dArray[0], (int)dArray[1]);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), exception);
        }
        finally {
            if (null != fileInputStream) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    logger.warn(exception.getMessage(), exception);
                }
            }
        }
    }
}

