/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework;

import com.swimap.iview.util.jni.Linux;
import com.swimap.iview.util.jni.Os;
import com.swimap.iview.util.log.IviewLogger;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class IViewTimeZone {
    private static IviewLogger logger = IviewLogger.getLogger(IViewTimeZone.class, "IVIEW");
    private static final int MINUTE_TO_SECOND = 60;
    private static final int SECOND_TO_MILLSECOND = 1000;
    private static final int TIMEZONE_PROPERTY_MUNBER = 11;
    private static int dstOffset = 0;
    private static TimeZone localTimezone = TimeZone.getDefault();

    public void setTimeZone() {
        SimpleTimeZone simpleTimeZone = this.getLocaleTimeZone();
        if (null != simpleTimeZone) {
            TimeZone.setDefault(simpleTimeZone);
        }
    }

    public TimeZone getTimeZone() {
        SimpleTimeZone simpleTimeZone = this.getLocaleTimeZone();
        if (simpleTimeZone != null) {
            return simpleTimeZone;
        }
        return localTimezone;
    }

    private SimpleTimeZone getLocaleTimeZone() {
        SimpleTimeZone simpleTimeZone = null;
        try {
            Os os = Os.getOs();
            if (os == null || os instanceof Linux) {
                logger.trace("The os is not Windows/Solaris,the current timezone do not need adjust. OS is " + (os == null ? "null" : os.getClass()));
                return simpleTimeZone;
            }
            int[] nArray = this.adjustTimeZoneInfo(os.getTimeZoneInfo());
            String[] stringArray = new String[]{"DaylightBias = ", "daylightDate.Month = ", "daylightDate.Day = ", "daylightDate.DayOfWeek = ", "daylightDate.wHour = ", "startTimeMode = ", "stardardDate.Month = ", "stardardDate.Day = ", "stardardDate.DayOfWeek = ", "stardardDate.wHour = ", "stardardDate.TimeMode = "};
            for (int i = 0; i < nArray.length; ++i) {
                logger.trace(stringArray[i] + nArray[i]);
            }
            dstOffset = nArray[0];
            if (nArray.length == 11) {
                if (nArray[0] == 0) {
                    String string = null;
                    string = os.getTimeZoneID();
                    if (string != null) {
                        int n = this.adjustRawOffset(os.getTimeZoneRawOffset());
                        simpleTimeZone = new SimpleTimeZone(n, string);
                        logger.trace("The current timezone (don't apply the daylight time) is " + simpleTimeZone);
                    }
                } else {
                    String string = null;
                    string = os.getTimeZoneID();
                    if (string != null) {
                        int n = this.adjustRawOffset(os.getTimeZoneRawOffset());
                        simpleTimeZone = new SimpleTimeZone(n, string, nArray[1], nArray[2], nArray[3], nArray[4], nArray[6], nArray[7], nArray[8], nArray[9], nArray[0]);
                        logger.trace("The current timezone is " + simpleTimeZone);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            logger.trace(throwable.getMessage(), throwable);
        }
        return simpleTimeZone;
    }

    private int[] adjustTimeZoneInfo(int[] nArray) {
        nArray[0] = nArray[0] * 60 * 1000;
        nArray[1] = nArray[1] - 1;
        nArray[2] = nArray[2] == 5 ? -1 : nArray[2];
        nArray[3] = nArray[3] + 1;
        nArray[4] = nArray[4];
        nArray[5] = nArray[5];
        nArray[6] = nArray[6] - 1;
        nArray[7] = nArray[7] == 5 ? -1 : nArray[7];
        nArray[8] = nArray[8] + 1;
        nArray[9] = nArray[9];
        nArray[10] = nArray[10];
        return nArray;
    }

    private int adjustRawOffset(int n) {
        return n * 60 * 1000;
    }

    public static int getDstOffset() {
        return dstOffset;
    }
}

