/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.TabInterface;
import com.swimap.iview.framework.lookandfeel.UIStyleTool;
import com.swimap.iview.framework.subsystemmanagement.SubsystemManager;
import com.swimap.iview.framework.subsystemmanagement.SubsystemUtilities;
import com.swimap.iview.framework.util.OneSideEtchedBorder;
import com.swimap.iview.framework.util.ResourceAdapter;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AboutDialog
extends JDialog {
    private static IviewLogger logger = IviewLogger.getLogger(AboutDialog.class, "IVIEW");
    private static final String PAGE_FILE_NAME = "conf/mainfrm/abouttabpage";
    private static final String AREADESC_NAME = "tabpage";
    private static final String PARA_NAME = "classname";
    private static final ResourceBundle RES = Main.getResourceBundle();
    private static final ResourceBundle PRODUCT_RES = Main.getProductResourceBundle();
    private JTabbedPane tabPane = new JTabbedPane();
    private JPanel defaultTabPanel = new JPanel();
    private int pageCount = 0;
    private JLabel titleLabel = new JLabel();
    private JLabel versionLabel = new JLabel();
    private JLabel webAddrLabel = new JLabel();
    private JLabel rightReservedLabel = new JLabel();
    private Icon copyrightIcon = new ImageIcon(this.getClass().getResource("cright.gif"));
    private JLabel rightYearLabel = new JLabel(CommonUtil.getResString(PRODUCT_RES, "AboutDialog_1999_2001"), this.copyrightIcon, 2);
    private JLabel rightCompanyNameLabel = new JLabel(CommonUtil.getResString(PRODUCT_RES, "AboutDialog_technology"));
    private JPanel rightYearCompanyNamePanel = new JPanel(new BorderLayout());
    private JLabel jNameTitle = new JLabel();
    private JLabel swimapLabel = new JLabel(ResourceMng.getInstance().getIcon("LOGO"));
    private final Object lock = new Object();
    private AbstractAction keyAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AboutDialog.this.dispose();
        }
    };
    private KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
    private static final String ESCAPE = "ESCAPE";

    public AboutDialog() {
        this((JFrame)null);
    }

    public AboutDialog(JFrame jFrame) {
        super(jFrame, CommonUtil.getResString(RES, "AboutDialog_About"), true);
        this.jbInit();
    }

    private void loadPage() {
        DescContainer[] descContainerArray;
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(PAGE_FILE_NAME);
        AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer(AREADESC_NAME);
        if (areaDescContainer != null && (descContainerArray = areaDescContainer.getDescContainer()) != null && descContainerArray.length > 0) {
            int n = descContainerArray.length;
            for (int i = 0; i < n; ++i) {
                try {
                    String string = descContainerArray[i].getParasItemValue(PARA_NAME);
                    if (string == null) continue;
                    Class<?> clazz = Class.forName(string);
                    Object obj = clazz.getConstructor(null).newInstance(null);
                    TabInterface tabInterface = (TabInterface)obj;
                    this.addPage(tabInterface.getTitle(), tabInterface.getPage());
                    continue;
                }
                catch (Exception exception) {
                    logger.trace(exception.getMessage(), exception);
                }
            }
        }
    }

    private void jbInit() {
        this.setSize(445, 320);
        this.setResizable(false);
        ScreenToolKit.centerLocateToScreen(this);
        this.setName("AboutDialog");
        this.tabPane.setName("AboutDialog_tabPane");
        this.loadSubsystemManagerForHelp();
        this.titleLabel = new JLabel(ResourceAdapter.getAboutBannerIcon());
        this.jNameTitle = new JLabel(ResourceAdapter.getAboutTitleIcon());
        this.initDefaultTabPanel();
        this.getContentPane().add((Component)this.defaultTabPanel, "Center");
        ++this.pageCount;
        this.loadPage();
        this.defaultTabPanel.putClientProperty("HELP_ID_PROPERTY", "IVIEW.about.Version");
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.enableHelpKey(this.defaultTabPanel, "IVIEW.about.Version");
        this.tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AboutDialog.this.tabbedPane_stateChanged();
            }
        });
        HelpManager.getInstance().enableHelpKey(this.getRootPane(), "IVIEW.about.Version");
        this.addKeyBoardListener(this.getContentPane());
    }

    private void tabbedPane_stateChanged() {
        Component component = this.tabPane.getSelectedComponent();
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            try {
                String string = (String)jComponent.getClientProperty("HELP_ID_PROPERTY");
                if (null == string || "".equalsIgnoreCase(string)) {
                    string = "IVIEW.about.Version";
                }
                HelpManager.getInstance().enableHelpKey(this.getRootPane(), string);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
    }

    private void loadSubsystemManagerForHelp() {
        SubsystemManager subsystemManager = SubsystemManager.getInstance();
        int n = subsystemManager.getLoadedSubsystemCount();
        logger.trace("count : " + subsystemManager.getLoadedSubsystemCount());
        if (0 != n) {
            return;
        }
        String string = System.getProperty("subsystem");
        SubsystemManager subsystemManager2 = SubsystemManager.getInstance();
        List<String> list = SubsystemUtilities.getSubsystemList(string);
        subsystemManager2.setSubsystemLoaded(list, true);
    }

    private void webAddrLabel_mouseEntered(MouseEvent mouseEvent) {
        this.webAddrLabel.setText("<html><u>" + CommonUtil.getResString(PRODUCT_RES, "AboutDialog_webAddr") + "&nbsp;</u></html>");
        this.webAddrLabel.setFont(this.webAddrLabel.getFont().deriveFont(1));
    }

    private void webAddrLabel_mouseExited(MouseEvent mouseEvent) {
        this.webAddrLabel.setText("<html><u>" + CommonUtil.getResString(PRODUCT_RES, "AboutDialog_webAddr") + "</u></html>");
        this.webAddrLabel.setFont(this.webAddrLabel.getFont().deriveFont(0));
    }

    private void webAddrLabel_mouseClicked(MouseEvent mouseEvent) {
        String string = System.getProperty("os.name");
        String[] stringArray = new String[2];
        stringArray[1] = CommonUtil.getResString(PRODUCT_RES, "AboutDialog_webAddr");
        if (string != null) {
            if (string.indexOf("Solaris") != -1 || string.indexOf("SunOS") != -1 || string.indexOf("Linux") != -1 || string.indexOf("HP-UX") != -1) {
                stringArray[0] = "netscape";
            } else if (string.charAt(0) == 'W' || string.charAt(0) == 'w') {
                stringArray[0] = "explorer";
            }
            try {
                Runtime.getRuntime().exec(stringArray);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
    }

    private void initDefaultTabPanel() {
        this.versionLabel.setFont(this.versionLabel.getFont().deriveFont(0, 14.0f));
        this.versionLabel.setText(ResourceAdapter.getVersion());
        this.versionLabel.setName("AboutDialog_versionLabel");
        this.rightYearLabel.setFont(this.rightYearLabel.getFont().deriveFont(0, 12.0f));
        this.rightYearLabel.setName("AboutDialog_rightYearLabel");
        this.rightCompanyNameLabel.setFont(this.rightCompanyNameLabel.getFont().deriveFont(0, 12.0f));
        this.rightCompanyNameLabel.setName("AboutDialog_rightCompanyNameLabel");
        this.swimapLabel.setPreferredSize(new Dimension(110, 84));
        this.swimapLabel.setMinimumSize(new Dimension(110, 110));
        this.swimapLabel.setMaximumSize(new Dimension(110, 110));
        this.swimapLabel.setName("AboutDialog_swimapLabel");
        this.rightYearCompanyNamePanel.add((Component)this.rightYearLabel, "West");
        this.rightYearCompanyNamePanel.add((Component)this.rightCompanyNameLabel, "Center");
        this.webAddrLabel.setFont(this.webAddrLabel.getFont().deriveFont(0, 12.0f));
        this.webAddrLabel.setText("<html><u>" + CommonUtil.getResString(PRODUCT_RES, "AboutDialog_webAddr") + "</u></html>");
        this.webAddrLabel.setName("AboutDialog_webAddrLabel");
        this.webAddrLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AboutDialog.this.webAddrLabel_mouseClicked(mouseEvent);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                AboutDialog.this.webAddrLabel_mouseEntered(mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                AboutDialog.this.webAddrLabel_mouseExited(mouseEvent);
            }
        });
        this.webAddrLabel.setForeground(UIStyleTool.HYPERLINK_COLOR);
        this.webAddrLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.rightReservedLabel.setText(CommonUtil.getResString(RES, "AboutDialog_All_Rights_Reserved"));
        this.rightReservedLabel.setFont(this.rightReservedLabel.getFont().deriveFont(0, 12.0f));
        this.rightReservedLabel.setName("AboutDialog_rightReservedLabel");
        JPanel jPanel = new JPanel();
        jPanel.add(this.swimapLabel);
        this.defaultTabPanel.setLayout(new GridBagLayout());
        this.defaultTabPanel.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.defaultTabPanel.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 5, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.defaultTabPanel.add((Component)this.jNameTitle, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 3, new Insets(0, 0, 10, 0), 0, 0));
        this.defaultTabPanel.add((Component)this.versionLabel, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.rightYearCompanyNamePanel.setBorder(new OneSideEtchedBorder());
        String string = System.getProperty("aboutdialog.showright");
        if (string == null || "true".equalsIgnoreCase(string)) {
            this.defaultTabPanel.add((Component)this.rightYearCompanyNamePanel, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.defaultTabPanel.add((Component)this.rightReservedLabel, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 1, new Insets(10, 0, 10, 0), 0, 0));
            JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
            jPanel2.add(this.webAddrLabel);
            this.defaultTabPanel.add((Component)jPanel2, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 10, 0), 0, 0));
        } else {
            JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
            jPanel3.add(this.webAddrLabel);
            this.defaultTabPanel.add((Component)jPanel3, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 10, 0), 0, 0));
        }
    }

    public void addPage(String string, JComponent jComponent) {
        this.addPage(string, null, jComponent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPage(String string, Icon icon, JComponent jComponent, String string2) {
        if (null == jComponent) {
            return;
        }
        if (this.pageCount == 1) {
            this.setSize(450, 350);
            this.getContentPane().remove(this.defaultTabPanel);
            this.tabPane.addTab(CommonUtil.getResString(RES, "AboutDialog_About"), this.defaultTabPanel);
            this.getContentPane().add(this.tabPane);
        }
        this.tabPane.addTab(string, icon, jComponent, string2);
        Object object = this.lock;
        synchronized (object) {
            this.pageCount = this.tabPane.getComponentCount();
        }
        this.validate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePage(JComponent jComponent) {
        if (null == jComponent || this.pageCount <= 1) {
            logger.debug("RemovePage return because page is null or pageCount =1.");
            return;
        }
        this.tabPane.remove(jComponent);
        Object object = this.lock;
        synchronized (object) {
            this.pageCount = this.tabPane.getComponentCount();
        }
        if (this.pageCount == 1) {
            this.setSize(445, 320);
            this.getContentPane().remove(this.tabPane);
            this.getContentPane().add(this.defaultTabPanel);
        }
    }

    private void addKeyBoardListener(Component component) {
        Component[] componentArray;
        Container container;
        if (component == null) {
            return;
        }
        if (component instanceof JTabbedPane) {
            container = (JTabbedPane)component;
            int n = ((JTabbedPane)container).getTabCount();
            for (int i = 0; i < n; ++i) {
                this.addKeyBoardListener(((JTabbedPane)container).getComponentAt(i));
            }
        } else if (component instanceof Container && (componentArray = (container = (Container)component).getComponents()) != null && componentArray.length != 0) {
            for (int i = 0; i < componentArray.length; ++i) {
                this.addKeyBoardListener(componentArray[i]);
            }
        }
        if (component instanceof JComponent) {
            container = (JComponent)component;
            ((JComponent)container).getInputMap().put(this.escapeKeyStroke, ESCAPE);
            ((JComponent)container).getActionMap().put(ESCAPE, this.keyAction);
        }
    }
}

