/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.communicate.server;

import com.swimap.iview.communicate.CommHandle;
import com.swimap.iview.communicate.server.CommandAccepter;
import com.swimap.iview.communicate.server.CommandListener;
import com.swimap.iview.communicate.server.CommandResult;
import java.net.ServerSocket;
import java.net.Socket;

public class CommandServer
extends Thread
implements CommandListener {
    private ServerSocket server = null;
    private boolean running = false;
    private CommandListener listener = null;

    public CommandServer(int n) throws Exception {
        this.server = new ServerSocket(n);
        this.running = true;
        this.start();
    }

    @Override
    public void run() {
        block4: while (true) {
            try {
                while (this.running) {
                    Socket socket = this.server.accept();
                    try {
                        new CommandAccepter(this, socket);
                        continue block4;
                    }
                    catch (Exception exception) {
                        CommHandle.logException(4, exception);
                    }
                }
                break;
            }
            catch (Exception exception) {
                this.running = false;
                CommHandle.logException(exception);
                break;
            }
        }
    }

    public void addCommandListener(CommandListener commandListener) {
        this.listener = commandListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResult execute(String string) {
        if (this.listener != null) {
            CommandListener commandListener = this.listener;
            synchronized (commandListener) {
                return this.listener.execute(string);
            }
        }
        return null;
    }

    public void close() {
        this.running = false;
        try {
            this.server.close();
        }
        catch (Exception exception) {
            CommHandle.logException(exception);
        }
    }
}

