/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.communicate.server;

import com.swimap.iview.communicate.CommHandle;
import com.swimap.iview.communicate.server.CommandListener;
import com.swimap.iview.communicate.server.CommandResult;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;

public class CommandAccepter
extends Thread {
    private static final int DEFAULT_BUF_LEN = 256;
    private CommandListener listener = null;
    private Socket sock = null;
    private BufferedInputStream in = null;
    private BufferedOutputStream out = null;
    private byte[] buffer = new byte[256];

    public CommandAccepter(CommandListener commandListener, Socket socket) throws Exception {
        this.sock = socket;
        this.listener = commandListener;
        this.in = new BufferedInputStream(socket.getInputStream());
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String string;
            CommandResult commandResult;
            int n = this.in.read(this.buffer);
            if (n > 0 && (commandResult = this.listener.execute(string = new String(this.buffer, 0, n))) != null) {
                this.out = new BufferedOutputStream(this.sock.getOutputStream());
                this.out.write(commandResult.toBytes());
                this.out.flush();
            }
        }
        catch (Exception exception) {
            CommHandle.logException(4, exception);
        }
        finally {
            try {
                if (this.out != null) {
                    this.out.close();
                    this.out = null;
                }
            }
            catch (Exception exception) {
                CommHandle.logException(4, exception);
            }
            try {
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
            }
            catch (Exception exception) {
                CommHandle.logException(4, exception);
            }
            try {
                this.sock.close();
                this.sock = null;
            }
            catch (IOException iOException) {
                CommHandle.logException(4, iOException);
            }
        }
    }
}

